/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.binary.BinaryRawReaderEx;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.processors.platform.PlatformAsyncTarget;
import org.apache.ignite.internal.processors.platform.PlatformContext;
import org.apache.ignite.internal.processors.platform.PlatformTarget;
import org.apache.ignite.internal.processors.platform.memory.PlatformMemory;
import org.apache.ignite.internal.processors.platform.utils.PlatformFutureUtils;
import org.apache.ignite.internal.processors.platform.utils.PlatformListenable;
import org.apache.ignite.internal.processors.platform.utils.PlatformListenableTarget;
import org.apache.ignite.lang.IgniteFuture;
import org.jetbrains.annotations.Nullable;

public abstract class PlatformAbstractTarget
implements PlatformTarget,
PlatformAsyncTarget {
    protected static final int TRUE = 1;
    protected static final int FALSE = 0;
    protected static final int ERROR = -1;
    protected final PlatformContext platformCtx;
    protected final IgniteLogger log;

    protected PlatformAbstractTarget(PlatformContext platformCtx) {
        this.platformCtx = platformCtx;
        this.log = platformCtx.kernalContext().log(PlatformAbstractTarget.class);
    }

    public PlatformContext platformContext() {
        return this.platformCtx;
    }

    @Override
    public Exception convertException(Exception e) {
        return e;
    }

    @Override
    public IgniteInternalFuture currentFuture() throws IgniteCheckedException {
        throw new IgniteCheckedException("Future listening is not supported in " + this.getClass());
    }

    @Override
    @Nullable
    public PlatformFutureUtils.Writer futureWriter(int opId) {
        return null;
    }

    @Override
    public long processInLongOutLong(int type, long val) throws IgniteCheckedException {
        return (Long)this.throwUnsupported(type);
    }

    @Override
    public long processInStreamOutLong(int type, BinaryRawReaderEx reader) throws IgniteCheckedException {
        return (Long)this.throwUnsupported(type);
    }

    @Override
    public long processInStreamOutLong(int type, BinaryRawReaderEx reader, PlatformMemory mem) throws IgniteCheckedException {
        return this.processInStreamOutLong(type, reader);
    }

    @Override
    public void processInStreamOutStream(int type, BinaryRawReaderEx reader, BinaryRawWriterEx writer) throws IgniteCheckedException {
        this.throwUnsupported(type);
    }

    @Override
    public PlatformTarget processInStreamOutObject(int type, BinaryRawReaderEx reader) throws IgniteCheckedException {
        return (PlatformTarget)this.throwUnsupported(type);
    }

    @Override
    public PlatformTarget processInObjectStreamOutObjectStream(int type, @Nullable PlatformTarget arg, BinaryRawReaderEx reader, BinaryRawWriterEx writer) throws IgniteCheckedException {
        return (PlatformTarget)this.throwUnsupported(type);
    }

    @Override
    public void processOutStream(int type, BinaryRawWriterEx writer) throws IgniteCheckedException {
        this.throwUnsupported(type);
    }

    @Override
    public PlatformTarget processOutObject(int type) throws IgniteCheckedException {
        return (PlatformTarget)this.throwUnsupported(type);
    }

    private <T> T throwUnsupported(int type) throws IgniteCheckedException {
        throw new IgniteCheckedException("Unsupported operation type: " + type);
    }

    protected PlatformListenable readAndListenFuture(BinaryRawReader reader, IgniteInternalFuture fut, PlatformFutureUtils.Writer writer) throws IgniteCheckedException {
        long futId = reader.readLong();
        int futTyp = reader.readInt();
        return PlatformFutureUtils.listen(this.platformCtx, fut, futId, futTyp, writer, (PlatformTarget)this);
    }

    protected PlatformListenable readAndListenFuture(BinaryRawReader reader, IgniteFuture fut, PlatformFutureUtils.Writer writer) throws IgniteCheckedException {
        long futId = reader.readLong();
        int futTyp = reader.readInt();
        return PlatformFutureUtils.listen(this.platformCtx, fut, futId, futTyp, writer, (PlatformTarget)this);
    }

    protected PlatformListenable readAndListenFuture(BinaryRawReader reader, IgniteInternalFuture fut) throws IgniteCheckedException {
        return this.readAndListenFuture(reader, fut, null);
    }

    protected PlatformListenable readAndListenFuture(BinaryRawReader reader, IgniteFuture fut) throws IgniteCheckedException {
        return this.readAndListenFuture(reader, fut, null);
    }

    protected long readAndListenFuture(BinaryRawReader reader) throws IgniteCheckedException {
        this.readAndListenFuture(reader, this.currentFuture(), null);
        return 1L;
    }

    protected PlatformTarget wrapListenable(PlatformListenable listenable) {
        return new PlatformListenableTarget(listenable, this.platformCtx);
    }
}

