/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteAtomicSequence;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.NearCacheConfiguration;
import org.apache.ignite.configuration.PlatformConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.binary.BinaryRawReaderEx;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.processors.GridProcessorAdapter;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxy;
import org.apache.ignite.internal.processors.datastreamer.DataStreamerImpl;
import org.apache.ignite.internal.processors.datastructures.GridCacheAtomicLongImpl;
import org.apache.ignite.internal.processors.platform.PlatformConfigurationEx;
import org.apache.ignite.internal.processors.platform.PlatformContext;
import org.apache.ignite.internal.processors.platform.PlatformContextImpl;
import org.apache.ignite.internal.processors.platform.PlatformProcessor;
import org.apache.ignite.internal.processors.platform.PlatformTarget;
import org.apache.ignite.internal.processors.platform.PlatformTargetProxy;
import org.apache.ignite.internal.processors.platform.PlatformTargetProxyImpl;
import org.apache.ignite.internal.processors.platform.binary.PlatformBinaryProcessor;
import org.apache.ignite.internal.processors.platform.cache.PlatformCache;
import org.apache.ignite.internal.processors.platform.cache.PlatformCacheExtension;
import org.apache.ignite.internal.processors.platform.cache.affinity.PlatformAffinity;
import org.apache.ignite.internal.processors.platform.cache.store.PlatformCacheStore;
import org.apache.ignite.internal.processors.platform.cluster.PlatformClusterGroup;
import org.apache.ignite.internal.processors.platform.compute.PlatformCompute;
import org.apache.ignite.internal.processors.platform.datastreamer.PlatformDataStreamer;
import org.apache.ignite.internal.processors.platform.datastructures.PlatformAtomicLong;
import org.apache.ignite.internal.processors.platform.datastructures.PlatformAtomicReference;
import org.apache.ignite.internal.processors.platform.datastructures.PlatformAtomicSequence;
import org.apache.ignite.internal.processors.platform.dotnet.PlatformDotNetCacheStore;
import org.apache.ignite.internal.processors.platform.events.PlatformEvents;
import org.apache.ignite.internal.processors.platform.memory.PlatformMemory;
import org.apache.ignite.internal.processors.platform.memory.PlatformOutputStream;
import org.apache.ignite.internal.processors.platform.messaging.PlatformMessaging;
import org.apache.ignite.internal.processors.platform.services.PlatformServices;
import org.apache.ignite.internal.processors.platform.transactions.PlatformTransactions;
import org.apache.ignite.internal.processors.platform.utils.PlatformConfigurationUtils;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteFuture;
import org.jetbrains.annotations.Nullable;

public class PlatformProcessorImpl
extends GridProcessorAdapter
implements PlatformProcessor {
    private final CountDownLatch startLatch = new CountDownLatch(1);
    private final Collection<StoreInfo> pendingStores = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ReadWriteLock storeLock = new ReentrantReadWriteLock();
    private final IgniteLogger log;
    private final PlatformContext platformCtx;
    private final PlatformConfigurationEx interopCfg;
    private boolean started;
    private volatile boolean stopped;
    private final PlatformCacheExtension[] cacheExts;
    private volatile boolean clusterRestarted;

    public PlatformProcessorImpl(GridKernalContext ctx) {
        super(ctx);
        this.log = ctx.log(PlatformProcessorImpl.class);
        PlatformConfiguration interopCfg0 = ctx.config().getPlatformConfiguration();
        assert (interopCfg0 != null) : "Must be checked earlier during component creation.";
        if (!(interopCfg0 instanceof PlatformConfigurationEx)) {
            throw new IgniteException("Unsupported platform configuration: " + interopCfg0.getClass().getName());
        }
        this.interopCfg = (PlatformConfigurationEx)((Object)interopCfg0);
        if (!F.isEmpty(this.interopCfg.warnings())) {
            for (String w : this.interopCfg.warnings()) {
                U.warn(this.log, w);
            }
        }
        this.platformCtx = new PlatformContextImpl(ctx, this.interopCfg.gate(), this.interopCfg.memory(), this.interopCfg.platform());
        this.cacheExts = PlatformProcessorImpl.prepareCacheExtensions(this.interopCfg.cacheExtensions());
        if (this.interopCfg.logger() != null) {
            this.interopCfg.logger().setContext(this.platformCtx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws IgniteCheckedException {
        try (PlatformMemory mem = this.platformCtx.memory().allocate();){
            PlatformOutputStream out = mem.output();
            BinaryRawWriterEx writer = this.platformCtx.writer(out);
            writer.writeString(this.ctx.gridName());
            out.synchronize();
            this.platformCtx.gateway().onStart(this, mem.pointer());
        }
        this.storeLock.writeLock().lock();
        try {
            for (StoreInfo store : this.pendingStores) {
                this.registerStore0(store.store, store.convertBinary);
            }
            this.pendingStores.clear();
            this.started = true;
        }
        finally {
            this.storeLock.writeLock().unlock();
        }
        this.ctx.addNodeAttribute("org.apache.ignite.platform", this.interopCfg.platform());
    }

    @Override
    public void onKernalStop(boolean cancel) {
        this.startLatch.countDown();
    }

    @Override
    public void stop(boolean cancel) throws IgniteCheckedException {
        if (this.platformCtx != null) {
            this.stopped = true;
            this.platformCtx.gateway().onStop();
        }
    }

    @Override
    public Ignite ignite() {
        return this.ctx.grid();
    }

    @Override
    public long environmentPointer() {
        return this.platformCtx.gateway().environmentPointer();
    }

    @Override
    public void releaseStart() {
        this.startLatch.countDown();
    }

    @Override
    public void awaitStart() throws IgniteCheckedException {
        U.await(this.startLatch);
    }

    @Override
    public PlatformContext context() {
        if (!"dotnet".equals(this.interopCfg.platform())) {
            throw new IgniteException(".NET platform is not available [nodeId=" + this.ctx.grid().localNode().id() + "] " + "(Use Apache.Ignite.Core.Ignition.Start() or Apache.Ignite.exe to start Ignite.NET nodes).");
        }
        return this.platformCtx;
    }

    @Override
    public PlatformTargetProxy cache(@Nullable String name) throws IgniteCheckedException {
        IgniteCacheProxy cache = (IgniteCacheProxy)this.ctx.grid().cache(name);
        if (cache == null) {
            throw new IllegalArgumentException("Cache doesn't exist: " + name);
        }
        return this.createPlatformCache(cache);
    }

    @Override
    public PlatformTargetProxy createCache(@Nullable String name) throws IgniteCheckedException {
        IgniteCacheProxy cache = (IgniteCacheProxy)this.ctx.grid().createCache(name);
        assert (cache != null);
        return this.createPlatformCache(cache);
    }

    @Override
    public PlatformTargetProxy getOrCreateCache(@Nullable String name) throws IgniteCheckedException {
        IgniteCacheProxy cache = (IgniteCacheProxy)this.ctx.grid().getOrCreateCache(name);
        assert (cache != null);
        return this.createPlatformCache(cache);
    }

    @Override
    public PlatformTargetProxy createCacheFromConfig(long memPtr) throws IgniteCheckedException {
        BinaryRawReaderEx reader = this.platformCtx.reader(this.platformCtx.memory().get(memPtr));
        CacheConfiguration cfg = PlatformConfigurationUtils.readCacheConfiguration(reader);
        IgniteCacheProxy cache = reader.readBoolean() ? (IgniteCacheProxy)this.ctx.grid().createCache(cfg, PlatformConfigurationUtils.readNearConfiguration(reader)) : (IgniteCacheProxy)this.ctx.grid().createCache(cfg);
        return this.createPlatformCache(cache);
    }

    @Override
    public PlatformTargetProxy getOrCreateCacheFromConfig(long memPtr) throws IgniteCheckedException {
        BinaryRawReaderEx reader = this.platformCtx.reader(this.platformCtx.memory().get(memPtr));
        CacheConfiguration cfg = PlatformConfigurationUtils.readCacheConfiguration(reader);
        IgniteCacheProxy cache = reader.readBoolean() ? (IgniteCacheProxy)this.ctx.grid().getOrCreateCache(cfg, PlatformConfigurationUtils.readNearConfiguration(reader)) : (IgniteCacheProxy)this.ctx.grid().getOrCreateCache(cfg);
        return this.createPlatformCache(cache);
    }

    @Override
    public void destroyCache(@Nullable String name) throws IgniteCheckedException {
        this.ctx.grid().destroyCache(name);
    }

    @Override
    public PlatformTargetProxy affinity(@Nullable String name) throws IgniteCheckedException {
        return this.proxy(new PlatformAffinity(this.platformCtx, this.ctx, name));
    }

    @Override
    public PlatformTargetProxy dataStreamer(@Nullable String cacheName, boolean keepBinary) throws IgniteCheckedException {
        DataStreamerImpl ldr = this.ctx.dataStream().dataStreamer(cacheName);
        ldr.keepBinary(true);
        return this.proxy(new PlatformDataStreamer(this.platformCtx, cacheName, ldr, keepBinary));
    }

    @Override
    public PlatformTargetProxy transactions() {
        return this.proxy(new PlatformTransactions(this.platformCtx));
    }

    @Override
    public PlatformTargetProxy projection() throws IgniteCheckedException {
        return this.proxy(new PlatformClusterGroup(this.platformCtx, this.ctx.grid().cluster()));
    }

    @Override
    public PlatformTargetProxy compute(PlatformTargetProxy grp) {
        PlatformClusterGroup grp0 = (PlatformClusterGroup)grp.unwrap();
        return this.proxy(new PlatformCompute(this.platformCtx, grp0.projection(), "org.apache.ignite.platform"));
    }

    @Override
    public PlatformTargetProxy message(PlatformTargetProxy grp) {
        PlatformClusterGroup grp0 = (PlatformClusterGroup)grp.unwrap();
        return this.proxy(new PlatformMessaging(this.platformCtx, grp0.projection().ignite().message(grp0.projection())));
    }

    @Override
    public PlatformTargetProxy events(PlatformTargetProxy grp) {
        PlatformClusterGroup grp0 = (PlatformClusterGroup)grp.unwrap();
        return this.proxy(new PlatformEvents(this.platformCtx, grp0.projection().ignite().events(grp0.projection())));
    }

    @Override
    public PlatformTargetProxy services(PlatformTargetProxy grp) {
        PlatformClusterGroup grp0 = (PlatformClusterGroup)grp.unwrap();
        return this.proxy(new PlatformServices(this.platformCtx, grp0.projection().ignite().services(grp0.projection()), false));
    }

    @Override
    public PlatformTargetProxy extensions() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerStore(PlatformCacheStore store, boolean convertBinary) throws IgniteCheckedException {
        this.storeLock.readLock().lock();
        try {
            if (this.stopped) {
                throw new IgniteCheckedException("Failed to initialize interop store because node is stopping: " + store);
            }
            if (this.started) {
                this.registerStore0(store, convertBinary);
            } else {
                this.pendingStores.add(new StoreInfo(store, convertBinary));
            }
        }
        finally {
            this.storeLock.readLock().unlock();
        }
    }

    @Override
    public PlatformTargetProxy atomicLong(String name, long initVal, boolean create) throws IgniteException {
        GridCacheAtomicLongImpl atomicLong = (GridCacheAtomicLongImpl)this.ignite().atomicLong(name, initVal, create);
        if (atomicLong == null) {
            return null;
        }
        return this.proxy(new PlatformAtomicLong(this.platformCtx, atomicLong));
    }

    @Override
    public PlatformTargetProxy atomicSequence(String name, long initVal, boolean create) throws IgniteException {
        IgniteAtomicSequence atomicSeq = this.ignite().atomicSequence(name, initVal, create);
        if (atomicSeq == null) {
            return null;
        }
        return this.proxy(new PlatformAtomicSequence(this.platformCtx, atomicSeq));
    }

    @Override
    public PlatformTargetProxy atomicReference(String name, long memPtr, boolean create) throws IgniteException {
        PlatformAtomicReference ref = PlatformAtomicReference.createInstance(this.platformCtx, name, memPtr, create);
        return ref != null ? this.proxy(ref) : null;
    }

    @Override
    public void onDisconnected(IgniteFuture<?> reconnectFut) throws IgniteCheckedException {
        this.platformCtx.gateway().onClientDisconnected();
        reconnectFut.listen(new CI1<IgniteFuture<?>>(){

            @Override
            public void apply(IgniteFuture<?> future) {
                PlatformProcessorImpl.this.platformCtx.gateway().onClientReconnected(PlatformProcessorImpl.this.clusterRestarted);
            }
        });
    }

    @Override
    public IgniteInternalFuture<?> onReconnected(boolean clusterRestarted) throws IgniteCheckedException {
        this.clusterRestarted = clusterRestarted;
        return null;
    }

    @Override
    public void getIgniteConfiguration(long memPtr) {
        PlatformOutputStream stream = this.platformCtx.memory().get(memPtr).output();
        BinaryRawWriterEx writer = this.platformCtx.writer(stream);
        PlatformConfigurationUtils.writeIgniteConfiguration(writer, this.ignite().configuration());
        stream.synchronize();
    }

    @Override
    public void getCacheNames(long memPtr) {
        PlatformOutputStream stream = this.platformCtx.memory().get(memPtr).output();
        BinaryRawWriterEx writer = this.platformCtx.writer(stream);
        Collection<String> names = this.ignite().cacheNames();
        writer.writeInt(names.size());
        for (String name : names) {
            writer.writeString(name);
        }
        stream.synchronize();
    }

    @Override
    public PlatformTargetProxy createNearCache(@Nullable String cacheName, long memPtr) {
        NearCacheConfiguration cfg = this.getNearCacheConfiguration(memPtr);
        IgniteCacheProxy cache = (IgniteCacheProxy)this.ctx.grid().createNearCache(cacheName, cfg);
        return this.createPlatformCache(cache);
    }

    @Override
    public PlatformTargetProxy getOrCreateNearCache(@Nullable String cacheName, long memPtr) {
        NearCacheConfiguration cfg = this.getNearCacheConfiguration(memPtr);
        IgniteCacheProxy cache = (IgniteCacheProxy)this.ctx.grid().getOrCreateNearCache(cacheName, cfg);
        return this.createPlatformCache(cache);
    }

    private PlatformTargetProxy createPlatformCache(IgniteCacheProxy cache) {
        return this.proxy(new PlatformCache(this.platformCtx, cache, false, this.cacheExts));
    }

    @Override
    public boolean loggerIsLevelEnabled(int level) {
        IgniteLogger log = this.ctx.grid().log();
        switch (level) {
            case 0: {
                return log.isTraceEnabled();
            }
            case 1: {
                return log.isDebugEnabled();
            }
            case 2: {
                return log.isInfoEnabled();
            }
            case 3: {
                return true;
            }
            case 4: {
                return true;
            }
        }
        assert (false);
        return false;
    }

    @Override
    public void loggerLog(int level, String message, String category, String errorInfo) {
        IgniteLogger log = this.ctx.grid().log();
        if (category != null) {
            log = log.getLogger(category);
        }
        IgniteException err = errorInfo == null ? null : new IgniteException("Platform error:" + errorInfo);
        switch (level) {
            case 0: {
                log.trace(message);
                break;
            }
            case 1: {
                log.debug(message);
                break;
            }
            case 2: {
                log.info(message);
                break;
            }
            case 3: {
                log.warning(message, err);
                break;
            }
            case 4: {
                log.error(message, err);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    @Override
    public PlatformTargetProxy binaryProcessor() {
        return this.proxy(new PlatformBinaryProcessor(this.platformCtx));
    }

    private NearCacheConfiguration getNearCacheConfiguration(long memPtr) {
        assert (memPtr != 0L);
        BinaryRawReaderEx reader = this.platformCtx.reader(this.platformCtx.memory().get(memPtr));
        return PlatformConfigurationUtils.readNearConfiguration(reader);
    }

    private void registerStore0(PlatformCacheStore store, boolean convertBinary) throws IgniteCheckedException {
        if (!(store instanceof PlatformDotNetCacheStore)) {
            throw new IgniteCheckedException("Unsupported interop store: " + store);
        }
        PlatformDotNetCacheStore store0 = (PlatformDotNetCacheStore)store;
        store0.initialize(this.ctx, convertBinary);
    }

    private static PlatformCacheExtension[] prepareCacheExtensions(Collection<PlatformCacheExtension> cacheExts) {
        if (!F.isEmpty(cacheExts)) {
            int maxExtId = 0;
            HashMap<Integer, PlatformCacheExtension> idToExt = new HashMap<Integer, PlatformCacheExtension>();
            for (PlatformCacheExtension cacheExt : cacheExts) {
                if (cacheExt == null) {
                    throw new IgniteException("Platform cache extension cannot be null.");
                }
                if (cacheExt.id() < 0) {
                    throw new IgniteException("Platform cache extension ID cannot be negative: " + cacheExt);
                }
                PlatformCacheExtension oldCacheExt = idToExt.put(cacheExt.id(), cacheExt);
                if (oldCacheExt != null) {
                    throw new IgniteException("Platform cache extensions cannot have the same ID [id=" + cacheExt.id() + ", first=" + oldCacheExt + ", second=" + cacheExt + ']');
                }
                if (cacheExt.id() <= maxExtId) continue;
                maxExtId = cacheExt.id();
            }
            PlatformCacheExtension[] res = new PlatformCacheExtension[maxExtId + 1];
            Iterator<PlatformCacheExtension> i$ = cacheExts.iterator();
            while (i$.hasNext()) {
                PlatformCacheExtension cacheExt;
                res[cacheExt.id()] = cacheExt = i$.next();
            }
            return res;
        }
        return new PlatformCacheExtension[0];
    }

    private PlatformTargetProxy proxy(PlatformTarget target) {
        return new PlatformTargetProxyImpl(target, this.platformCtx);
    }

    private static class StoreInfo {
        private final PlatformCacheStore store;
        private final boolean convertBinary;

        private StoreInfo(PlatformCacheStore store, boolean convertBinary) {
            this.store = store;
            this.convertBinary = convertBinary;
        }
    }
}

