/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.binary;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.binary.BinaryRawReaderEx;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.processors.platform.PlatformAbstractTarget;
import org.apache.ignite.internal.processors.platform.PlatformContext;

public class PlatformBinaryProcessor
extends PlatformAbstractTarget {
    private static final int OP_GET_META = 1;
    private static final int OP_GET_ALL_META = 2;
    private static final int OP_PUT_META = 3;
    private static final int OP_GET_SCHEMA = 4;

    public PlatformBinaryProcessor(PlatformContext platformCtx) {
        super(platformCtx);
    }

    @Override
    public long processInStreamOutLong(int type, BinaryRawReaderEx reader) throws IgniteCheckedException {
        if (type == 3) {
            this.platformCtx.processMetadata(reader);
            return 1L;
        }
        return super.processInStreamOutLong(type, reader);
    }

    @Override
    public void processOutStream(int type, BinaryRawWriterEx writer) throws IgniteCheckedException {
        if (type == 2) {
            this.platformCtx.writeAllMetadata(writer);
        } else {
            super.processOutStream(type, writer);
        }
    }

    @Override
    public void processInStreamOutStream(int type, BinaryRawReaderEx reader, BinaryRawWriterEx writer) throws IgniteCheckedException {
        switch (type) {
            case 1: {
                int typeId = reader.readInt();
                this.platformCtx.writeMetadata(writer, typeId);
                break;
            }
            case 4: {
                int typeId = reader.readInt();
                int schemaId = reader.readInt();
                this.platformCtx.writeSchema(writer, typeId, schemaId);
                break;
            }
            default: {
                super.processInStreamOutStream(type, reader, writer);
            }
        }
    }
}

