/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.cache.query;

import java.util.Iterator;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.processors.cache.query.QueryCursorEx;
import org.apache.ignite.internal.processors.platform.PlatformAbstractTarget;
import org.apache.ignite.internal.processors.platform.PlatformContext;
import org.apache.ignite.internal.processors.platform.utils.PlatformUtils;

public abstract class PlatformAbstractQueryCursor<T>
extends PlatformAbstractTarget
implements AutoCloseable {
    private static final int OP_GET_ALL = 1;
    private static final int OP_GET_BATCH = 2;
    private static final int OP_GET_SINGLE = 3;
    private static final int OP_ITERATOR = 4;
    private static final int OP_ITERATOR_CLOSE = 5;
    private static final int OP_ITERATOR_HAS_NEXT = 6;
    private final QueryCursorEx<T> cursor;
    private final int batchSize;
    private Iterator<T> iter;

    public PlatformAbstractQueryCursor(PlatformContext platformCtx, QueryCursorEx<T> cursor, int batchSize) {
        super(platformCtx);
        this.cursor = cursor;
        this.batchSize = batchSize;
    }

    @Override
    public void processOutStream(int type, BinaryRawWriterEx writer) throws IgniteCheckedException {
        switch (type) {
            case 2: {
                assert (this.iter != null) : "iterator() has not been called";
                try {
                    int cnt;
                    int cntPos = writer.reserveInt();
                    for (cnt = 0; cnt < this.batchSize && this.iter.hasNext(); ++cnt) {
                        this.write(writer, this.iter.next());
                    }
                    writer.writeInt(cntPos, cnt);
                    break;
                }
                catch (Exception err) {
                    throw PlatformUtils.unwrapQueryException(err);
                }
            }
            case 3: {
                assert (this.iter != null) : "iterator() has not been called";
                try {
                    if (this.iter.hasNext()) {
                        this.write(writer, this.iter.next());
                        return;
                    }
                }
                catch (Exception err) {
                    throw PlatformUtils.unwrapQueryException(err);
                }
                throw new IgniteCheckedException("No more data available.");
            }
            case 1: {
                try {
                    int pos = writer.reserveInt();
                    Consumer consumer = new Consumer(this, writer);
                    this.cursor.getAll(consumer);
                    writer.writeInt(pos, consumer.cnt);
                    break;
                }
                catch (Exception err) {
                    throw PlatformUtils.unwrapQueryException(err);
                }
            }
            default: {
                super.processOutStream(type, writer);
            }
        }
    }

    @Override
    public long processInLongOutLong(int type, long val) throws IgniteCheckedException {
        switch (type) {
            case 4: {
                this.iter = this.cursor.iterator();
                return 1L;
            }
            case 5: {
                this.cursor.close();
                return 1L;
            }
            case 6: {
                assert (this.iter != null) : "iterator() has not been called";
                return this.iter.hasNext() ? 1L : 0L;
            }
        }
        return super.processInLongOutLong(type, val);
    }

    @Override
    public void close() throws Exception {
        this.cursor.close();
    }

    protected abstract void write(BinaryRawWriterEx var1, T var2);

    private static class Consumer<T>
    implements QueryCursorEx.Consumer<T> {
        private final PlatformAbstractQueryCursor<T> cursor;
        private final BinaryRawWriterEx writer;
        private int cnt;

        public Consumer(PlatformAbstractQueryCursor<T> cursor, BinaryRawWriterEx writer) {
            this.cursor = cursor;
            this.writer = writer;
        }

        @Override
        public void consume(T val) throws IgniteCheckedException {
            this.cursor.write(this.writer, val);
            ++this.cnt;
        }
    }
}

