/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.cluster;

import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteCluster;
import org.apache.ignite.cluster.ClusterMetrics;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.binary.BinaryRawReaderEx;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.cluster.ClusterGroupEx;
import org.apache.ignite.internal.processors.platform.PlatformAbstractTarget;
import org.apache.ignite.internal.processors.platform.PlatformContext;
import org.apache.ignite.internal.processors.platform.PlatformTarget;
import org.apache.ignite.internal.processors.platform.cache.PlatformCache;
import org.apache.ignite.internal.processors.platform.utils.PlatformUtils;
import org.jetbrains.annotations.Nullable;

public class PlatformClusterGroup
extends PlatformAbstractTarget {
    private static final int OP_FOR_ATTRIBUTE = 2;
    private static final int OP_FOR_CACHE = 3;
    private static final int OP_FOR_CLIENT = 4;
    private static final int OP_FOR_DATA = 5;
    private static final int OP_FOR_HOST = 6;
    private static final int OP_FOR_NODE_IDS = 7;
    private static final int OP_METRICS = 9;
    private static final int OP_METRICS_FILTERED = 10;
    private static final int OP_NODE_METRICS = 11;
    private static final int OP_NODES = 12;
    private static final int OP_PING_NODE = 13;
    private static final int OP_TOPOLOGY = 14;
    private static final int OP_FOR_OTHERS = 16;
    private static final int OP_FOR_REMOTES = 17;
    private static final int OP_FOR_DAEMONS = 18;
    private static final int OP_FOR_RANDOM = 19;
    private static final int OP_FOR_OLDEST = 20;
    private static final int OP_FOR_YOUNGEST = 21;
    private static final int OP_RESET_METRICS = 22;
    private static final int OP_FOR_SERVERS = 23;
    private static final int OP_CACHE_METRICS = 24;
    private final ClusterGroupEx prj;

    public PlatformClusterGroup(PlatformContext platformCtx, ClusterGroupEx prj) {
        super(platformCtx);
        this.prj = prj;
    }

    @Override
    public void processOutStream(int type, BinaryRawWriterEx writer) throws IgniteCheckedException {
        switch (type) {
            case 9: {
                this.platformCtx.writeClusterMetrics(writer, this.prj.metrics());
                break;
            }
            default: {
                super.processOutStream(type, writer);
            }
        }
    }

    @Override
    public void processInStreamOutStream(int type, BinaryRawReaderEx reader, BinaryRawWriterEx writer) throws IgniteCheckedException {
        switch (type) {
            case 10: {
                List<UUID> ids = PlatformUtils.readCollection(reader);
                this.platformCtx.writeClusterMetrics(writer, this.prj.forNodeIds(ids).metrics());
                break;
            }
            case 12: {
                long oldTopVer = reader.readLong();
                long curTopVer = this.platformCtx.kernalContext().discovery().topologyVersion();
                if (curTopVer > oldTopVer) {
                    writer.writeBoolean(true);
                    writer.writeLong(curTopVer);
                    Collection<ClusterNode> nodes = this.prj.nodes();
                    this.platformCtx.writeNodes(writer, nodes);
                    break;
                }
                writer.writeBoolean(false);
                break;
            }
            case 11: {
                UUID nodeId = reader.readUuid();
                long lastUpdateTime = reader.readLong();
                ClusterNode node = this.platformCtx.kernalContext().discovery().node(nodeId);
                ClusterMetrics metrics = null;
                if (node != null) {
                    ClusterMetrics metrics0 = node.metrics();
                    long triggerTime = lastUpdateTime + this.platformCtx.kernalContext().config().getMetricsUpdateFrequency();
                    metrics = metrics0.getLastUpdateTime() > triggerTime ? metrics0 : null;
                }
                this.platformCtx.writeClusterMetrics(writer, metrics);
                break;
            }
            case 14: {
                long topVer = reader.readLong();
                this.platformCtx.writeNodes(writer, this.topology(topVer));
                break;
            }
            case 24: {
                String cacheName = reader.readString();
                IgniteCache cache = this.platformCtx.kernalContext().grid().cache(cacheName);
                PlatformCache.writeCacheMetrics(writer, cache.metrics(this.prj));
                break;
            }
            default: {
                super.processInStreamOutStream(type, reader, writer);
            }
        }
    }

    @Override
    public long processInStreamOutLong(int type, BinaryRawReaderEx reader) throws IgniteCheckedException {
        switch (type) {
            case 13: {
                return this.pingNode(reader.readUuid()) ? 1L : 0L;
            }
        }
        return super.processInStreamOutLong(type, reader);
    }

    @Override
    public PlatformTarget processInStreamOutObject(int type, BinaryRawReaderEx reader) throws IgniteCheckedException {
        switch (type) {
            case 7: {
                List<UUID> ids = PlatformUtils.readCollection(reader);
                return new PlatformClusterGroup(this.platformCtx, (ClusterGroupEx)this.prj.forNodeIds(ids));
            }
            case 2: {
                return new PlatformClusterGroup(this.platformCtx, (ClusterGroupEx)this.prj.forAttribute(reader.readString(), reader.readString()));
            }
            case 3: {
                String cacheName = reader.readString();
                return new PlatformClusterGroup(this.platformCtx, (ClusterGroupEx)this.prj.forCacheNodes(cacheName));
            }
            case 4: {
                String cacheName = reader.readString();
                return new PlatformClusterGroup(this.platformCtx, (ClusterGroupEx)this.prj.forClientNodes(cacheName));
            }
            case 5: {
                String cacheName = reader.readString();
                return new PlatformClusterGroup(this.platformCtx, (ClusterGroupEx)this.prj.forDataNodes(cacheName));
            }
            case 6: {
                UUID nodeId = reader.readUuid();
                ClusterNode node = this.prj.node(nodeId);
                return new PlatformClusterGroup(this.platformCtx, (ClusterGroupEx)this.prj.forHost(node));
            }
        }
        return super.processInStreamOutObject(type, reader);
    }

    @Override
    public PlatformTarget processInObjectStreamOutObjectStream(int type, @Nullable PlatformTarget arg, BinaryRawReaderEx reader, BinaryRawWriterEx writer) throws IgniteCheckedException {
        switch (type) {
            case 16: {
                PlatformClusterGroup exclude = (PlatformClusterGroup)arg;
                assert (exclude != null);
                return new PlatformClusterGroup(this.platformCtx, (ClusterGroupEx)this.prj.forOthers(exclude.prj));
            }
        }
        return super.processInObjectStreamOutObjectStream(type, arg, reader, writer);
    }

    @Override
    public PlatformTarget processOutObject(int type) throws IgniteCheckedException {
        switch (type) {
            case 17: {
                return new PlatformClusterGroup(this.platformCtx, (ClusterGroupEx)this.prj.forRemotes());
            }
            case 18: {
                return new PlatformClusterGroup(this.platformCtx, (ClusterGroupEx)this.prj.forDaemons());
            }
            case 19: {
                return new PlatformClusterGroup(this.platformCtx, (ClusterGroupEx)this.prj.forRandom());
            }
            case 20: {
                return new PlatformClusterGroup(this.platformCtx, (ClusterGroupEx)this.prj.forOldest());
            }
            case 21: {
                return new PlatformClusterGroup(this.platformCtx, (ClusterGroupEx)this.prj.forYoungest());
            }
            case 23: {
                return new PlatformClusterGroup(this.platformCtx, (ClusterGroupEx)this.prj.forServers());
            }
        }
        return super.processOutObject(type);
    }

    @Override
    public long processInLongOutLong(int type, long val) throws IgniteCheckedException {
        switch (type) {
            case 22: {
                assert (this.prj instanceof IgniteCluster);
                ((IgniteCluster)((Object)this.prj)).resetMetrics();
                return 1L;
            }
        }
        return super.processInLongOutLong(type, val);
    }

    public ClusterGroupEx projection() {
        return this.prj;
    }

    private boolean pingNode(UUID nodeId) {
        assert (this.prj instanceof IgniteCluster);
        return ((IgniteCluster)((Object)this.prj)).pingNode(nodeId);
    }

    private Collection<ClusterNode> topology(long topVer) {
        assert (this.prj instanceof IgniteCluster);
        return ((IgniteCluster)((Object)this.prj)).topology(topVer);
    }
}

