/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.cluster;

import org.apache.ignite.Ignite;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.processors.platform.PlatformAbstractPredicate;
import org.apache.ignite.internal.processors.platform.PlatformContext;
import org.apache.ignite.internal.processors.platform.cluster.PlatformClusterNodeFilter;
import org.apache.ignite.internal.processors.platform.memory.PlatformMemory;
import org.apache.ignite.internal.processors.platform.memory.PlatformOutputStream;
import org.apache.ignite.internal.processors.platform.utils.PlatformUtils;
import org.apache.ignite.resources.IgniteInstanceResource;

public class PlatformClusterNodeFilterImpl
extends PlatformAbstractPredicate
implements PlatformClusterNodeFilter {
    private static final long serialVersionUID = 0L;

    public PlatformClusterNodeFilterImpl() {
    }

    public PlatformClusterNodeFilterImpl(Object pred, PlatformContext ctx) {
        super(pred, 0L, ctx);
    }

    @Override
    public boolean apply(ClusterNode clusterNode) {
        try (PlatformMemory mem = this.ctx.memory().allocate();){
            PlatformOutputStream out = mem.output();
            BinaryRawWriterEx writer = this.ctx.writer(out);
            writer.writeObject(this.pred);
            this.ctx.writeNode(writer, clusterNode);
            out.synchronize();
            boolean bl = this.ctx.gateway().clusterNodeFilterApply(mem.pointer()) != 0;
            return bl;
        }
    }

    @IgniteInstanceResource
    public void setIgniteInstance(Ignite ignite) {
        this.ctx = PlatformUtils.platformContext(ignite);
    }
}

