/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.compute;

import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite.IgniteException;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.compute.ComputeJobResultPolicy;
import org.apache.ignite.compute.ComputeTask;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.processors.platform.PlatformContext;
import org.apache.ignite.internal.processors.platform.PlatformNativeException;
import org.apache.ignite.internal.processors.platform.compute.PlatformAbstractJob;
import org.apache.ignite.internal.processors.platform.memory.PlatformMemory;
import org.apache.ignite.internal.processors.platform.memory.PlatformOutputStream;
import org.apache.ignite.internal.processors.platform.utils.PlatformUtils;
import org.apache.ignite.internal.util.typedef.X;
import org.jetbrains.annotations.Nullable;

public abstract class PlatformAbstractTask
implements ComputeTask<Object, Void> {
    protected final PlatformContext ctx;
    protected final long taskPtr;
    protected final ReadWriteLock lock = new ReentrantReadWriteLock();
    protected boolean done;

    protected PlatformAbstractTask(PlatformContext ctx, long taskPtr) {
        this.ctx = ctx;
        this.taskPtr = taskPtr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComputeJobResultPolicy result(ComputeJobResult res, List<ComputeJobResult> rcvd) {
        assert (rcvd.isEmpty()) : "Should not cache result in Java for interop task";
        this.lock.readLock().lock();
        try {
            Object object;
            int plc;
            assert (!this.done);
            PlatformAbstractJob job = (PlatformAbstractJob)res.getJob();
            assert (job.pointer() != 0L);
            Object res0bj = res.getData();
            if (res0bj == PlatformAbstractJob.LOC_JOB_RES) {
                plc = this.ctx.gateway().computeTaskLocalJobResult(this.taskPtr, job.pointer());
            } else {
                PlatformMemory mem = this.ctx.memory().allocate();
                object = null;
                try {
                    PlatformOutputStream out = mem.output();
                    BinaryRawWriterEx writer = this.ctx.writer(out);
                    writer.writeLong(this.taskPtr);
                    writer.writeLong(job.pointer());
                    writer.writeUuid(res.getNode().id());
                    writer.writeBoolean(res.isCancelled());
                    IgniteException err = res.getException();
                    PlatformUtils.writeInvocationResult(writer, res0bj, err);
                    out.synchronize();
                    plc = this.ctx.gateway().computeTaskJobResult(mem.pointer());
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (mem != null) {
                        if (object != null) {
                            try {
                                mem.close();
                            }
                            catch (Throwable x2) {
                                ((Throwable)object).addSuppressed(x2);
                            }
                        } else {
                            mem.close();
                        }
                    }
                }
            }
            ComputeJobResultPolicy plc0 = ComputeJobResultPolicy.fromOrdinal((byte)plc);
            assert (plc0 != null) : plc;
            object = plc0;
            return object;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Void reduce(List<ComputeJobResult> results) {
        assert (results.isEmpty()) : "Should not cache result in java for interop task";
        this.lock.readLock().lock();
        try {
            assert (!this.done);
            this.ctx.gateway().computeTaskReduce(this.taskPtr);
        }
        finally {
            this.lock.readLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDone(Exception e) {
        block19: {
            this.lock.writeLock().lock();
            try {
                assert (!this.done);
                if (e == null) {
                    this.ctx.gateway().computeTaskComplete(this.taskPtr, 0L);
                    break block19;
                }
                PlatformNativeException e0 = X.cause(e, PlatformNativeException.class);
                try (PlatformMemory mem = this.ctx.memory().allocate();){
                    PlatformOutputStream out = mem.output();
                    BinaryRawWriterEx writer = this.ctx.writer(out);
                    if (e0 == null) {
                        writer.writeBoolean(false);
                        writer.writeString(e.getClass().getName());
                        writer.writeString(e.getMessage());
                        writer.writeString(X.getFullStackTrace(e));
                    } else {
                        writer.writeBoolean(true);
                        writer.writeObject(e0.cause());
                    }
                    out.synchronize();
                    this.ctx.gateway().computeTaskComplete(this.taskPtr, mem.pointer());
                }
            }
            finally {
                this.done = true;
                this.lock.writeLock().unlock();
            }
        }
    }

    boolean onJobLock() {
        this.lock.readLock().lock();
        if (this.done) {
            this.lock.readLock().unlock();
            return false;
        }
        return true;
    }

    void onJobUnlock() {
        assert (!this.done);
        this.lock.readLock().unlock();
    }
}

