/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.datastructures;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.binary.BinaryRawReaderEx;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.processors.datastructures.GridCacheAtomicReferenceImpl;
import org.apache.ignite.internal.processors.platform.PlatformAbstractTarget;
import org.apache.ignite.internal.processors.platform.PlatformContext;
import org.apache.ignite.internal.processors.platform.memory.PlatformMemory;

public class PlatformAtomicReference
extends PlatformAbstractTarget {
    private static final int OP_GET = 1;
    private static final int OP_SET = 2;
    private static final int OP_COMPARE_AND_SET_AND_GET = 3;
    private static final int OP_CLOSE = 4;
    private static final int OP_IS_CLOSED = 5;
    private final GridCacheAtomicReferenceImpl atomicRef;

    public static PlatformAtomicReference createInstance(PlatformContext ctx, String name, long memPtr, boolean create) {
        GridCacheAtomicReferenceImpl atomicRef;
        assert (ctx != null);
        assert (name != null);
        Object initVal = null;
        if (memPtr != 0L) {
            try (PlatformMemory mem = ctx.memory().get(memPtr);){
                initVal = ctx.reader(mem).readObjectDetached();
            }
        }
        if ((atomicRef = (GridCacheAtomicReferenceImpl)ctx.kernalContext().grid().atomicReference(name, initVal, create)) == null) {
            return null;
        }
        return new PlatformAtomicReference(ctx, atomicRef);
    }

    private PlatformAtomicReference(PlatformContext ctx, GridCacheAtomicReferenceImpl ref) {
        super(ctx);
        assert (ref != null);
        this.atomicRef = ref;
    }

    @Override
    public void processOutStream(int type, BinaryRawWriterEx writer) throws IgniteCheckedException {
        if (type == 1) {
            writer.writeObject(this.atomicRef.get());
        } else {
            super.processOutStream(type, writer);
        }
    }

    @Override
    public long processInStreamOutLong(int type, BinaryRawReaderEx reader) throws IgniteCheckedException {
        if (type == 2) {
            this.atomicRef.set(reader.readObjectDetached());
            return 0L;
        }
        return super.processInStreamOutLong(type, reader);
    }

    @Override
    public void processInStreamOutStream(int type, BinaryRawReaderEx reader, BinaryRawWriterEx writer) throws IgniteCheckedException {
        if (type == 3) {
            Object res;
            Object val = reader.readObjectDetached();
            Object cmp = reader.readObjectDetached();
            if (cmp == (res = this.atomicRef.compareAndSetAndGet(val, cmp))) {
                writer.writeBoolean(true);
            } else {
                writer.writeBoolean(false);
                writer.writeObject(res);
            }
        } else {
            super.processInStreamOutStream(type, reader, writer);
        }
    }

    @Override
    public long processInLongOutLong(int type, long val) throws IgniteCheckedException {
        switch (type) {
            case 4: {
                this.atomicRef.close();
                return 1L;
            }
            case 5: {
                return this.atomicRef.removed() ? 1L : 0L;
            }
        }
        return super.processInLongOutLong(type, val);
    }
}

