/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.dotnet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.ignite.IgniteException;
import org.apache.ignite.binary.BinaryBasicIdMapper;
import org.apache.ignite.binary.BinaryBasicNameMapper;
import org.apache.ignite.binary.BinaryIdMapper;
import org.apache.ignite.binary.BinaryNameMapper;
import org.apache.ignite.configuration.BinaryConfiguration;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.PlatformConfiguration;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.binary.GridBinaryMarshaller;
import org.apache.ignite.internal.logger.platform.PlatformLogger;
import org.apache.ignite.internal.processors.platform.PlatformAbstractConfigurationClosure;
import org.apache.ignite.internal.processors.platform.dotnet.PlatformDotNetConfigurationEx;
import org.apache.ignite.internal.processors.platform.lifecycle.PlatformLifecycleBean;
import org.apache.ignite.internal.processors.platform.memory.PlatformMemory;
import org.apache.ignite.internal.processors.platform.memory.PlatformMemoryManagerImpl;
import org.apache.ignite.internal.processors.platform.memory.PlatformOutputStream;
import org.apache.ignite.internal.processors.platform.utils.PlatformConfigurationUtils;
import org.apache.ignite.internal.processors.platform.utils.PlatformUtils;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lifecycle.LifecycleBean;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.platform.dotnet.PlatformDotNetAffinityFunction;
import org.apache.ignite.platform.dotnet.PlatformDotNetConfiguration;
import org.apache.ignite.platform.dotnet.PlatformDotNetLifecycleBean;

public class PlatformDotNetConfigurationClosure
extends PlatformAbstractConfigurationClosure {
    private static final long serialVersionUID = 0L;
    private IgniteConfiguration cfg;
    private PlatformMemoryManagerImpl memMgr;

    public PlatformDotNetConfigurationClosure(long envPtr) {
        super(envPtr);
    }

    @Override
    protected void apply0(IgniteConfiguration igniteCfg) {
        PlatformDotNetConfiguration dotNetCfg;
        PlatformConfiguration interopCfg = igniteCfg.getPlatformConfiguration();
        if (interopCfg != null && !(interopCfg instanceof PlatformDotNetConfiguration)) {
            throw new IgniteException("Illegal platform configuration (must be of type " + PlatformDotNetConfiguration.class.getName() + "): " + interopCfg.getClass().getName());
        }
        PlatformDotNetConfiguration platformDotNetConfiguration = dotNetCfg = interopCfg != null ? (PlatformDotNetConfiguration)interopCfg : null;
        if (dotNetCfg == null) {
            dotNetCfg = new PlatformDotNetConfiguration();
        }
        this.memMgr = new PlatformMemoryManagerImpl(this.gate, 1024);
        PlatformLogger userLogger = null;
        if (igniteCfg.getGridLogger() instanceof PlatformLogger) {
            userLogger = (PlatformLogger)igniteCfg.getGridLogger();
            userLogger.setGateway(this.gate);
        }
        PlatformDotNetConfigurationEx dotNetCfg0 = new PlatformDotNetConfigurationEx(dotNetCfg, this.gate, this.memMgr, userLogger);
        igniteCfg.setPlatformConfiguration(dotNetCfg0);
        Marshaller marsh = igniteCfg.getMarshaller();
        if (marsh == null) {
            igniteCfg.setMarshaller(new BinaryMarshaller());
            dotNetCfg0.warnings(Collections.singleton("Marshaller is automatically set to " + BinaryMarshaller.class.getName() + " (other nodes must have the same marshaller type)."));
        } else if (!(marsh instanceof BinaryMarshaller)) {
            throw new IgniteException("Unsupported marshaller (only " + BinaryMarshaller.class.getName() + " can be used when running Apache Ignite.NET): " + marsh.getClass().getName());
        }
        BinaryConfiguration bCfg = igniteCfg.getBinaryConfiguration();
        if (bCfg == null) {
            bCfg = new BinaryConfiguration();
            bCfg.setNameMapper(new BinaryBasicNameMapper(true));
            bCfg.setIdMapper(new BinaryBasicIdMapper(true));
            igniteCfg.setBinaryConfiguration(bCfg);
            dotNetCfg0.warnings(Collections.singleton("Binary configuration is automatically initiated, note that binary name mapper is set to " + bCfg.getNameMapper() + " and binary ID mapper is set to " + bCfg.getIdMapper() + " (other nodes must have the same binary name and ID mapper types)."));
        } else {
            BinaryIdMapper idMapper;
            BinaryNameMapper nameMapper = bCfg.getNameMapper();
            if (nameMapper == null) {
                bCfg.setNameMapper(new BinaryBasicNameMapper(true));
                dotNetCfg0.warnings(Collections.singleton("Binary name mapper is automatically set to " + bCfg.getNameMapper() + " (other nodes must have the same binary name mapper type)."));
            }
            if ((idMapper = bCfg.getIdMapper()) == null) {
                bCfg.setIdMapper(new BinaryBasicIdMapper(true));
                dotNetCfg0.warnings(Collections.singleton("Binary ID mapper is automatically set to " + bCfg.getIdMapper() + " (other nodes must have the same binary ID mapper type)."));
            }
        }
        String ggHome = igniteCfg.getIgniteHome();
        if (ggHome != null) {
            U.setIgniteHome(ggHome);
        }
        this.prepare(igniteCfg, dotNetCfg0);
    }

    private void prepare(IgniteConfiguration igniteCfg, PlatformDotNetConfigurationEx interopCfg) {
        this.cfg = igniteCfg;
        try (PlatformMemory outMem = this.memMgr.allocate();
             PlatformMemory inMem = this.memMgr.allocate();){
            PlatformOutputStream out = outMem.output();
            GridBinaryMarshaller marshaller = PlatformUtils.marshaller();
            BinaryWriterExImpl writer = marshaller.writer(out);
            PlatformConfigurationUtils.writeDotNetConfiguration(writer, interopCfg.unwrap());
            List<PlatformDotNetLifecycleBean> beans = PlatformDotNetConfigurationClosure.beans(igniteCfg);
            writer.writeInt(beans.size());
            for (PlatformDotNetLifecycleBean bean : beans) {
                writer.writeString(bean.getTypeName());
                writer.writeMap(bean.getProperties());
            }
            List<PlatformDotNetAffinityFunction> affFuncs = PlatformDotNetConfigurationClosure.affinityFunctions(igniteCfg);
            writer.writeInt(affFuncs.size());
            for (PlatformDotNetAffinityFunction func : affFuncs) {
                writer.writeString(func.getTypeName());
                writer.writeMap(func.getProperties());
            }
            out.synchronize();
            this.gate.extensionCallbackInLongLongOutLong(1, outMem.pointer(), inMem.pointer());
            this.processPrepareResult(marshaller.reader(inMem.input()));
        }
    }

    private void processPrepareResult(BinaryReaderExImpl in) {
        List<PlatformDotNetAffinityFunction> affFuncs;
        assert (this.cfg != null);
        PlatformConfigurationUtils.readIgniteConfiguration(in, this.cfg);
        List<PlatformDotNetLifecycleBean> beans = PlatformDotNetConfigurationClosure.beans(this.cfg);
        ArrayList<PlatformLifecycleBean> newBeans = new ArrayList<PlatformLifecycleBean>();
        int len = in.readInt();
        for (int i = 0; i < len; ++i) {
            if (i < beans.size()) {
                beans.get(i).initialize(this.gate, in.readLong());
                continue;
            }
            newBeans.add(new PlatformLifecycleBean(this.gate, in.readLong()));
        }
        if (!newBeans.isEmpty()) {
            LifecycleBean[] newBeans0 = newBeans.toArray(new LifecycleBean[newBeans.size()]);
            LifecycleBean[] oldBeans = this.cfg.getLifecycleBeans();
            if (oldBeans == null) {
                this.cfg.setLifecycleBeans(newBeans0);
            } else {
                LifecycleBean[] mergedBeans = new LifecycleBean[oldBeans.length + newBeans.size()];
                System.arraycopy(oldBeans, 0, mergedBeans, 0, oldBeans.length);
                System.arraycopy(newBeans0, 0, mergedBeans, oldBeans.length, newBeans0.length);
                this.cfg.setLifecycleBeans(mergedBeans);
            }
        }
        if (!(affFuncs = PlatformDotNetConfigurationClosure.affinityFunctions(this.cfg)).isEmpty()) {
            for (PlatformDotNetAffinityFunction aff : affFuncs) {
                aff.init(PlatformConfigurationUtils.readAffinityFunction(in));
            }
        }
    }

    private static List<PlatformDotNetLifecycleBean> beans(IgniteConfiguration cfg) {
        ArrayList<PlatformDotNetLifecycleBean> res = new ArrayList<PlatformDotNetLifecycleBean>();
        if (cfg.getLifecycleBeans() != null) {
            for (LifecycleBean bean : cfg.getLifecycleBeans()) {
                if (!(bean instanceof PlatformDotNetLifecycleBean)) continue;
                res.add((PlatformDotNetLifecycleBean)bean);
            }
        }
        return res;
    }

    private static List<PlatformDotNetAffinityFunction> affinityFunctions(IgniteConfiguration cfg) {
        ArrayList<PlatformDotNetAffinityFunction> res = new ArrayList<PlatformDotNetAffinityFunction>();
        CacheConfiguration[] cacheCfg = cfg.getCacheConfiguration();
        if (cacheCfg != null) {
            for (CacheConfiguration ccfg : cacheCfg) {
                if (!(ccfg.getAffinity() instanceof PlatformDotNetAffinityFunction)) continue;
                res.add((PlatformDotNetAffinityFunction)ccfg.getAffinity());
            }
        }
        return res;
    }
}

