/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.transactions;

import java.sql.Timestamp;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteTransactions;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.configuration.TransactionConfiguration;
import org.apache.ignite.internal.binary.BinaryRawReaderEx;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.processors.cache.transactions.TransactionProxyImpl;
import org.apache.ignite.internal.processors.platform.PlatformAbstractTarget;
import org.apache.ignite.internal.processors.platform.PlatformContext;
import org.apache.ignite.internal.util.GridConcurrentFactory;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.transactions.Transaction;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.apache.ignite.transactions.TransactionMetrics;

public class PlatformTransactions
extends PlatformAbstractTarget {
    public static final int OP_CACHE_CONFIG_PARAMETERS = 1;
    public static final int OP_METRICS = 2;
    public static final int OP_START = 3;
    public static final int OP_COMMIT = 4;
    public static final int OP_ROLLBACK = 5;
    public static final int OP_CLOSE = 6;
    public static final int OP_STATE = 7;
    public static final int OP_SET_ROLLBACK_ONLY = 8;
    public static final int OP_COMMIT_ASYNC = 9;
    public static final int OP_ROLLBACK_ASYNC = 10;
    public static final int OP_RESET_METRICS = 11;
    public static final int OP_PREPARE = 12;
    private final IgniteTransactions txs;
    private final ConcurrentMap<Long, Transaction> txMap = GridConcurrentFactory.newMap();
    private static final AtomicLong TX_ID_GEN = new AtomicLong();

    public PlatformTransactions(PlatformContext platformCtx) {
        super(platformCtx);
        this.txs = platformCtx.kernalContext().grid().transactions();
    }

    private long registerTx(Transaction tx) {
        long id = TX_ID_GEN.incrementAndGet();
        Transaction old = this.txMap.put(id, tx);
        assert (old == null) : "Duplicate TX ids: " + old;
        return id;
    }

    private void unregisterTx(long id) {
        Transaction tx = (Transaction)this.txMap.remove(id);
        assert (tx != null) : "Failed to unregister transaction: " + id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int txClose(long id) {
        Transaction tx = this.tx(id);
        try {
            tx.close();
            int n = tx.state().ordinal();
            return n;
        }
        finally {
            this.unregisterTx(id);
        }
    }

    private Transaction tx(long id) {
        Transaction tx = (Transaction)this.txMap.get(id);
        assert (tx != null) : "Transaction not found for ID: " + id;
        return tx;
    }

    @Override
    public long processInLongOutLong(int type, long val) throws IgniteCheckedException {
        switch (type) {
            case 12: {
                ((TransactionProxyImpl)this.tx(val)).tx().prepare();
                return 1L;
            }
            case 4: {
                this.tx(val).commit();
                return this.txClose(val);
            }
            case 5: {
                this.tx(val).rollback();
                return this.txClose(val);
            }
            case 6: {
                return this.txClose(val);
            }
            case 8: {
                return this.tx(val).setRollbackOnly() ? 1L : 0L;
            }
            case 7: {
                return this.tx(val).state().ordinal();
            }
            case 11: {
                this.txs.resetMetrics();
                return 1L;
            }
        }
        return super.processInLongOutLong(type, val);
    }

    @Override
    public long processInStreamOutLong(int type, BinaryRawReaderEx reader) throws IgniteCheckedException {
        long txId = reader.readLong();
        Transaction asyncTx = (Transaction)this.tx(txId).withAsync();
        switch (type) {
            case 9: {
                asyncTx.commit();
                break;
            }
            case 10: {
                asyncTx.rollback();
                break;
            }
            default: {
                return super.processInStreamOutLong(type, reader);
            }
        }
        IgniteFuture<Object> fut = asyncTx.future().chain(new C1<IgniteFuture, Object>(){
            private static final long serialVersionUID = 0L;

            @Override
            public Object apply(IgniteFuture fut) {
                return null;
            }
        });
        this.readAndListenFuture((BinaryRawReader)reader, fut);
        return 1L;
    }

    @Override
    public void processInStreamOutStream(int type, BinaryRawReaderEx reader, BinaryRawWriterEx writer) throws IgniteCheckedException {
        switch (type) {
            case 3: {
                TransactionConcurrency txConcurrency = TransactionConcurrency.fromOrdinal(reader.readInt());
                assert (txConcurrency != null);
                TransactionIsolation txIsolation = TransactionIsolation.fromOrdinal(reader.readInt());
                assert (txIsolation != null);
                Transaction tx = this.txs.txStart(txConcurrency, txIsolation, reader.readLong(), reader.readInt());
                long id = this.registerTx(tx);
                writer.writeLong(id);
                return;
            }
        }
        super.processInStreamOutStream(type, reader, writer);
    }

    @Override
    public void processOutStream(int type, BinaryRawWriterEx writer) throws IgniteCheckedException {
        switch (type) {
            case 1: {
                TransactionConfiguration txCfg = this.platformCtx.kernalContext().config().getTransactionConfiguration();
                writer.writeInt(txCfg.getDefaultTxConcurrency().ordinal());
                writer.writeInt(txCfg.getDefaultTxIsolation().ordinal());
                writer.writeLong(txCfg.getDefaultTxTimeout());
                break;
            }
            case 2: {
                TransactionMetrics metrics = this.txs.metrics();
                writer.writeTimestamp(new Timestamp(metrics.commitTime()));
                writer.writeTimestamp(new Timestamp(metrics.rollbackTime()));
                writer.writeInt(metrics.txCommits());
                writer.writeInt(metrics.txRollbacks());
                break;
            }
            default: {
                super.processOutStream(type, writer);
            }
        }
    }
}

