/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.utils;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.security.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.cache.CacheException;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryListenerException;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.MarshallerContextImpl;
import org.apache.ignite.internal.binary.BinaryContext;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.internal.binary.BinaryNoopMetadataHandler;
import org.apache.ignite.internal.binary.BinaryRawReaderEx;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.binary.GridBinaryMarshaller;
import org.apache.ignite.internal.processors.platform.PlatformContext;
import org.apache.ignite.internal.processors.platform.PlatformExtendedException;
import org.apache.ignite.internal.processors.platform.PlatformNativeException;
import org.apache.ignite.internal.processors.platform.PlatformProcessor;
import org.apache.ignite.internal.processors.platform.memory.PlatformInputStream;
import org.apache.ignite.internal.processors.platform.memory.PlatformMemory;
import org.apache.ignite.internal.processors.platform.memory.PlatformMemoryUtils;
import org.apache.ignite.internal.processors.platform.memory.PlatformOutputStream;
import org.apache.ignite.internal.processors.platform.utils.PlatformReaderBiClosure;
import org.apache.ignite.internal.processors.platform.utils.PlatformReaderClosure;
import org.apache.ignite.internal.processors.platform.utils.PlatformWriterBiClosure;
import org.apache.ignite.internal.processors.platform.utils.PlatformWriterClosure;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.logger.NullLogger;
import org.jetbrains.annotations.Nullable;

public class PlatformUtils {
    public static final String ATTR_PLATFORM = "org.apache.ignite.platform";
    public static final String PLATFORM_CPP = "cpp";
    public static final String PLATFORM_DOTNET = "dotnet";
    public static final int OP_PREPARE_DOT_NET = 1;
    private static final int CACHE_PEEK_MODES_CNT = CachePeekMode.values().length;
    private static volatile CachePeekMode[][] CACHE_PEEK_MODES;

    public static <T> void writeNullableCollection(BinaryRawWriterEx writer, @Nullable Collection<T> col) {
        PlatformUtils.writeNullableCollection(writer, col, null, null);
    }

    public static <T> void writeNullableCollection(BinaryRawWriterEx writer, @Nullable Collection<T> col, @Nullable PlatformWriterClosure<T> writeClo) {
        PlatformUtils.writeNullableCollection(writer, col, writeClo, null);
    }

    public static <T> void writeNullableCollection(BinaryRawWriterEx writer, @Nullable Collection<T> col, @Nullable PlatformWriterClosure<T> writeClo, @Nullable IgnitePredicate<T> filter) {
        if (col != null) {
            writer.writeBoolean(true);
            PlatformUtils.writeCollection(writer, col, writeClo, filter);
        } else {
            writer.writeBoolean(false);
        }
    }

    public static <T> void writeCollection(BinaryRawWriterEx writer, Collection<T> col) {
        PlatformUtils.writeCollection(writer, col, null, null);
    }

    public static <T> void writeCollection(BinaryRawWriterEx writer, Collection<T> col, @Nullable PlatformWriterClosure<T> writeClo) {
        PlatformUtils.writeCollection(writer, col, writeClo, null);
    }

    public static <T> void writeCollection(BinaryRawWriterEx writer, Collection<T> col, @Nullable PlatformWriterClosure<T> writeClo, @Nullable IgnitePredicate<T> filter) {
        assert (col != null);
        if (filter == null) {
            writer.writeInt(col.size());
            if (writeClo == null) {
                for (T entry : col) {
                    writer.writeObject(entry);
                }
            } else {
                for (T entry : col) {
                    writeClo.write(writer, entry);
                }
            }
        } else {
            int pos = writer.reserveInt();
            int cnt = 0;
            for (T entry : col) {
                if (!filter.apply(entry)) continue;
                ++cnt;
                if (writeClo == null) {
                    writer.writeObject(entry);
                    continue;
                }
                writeClo.write(writer, entry);
            }
            writer.writeInt(pos, cnt);
        }
    }

    public static <K, V> void writeNullableMap(BinaryRawWriterEx writer, @Nullable Map<K, V> map) {
        if (map != null) {
            writer.writeBoolean(true);
            PlatformUtils.writeMap(writer, map);
        } else {
            writer.writeBoolean(false);
        }
    }

    public static <K, V> void writeMap(BinaryRawWriterEx writer, Map<K, V> map) {
        assert (map != null);
        PlatformUtils.writeMap(writer, map, null);
    }

    public static <K, V> void writeMap(BinaryRawWriterEx writer, Map<K, V> map, @Nullable PlatformWriterBiClosure<K, V> writeClo) {
        assert (map != null);
        writer.writeInt(map.size());
        if (writeClo == null) {
            for (Map.Entry<K, V> entry : map.entrySet()) {
                writer.writeObject(entry.getKey());
                writer.writeObject(entry.getValue());
            }
        } else {
            for (Map.Entry<K, V> entry : map.entrySet()) {
                writeClo.write(writer, entry.getKey(), entry.getValue());
            }
        }
    }

    public static <T> List<T> readCollection(BinaryRawReaderEx reader) {
        return PlatformUtils.readCollection(reader, null);
    }

    public static <T> List<T> readCollection(BinaryRawReaderEx reader, @Nullable PlatformReaderClosure<T> readClo) {
        int cnt = reader.readInt();
        ArrayList<Object> res = new ArrayList<Object>(cnt);
        if (readClo == null) {
            for (int i = 0; i < cnt; ++i) {
                res.add(reader.readObjectDetached());
            }
        } else {
            for (int i = 0; i < cnt; ++i) {
                res.add(readClo.read(reader));
            }
        }
        return res;
    }

    public static <T> List<T> readNullableCollection(BinaryRawReaderEx reader) {
        return PlatformUtils.readNullableCollection(reader, null);
    }

    public static <T> List<T> readNullableCollection(BinaryRawReaderEx reader, @Nullable PlatformReaderClosure<T> readClo) {
        if (!reader.readBoolean()) {
            return null;
        }
        return PlatformUtils.readCollection(reader, readClo);
    }

    public static <T> Set<T> readSet(BinaryRawReaderEx reader) {
        int cnt = reader.readInt();
        HashSet res = U.newHashSet(cnt);
        for (int i = 0; i < cnt; ++i) {
            res.add(reader.readObjectDetached());
        }
        return res;
    }

    public static <T> Set<T> readNullableSet(BinaryRawReaderEx reader) {
        if (!reader.readBoolean()) {
            return null;
        }
        return PlatformUtils.readSet(reader);
    }

    public static <K, V> Map<K, V> readMap(BinaryRawReaderEx reader) {
        return PlatformUtils.readMap(reader, null);
    }

    public static <K, V> Map<K, V> readMap(BinaryRawReaderEx reader, @Nullable PlatformReaderBiClosure<K, V> readClo) {
        int cnt = reader.readInt();
        HashMap<Object, Object> map = U.newHashMap(cnt);
        if (readClo == null) {
            for (int i = 0; i < cnt; ++i) {
                map.put(reader.readObjectDetached(), reader.readObjectDetached());
            }
        } else {
            for (int i = 0; i < cnt; ++i) {
                IgniteBiTuple<K, V> entry = readClo.read(reader);
                map.put(entry.getKey(), entry.getValue());
            }
        }
        return map;
    }

    public static <K, V> Map<K, V> readLinkedMap(BinaryRawReaderEx reader, @Nullable PlatformReaderBiClosure<K, V> readClo) {
        int cnt = reader.readInt();
        LinkedHashMap<Object, Object> map = U.newLinkedHashMap(cnt);
        if (readClo == null) {
            for (int i = 0; i < cnt; ++i) {
                map.put(reader.readObjectDetached(), reader.readObjectDetached());
            }
        } else {
            for (int i = 0; i < cnt; ++i) {
                IgniteBiTuple<K, V> entry = readClo.read(reader);
                map.put(entry.getKey(), entry.getValue());
            }
        }
        return map;
    }

    public static <K, V> Map<K, V> readNullableMap(BinaryRawReaderEx reader) {
        if (!reader.readBoolean()) {
            return null;
        }
        return PlatformUtils.readMap(reader);
    }

    public static void writeIgniteUuid(BinaryRawWriterEx writer, IgniteUuid val) {
        if (val == null) {
            writer.writeUuid(null);
        } else {
            writer.writeUuid(val.globalId());
            writer.writeLong(val.localId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CachePeekMode[] decodeCachePeekModes(int modes) {
        CachePeekMode[] res = CACHE_PEEK_MODES[modes];
        if (res != null) return res;
        ArrayList<CachePeekMode> res0 = new ArrayList<CachePeekMode>(CACHE_PEEK_MODES_CNT);
        for (int i = 0; i < CACHE_PEEK_MODES_CNT; ++i) {
            int mask = 1 << i;
            if ((modes & mask) != mask) continue;
            res0.add(CachePeekMode.fromOrdinal((byte)i));
        }
        res = res0.toArray(new CachePeekMode[res0.size()]);
        Class<PlatformUtils> clazz = PlatformUtils.class;
        synchronized (PlatformUtils.class) {
            PlatformUtils.CACHE_PEEK_MODES[modes] = res;
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return res;
        }
    }

    public static IgniteCheckedException unwrapQueryException(Throwable err) {
        assert (err != null);
        Throwable parent = err;
        Throwable child = parent.getCause();
        while (child != null && child != parent && (child instanceof IgniteException || child instanceof IgniteCheckedException || child instanceof CacheException)) {
            parent = child;
            child = parent.getCause();
        }
        if (parent.getMessage() == null) {
            return new IgniteCheckedException("Query execution failed due to exception: " + parent.getClass().getName(), err);
        }
        return new IgniteCheckedException(parent.getMessage(), err);
    }

    public static void applyContinuousQueryEvents(PlatformContext ctx, long lsnrPtr, Iterable<CacheEntryEvent> evts) throws CacheEntryListenerException {
        assert (lsnrPtr != 0L);
        assert (evts != null);
        try (PlatformMemory mem = ctx.memory().allocate();){
            PlatformOutputStream out = mem.output();
            BinaryRawWriterEx writer = ctx.writer(out);
            writer.writeLong(lsnrPtr);
            int cntPos = writer.reserveInt();
            int cnt = 0;
            for (CacheEntryEvent evt : evts) {
                PlatformUtils.writeCacheEntryEvent(writer, evt);
                ++cnt;
            }
            writer.writeInt(cntPos, cnt);
            out.synchronize();
            ctx.gateway().continuousQueryListenerApply(mem.pointer());
        }
        catch (Exception e) {
            throw PlatformUtils.toCacheEntryListenerException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean evaluateContinuousQueryEvent(PlatformContext ctx, long filterPtr, CacheEntryEvent evt) throws CacheEntryListenerException {
        assert (filterPtr != 0L);
        try (PlatformMemory mem = ctx.memory().allocate();){
            PlatformOutputStream out = mem.output();
            out.writeLong(filterPtr);
            PlatformUtils.writeCacheEntryEvent(ctx.writer(out), evt);
            out.synchronize();
            boolean bl = ctx.gateway().continuousQueryFilterApply(mem.pointer()) == 1L;
            return bl;
        }
        catch (Exception e) {
            throw PlatformUtils.toCacheEntryListenerException(e);
        }
    }

    private static CacheEntryListenerException toCacheEntryListenerException(Exception e) {
        assert (e != null);
        return e instanceof CacheEntryListenerException ? (CacheEntryListenerException)e : (e.getMessage() != null ? new CacheEntryListenerException(e.getMessage(), e) : new CacheEntryListenerException(e));
    }

    private static void writeCacheEntryEvent(BinaryRawWriterEx writer, CacheEntryEvent evt) {
        writer.writeObjectDetached(evt.getKey());
        writer.writeObjectDetached(evt.getOldValue());
        writer.writeObjectDetached(evt.getValue());
    }

    public static void writeError(Throwable ex, BinaryRawWriterEx writer) {
        writer.writeObjectDetached(ex.getClass().getName());
        writer.writeObjectDetached(ex.getMessage());
        writer.writeObjectDetached(X.getFullStackTrace(ex));
        PlatformNativeException nativeCause = X.cause(ex, PlatformNativeException.class);
        if (nativeCause != null) {
            writer.writeBoolean(true);
            writer.writeObjectDetached(nativeCause.cause());
        } else {
            writer.writeBoolean(false);
        }
    }

    public static void writeErrorData(Throwable err, BinaryRawWriterEx writer) {
        PlatformUtils.writeErrorData(err, writer, null);
    }

    public static void writeErrorData(Throwable err, BinaryRawWriterEx writer, @Nullable IgniteLogger log) {
        if (err instanceof PlatformExtendedException) {
            PlatformExtendedException err0 = (PlatformExtendedException)err;
            writer.writeBoolean(true);
            int pos = writer.out().position();
            try {
                writer.writeBoolean(true);
                err0.writeData(writer);
            }
            catch (Exception e) {
                String innerMsg;
                if (log != null) {
                    U.warn(log, "Failed to write interop exception data: " + e.getMessage(), e);
                }
                writer.out().position(pos);
                writer.writeBoolean(false);
                writer.writeString(e.getClass().getName());
                try {
                    innerMsg = e.getMessage();
                }
                catch (Exception ignored) {
                    innerMsg = "Exception message is not available.";
                }
                writer.writeString(innerMsg);
            }
        } else {
            writer.writeBoolean(false);
        }
    }

    public static PlatformProcessor platformProcessor(Ignite grid) {
        GridKernalContext ctx = ((IgniteKernal)grid).context();
        return ctx.platform();
    }

    public static PlatformContext platformContext(Ignite grid) {
        return PlatformUtils.platformProcessor(grid).context();
    }

    public static void reallocate(long memPtr, int cap) {
        PlatformMemoryUtils.reallocate(memPtr, cap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] errorData(Throwable err) {
        if (err instanceof PlatformExtendedException) {
            PlatformContext ctx = ((PlatformExtendedException)err).context();
            try (PlatformMemory mem = ctx.memory().allocate();){
                PlatformOutputStream out = mem.output();
                BinaryRawWriterEx writer = ctx.writer(out);
                try {
                    PlatformUtils.writeErrorData(err, writer, ctx.kernalContext().log(PlatformContext.class));
                }
                finally {
                    out.synchronize();
                }
                PlatformInputStream in = mem.input();
                in.synchronize();
                int len = in.remaining();
                assert (len > 0);
                byte[] arr = in.array();
                byte[] res = new byte[len];
                System.arraycopy(arr, 0, res, 0, len);
                byte[] byArray = res;
                return byArray;
            }
        }
        return null;
    }

    public static void writeInvocationResult(BinaryRawWriterEx writer, Object resObj, Exception err) {
        if (err == null) {
            writer.writeBoolean(true);
            writer.writeObject(resObj);
        } else {
            writer.writeBoolean(false);
            PlatformNativeException nativeErr = null;
            if (err instanceof IgniteCheckedException) {
                nativeErr = ((IgniteCheckedException)err).getCause(PlatformNativeException.class);
            } else if (err instanceof IgniteException) {
                nativeErr = ((IgniteException)err).getCause(PlatformNativeException.class);
            }
            if (nativeErr == null) {
                writer.writeBoolean(false);
                writer.writeString(err.getClass().getName());
                writer.writeString(err.getMessage());
                writer.writeString(X.getFullStackTrace(err));
            } else {
                writer.writeBoolean(true);
                writer.writeObject(nativeErr.cause());
            }
        }
    }

    public static Object readInvocationResult(PlatformContext ctx, BinaryRawReaderEx reader) throws IgniteCheckedException {
        boolean success = reader.readBoolean();
        if (success) {
            return reader.readObjectDetached();
        }
        boolean hasException = reader.readBoolean();
        if (hasException) {
            Object nativeErr = reader.readObjectDetached();
            assert (nativeErr != null);
            throw ctx.createNativeException(nativeErr);
        }
        String errMsg = reader.readString();
        assert (errMsg != null);
        throw new IgniteCheckedException(errMsg);
    }

    public static GridBinaryMarshaller marshaller() {
        try {
            IgniteConfiguration cfg = new IgniteConfiguration();
            BinaryContext ctx = new BinaryContext(BinaryNoopMetadataHandler.instance(), cfg, new NullLogger());
            BinaryMarshaller marsh = new BinaryMarshaller();
            String workDir = U.workDirectory(cfg.getWorkDirectory(), cfg.getIgniteHome());
            marsh.setContext(new MarshallerContextImpl(workDir, null));
            ctx.configure(marsh, new IgniteConfiguration());
            return new GridBinaryMarshaller(ctx);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    private static Object unwrapBinary(Object o) {
        if (o == null) {
            return null;
        }
        if (PlatformUtils.knownArray(o)) {
            return o;
        }
        if (o instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)o;
            Object key = entry.getKey();
            Object uKey = PlatformUtils.unwrapBinary(key);
            Object val = entry.getValue();
            Object uVal = PlatformUtils.unwrapBinary(val);
            return key != uKey || val != uVal ? F.t(uKey, uVal) : o;
        }
        if (BinaryUtils.knownCollection(o)) {
            return PlatformUtils.unwrapKnownCollection((Collection)o);
        }
        if (BinaryUtils.knownMap(o)) {
            return PlatformUtils.unwrapBinariesIfNeeded((Map)o);
        }
        if (o instanceof Object[]) {
            return PlatformUtils.unwrapBinariesInArray((Object[])o);
        }
        if (o instanceof BinaryObject) {
            return ((BinaryObject)o).deserialize();
        }
        return o;
    }

    private static boolean knownArray(Object obj) {
        return obj instanceof String[] || obj instanceof boolean[] || obj instanceof byte[] || obj instanceof char[] || obj instanceof int[] || obj instanceof long[] || obj instanceof short[] || obj instanceof Timestamp[] || obj instanceof double[] || obj instanceof float[] || obj instanceof UUID[] || obj instanceof BigDecimal[];
    }

    private static boolean knownCollection(Object o) {
        Class<?> cls = o == null ? null : o.getClass();
        return cls == ArrayList.class || cls == LinkedList.class || cls == HashSet.class;
    }

    private static boolean knownMap(Object o) {
        Class<?> cls = o == null ? null : o.getClass();
        return cls == HashMap.class || cls == LinkedHashMap.class;
    }

    private static Collection<Object> unwrapKnownCollection(Collection<Object> col) {
        Collection<Object> col0 = BinaryUtils.newKnownCollection(col);
        for (Object obj : col) {
            col0.add(PlatformUtils.unwrapBinary(obj));
        }
        return col0;
    }

    public static Object[] unwrapBinariesInArray(Object[] arr) {
        Object[] res = new Object[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            res[i] = PlatformUtils.unwrapBinary(arr[i]);
        }
        return res;
    }

    private static Map<Object, Object> unwrapBinariesIfNeeded(Map<Object, Object> map) {
        Map<Object, Object> map0 = BinaryUtils.newMap(map);
        for (Map.Entry<Object, Object> e : map.entrySet()) {
            map0.put(PlatformUtils.unwrapBinary(e.getKey()), PlatformUtils.unwrapBinary(e.getValue()));
        }
        return map0;
    }

    public static <T> T createJavaObject(String clsName) {
        if (clsName == null) {
            throw new IgniteException("Java object/factory class name is not set.");
        }
        Class<?> cls = U.classForName(clsName, null);
        if (cls == null) {
            throw new IgniteException("Java object/factory class is not found (is it in the classpath?): " + clsName);
        }
        try {
            return (T)cls.newInstance();
        }
        catch (ReflectiveOperationException e) {
            throw new IgniteException("Failed to instantiate Java object/factory class (does it have public default constructor?): " + clsName, e);
        }
    }

    public static void initializeJavaObject(Object obj, String clsName, @Nullable Map<String, Object> props, @Nullable GridKernalContext ctx) {
        if (props != null) {
            for (Map.Entry<String, Object> prop : props.entrySet()) {
                String fieldName = prop.getKey();
                if (fieldName == null) {
                    throw new IgniteException("Java object/factory field name cannot be null: " + clsName);
                }
                Field field = U.findField(obj.getClass(), fieldName);
                if (field == null) {
                    throw new IgniteException("Java object/factory class field is not found [className=" + clsName + ", fieldName=" + fieldName + ']');
                }
                try {
                    field.set(obj, prop.getValue());
                }
                catch (Exception e) {
                    throw new IgniteException("Failed to set Java object/factory field [className=" + clsName + ", fieldName=" + fieldName + ", fieldValue=" + prop.getValue() + ']', e);
                }
            }
        }
        if (ctx != null) {
            try {
                ctx.resource().injectGeneric(obj);
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException("Failed to inject resources to Java factory: " + clsName, e);
            }
        }
    }

    public static String getFullStackTrace(Throwable throwable) {
        return X.getFullStackTrace(throwable);
    }

    private PlatformUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        int len = 1 << CACHE_PEEK_MODES_CNT;
        Class<PlatformUtils> clazz = PlatformUtils.class;
        synchronized (PlatformUtils.class) {
            CACHE_PEEK_MODES = new CachePeekMode[len][];
            PlatformUtils.CACHE_PEEK_MODES[0] = new CachePeekMode[0];
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

