/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.port;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.TreeSet;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.GridProcessorAdapter;
import org.apache.ignite.internal.processors.port.GridPortListener;
import org.apache.ignite.internal.processors.port.GridPortRecord;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.spi.IgnitePortProtocol;

public class GridPortProcessor
extends GridProcessorAdapter {
    private final Collection<GridPortRecord> recs;
    private final Collection<GridPortListener> lsnrs = new LinkedHashSet<GridPortListener>();

    public GridPortProcessor(GridKernalContext ctx) {
        super(ctx);
        this.recs = new TreeSet<GridPortRecord>(new Comparator<GridPortRecord>(){

            @Override
            public int compare(GridPortRecord o1, GridPortRecord o2) {
                int p2;
                int p1 = o1.port();
                return p1 < (p2 = o2.port()) ? -1 : (p1 == p2 ? 0 : 1);
            }
        });
    }

    @Override
    public void start() throws IgniteCheckedException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Started port processor.");
        }
    }

    @Override
    public void stop(boolean cancel) throws IgniteCheckedException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Stopped port processor.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPort(int port, IgnitePortProtocol proto, Class cls) {
        assert (port > 0 && port < 65535);
        assert (proto != null);
        assert (cls != null);
        Collection<GridPortRecord> collection = this.recs;
        synchronized (collection) {
            this.recs.add(new GridPortRecord(port, proto, cls));
        }
        this.notifyListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterPorts(Class cls) {
        assert (cls != null);
        Collection<GridPortRecord> collection = this.recs;
        synchronized (collection) {
            Iterator<GridPortRecord> iter = this.recs.iterator();
            while (iter.hasNext()) {
                GridPortRecord pr = iter.next();
                if (!pr.clazz().equals(cls)) continue;
                iter.remove();
            }
        }
        this.notifyListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterPort(int port, IgnitePortProtocol proto, Class cls) {
        assert (port > 0 && port < 65535);
        assert (proto != null);
        assert (cls != null);
        Collection<GridPortRecord> collection = this.recs;
        synchronized (collection) {
            Iterator<GridPortRecord> iter = this.recs.iterator();
            while (iter.hasNext()) {
                GridPortRecord pr = iter.next();
                if (pr.port() != port || pr.protocol() != proto || !pr.clazz().equals(cls)) continue;
                iter.remove();
            }
        }
        this.notifyListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<GridPortRecord> records() {
        Collection<GridPortRecord> collection = this.recs;
        synchronized (collection) {
            return Collections.unmodifiableCollection(new ArrayList<GridPortRecord>(this.recs));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPortListener(GridPortListener lsnr) {
        assert (lsnr != null);
        Collection<GridPortListener> collection = this.lsnrs;
        synchronized (collection) {
            this.lsnrs.add(lsnr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePortListener(GridPortListener lsnr) {
        assert (lsnr != null);
        Collection<GridPortListener> collection = this.lsnrs;
        synchronized (collection) {
            this.lsnrs.remove(lsnr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners() {
        Collection<GridPortListener> collection = this.lsnrs;
        synchronized (collection) {
            for (GridPortListener lsnr : this.lsnrs) {
                lsnr.onPortChange();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printMemoryStats() {
        int lsnrsSize;
        int recsSize;
        Collection<GridPortRecord> collection = this.recs;
        synchronized (collection) {
            recsSize = this.recs.size();
        }
        Collection<GridPortListener> collection2 = this.lsnrs;
        synchronized (collection2) {
            lsnrsSize = this.lsnrs.size();
        }
        X.println(">>>", new Object[0]);
        X.println(">>> Task session processor memory stats [grid=" + this.ctx.gridName() + ']', new Object[0]);
        X.println(">>>  recsSize: " + recsSize, new Object[0]);
        X.println(">>>  lsnrsSize: " + lsnrsSize, new Object[0]);
    }
}

