/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.cache.Cache;
import javax.cache.CacheException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.IgniteException;
import org.apache.ignite.binary.BinaryField;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.binary.BinaryObjectBuilder;
import org.apache.ignite.binary.BinaryType;
import org.apache.ignite.binary.Binarylizable;
import org.apache.ignite.cache.CacheTypeMetadata;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.QueryIndexType;
import org.apache.ignite.cache.affinity.AffinityKeyMapper;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.events.CacheQueryExecutedEvent;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteComponentType;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.internal.binary.BinaryObjectEx;
import org.apache.ignite.internal.processors.GridProcessorAdapter;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheDefaultAffinityKeyMapper;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxy;
import org.apache.ignite.internal.processors.cache.QueryCursorImpl;
import org.apache.ignite.internal.processors.cache.binary.CacheObjectBinaryProcessorImpl;
import org.apache.ignite.internal.processors.cache.query.CacheQueryFuture;
import org.apache.ignite.internal.processors.cache.query.CacheQueryType;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryType;
import org.apache.ignite.internal.processors.query.GridQueryCancel;
import org.apache.ignite.internal.processors.query.GridQueryFieldMetadata;
import org.apache.ignite.internal.processors.query.GridQueryIndexDescriptor;
import org.apache.ignite.internal.processors.query.GridQueryIndexType;
import org.apache.ignite.internal.processors.query.GridQueryIndexing;
import org.apache.ignite.internal.processors.query.GridQueryProperty;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.GridRunningQueryInfo;
import org.apache.ignite.internal.processors.timeout.GridTimeoutProcessor;
import org.apache.ignite.internal.util.GridSpinBusyLock;
import org.apache.ignite.internal.util.future.GridCompoundFuture;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.lang.GridCloseableIterator;
import org.apache.ignite.internal.util.lang.GridClosureException;
import org.apache.ignite.internal.util.lang.IgniteOutClosureX;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.internal.util.worker.GridWorkerFuture;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.spi.indexing.IndexingQueryFilter;
import org.jetbrains.annotations.Nullable;
import org.jsr166.ConcurrentHashMap8;

public class GridQueryProcessor
extends GridProcessorAdapter {
    public static final String _VAL = "_val";
    private static final Class<?> GEOMETRY_CLASS = U.classForName("com.vividsolutions.jts.geom.Geometry", null);
    private static final int QRY_DETAIL_METRICS_EVICTION_FREQ = 3000;
    private static final Set<Class<?>> SQL_TYPES = new HashSet<Class[]>(F.asList(new Class[]{Integer.class, Boolean.class, Byte.class, Short.class, Long.class, BigDecimal.class, Double.class, Float.class, Time.class, Timestamp.class, Date.class, java.sql.Date.class, String.class, UUID.class, byte[].class}));
    public static Class<? extends GridQueryIndexing> idxCls;
    private final GridSpinBusyLock busyLock = new GridSpinBusyLock();
    private final Map<TypeId, TypeDescriptor> types = new ConcurrentHashMap8<TypeId, TypeDescriptor>();
    private final ConcurrentMap<TypeName, TypeDescriptor> typesByName = new ConcurrentHashMap8<TypeName, TypeDescriptor>();
    private ExecutorService execSvc;
    private final GridQueryIndexing idx;
    private GridTimeoutProcessor.CancelableTask qryDetailMetricsEvictTask;
    private static final ThreadLocal<AffinityTopologyVersion> requestTopVer;

    public GridQueryProcessor(GridKernalContext ctx) throws IgniteCheckedException {
        super(ctx);
        if (idxCls != null) {
            this.idx = U.newInstance(idxCls);
            idxCls = null;
        } else {
            this.idx = IgniteComponentType.INDEXING.inClassPath() ? (GridQueryIndexing)U.newInstance(IgniteComponentType.INDEXING.className()) : null;
        }
    }

    @Override
    public void start() throws IgniteCheckedException {
        super.start();
        if (this.idx != null) {
            this.ctx.resource().injectGeneric(this.idx);
            this.execSvc = this.ctx.getExecutorService();
            this.idx.start(this.ctx, this.busyLock);
        }
        this.qryDetailMetricsEvictTask = this.ctx.timeout().schedule(new Runnable(){

            @Override
            public void run() {
                for (IgniteCacheProxy<?, ?> cache : GridQueryProcessor.this.ctx.cache().jcaches()) {
                    cache.context().queries().evictDetailMetrics();
                }
            }
        }, 3000L, 3000L);
    }

    public static boolean isEnabled(CacheConfiguration<?, ?> ccfg) {
        return !F.isEmpty(ccfg.getIndexedTypes()) || !F.isEmpty(ccfg.getTypeMetadata()) || !F.isEmpty(ccfg.getQueryEntities());
    }

    public boolean moduleEnabled() {
        return this.idx != null;
    }

    private void initializeCache(GridCacheContext<?, ?> cctx) throws IgniteCheckedException {
        CacheConfiguration ccfg = cctx.config();
        this.idx.registerCache(cctx, cctx.config());
        try {
            TypeId typeId;
            TypeId altTypeId;
            String simpleValType;
            boolean keyOrValMustDeserialize;
            boolean valMustDeserialize;
            boolean keyMustDeserialize;
            Class<?> valCls;
            Class<Object> keyCls;
            TypeDescriptor desc;
            CacheObjectContext coCtx;
            ArrayList mustDeserializeClss = null;
            boolean binaryEnabled = this.ctx.cacheObjects().isBinaryEnabled(ccfg);
            CacheObjectContext cacheObjectContext = coCtx = binaryEnabled ? this.ctx.cacheObjects().contextForCache(ccfg) : null;
            if (!F.isEmpty(ccfg.getQueryEntities())) {
                for (QueryEntity qryEntity : ccfg.getQueryEntities()) {
                    if (F.isEmpty(qryEntity.getValueType())) {
                        throw new IgniteCheckedException("Value type is not set: " + qryEntity);
                    }
                    desc = new TypeDescriptor();
                    keyCls = U.classForName(qryEntity.getKeyType(), null);
                    valCls = U.classForName(qryEntity.getValueType(), null);
                    keyMustDeserialize = this.mustDeserializeBinary(keyCls);
                    valMustDeserialize = this.mustDeserializeBinary(valCls);
                    boolean bl = keyOrValMustDeserialize = keyMustDeserialize || valMustDeserialize;
                    if (keyCls == null) {
                        keyCls = Object.class;
                    }
                    simpleValType = valCls == null ? GridQueryProcessor.typeName(qryEntity.getValueType()) : GridQueryProcessor.typeName(valCls);
                    desc.name(simpleValType);
                    desc.tableName(qryEntity.getTableName());
                    if (binaryEnabled && !keyOrValMustDeserialize) {
                        if (SQL_TYPES.contains(valCls)) {
                            desc.valueClass(valCls);
                        } else {
                            desc.valueClass(Object.class);
                        }
                        if (SQL_TYPES.contains(keyCls)) {
                            desc.keyClass(keyCls);
                        } else {
                            desc.keyClass(Object.class);
                        }
                    } else {
                        if (keyCls == null) {
                            throw new IgniteCheckedException("Failed to find key class in the node classpath (use default marshaller to enable binary objects): " + qryEntity.getKeyType());
                        }
                        if (valCls == null) {
                            throw new IgniteCheckedException("Failed to find value class in the node classpath (use default marshaller to enable binary objects) : " + qryEntity.getValueType());
                        }
                        desc.valueClass(valCls);
                        desc.keyClass(keyCls);
                    }
                    desc.keyTypeName(qryEntity.getKeyType());
                    desc.valueTypeName(qryEntity.getValueType());
                    if (binaryEnabled && keyOrValMustDeserialize) {
                        if (mustDeserializeClss == null) {
                            mustDeserializeClss = new ArrayList();
                        }
                        if (keyMustDeserialize) {
                            mustDeserializeClss.add(keyCls);
                        }
                        if (valMustDeserialize) {
                            mustDeserializeClss.add(valCls);
                        }
                    }
                    altTypeId = null;
                    if (valCls == null || binaryEnabled && !keyOrValMustDeserialize) {
                        String affField;
                        this.processBinaryMeta(qryEntity, desc);
                        typeId = new TypeId(ccfg.getName(), this.ctx.cacheObjects().typeId(qryEntity.getValueType()));
                        if (valCls != null) {
                            altTypeId = new TypeId(ccfg.getName(), valCls);
                        }
                        if (!cctx.customAffinityMapper() && qryEntity.getKeyType() != null && (affField = this.ctx.cacheObjects().affinityField(qryEntity.getKeyType())) != null) {
                            desc.affinityKey(affField);
                        }
                    } else {
                        String affField;
                        this.processClassMeta(qryEntity, desc, coCtx);
                        AffinityKeyMapper keyMapper = cctx.config().getAffinityMapper();
                        if (keyMapper instanceof GridCacheDefaultAffinityKeyMapper && (affField = ((GridCacheDefaultAffinityKeyMapper)keyMapper).affinityKeyPropertyName(desc.keyCls)) != null) {
                            desc.affinityKey(affField);
                        }
                        typeId = new TypeId(ccfg.getName(), valCls);
                        altTypeId = new TypeId(ccfg.getName(), this.ctx.cacheObjects().typeId(qryEntity.getValueType()));
                    }
                    this.addTypeByName(ccfg, desc);
                    this.types.put(typeId, desc);
                    if (altTypeId != null) {
                        this.types.put(altTypeId, desc);
                    }
                    desc.registered(this.idx.registerType(ccfg.getName(), desc));
                }
            }
            if (!F.isEmpty(ccfg.getTypeMetadata())) {
                for (CacheTypeMetadata meta : ccfg.getTypeMetadata()) {
                    if (F.isEmpty(meta.getValueType())) {
                        throw new IgniteCheckedException("Value type is not set: " + meta);
                    }
                    if (meta.getQueryFields().isEmpty() && meta.getAscendingFields().isEmpty() && meta.getDescendingFields().isEmpty() && meta.getGroups().isEmpty()) continue;
                    desc = new TypeDescriptor();
                    keyCls = U.classForName(meta.getKeyType(), null);
                    valCls = U.classForName(meta.getValueType(), null);
                    keyMustDeserialize = this.mustDeserializeBinary(keyCls);
                    valMustDeserialize = this.mustDeserializeBinary(valCls);
                    boolean bl = keyOrValMustDeserialize = keyMustDeserialize || valMustDeserialize;
                    if (keyCls == null) {
                        keyCls = Object.class;
                    }
                    if ((simpleValType = meta.getSimpleValueType()) == null) {
                        simpleValType = GridQueryProcessor.typeName(meta.getValueType());
                    }
                    desc.name(simpleValType);
                    if (binaryEnabled && !keyOrValMustDeserialize) {
                        if (SQL_TYPES.contains(valCls)) {
                            desc.valueClass(valCls);
                        } else {
                            desc.valueClass(Object.class);
                        }
                        if (SQL_TYPES.contains(keyCls)) {
                            desc.keyClass(keyCls);
                        } else {
                            desc.keyClass(Object.class);
                        }
                    } else {
                        desc.valueClass(valCls);
                        desc.keyClass(keyCls);
                    }
                    desc.keyTypeName(meta.getKeyType());
                    desc.valueTypeName(meta.getValueType());
                    if (binaryEnabled && keyOrValMustDeserialize) {
                        if (mustDeserializeClss == null) {
                            mustDeserializeClss = new ArrayList();
                        }
                        if (keyMustDeserialize) {
                            mustDeserializeClss.add(keyCls);
                        }
                        if (valMustDeserialize) {
                            mustDeserializeClss.add(valCls);
                        }
                    }
                    altTypeId = null;
                    if (valCls == null || binaryEnabled && !keyOrValMustDeserialize) {
                        this.processBinaryMeta(meta, desc);
                        typeId = new TypeId(ccfg.getName(), this.ctx.cacheObjects().typeId(meta.getValueType()));
                        if (valCls != null) {
                            altTypeId = new TypeId(ccfg.getName(), valCls);
                        }
                    } else {
                        this.processClassMeta(meta, desc, coCtx);
                        typeId = new TypeId(ccfg.getName(), valCls);
                        altTypeId = new TypeId(ccfg.getName(), this.ctx.cacheObjects().typeId(meta.getValueType()));
                    }
                    this.addTypeByName(ccfg, desc);
                    this.types.put(typeId, desc);
                    if (altTypeId != null) {
                        this.types.put(altTypeId, desc);
                    }
                    desc.registered(this.idx.registerType(ccfg.getName(), desc));
                }
            }
            if (mustDeserializeClss != null) {
                U.warn(this.log, "Some classes in query configuration cannot be written in binary format because they either implement Externalizable interface or have writeObject/readObject methods. Instances of these classes will be deserialized in order to build indexes. Please ensure that all nodes have these classes in classpath. To enable binary serialization either implement " + Binarylizable.class.getSimpleName() + " interface or set explicit serializer using " + "BinaryTypeConfiguration.setSerializer() method: " + mustDeserializeClss);
            }
        }
        catch (RuntimeException | IgniteCheckedException e) {
            this.idx.unregisterCache(ccfg);
            throw e;
        }
    }

    private boolean mustDeserializeBinary(Class cls) {
        if (cls != null && this.ctx.config().getMarshaller() instanceof BinaryMarshaller) {
            CacheObjectBinaryProcessorImpl proc0 = (CacheObjectBinaryProcessorImpl)this.ctx.cacheObjects();
            return proc0.binaryContext().mustDeserialize(cls);
        }
        return false;
    }

    private void addTypeByName(CacheConfiguration<?, ?> ccfg, TypeDescriptor desc) throws IgniteCheckedException {
        if (this.typesByName.putIfAbsent(new TypeName(ccfg.getName(), desc.name()), desc) != null) {
            throw new IgniteCheckedException("Type with name '" + desc.name() + "' already indexed " + "in cache '" + ccfg.getName() + "'.");
        }
    }

    @Override
    public void onKernalStop(boolean cancel) {
        super.onKernalStop(cancel);
        if (cancel && this.idx != null) {
            try {
                while (!this.busyLock.tryBlock(500L)) {
                    this.idx.cancelAllQueries();
                }
                return;
            }
            catch (InterruptedException ignored) {
                U.warn(this.log, "Interrupted while waiting for active queries cancellation.");
                Thread.currentThread().interrupt();
            }
        }
        this.busyLock.block();
    }

    @Override
    public void stop(boolean cancel) throws IgniteCheckedException {
        super.stop(cancel);
        if (this.idx != null) {
            this.idx.stop();
        }
        U.closeQuiet(this.qryDetailMetricsEvictTask);
    }

    @Override
    public void onDisconnected(IgniteFuture<?> reconnectFut) throws IgniteCheckedException {
        if (this.idx != null) {
            this.idx.onDisconnected(reconnectFut);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCacheStart(GridCacheContext cctx) throws IgniteCheckedException {
        if (this.idx == null) {
            return;
        }
        if (!this.busyLock.enterBusy()) {
            return;
        }
        try {
            this.initializeCache(cctx);
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCacheStop(GridCacheContext cctx) {
        if (this.idx == null) {
            return;
        }
        if (!this.busyLock.enterBusy()) {
            return;
        }
        try {
            this.idx.unregisterCache(cctx.config());
            Iterator<Map.Entry<TypeId, TypeDescriptor>> it = this.types.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<TypeId, TypeDescriptor> entry = it.next();
                if (!F.eq(cctx.name(), entry.getKey().space)) continue;
                it.remove();
                this.typesByName.remove(new TypeName(cctx.name(), entry.getValue().name()));
            }
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Failed to clear indexing on cache stop (will ignore): " + cctx.name(), e);
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IgniteInternalFuture<?> rebuildIndexes(@Nullable String space, String valTypeName) {
        if (!this.busyLock.enterBusy()) {
            throw new IllegalStateException("Failed to rebuild indexes (grid is stopping).");
        }
        try {
            IgniteInternalFuture<?> igniteInternalFuture = this.rebuildIndexes(space, (TypeDescriptor)this.typesByName.get(new TypeName(space, valTypeName)));
            return igniteInternalFuture;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    private IgniteInternalFuture<?> rebuildIndexes(final @Nullable String space, final @Nullable TypeDescriptor desc) {
        if (this.idx == null) {
            return new GridFinishedFuture(new IgniteCheckedException("Indexing is disabled."));
        }
        if (desc == null || !desc.registered()) {
            return new GridFinishedFuture();
        }
        final GridWorkerFuture fut = new GridWorkerFuture();
        GridWorker w = new GridWorker(this.ctx.gridName(), "index-rebuild-worker", this.log){

            @Override
            protected void body() {
                block3: {
                    try {
                        GridQueryProcessor.this.idx.rebuildIndexes(space, desc);
                        fut.onDone();
                    }
                    catch (Exception e) {
                        fut.onDone(e);
                    }
                    catch (Throwable e) {
                        this.log.error("Failed to rebuild indexes for type: " + desc.name(), e);
                        fut.onDone(e);
                        if (!(e instanceof Error)) break block3;
                        throw e;
                    }
                }
            }
        };
        fut.setWorker(w);
        this.execSvc.execute(w);
        return fut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IgniteInternalFuture<?> rebuildAllIndexes() {
        if (!this.busyLock.enterBusy()) {
            throw new IllegalStateException("Failed to get space size (grid is stopping).");
        }
        try {
            GridCompoundFuture fut = new GridCompoundFuture();
            for (Map.Entry<TypeId, TypeDescriptor> e : this.types.entrySet()) {
                fut.add(this.rebuildIndexes(e.getKey().space, e.getValue()));
            }
            fut.markInitialized();
            GridCompoundFuture gridCompoundFuture = fut;
            return gridCompoundFuture;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    private CacheObjectContext cacheObjectContext(String space) {
        return this.ctx.cache().internalCache(space).context().cacheObjectContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(String space, CacheObject key, CacheObject val, byte[] ver, long expirationTime) throws IgniteCheckedException {
        assert (key != null);
        assert (val != null);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Store [space=" + space + ", key=" + key + ", val=" + val + "]");
        }
        CacheObjectContext coctx = null;
        if (this.idx == null) {
            return;
        }
        if (!this.busyLock.enterBusy()) {
            return;
        }
        try {
            TypeId id;
            if (coctx == null) {
                coctx = this.cacheObjectContext(space);
            }
            Class<?> valCls = null;
            boolean binaryVal = this.ctx.cacheObjects().isBinaryObject(val);
            if (binaryVal) {
                int typeId = this.ctx.cacheObjects().typeId(val);
                id = new TypeId(space, typeId);
            } else {
                valCls = val.value(coctx, false).getClass();
                id = new TypeId(space, valCls);
            }
            TypeDescriptor desc = this.types.get(id);
            if (desc == null || !desc.registered()) {
                return;
            }
            if (!binaryVal && !desc.valueClass().isAssignableFrom(valCls)) {
                throw new IgniteCheckedException("Failed to update index due to class name conflict(multiple classes with same simple name are stored in the same cache) [expCls=" + desc.valueClass().getName() + ", actualCls=" + valCls.getName() + ']');
            }
            if (!this.ctx.cacheObjects().isBinaryObject(key)) {
                Class<?> keyCls = key.value(coctx, false).getClass();
                if (!desc.keyClass().isAssignableFrom(keyCls)) {
                    throw new IgniteCheckedException("Failed to update index, incorrect key class [expCls=" + desc.keyClass().getName() + ", actualCls=" + keyCls.getName() + "]");
                }
            }
            this.idx.store(space, desc, key, val, ver, expirationTime);
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    private void checkEnabled() throws IgniteCheckedException {
        if (this.idx == null) {
            throw new IgniteCheckedException("Indexing is disabled.");
        }
    }

    private void checkxEnabled() throws IgniteException {
        if (this.idx == null) {
            throw new IgniteException("Failed to execute query because indexing is disabled (consider adding module " + IgniteComponentType.INDEXING.module() + " to classpath or moving it from 'optional' to 'libs' folder).");
        }
    }

    public QueryCursor<List<?>> queryTwoStep(final GridCacheContext<?, ?> cctx, final SqlFieldsQuery qry) {
        this.checkxEnabled();
        if (!this.busyLock.enterBusy()) {
            throw new IllegalStateException("Failed to execute query (grid is stopping).");
        }
        try {
            QueryCursor queryCursor = (QueryCursor)this.executeQuery(GridCacheQueryType.SQL_FIELDS, qry.getSql(), cctx, new IgniteOutClosureX<QueryCursor<List<?>>>(){

                @Override
                public QueryCursor<List<?>> applyx() throws IgniteCheckedException {
                    return GridQueryProcessor.this.idx.queryTwoStep(cctx, qry, null);
                }
            }, true);
            return queryCursor;
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    public long streamUpdateQuery(final @Nullable String spaceName, final IgniteDataStreamer<?, ?> streamer, final String qry, final Object[] args) {
        assert (streamer != null);
        if (!this.busyLock.enterBusy()) {
            throw new IllegalStateException("Failed to execute query (grid is stopping).");
        }
        try {
            GridCacheContext cctx = this.ctx.cache().cache(spaceName).context();
            long l = this.executeQuery(GridCacheQueryType.SQL_FIELDS, qry, cctx, new IgniteOutClosureX<Long>(){

                @Override
                public Long applyx() throws IgniteCheckedException {
                    return GridQueryProcessor.this.idx.streamUpdateQuery(spaceName, qry, args, streamer);
                }
            }, true);
            return l;
        }
        catch (IgniteCheckedException e) {
            throw new CacheException(e);
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    public <K, V> QueryCursor<Cache.Entry<K, V>> queryTwoStep(final GridCacheContext<?, ?> cctx, final SqlQuery qry) {
        this.checkxEnabled();
        if (!this.busyLock.enterBusy()) {
            throw new IllegalStateException("Failed to execute query (grid is stopping).");
        }
        try {
            QueryCursor queryCursor = (QueryCursor)this.executeQuery(GridCacheQueryType.SQL, qry.getSql(), cctx, new IgniteOutClosureX<QueryCursor<Cache.Entry<K, V>>>(){

                @Override
                public QueryCursor<Cache.Entry<K, V>> applyx() throws IgniteCheckedException {
                    return GridQueryProcessor.this.idx.queryTwoStep(cctx, qry);
                }
            }, true);
            return queryCursor;
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    public <K, V> QueryCursor<Cache.Entry<K, V>> queryLocal(final GridCacheContext<?, ?> cctx, final SqlQuery qry, final boolean keepBinary) {
        if (!this.busyLock.enterBusy()) {
            throw new IllegalStateException("Failed to execute query (grid is stopping).");
        }
        try {
            QueryCursor queryCursor = (QueryCursor)this.executeQuery(GridCacheQueryType.SQL, qry.getSql(), cctx, new IgniteOutClosureX<QueryCursor<Cache.Entry<K, V>>>(){

                @Override
                public QueryCursor<Cache.Entry<K, V>> applyx() throws IgniteCheckedException {
                    String type = qry.getType();
                    TypeDescriptor typeDesc = (TypeDescriptor)GridQueryProcessor.this.typesByName.get(new TypeName(cctx.name(), type));
                    if (typeDesc == null || !typeDesc.registered()) {
                        throw new CacheException("Failed to find SQL table for type: " + type);
                    }
                    qry.setType(typeDesc.name());
                    GridQueryProcessor.this.sendQueryExecutedEvent(qry.getSql(), qry.getArgs());
                    return GridQueryProcessor.this.idx.queryLocalSql(cctx, qry, GridQueryProcessor.this.idx.backupFilter((AffinityTopologyVersion)requestTopVer.get(), null), keepBinary);
                }
            }, true);
            return queryCursor;
        }
        catch (IgniteCheckedException e) {
            throw new CacheException(e);
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    public Collection<GridRunningQueryInfo> runningQueries(long duration) {
        if (this.moduleEnabled()) {
            return this.idx.runningQueries(duration);
        }
        return Collections.emptyList();
    }

    public void cancelQueries(Collection<Long> queries) {
        if (this.moduleEnabled()) {
            this.idx.cancelQueries(queries);
        }
    }

    private void sendQueryExecutedEvent(String sqlQry, Object[] params) {
        if (this.ctx.event().isRecordable(96)) {
            this.ctx.event().record(new CacheQueryExecutedEvent(this.ctx.discovery().localNode(), "SQL query executed.", 96, CacheQueryType.SQL.name(), null, null, sqlQry, null, null, params, null, null));
        }
    }

    public PreparedStatement prepareNativeStatement(String schema, String sql) throws SQLException {
        this.checkxEnabled();
        return this.idx.prepareNativeStatement(schema, sql);
    }

    public String space(String schema) throws SQLException {
        this.checkxEnabled();
        return this.idx.space(schema);
    }

    public IgniteDataStreamer<?, ?> createStreamer(String spaceName, PreparedStatement nativeStmt, long autoFlushFreq, int nodeBufSize, int nodeParOps, boolean allowOverwrite) {
        return this.idx.createStreamer(spaceName, nativeStmt, autoFlushFreq, nodeBufSize, nodeParOps, allowOverwrite);
    }

    public static int validateTimeout(int timeout, TimeUnit timeUnit) {
        A.ensure(timeUnit != TimeUnit.MICROSECONDS && timeUnit != TimeUnit.NANOSECONDS, "timeUnit minimal resolution is millisecond.");
        A.ensure(timeout >= 0, "timeout value should be non-negative.");
        long tmp = TimeUnit.MILLISECONDS.convert(timeout, timeUnit);
        A.ensure(timeout <= Integer.MAX_VALUE, "timeout value too large.");
        return (int)tmp;
    }

    public QueryCursor<List<?>> queryLocalFields(final GridCacheContext<?, ?> cctx, final SqlFieldsQuery qry) {
        if (!this.busyLock.enterBusy()) {
            throw new IllegalStateException("Failed to execute query (grid is stopping).");
        }
        try {
            QueryCursor queryCursor = (QueryCursor)this.executeQuery(GridCacheQueryType.SQL_FIELDS, qry.getSql(), cctx, new IgniteOutClosureX<QueryCursor<List<?>>>(){

                @Override
                public QueryCursor<List<?>> applyx() throws IgniteCheckedException {
                    GridQueryCancel cancel = new GridQueryCancel();
                    final QueryCursor<List<?>> cursor = GridQueryProcessor.this.idx.queryLocalSqlFields(cctx, qry, GridQueryProcessor.this.idx.backupFilter((AffinityTopologyVersion)requestTopVer.get(), null), cancel);
                    return new QueryCursorImpl<List<?>>(new Iterable<List<?>>(){

                        @Override
                        public Iterator<List<?>> iterator() {
                            GridQueryProcessor.this.sendQueryExecutedEvent(qry.getSql(), qry.getArgs());
                            return cursor.iterator();
                        }
                    }, cancel){

                        @Override
                        public List<GridQueryFieldMetadata> fieldsMeta() {
                            if (cursor instanceof QueryCursorImpl) {
                                return ((QueryCursorImpl)cursor).fieldsMeta();
                            }
                            return super.fieldsMeta();
                        }
                    };
                }
            }, true);
            return queryCursor;
        }
        catch (IgniteCheckedException e) {
            throw new CacheException(e);
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String space, CacheObject key, CacheObject val) throws IgniteCheckedException {
        assert (key != null);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Remove [space=" + space + ", key=" + key + ", val=" + val + "]");
        }
        if (this.idx == null) {
            return;
        }
        if (!this.busyLock.enterBusy()) {
            throw new IllegalStateException("Failed to remove from index (grid is stopping).");
        }
        try {
            this.idx.remove(space, key, val);
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    public static boolean isSqlType(Class<?> cls) {
        return SQL_TYPES.contains(cls = U.box(cls)) || GridQueryProcessor.isGeometryClass(cls);
    }

    public static boolean isGeometryClass(Class<?> cls) {
        return GEOMETRY_CLASS != null && GEOMETRY_CLASS.isAssignableFrom(cls);
    }

    public static String typeName(Class<?> cls) {
        String typeName = cls.getSimpleName();
        if (F.isEmpty(typeName)) {
            String pkg = cls.getPackage().getName();
            typeName = cls.getName().substring(pkg.length() + (pkg.isEmpty() ? 0 : 1));
        }
        if (cls.isArray()) {
            assert (typeName.endsWith("[]"));
            typeName = typeName.substring(0, typeName.length() - 2) + "_array";
        }
        return typeName;
    }

    public static String typeName(String clsName) {
        int parentEnd;
        int pkgEnd = clsName.lastIndexOf(46);
        if (pkgEnd >= 0 && pkgEnd < clsName.length() - 1) {
            clsName = clsName.substring(pkgEnd + 1);
        }
        if (clsName.endsWith("[]")) {
            clsName = clsName.substring(0, clsName.length() - 2) + "_array";
        }
        if ((parentEnd = clsName.lastIndexOf(36)) >= 0) {
            clsName = clsName.substring(parentEnd + 1);
        }
        return clsName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> GridCloseableIterator<IgniteBiTuple<K, V>> queryText(final String space, final String clause, final String resType, final IndexingQueryFilter filters) throws IgniteCheckedException {
        this.checkEnabled();
        if (!this.busyLock.enterBusy()) {
            throw new IllegalStateException("Failed to execute query (grid is stopping).");
        }
        try {
            GridCacheContext cctx = this.ctx.cache().internalCache(space).context();
            GridCloseableIterator gridCloseableIterator = (GridCloseableIterator)this.executeQuery(GridCacheQueryType.TEXT, clause, cctx, new IgniteOutClosureX<GridCloseableIterator<IgniteBiTuple<K, V>>>(){

                @Override
                public GridCloseableIterator<IgniteBiTuple<K, V>> applyx() throws IgniteCheckedException {
                    TypeDescriptor type = (TypeDescriptor)GridQueryProcessor.this.typesByName.get(new TypeName(space, resType));
                    if (type == null || !type.registered()) {
                        throw new CacheException("Failed to find SQL table for type: " + resType);
                    }
                    return GridQueryProcessor.this.idx.queryLocalText(space, clause, type, filters);
                }
            }, true);
            return gridCloseableIterator;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSwap(String spaceName, CacheObject key) throws IgniteCheckedException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Swap [space=" + spaceName + ", key=" + key + "]");
        }
        if (this.idx == null) {
            return;
        }
        if (!this.busyLock.enterBusy()) {
            throw new IllegalStateException("Failed to process swap event (grid is stopping).");
        }
        try {
            this.idx.onSwap(spaceName, key);
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUnswap(String spaceName, CacheObject key, CacheObject val) throws IgniteCheckedException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Unswap [space=" + spaceName + ", key=" + key + ", val=" + val + "]");
        }
        if (this.idx == null) {
            return;
        }
        if (!this.busyLock.enterBusy()) {
            throw new IllegalStateException("Failed to process swap event (grid is stopping).");
        }
        try {
            this.idx.onUnswap(spaceName, key, val);
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUndeploy(@Nullable String space, ClassLoader ldr) throws IgniteCheckedException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Undeploy [space=" + space + "]");
        }
        if (this.idx == null) {
            return;
        }
        if (!this.busyLock.enterBusy()) {
            throw new IllegalStateException("Failed to process undeploy event (grid is stopping).");
        }
        try {
            Iterator<Map.Entry<TypeId, TypeDescriptor>> it = this.types.entrySet().iterator();
            while (it.hasNext()) {
                TypeDescriptor desc;
                Map.Entry<TypeId, TypeDescriptor> e = it.next();
                if (!F.eq(e.getKey().space, space) || !ldr.equals(U.detectClassLoader((desc = e.getValue()).valCls)) && !ldr.equals(U.detectClassLoader(desc.keyCls))) continue;
                this.idx.unregisterType(e.getKey().space, desc);
                it.remove();
            }
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    private void processClassMeta(CacheTypeMetadata meta, TypeDescriptor d, CacheObjectContext coCtx) throws IgniteCheckedException {
        Map<String, String> aliases = meta.getAliases();
        if (aliases == null) {
            aliases = Collections.emptyMap();
        }
        Class<?> keyCls = d.keyClass();
        Class<?> valCls = d.valueClass();
        assert (keyCls != null);
        assert (valCls != null);
        for (Map.Entry<String, Class<?>> entry : meta.getAscendingFields().entrySet()) {
            this.addToIndex(d, keyCls, valCls, entry.getKey(), entry.getValue(), 0, IndexType.ASC, null, aliases, coCtx);
        }
        for (Map.Entry<String, Class<?>> entry : meta.getDescendingFields().entrySet()) {
            this.addToIndex(d, keyCls, valCls, entry.getKey(), entry.getValue(), 0, IndexType.DESC, null, aliases, coCtx);
        }
        for (String txtField : meta.getTextFields()) {
            this.addToIndex(d, keyCls, valCls, txtField, String.class, 0, IndexType.TEXT, null, aliases, coCtx);
        }
        Map<String, LinkedHashMap<String, IgniteBiTuple<Class<?>, Boolean>>> grps = meta.getGroups();
        if (grps != null) {
            for (Map.Entry<String, Serializable> entry : grps.entrySet()) {
                String idxName = entry.getKey();
                LinkedHashMap idxFields = (LinkedHashMap)entry.getValue();
                int order = 0;
                for (Map.Entry idxField : idxFields.entrySet()) {
                    Boolean descending = (Boolean)((IgniteBiTuple)idxField.getValue()).get2();
                    if (descending == null) {
                        descending = false;
                    }
                    this.addToIndex(d, keyCls, valCls, (String)idxField.getKey(), (Class)((IgniteBiTuple)idxField.getValue()).get1(), order, descending != false ? IndexType.DESC : IndexType.ASC, idxName, aliases, coCtx);
                    ++order;
                }
            }
        }
        for (Map.Entry<String, Serializable> entry : meta.getQueryFields().entrySet()) {
            ClassProperty prop = GridQueryProcessor.buildClassProperty(keyCls, valCls, entry.getKey(), (Class)entry.getValue(), aliases, coCtx);
            d.addProperty(prop, false);
        }
    }

    private void addToIndex(TypeDescriptor d, Class<?> keyCls, Class<?> valCls, String pathStr, Class<?> resType, int idxOrder, IndexType idxType, String idxName, Map<String, String> aliases, CacheObjectContext coCtx) throws IgniteCheckedException {
        Class<?> propCls;
        String propName;
        if (_VAL.equals(pathStr)) {
            propName = _VAL;
            propCls = valCls;
        } else {
            ClassProperty prop = GridQueryProcessor.buildClassProperty(keyCls, valCls, pathStr, resType, aliases, coCtx);
            d.addProperty(prop, false);
            propName = prop.name();
            propCls = prop.type();
        }
        if (idxType != null) {
            if (idxName == null) {
                idxName = propName + "_idx";
            }
            if (idxOrder == 0) {
                d.addIndex(idxName, GridQueryProcessor.isGeometryClass(propCls) ? GridQueryIndexType.GEO_SPATIAL : GridQueryIndexType.SORTED);
            }
            if (idxType == IndexType.TEXT) {
                d.addFieldToTextIndex(propName);
            } else {
                d.addFieldToIndex(idxName, propName, idxOrder, idxType == IndexType.DESC);
            }
        }
    }

    private void processBinaryMeta(CacheTypeMetadata meta, TypeDescriptor d) throws IgniteCheckedException {
        String idxName;
        Map<String, String> aliases = meta.getAliases();
        if (aliases == null) {
            aliases = Collections.emptyMap();
        }
        for (Map.Entry<String, Class<?>> entry : meta.getAscendingFields().entrySet()) {
            BinaryProperty binaryProperty = this.buildBinaryProperty(entry.getKey(), entry.getValue(), aliases, null);
            d.addProperty(binaryProperty, false);
            idxName = binaryProperty.name() + "_idx";
            d.addIndex(idxName, GridQueryProcessor.isGeometryClass(binaryProperty.type()) ? GridQueryIndexType.GEO_SPATIAL : GridQueryIndexType.SORTED);
            d.addFieldToIndex(idxName, binaryProperty.name(), 0, false);
        }
        for (Map.Entry<String, Class<?>> entry : meta.getDescendingFields().entrySet()) {
            BinaryProperty binaryProperty = this.buildBinaryProperty(entry.getKey(), entry.getValue(), aliases, null);
            d.addProperty(binaryProperty, false);
            idxName = binaryProperty.name() + "_idx";
            d.addIndex(idxName, GridQueryProcessor.isGeometryClass(binaryProperty.type()) ? GridQueryIndexType.GEO_SPATIAL : GridQueryIndexType.SORTED);
            d.addFieldToIndex(idxName, binaryProperty.name(), 0, true);
        }
        for (String txtIdx : meta.getTextFields()) {
            BinaryProperty binaryProperty = this.buildBinaryProperty(txtIdx, String.class, aliases, null);
            d.addProperty(binaryProperty, false);
            d.addFieldToTextIndex(binaryProperty.name());
        }
        Map<String, LinkedHashMap<String, IgniteBiTuple<Class<?>, Boolean>>> grps = meta.getGroups();
        if (grps != null) {
            for (Map.Entry<String, Serializable> entry : grps.entrySet()) {
                idxName = entry.getKey();
                LinkedHashMap idxFields = (LinkedHashMap)entry.getValue();
                int order = 0;
                for (Map.Entry idxField : idxFields.entrySet()) {
                    BinaryProperty prop2 = this.buildBinaryProperty((String)idxField.getKey(), (Class)((IgniteBiTuple)idxField.getValue()).get1(), aliases, null);
                    d.addProperty(prop2, false);
                    Boolean descending = (Boolean)((IgniteBiTuple)idxField.getValue()).get2();
                    d.addFieldToIndex(idxName, prop2.name(), order, descending != null && descending != false);
                    ++order;
                }
            }
        }
        for (Map.Entry<String, Serializable> entry : meta.getQueryFields().entrySet()) {
            BinaryProperty prop3 = this.buildBinaryProperty(entry.getKey(), (Class)entry.getValue(), aliases, null);
            if (d.props.containsKey(prop3.name())) continue;
            d.addProperty(prop3, false);
        }
    }

    private void processBinaryMeta(QueryEntity qryEntity, TypeDescriptor d) throws IgniteCheckedException {
        Set<String> keyFields;
        Map<String, String> aliases = qryEntity.getAliases();
        if (aliases == null) {
            aliases = Collections.emptyMap();
        }
        boolean hasKeyFields = (keyFields = qryEntity.getKeyFields()) != null;
        boolean isKeyClsSqlType = GridQueryProcessor.isSqlType(d.keyClass());
        if (hasKeyFields && !isKeyClsSqlType) {
            for (String string : keyFields) {
                if (qryEntity.getFields().containsKey(string)) continue;
                throw new IgniteCheckedException("QueryEntity 'keyFields' property must be a subset of keys from 'fields' property (case sensitive): " + string);
            }
        }
        for (Map.Entry entry : qryEntity.getFields().entrySet()) {
            Boolean isKeyField = isKeyClsSqlType ? Boolean.valueOf(false) : (hasKeyFields ? Boolean.valueOf(keyFields.contains(entry.getKey())) : null);
            BinaryProperty prop = this.buildBinaryProperty((String)entry.getKey(), U.classForName((String)entry.getValue(), Object.class, true), aliases, isKeyField);
            d.addProperty(prop, false);
        }
        this.processIndexes(qryEntity, d);
    }

    private void processClassMeta(QueryEntity qryEntity, TypeDescriptor d, CacheObjectContext coCtx) throws IgniteCheckedException {
        Map<String, String> aliases = qryEntity.getAliases();
        if (aliases == null) {
            aliases = Collections.emptyMap();
        }
        for (Map.Entry<String, String> entry : qryEntity.getFields().entrySet()) {
            ClassProperty prop = GridQueryProcessor.buildClassProperty(d.keyClass(), d.valueClass(), entry.getKey(), U.classForName(entry.getValue(), Object.class), aliases, coCtx);
            d.addProperty(prop, false);
        }
        this.processIndexes(qryEntity, d);
    }

    private void processIndexes(QueryEntity qryEntity, TypeDescriptor d) throws IgniteCheckedException {
        if (!F.isEmpty(qryEntity.getIndexes())) {
            Map<String, String> aliases = qryEntity.getAliases();
            if (aliases == null) {
                aliases = Collections.emptyMap();
            }
            for (QueryIndex idx : qryEntity.getIndexes()) {
                String idxName = idx.getName();
                if (idxName == null) {
                    idxName = QueryEntity.defaultIndexName(idx);
                }
                if (idx.getIndexType() == QueryIndexType.SORTED || idx.getIndexType() == QueryIndexType.GEOSPATIAL) {
                    d.addIndex(idxName, idx.getIndexType() == QueryIndexType.SORTED ? GridQueryIndexType.SORTED : GridQueryIndexType.GEO_SPATIAL);
                    int i = 0;
                    for (Map.Entry<String, Boolean> entry : idx.getFields().entrySet()) {
                        String field = entry.getKey();
                        boolean asc = entry.getValue();
                        String alias = aliases.get(field);
                        if (alias != null) {
                            field = alias;
                        }
                        d.addFieldToIndex(idxName, field, i++, !asc);
                    }
                    continue;
                }
                assert (idx.getIndexType() == QueryIndexType.FULLTEXT);
                for (String field : idx.getFields().keySet()) {
                    String alias = aliases.get(field);
                    if (alias != null) {
                        field = alias;
                    }
                    d.addFieldToTextIndex(field);
                }
            }
        }
    }

    private BinaryProperty buildBinaryProperty(String pathStr, Class<?> resType, Map<String, String> aliases, @Nullable Boolean isKeyField) throws IgniteCheckedException {
        String[] path = pathStr.split("\\.");
        BinaryProperty res = null;
        StringBuilder fullName = new StringBuilder();
        for (String prop : path) {
            if (fullName.length() != 0) {
                fullName.append('.');
            }
            fullName.append(prop);
            String alias = aliases.get(fullName.toString());
            res = new BinaryProperty(prop, res, resType, isKeyField, alias);
        }
        return res;
    }

    private static ClassProperty buildClassProperty(Class<?> keyCls, Class<?> valCls, String pathStr, Class<?> resType, Map<String, String> aliases, CacheObjectContext coCtx) throws IgniteCheckedException {
        ClassProperty res = GridQueryProcessor.buildClassProperty(true, keyCls, pathStr, resType, aliases, coCtx);
        if (res == null) {
            res = GridQueryProcessor.buildClassProperty(false, valCls, pathStr, resType, aliases, coCtx);
        }
        if (res == null) {
            throw new IgniteCheckedException("Failed to initialize property '" + pathStr + "' of type '" + resType.getName() + "' for key class '" + keyCls + "' and value class '" + valCls + "'. " + "Make sure that one of these classes contains respective getter method or field.");
        }
        return res;
    }

    private static ClassProperty buildClassProperty(boolean key, Class<?> cls, String pathStr, Class<?> resType, Map<String, String> aliases, CacheObjectContext coCtx) {
        String[] path = pathStr.split("\\.");
        ClassProperty res = null;
        StringBuilder fullName = new StringBuilder();
        for (String prop : path) {
            if (fullName.length() != 0) {
                fullName.append('.');
            }
            fullName.append(prop);
            String alias = aliases.get(fullName.toString());
            PropertyAccessor accessor = GridQueryProcessor.findProperty(prop, cls);
            if (accessor == null) {
                return null;
            }
            ClassProperty tmp = new ClassProperty(accessor, key, alias, coCtx);
            tmp.parent(res);
            cls = tmp.type();
            res = tmp;
        }
        if (!U.box(resType).isAssignableFrom(U.box(res.type()))) {
            return null;
        }
        return res;
    }

    public Collection<GridQueryTypeDescriptor> types(@Nullable String space) {
        ArrayList<GridQueryTypeDescriptor> spaceTypes = new ArrayList<GridQueryTypeDescriptor>(Math.min(10, this.types.size()));
        for (Map.Entry<TypeId, TypeDescriptor> e : this.types.entrySet()) {
            TypeDescriptor desc = e.getValue();
            if (!desc.registered() || !F.eq(e.getKey().space, space)) continue;
            spaceTypes.add(desc);
        }
        return spaceTypes;
    }

    public GridQueryTypeDescriptor type(@Nullable String space, String typeName) throws IgniteCheckedException {
        TypeDescriptor type = (TypeDescriptor)this.typesByName.get(new TypeName(space, typeName));
        if (type == null || !type.registered()) {
            throw new IgniteCheckedException("Failed to find type descriptor for type name: " + typeName);
        }
        return type;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <R> R executeQuery(GridCacheQueryType qryType, String qry, GridCacheContext<?, ?> cctx, IgniteOutClosureX<R> clo, boolean complete) throws IgniteCheckedException {
        boolean bl;
        CacheQueryFuture fut;
        long startTime = U.currentTimeMillis();
        Throwable err = null;
        CacheQueryFuture res = null;
        try {
            res = (CacheQueryFuture)clo.apply();
            if (res instanceof CacheQueryFuture) {
                fut = res;
                err = fut.error();
            }
            fut = res;
            bl = err != null;
        }
        catch (GridClosureException e) {
            try {
                err = e.unwrap();
                throw (IgniteCheckedException)err;
                catch (CacheException e2) {
                    err = e2;
                    throw e2;
                }
                catch (Exception e3) {
                    err = e3;
                    throw new IgniteCheckedException(e3);
                }
            }
            catch (Throwable throwable) {
                boolean failed2 = err != null;
                long duration = U.currentTimeMillis() - startTime;
                if (complete || failed2) {
                    cctx.queries().collectMetrics(qryType, qry, startTime, duration, failed2);
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("Query execution [startTime=" + startTime + ", duration=" + duration + ", fail=" + failed2 + ", res=" + res + ']');
                    }
                }
                throw throwable;
            }
        }
        boolean failed = bl;
        long duration = U.currentTimeMillis() - startTime;
        if (complete || failed) {
            cctx.queries().collectMetrics(qryType, qry, startTime, duration, failed);
            if (this.log.isTraceEnabled()) {
                this.log.trace("Query execution [startTime=" + startTime + ", duration=" + duration + ", fail=" + failed + ", res=" + res + ']');
            }
        }
        return (R)fut;
    }

    @Nullable
    private static PropertyAccessor findProperty(String prop, Class<?> cls) {
        StringBuilder getBldr = new StringBuilder("get");
        getBldr.append(prop);
        getBldr.setCharAt(3, Character.toUpperCase(getBldr.charAt(3)));
        StringBuilder setBldr = new StringBuilder("set");
        setBldr.append(prop);
        setBldr.setCharAt(3, Character.toUpperCase(setBldr.charAt(3)));
        try {
            Method setter;
            Method getter = cls.getMethod(getBldr.toString(), new Class[0]);
            try {
                setter = cls.getMethod(setBldr.toString(), getter.getReturnType());
            }
            catch (NoSuchMethodException ignore) {
                return new ReadOnlyMethodsAccessor(getter, prop);
            }
            return new MethodsAccessor(getter, setter, prop);
        }
        catch (NoSuchMethodException getter) {
            getBldr = new StringBuilder("is");
            getBldr.append(prop);
            getBldr.setCharAt(2, Character.toUpperCase(getBldr.charAt(2)));
            try {
                Method setter;
                Method getter2 = cls.getMethod(getBldr.toString(), new Class[0]);
                try {
                    setter = cls.getMethod(setBldr.toString(), getter2.getReturnType());
                }
                catch (NoSuchMethodException ignore) {
                    return new ReadOnlyMethodsAccessor(getter2, prop);
                }
                return new MethodsAccessor(getter2, setter, prop);
            }
            catch (NoSuchMethodException getter2) {
                for (Class<?> cls0 = cls; cls0 != null; cls0 = cls0.getSuperclass()) {
                    try {
                        return new FieldAccessor(cls0.getDeclaredField(prop));
                    }
                    catch (NoSuchFieldException ignored) {
                        continue;
                    }
                }
                try {
                    Method setter;
                    Method getter3 = cls.getMethod(prop, new Class[0]);
                    try {
                        setter = cls.getMethod(prop, getter3.getReturnType());
                    }
                    catch (NoSuchMethodException ignore) {
                        return new ReadOnlyMethodsAccessor(getter3, prop);
                    }
                    return new MethodsAccessor(getter3, setter, prop);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    return null;
                }
            }
        }
    }

    public static void setRequestAffinityTopologyVersion(AffinityTopologyVersion ver) {
        requestTopVer.set(ver);
    }

    public static AffinityTopologyVersion getRequestAffinityTopologyVersion() {
        return requestTopVer.get();
    }

    static {
        requestTopVer = new ThreadLocal();
    }

    private static final class ReadOnlyMethodsAccessor
    implements PropertyAccessor {
        private final Method getter;
        private final String propName;

        private ReadOnlyMethodsAccessor(Method getter, String propName) {
            getter.setAccessible(true);
            this.getter = getter;
            this.propName = propName;
        }

        @Override
        public Object getValue(Object obj) throws IgniteCheckedException {
            try {
                return this.getter.invoke(obj, new Object[0]);
            }
            catch (Exception e) {
                throw new IgniteCheckedException("Failed to invoke getter method [type=" + this.getType() + ", property=" + this.propName + ']', e);
            }
        }

        @Override
        public void setValue(Object obj, Object newVal) throws IgniteCheckedException {
            throw new UnsupportedOperationException("Property is read-only [type=" + this.getType() + ", property=" + this.propName + ']');
        }

        @Override
        public String getPropertyName() {
            return this.propName;
        }

        @Override
        public Class<?> getType() {
            return this.getter.getReturnType();
        }
    }

    private static final class MethodsAccessor
    implements PropertyAccessor {
        private final Method getter;
        private final Method setter;
        private final String propName;

        private MethodsAccessor(Method getter, Method setter, String propName) {
            getter.setAccessible(true);
            setter.setAccessible(true);
            this.getter = getter;
            this.setter = setter;
            this.propName = propName;
        }

        @Override
        public Object getValue(Object obj) throws IgniteCheckedException {
            try {
                return this.getter.invoke(obj, new Object[0]);
            }
            catch (Exception e) {
                throw new IgniteCheckedException("Failed to invoke getter method [type=" + this.getType() + ", property=" + this.propName + ']', e);
            }
        }

        @Override
        public void setValue(Object obj, Object newVal) throws IgniteCheckedException {
            try {
                this.setter.invoke(obj, newVal);
            }
            catch (Exception e) {
                throw new IgniteCheckedException("Failed to invoke setter method [type=" + this.getType() + ", property=" + this.propName + ']', e);
            }
        }

        @Override
        public String getPropertyName() {
            return this.propName;
        }

        @Override
        public Class<?> getType() {
            return this.getter.getReturnType();
        }
    }

    private static final class FieldAccessor
    implements PropertyAccessor {
        private final Field fld;

        private FieldAccessor(Field fld) {
            fld.setAccessible(true);
            this.fld = fld;
        }

        @Override
        public Object getValue(Object obj) throws IgniteCheckedException {
            try {
                return this.fld.get(obj);
            }
            catch (Exception e) {
                throw new IgniteCheckedException("Failed to get field value", e);
            }
        }

        @Override
        public void setValue(Object obj, Object newVal) throws IgniteCheckedException {
            try {
                this.fld.set(obj, newVal);
            }
            catch (Exception e) {
                throw new IgniteCheckedException("Failed to set field value", e);
            }
        }

        @Override
        public String getPropertyName() {
            return this.fld.getName();
        }

        @Override
        public Class<?> getType() {
            return this.fld.getType();
        }
    }

    private static interface PropertyAccessor {
        public Object getValue(Object var1) throws IgniteCheckedException;

        public void setValue(Object var1, Object var2) throws IgniteCheckedException;

        public String getPropertyName();

        public Class<?> getType();
    }

    private static enum IndexType {
        ASC,
        DESC,
        TEXT;

    }

    private static class TypeName {
        private final String space;
        private final String typeName;

        private TypeName(@Nullable String space, String typeName) {
            assert (!F.isEmpty(typeName)) : typeName;
            this.space = space;
            this.typeName = typeName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TypeName other = (TypeName)o;
            return (this.space != null ? this.space.equals(other.space) : other.space == null) && this.typeName.equals(other.typeName);
        }

        public int hashCode() {
            return 31 * (this.space != null ? this.space.hashCode() : 0) + this.typeName.hashCode();
        }

        public String toString() {
            return S.toString(TypeName.class, this);
        }
    }

    private static class TypeId {
        private final String space;
        private final Class<?> valType;
        private final int valTypeId;

        private TypeId(String space, Class<?> valType) {
            assert (valType != null);
            this.space = space;
            this.valType = valType;
            this.valTypeId = 0;
        }

        private TypeId(String space, int valTypeId) {
            this.space = space;
            this.valTypeId = valTypeId;
            this.valType = null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TypeId typeId = (TypeId)o;
            return this.valTypeId == typeId.valTypeId && (this.valType != null ? this.valType == typeId.valType : typeId.valType == null) && (this.space != null ? this.space.equals(typeId.space) : typeId.space == null);
        }

        public int hashCode() {
            return 31 * (this.space != null ? this.space.hashCode() : 0) + (this.valType != null ? this.valType.hashCode() : this.valTypeId);
        }

        public String toString() {
            return S.toString(TypeId.class, this);
        }
    }

    private static class IndexDescriptor
    implements GridQueryIndexDescriptor {
        private final Collection<T2<String, Integer>> fields = new TreeSet<T2<String, Integer>>(new Comparator<T2<String, Integer>>(){

            @Override
            public int compare(T2<String, Integer> o1, T2<String, Integer> o2) {
                if (((Integer)o1.get2()).equals(o2.get2())) {
                    return ((String)o1.get1()).compareTo((String)o2.get1());
                }
                return (Integer)o1.get2() < (Integer)o2.get2() ? -1 : 1;
            }
        });
        private Collection<String> descendings;
        private final GridQueryIndexType type;

        private IndexDescriptor(GridQueryIndexType type) {
            assert (type != null);
            this.type = type;
        }

        @Override
        public Collection<String> fields() {
            ArrayList<String> res = new ArrayList<String>(this.fields.size());
            for (T2<String, Integer> t : this.fields) {
                res.add((String)t.get1());
            }
            return res;
        }

        @Override
        public boolean descending(String field) {
            return this.descendings != null && this.descendings.contains(field);
        }

        public void addField(String field, int orderNum, boolean descending) {
            this.fields.add(new T2<String, Integer>(field, orderNum));
            if (descending) {
                if (this.descendings == null) {
                    this.descendings = new HashSet<String>();
                }
                this.descendings.add(field);
            }
        }

        @Override
        public GridQueryIndexType type() {
            return this.type;
        }

        public String toString() {
            return S.toString(IndexDescriptor.class, this);
        }
    }

    private static class TypeDescriptor
    implements GridQueryTypeDescriptor {
        private String name;
        private String tblName;
        @GridToStringInclude
        private final Map<String, Class<?>> fields = new LinkedHashMap();
        @GridToStringExclude
        private final Map<String, GridQueryProperty> props = new HashMap<String, GridQueryProperty>();
        private final Map<String, GridQueryProperty> uppercaseProps = new HashMap<String, GridQueryProperty>();
        @GridToStringInclude
        private final Map<String, IndexDescriptor> indexes = new HashMap<String, IndexDescriptor>();
        private IndexDescriptor fullTextIdx;
        private Class<?> keyCls;
        private Class<?> valCls;
        private String keyTypeName;
        private String valTypeName;
        private boolean valTextIdx;
        private String affKey;
        private boolean registered;

        private TypeDescriptor() {
        }

        boolean registered() {
            return this.registered;
        }

        void registered(boolean registered) {
            this.registered = registered;
        }

        @Override
        public String name() {
            return this.name;
        }

        void name(String name) {
            this.name = name;
        }

        @Override
        public String tableName() {
            return this.tblName;
        }

        public void tableName(String tblName) {
            this.tblName = tblName;
        }

        @Override
        public Map<String, Class<?>> fields() {
            return this.fields;
        }

        @Override
        public GridQueryProperty property(String name) {
            return this.getProperty(name);
        }

        @Override
        public <T> T value(String field, Object key, Object val) throws IgniteCheckedException {
            assert (field != null);
            GridQueryProperty prop = this.getProperty(field);
            if (prop == null) {
                throw new IgniteCheckedException("Failed to find field '" + field + "' in type '" + this.name + "'.");
            }
            return (T)prop.value(key, val);
        }

        @Override
        public void setValue(String field, Object key, Object val, Object propVal) throws IgniteCheckedException {
            assert (field != null);
            GridQueryProperty prop = this.getProperty(field);
            if (prop == null) {
                throw new IgniteCheckedException("Failed to find field '" + field + "' in type '" + this.name + "'.");
            }
            prop.setValue(key, val, propVal);
        }

        @Override
        public Map<String, GridQueryIndexDescriptor> indexes() {
            return Collections.unmodifiableMap(this.indexes);
        }

        public IndexDescriptor addIndex(String idxName, GridQueryIndexType type) throws IgniteCheckedException {
            IndexDescriptor idx = new IndexDescriptor(type);
            if (this.indexes.put(idxName, idx) != null) {
                throw new IgniteCheckedException("Index with name '" + idxName + "' already exists.");
            }
            return idx;
        }

        public void addFieldToIndex(String idxName, String field, int orderNum, boolean descending) throws IgniteCheckedException {
            IndexDescriptor desc = this.indexes.get(idxName);
            if (desc == null) {
                desc = this.addIndex(idxName, GridQueryIndexType.SORTED);
            }
            desc.addField(field, orderNum, descending);
        }

        public void addFieldToTextIndex(String field) {
            if (this.fullTextIdx == null) {
                this.fullTextIdx = new IndexDescriptor(GridQueryIndexType.FULLTEXT);
                this.indexes.put(null, this.fullTextIdx);
            }
            this.fullTextIdx.addField(field, 0, false);
        }

        @Override
        public Class<?> valueClass() {
            return this.valCls;
        }

        void valueClass(Class<?> valCls) {
            A.notNull(valCls, "Value class must not be null");
            this.valCls = valCls;
        }

        @Override
        public Class<?> keyClass() {
            return this.keyCls;
        }

        void keyClass(Class<?> keyCls) {
            this.keyCls = keyCls;
        }

        @Override
        public String keyTypeName() {
            return this.keyTypeName;
        }

        public void keyTypeName(String keyTypeName) {
            this.keyTypeName = keyTypeName;
        }

        @Override
        public String valueTypeName() {
            return this.valTypeName;
        }

        public void valueTypeName(String valTypeName) {
            this.valTypeName = valTypeName;
        }

        public void addProperty(GridQueryProperty prop, boolean failOnDuplicate) throws IgniteCheckedException {
            String name = prop.name();
            if (this.props.put(name, prop) != null && failOnDuplicate) {
                throw new IgniteCheckedException("Property with name '" + name + "' already exists.");
            }
            if (this.uppercaseProps.put(name.toUpperCase(), prop) != null && failOnDuplicate) {
                throw new IgniteCheckedException("Property with upper cased name '" + name + "' already exists.");
            }
            this.fields.put(name, prop.type());
        }

        private GridQueryProperty getProperty(String field) {
            GridQueryProperty res = this.props.get(field);
            if (res == null) {
                res = this.uppercaseProps.get(field.toUpperCase());
            }
            return res;
        }

        @Override
        public boolean valueTextIndex() {
            return this.valTextIdx;
        }

        public void valueTextIndex(boolean valTextIdx) {
            this.valTextIdx = valTextIdx;
        }

        @Override
        public String affinityKey() {
            return this.affKey;
        }

        void affinityKey(String affKey) {
            this.affKey = affKey;
        }

        public String toString() {
            return S.toString(TypeDescriptor.class, this);
        }
    }

    private class BinaryProperty
    extends GridQueryProperty {
        private String propName;
        private String alias;
        private BinaryProperty parent;
        private Class<?> type;
        private volatile int isKeyProp;
        private volatile BinaryField field;
        private volatile boolean fieldTaken;
        private volatile boolean warned;

        private BinaryProperty(String propName, BinaryProperty parent, @Nullable Class<?> type, Boolean key, String alias) {
            this.propName = propName;
            this.alias = F.isEmpty(alias) ? propName : alias;
            this.parent = parent;
            this.type = type;
            if (key != null) {
                this.isKeyProp = key != false ? 1 : -1;
            }
        }

        @Override
        public Object value(Object key, Object val) throws IgniteCheckedException {
            Object obj;
            if (this.parent != null) {
                obj = this.parent.value(key, val);
                if (obj == null) {
                    return null;
                }
                if (!GridQueryProcessor.this.ctx.cacheObjects().isBinaryObject(obj)) {
                    throw new IgniteCheckedException("Non-binary object received as a result of property extraction [parent=" + this.parent + ", propName=" + this.propName + ", obj=" + obj + ']');
                }
            } else {
                int isKeyProp0 = this.isKeyProp;
                if (isKeyProp0 == 0) {
                    if (key instanceof BinaryObject && ((BinaryObject)key).hasField(this.propName)) {
                        isKeyProp0 = 1;
                        this.isKeyProp = 1;
                    } else if (val instanceof BinaryObject && ((BinaryObject)val).hasField(this.propName)) {
                        isKeyProp0 = -1;
                        this.isKeyProp = -1;
                    } else {
                        if (!this.warned) {
                            U.warn(GridQueryProcessor.this.log, "Neither key nor value have property \"" + this.propName + "\" " + "(is cache indexing configured correctly?)");
                            this.warned = true;
                        }
                        return null;
                    }
                }
                Object object = obj = isKeyProp0 == 1 ? key : val;
            }
            assert (obj instanceof BinaryObject);
            BinaryObject obj0 = (BinaryObject)obj;
            return this.fieldValue(obj0);
        }

        @Override
        public void setValue(Object key, Object val, Object propVal) throws IgniteCheckedException {
            Object obj;
            Object object = obj = this.key() ? key : val;
            if (obj == null) {
                return;
            }
            if (!(obj instanceof BinaryObjectBuilder)) {
                throw new UnsupportedOperationException("Individual properties can be set for binary builders only");
            }
            this.setValue0((BinaryObjectBuilder)obj, this.propName, propVal, this.type());
        }

        private <T> void setValue0(BinaryObjectBuilder builder, String field, Object val, Class<T> valType) {
            builder.setField(field, val, valType);
        }

        private BinaryField binaryField(BinaryObject obj) {
            BinaryField field0 = this.field;
            if (field0 == null && !this.fieldTaken) {
                BinaryType type;
                BinaryType binaryType = type = obj instanceof BinaryObjectEx ? ((BinaryObjectEx)obj).rawType() : obj.type();
                if (type != null) {
                    field0 = type.field(this.propName);
                    assert (field0 != null);
                    this.field = field0;
                }
                this.fieldTaken = true;
            }
            return field0;
        }

        private Object fieldValue(BinaryObject obj) {
            BinaryField field = this.binaryField(obj);
            if (field != null) {
                return field.value(obj);
            }
            return obj.field(this.propName);
        }

        @Override
        public String name() {
            return this.alias;
        }

        @Override
        public Class<?> type() {
            return this.type;
        }

        @Override
        public boolean key() {
            int isKeyProp0 = this.isKeyProp;
            if (isKeyProp0 == 0) {
                throw new IllegalStateException("Ownership flag not set for binary property. Have you set 'keyFields' property of QueryEntity in programmatic or XML configuration?");
            }
            return isKeyProp0 == 1;
        }
    }

    private static class ClassProperty
    extends GridQueryProperty {
        private final PropertyAccessor accessor;
        private final boolean key;
        private ClassProperty parent;
        private final String name;
        private final CacheObjectContext coCtx;

        ClassProperty(PropertyAccessor accessor, boolean key, String name, @Nullable CacheObjectContext coCtx) {
            this.accessor = accessor;
            this.key = key;
            this.name = !F.isEmpty(name) ? name : accessor.getPropertyName();
            this.coCtx = coCtx;
        }

        @Override
        public Object value(Object key, Object val) throws IgniteCheckedException {
            Object x = this.unwrap(this.key ? key : val);
            if (this.parent != null) {
                x = this.parent.value(key, val);
            }
            if (x == null) {
                return null;
            }
            return this.accessor.getValue(x);
        }

        @Override
        public void setValue(Object key, Object val, Object propVal) throws IgniteCheckedException {
            Object x = this.unwrap(this.key ? key : val);
            if (this.parent != null) {
                x = this.parent.value(key, val);
            }
            if (x == null) {
                return;
            }
            this.accessor.setValue(x, propVal);
        }

        @Override
        public boolean key() {
            return this.key;
        }

        private Object unwrap(Object o) {
            return this.coCtx == null ? o : (o instanceof CacheObject ? ((CacheObject)o).value(this.coCtx, false) : o);
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Class<?> type() {
            return this.accessor.getType();
        }

        public void parent(ClassProperty parent) {
            this.parent = parent;
        }

        public String toString() {
            return S.toString(ClassProperty.class, this);
        }
    }
}

