/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.sql.SQLException;
import org.apache.ignite.IgniteException;
import org.jetbrains.annotations.Nullable;

public class IgniteSQLException
extends IgniteException {
    private static final long serialVersionUID = 0L;
    private final String sqlState;
    private final int statusCode;

    public IgniteSQLException(String msg) {
        this(msg, null, 0);
    }

    public IgniteSQLException(SQLException cause) {
        super(cause);
        this.sqlState = null;
        this.statusCode = 0;
    }

    public IgniteSQLException(String msg, @Nullable Throwable cause) {
        super(msg, cause);
        this.sqlState = null;
        this.statusCode = 0;
    }

    public IgniteSQLException(String msg, int statusCode, @Nullable Throwable cause) {
        super(msg, cause);
        this.sqlState = null;
        this.statusCode = statusCode;
    }

    public IgniteSQLException(String msg, String sqlState, int statusCode) {
        super(msg);
        this.sqlState = sqlState;
        this.statusCode = statusCode;
    }

    public IgniteSQLException(String msg, int statusCode) {
        super(msg);
        this.sqlState = null;
        this.statusCode = statusCode;
    }

    public SQLException toJdbcException() {
        return new SQLException(this.getMessage(), this.sqlState, this.statusCode, this);
    }
}

