/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep.messages;

import java.nio.ByteBuffer;
import org.apache.ignite.cache.query.QueryCancelledException;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class GridQueryFailResponse
implements Message {
    public static final byte GENERAL_ERROR = 0;
    public static final byte CANCELLED_BY_ORIGINATOR = 1;
    private static final long serialVersionUID = 0L;
    private long qryReqId;
    private String errMsg;
    private byte failCode;

    public GridQueryFailResponse() {
    }

    public GridQueryFailResponse(long qryReqId, Throwable err) {
        this.qryReqId = qryReqId;
        this.errMsg = err.getClass() + ":" + err.getMessage();
        this.failCode = err instanceof QueryCancelledException ? (byte)1 : 0;
    }

    public long queryRequestId() {
        return this.qryReqId;
    }

    public String error() {
        return this.errMsg;
    }

    public byte failCode() {
        return this.failCode;
    }

    @Override
    public void onAckReceived() {
    }

    public String toString() {
        return S.toString(GridQueryFailResponse.class, this);
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeString("errMsg", this.errMsg)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeLong("qryReqId", this.qryReqId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeByte("failCode", this.failCode)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.errMsg = reader.readString("errMsg");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.qryReqId = reader.readLong("qryReqId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.failCode = reader.readByte("failCode");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridQueryFailResponse.class);
    }

    @Override
    public byte directType() {
        return 107;
    }

    @Override
    public byte fieldsCount() {
        return 3;
    }
}

