/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest.handlers.redis;

import java.util.Collection;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.rest.handlers.redis.GridRedisCommandHandler;
import org.apache.ignite.internal.processors.rest.protocols.tcp.redis.GridRedisCommand;
import org.apache.ignite.internal.processors.rest.protocols.tcp.redis.GridRedisMessage;
import org.apache.ignite.internal.processors.rest.protocols.tcp.redis.GridRedisProtocolParser;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.typedef.internal.U;

public class GridRedisConnectionCommandHandler
implements GridRedisCommandHandler {
    private static final Collection<GridRedisCommand> SUPPORTED_COMMANDS = U.sealList(GridRedisCommand.PING, GridRedisCommand.QUIT, GridRedisCommand.ECHO);
    private static final String PONG = "PONG";

    @Override
    public Collection<GridRedisCommand> supportedCommands() {
        return SUPPORTED_COMMANDS;
    }

    @Override
    public IgniteInternalFuture<GridRedisMessage> handleAsync(GridRedisMessage msg) {
        assert (msg != null);
        switch (msg.command()) {
            case PING: {
                msg.setResponse(GridRedisProtocolParser.toSimpleString(PONG));
                return new GridFinishedFuture<GridRedisMessage>(msg);
            }
            case QUIT: {
                msg.setResponse(GridRedisProtocolParser.oKString());
                return new GridFinishedFuture<GridRedisMessage>(msg);
            }
            case ECHO: {
                msg.setResponse(GridRedisProtocolParser.toSimpleString(msg.key()));
                return new GridFinishedFuture<GridRedisMessage>(msg);
            }
        }
        return new GridFinishedFuture<GridRedisMessage>();
    }
}

