/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest.handlers.redis.string;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import org.apache.ignite.IgniteAtomicLong;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.rest.GridRestCommand;
import org.apache.ignite.internal.processors.rest.GridRestProtocolHandler;
import org.apache.ignite.internal.processors.rest.GridRestResponse;
import org.apache.ignite.internal.processors.rest.handlers.redis.GridRedisRestCommandHandler;
import org.apache.ignite.internal.processors.rest.protocols.tcp.redis.GridRedisCommand;
import org.apache.ignite.internal.processors.rest.protocols.tcp.redis.GridRedisMessage;
import org.apache.ignite.internal.processors.rest.protocols.tcp.redis.GridRedisProtocolParser;
import org.apache.ignite.internal.processors.rest.request.GridRestCacheRequest;
import org.apache.ignite.internal.processors.rest.request.GridRestRequest;
import org.apache.ignite.internal.util.typedef.internal.U;

public class GridRedisGetCommandHandler
extends GridRedisRestCommandHandler {
    private static final Collection<GridRedisCommand> SUPPORTED_COMMANDS = U.sealList(GridRedisCommand.GET);
    private final GridKernalContext ctx;

    public GridRedisGetCommandHandler(IgniteLogger log, GridRestProtocolHandler hnd, GridKernalContext ctx) {
        super(log, hnd);
        this.ctx = ctx;
    }

    @Override
    public Collection<GridRedisCommand> supportedCommands() {
        return SUPPORTED_COMMANDS;
    }

    @Override
    public GridRestRequest asRestRequest(GridRedisMessage msg) throws IgniteCheckedException {
        assert (msg != null);
        GridRestCacheRequest restReq = new GridRestCacheRequest();
        restReq.clientId(msg.clientId());
        restReq.key(msg.key());
        restReq.command(GridRestCommand.CACHE_GET);
        return restReq;
    }

    @Override
    public ByteBuffer makeResponse(GridRestResponse restRes, List<String> params) {
        if (restRes.getResponse() == null) {
            long val;
            IgniteAtomicLong l = this.ctx.grid().atomicLong(params.get(0), 0L, false);
            try {
                val = l.get();
            }
            catch (Exception ignored) {
                return GridRedisProtocolParser.nil();
            }
            return GridRedisProtocolParser.toBulkString(val);
        }
        if (restRes.getResponse() instanceof String) {
            return GridRedisProtocolParser.toBulkString(restRes.getResponse());
        }
        return GridRedisProtocolParser.toTypeError("Operation against a key holding the wrong kind of value");
    }
}

