/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest.handlers.redis.string;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import org.apache.ignite.IgniteAtomicLong;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.rest.GridRestCommand;
import org.apache.ignite.internal.processors.rest.GridRestProtocolHandler;
import org.apache.ignite.internal.processors.rest.GridRestResponse;
import org.apache.ignite.internal.processors.rest.handlers.redis.GridRedisRestCommandHandler;
import org.apache.ignite.internal.processors.rest.handlers.redis.exception.GridRedisGenericException;
import org.apache.ignite.internal.processors.rest.protocols.tcp.redis.GridRedisCommand;
import org.apache.ignite.internal.processors.rest.protocols.tcp.redis.GridRedisMessage;
import org.apache.ignite.internal.processors.rest.protocols.tcp.redis.GridRedisProtocolParser;
import org.apache.ignite.internal.processors.rest.request.GridRestCacheRequest;
import org.apache.ignite.internal.processors.rest.request.GridRestRequest;
import org.apache.ignite.internal.util.typedef.internal.U;

public class GridRedisSetCommandHandler
extends GridRedisRestCommandHandler {
    private static final Collection<GridRedisCommand> SUPPORTED_COMMANDS = U.sealList(GridRedisCommand.SET);
    private static final int VAL_POS = 2;
    private final GridKernalContext ctx;

    public GridRedisSetCommandHandler(IgniteLogger log, GridRestProtocolHandler hnd, GridKernalContext ctx) {
        super(log, hnd);
        this.ctx = ctx;
    }

    @Override
    public Collection<GridRedisCommand> supportedCommands() {
        return SUPPORTED_COMMANDS;
    }

    @Override
    public GridRestRequest asRestRequest(GridRedisMessage msg) throws IgniteCheckedException {
        assert (msg != null);
        IgniteAtomicLong l = this.ctx.grid().atomicLong(msg.key(), 0L, false);
        if (l != null) {
            try {
                l.close();
            }
            catch (IgniteException ignored) {
                U.warn(this.log, "Failed to remove atomic long for key [" + msg.key() + "]");
            }
        }
        GridRestCacheRequest restReq = new GridRestCacheRequest();
        restReq.clientId(msg.clientId());
        restReq.key(msg.key());
        restReq.command(GridRestCommand.CACHE_PUT);
        if (msg.messageSize() < 3) {
            throw new GridRedisGenericException("Wrong number of arguments");
        }
        restReq.value(msg.aux(2));
        if (msg.messageSize() >= 4) {
            List<String> params = msg.aux();
            params.remove(0);
            if (this.isNx(params)) {
                restReq.command(GridRestCommand.CACHE_PUT_IF_ABSENT);
            } else if (this.isXx(params)) {
                restReq.command(GridRestCommand.CACHE_REPLACE);
            }
        }
        return restReq;
    }

    private boolean isNx(List<String> params) {
        if (params.size() >= 3) {
            return "nx".equalsIgnoreCase(params.get(0)) || "nx".equalsIgnoreCase(params.get(2));
        }
        return "nx".equalsIgnoreCase(params.get(0));
    }

    private boolean isXx(List<String> params) {
        if (params.size() >= 3) {
            return "xx".equalsIgnoreCase(params.get(0)) || "xx".equalsIgnoreCase(params.get(2));
        }
        return "xx".equalsIgnoreCase(params.get(0));
    }

    @Override
    public ByteBuffer makeResponse(GridRestResponse restRes, List<String> params) {
        Object resp = restRes.getResponse();
        if (resp == null) {
            return GridRedisProtocolParser.nil();
        }
        return (Boolean)resp == false ? GridRedisProtocolParser.nil() : GridRedisProtocolParser.oKString();
    }
}

