/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest.handlers.redis.string;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.rest.GridRestCommand;
import org.apache.ignite.internal.processors.rest.GridRestProtocolHandler;
import org.apache.ignite.internal.processors.rest.GridRestResponse;
import org.apache.ignite.internal.processors.rest.handlers.redis.GridRedisRestCommandHandler;
import org.apache.ignite.internal.processors.rest.handlers.redis.exception.GridRedisGenericException;
import org.apache.ignite.internal.processors.rest.protocols.tcp.redis.GridRedisCommand;
import org.apache.ignite.internal.processors.rest.protocols.tcp.redis.GridRedisMessage;
import org.apache.ignite.internal.processors.rest.protocols.tcp.redis.GridRedisProtocolParser;
import org.apache.ignite.internal.processors.rest.request.GridRestCacheRequest;
import org.apache.ignite.internal.processors.rest.request.GridRestRequest;
import org.apache.ignite.internal.util.typedef.internal.U;

public class GridRedisSetRangeCommandHandler
extends GridRedisRestCommandHandler {
    private static final Collection<GridRedisCommand> SUPPORTED_COMMANDS = U.sealList(GridRedisCommand.SETRANGE);
    private static final int OFFSET_POS = 2;
    private static final int VAL_POS = 3;
    private static final int MAX_OFFSET = 0x1FFFFFFF;

    public GridRedisSetRangeCommandHandler(IgniteLogger log, GridRestProtocolHandler hnd) {
        super(log, hnd);
    }

    @Override
    public Collection<GridRedisCommand> supportedCommands() {
        return SUPPORTED_COMMANDS;
    }

    @Override
    public GridRestRequest asRestRequest(GridRedisMessage msg) throws IgniteCheckedException {
        int off;
        assert (msg != null);
        if (msg.messageSize() < 4) {
            throw new GridRedisGenericException("Wrong number of arguments");
        }
        try {
            off = Integer.parseInt(msg.aux(2));
        }
        catch (NumberFormatException e) {
            U.error(this.log, "Erroneous offset", e);
            throw new GridRedisGenericException("Offset is not an integer");
        }
        String val = String.valueOf(msg.aux(3));
        GridRestCacheRequest getReq = new GridRestCacheRequest();
        getReq.clientId(msg.clientId());
        getReq.key(msg.key());
        getReq.command(GridRestCommand.CACHE_GET);
        if (val.isEmpty()) {
            return getReq;
        }
        Object resp = this.hnd.handle(getReq).getResponse();
        int totalLen = off + val.length();
        if (off < 0 || totalLen > 0x1FFFFFFF) {
            throw new GridRedisGenericException("Offset is out of range");
        }
        GridRestCacheRequest putReq = new GridRestCacheRequest();
        putReq.clientId(msg.clientId());
        putReq.key(msg.key());
        putReq.command(GridRestCommand.CACHE_PUT);
        if (resp == null) {
            byte[] dst = new byte[totalLen];
            System.arraycopy(val.getBytes(), 0, dst, off, val.length());
            putReq.value(new String(dst));
        } else {
            if (!(resp instanceof String)) {
                return getReq;
            }
            String cacheVal = String.valueOf(resp);
            cacheVal = cacheVal.substring(0, off) + val;
            putReq.value(cacheVal);
        }
        this.hnd.handle(putReq);
        return getReq;
    }

    @Override
    public ByteBuffer makeResponse(GridRestResponse restRes, List<String> params) {
        if (restRes.getResponse() == null) {
            return GridRedisProtocolParser.toInteger("0");
        }
        if (restRes.getResponse() instanceof String) {
            int resLen = ((String)restRes.getResponse()).length();
            return GridRedisProtocolParser.toInteger(String.valueOf(resLen));
        }
        return GridRedisProtocolParser.toTypeError("Operation against a key holding the wrong kind of value");
    }
}

