/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest.handlers.redis.string;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.rest.GridRestCommand;
import org.apache.ignite.internal.processors.rest.GridRestProtocolHandler;
import org.apache.ignite.internal.processors.rest.GridRestResponse;
import org.apache.ignite.internal.processors.rest.handlers.redis.GridRedisRestCommandHandler;
import org.apache.ignite.internal.processors.rest.protocols.tcp.redis.GridRedisCommand;
import org.apache.ignite.internal.processors.rest.protocols.tcp.redis.GridRedisMessage;
import org.apache.ignite.internal.processors.rest.protocols.tcp.redis.GridRedisProtocolParser;
import org.apache.ignite.internal.processors.rest.request.GridRestCacheRequest;
import org.apache.ignite.internal.processors.rest.request.GridRestRequest;
import org.apache.ignite.internal.util.typedef.internal.U;

public class GridRedisStrlenCommandHandler
extends GridRedisRestCommandHandler {
    private static final Collection<GridRedisCommand> SUPPORTED_COMMANDS = U.sealList(GridRedisCommand.STRLEN);

    public GridRedisStrlenCommandHandler(IgniteLogger log, GridRestProtocolHandler hnd) {
        super(log, hnd);
    }

    @Override
    public Collection<GridRedisCommand> supportedCommands() {
        return SUPPORTED_COMMANDS;
    }

    @Override
    public GridRestRequest asRestRequest(GridRedisMessage msg) throws IgniteCheckedException {
        assert (msg != null);
        GridRestCacheRequest restReq = new GridRestCacheRequest();
        restReq.clientId(msg.clientId());
        restReq.key(msg.key());
        restReq.command(GridRestCommand.CACHE_GET);
        return restReq;
    }

    @Override
    public ByteBuffer makeResponse(GridRestResponse restRes, List<String> params) {
        if (restRes.getResponse() == null) {
            return GridRedisProtocolParser.toInteger("0");
        }
        if (restRes.getResponse() instanceof String) {
            int len = String.valueOf(restRes.getResponse()).length();
            return GridRedisProtocolParser.toInteger(String.valueOf(len));
        }
        return GridRedisProtocolParser.toTypeError("Operation against a key holding the wrong kind of value");
    }
}

