/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest.handlers.top;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cluster.ClusterMetrics;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.client.GridClientCacheMode;
import org.apache.ignite.internal.processors.cache.GridCacheProcessor;
import org.apache.ignite.internal.processors.port.GridPortRecord;
import org.apache.ignite.internal.processors.rest.GridRestCommand;
import org.apache.ignite.internal.processors.rest.GridRestProtocol;
import org.apache.ignite.internal.processors.rest.GridRestResponse;
import org.apache.ignite.internal.processors.rest.client.message.GridClientCacheBean;
import org.apache.ignite.internal.processors.rest.client.message.GridClientNodeBean;
import org.apache.ignite.internal.processors.rest.client.message.GridClientNodeMetricsBean;
import org.apache.ignite.internal.processors.rest.handlers.GridRestCommandHandlerAdapter;
import org.apache.ignite.internal.processors.rest.request.GridRestRequest;
import org.apache.ignite.internal.processors.rest.request.GridRestTopologyRequest;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.P1;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.IgnitePortProtocol;

public class GridTopologyCommandHandler
extends GridRestCommandHandlerAdapter {
    private static final Collection<GridRestCommand> SUPPORTED_COMMANDS = U.sealList(GridRestCommand.TOPOLOGY, GridRestCommand.NODE);

    public GridTopologyCommandHandler(GridKernalContext ctx) {
        super(ctx);
    }

    @Override
    public Collection<GridRestCommand> supportedCommands() {
        return SUPPORTED_COMMANDS;
    }

    @Override
    public IgniteInternalFuture<GridRestResponse> handleAsync(GridRestRequest req) {
        assert (req instanceof GridRestTopologyRequest) : "Invalid command for topology handler: " + req;
        assert (SUPPORTED_COMMANDS.contains((Object)req.command()));
        if (this.log.isDebugEnabled()) {
            this.log.debug("Handling topology REST request: " + req);
        }
        GridRestTopologyRequest req0 = (GridRestTopologyRequest)req;
        GridRestResponse res = new GridRestResponse();
        boolean mtr = req0.includeMetrics();
        boolean attr = req0.includeAttributes();
        switch (req.command()) {
            case TOPOLOGY: {
                Collection<ClusterNode> allNodes = F.concat(false, this.ctx.discovery().allNodes(), this.ctx.discovery().daemonNodes());
                ArrayList<GridClientNodeBean> top = new ArrayList<GridClientNodeBean>(allNodes.size());
                for (ClusterNode node : allNodes) {
                    top.add(this.createNodeBean(node, mtr, attr));
                }
                res.setResponse(top);
                break;
            }
            case NODE: {
                ClusterNode node;
                UUID id = req0.nodeId();
                final String ip = req0.nodeIp();
                if (id == null && ip == null) {
                    return new GridFinishedFuture<GridRestResponse>(new IgniteCheckedException("Failed to handle request (either id or ip should be specified)."));
                }
                if (id != null) {
                    this.ctx.discovery().alive(id);
                    node = this.ctx.grid().cluster().node(id);
                    if (ip != null && node != null && !this.containsIp(node.addresses(), ip)) {
                        node = null;
                    }
                } else {
                    node = F.find(this.ctx.discovery().allNodes(), null, new P1<ClusterNode>(){

                        @Override
                        public boolean apply(ClusterNode n) {
                            return GridTopologyCommandHandler.this.containsIp(n.addresses(), ip);
                        }
                    });
                }
                if (node != null) {
                    res.setResponse(this.createNodeBean(node, mtr, attr));
                    break;
                }
                res.setResponse(null);
                break;
            }
            default: {
                assert (false) : "Invalid command for topology handler: " + req;
                break;
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Handled topology REST request [res=" + res + ", req=" + req + ']');
        }
        return new GridFinishedFuture<GridRestResponse>(res);
    }

    private boolean containsIp(Iterable<String> addrs, String ip) {
        for (String addr : addrs) {
            try {
                if (!InetAddress.getByName(addr).getHostAddress().equals(ip)) continue;
                return true;
            }
            catch (UnknownHostException unknownHostException) {
            }
        }
        return false;
    }

    public GridClientCacheBean createCacheBean(CacheConfiguration ccfg) {
        GridClientCacheBean cacheBean = new GridClientCacheBean();
        cacheBean.setName(ccfg.getName());
        cacheBean.setMode(GridClientCacheMode.valueOf(ccfg.getCacheMode().toString()));
        cacheBean.setSqlSchema(ccfg.getSqlSchema());
        return cacheBean;
    }

    private GridClientNodeBean createNodeBean(ClusterNode node, boolean mtr, boolean attr) {
        assert (node != null);
        GridClientNodeBean nodeBean = new GridClientNodeBean();
        nodeBean.setNodeId(node.id());
        nodeBean.setConsistentId(node.consistentId());
        nodeBean.setTcpPort(this.attribute(node, "org.apache.ignite.rest.tcp.port", 0));
        nodeBean.setTcpAddresses(GridTopologyCommandHandler.nonEmptyList((Collection)node.attribute("org.apache.ignite.rest.tcp.addrs")));
        nodeBean.setTcpHostNames(GridTopologyCommandHandler.nonEmptyList((Collection)node.attribute("org.apache.ignite.rest.tcp.host.names")));
        GridCacheProcessor cacheProc = this.ctx.cache();
        Map<String, CacheMode> nodeCaches = this.ctx.discovery().nodeCaches(node);
        ArrayList<GridClientCacheBean> caches = new ArrayList<GridClientCacheBean>(nodeCaches.size());
        for (String cacheName : nodeCaches.keySet()) {
            caches.add(this.createCacheBean(cacheProc.cacheConfiguration(cacheName)));
        }
        nodeBean.setCaches(caches);
        if (mtr) {
            ClusterMetrics metrics = node.metrics();
            GridClientNodeMetricsBean metricsBean = new GridClientNodeMetricsBean();
            metricsBean.setStartTime(metrics.getStartTime());
            metricsBean.setAverageActiveJobs(metrics.getAverageActiveJobs());
            metricsBean.setAverageCancelledJobs(metrics.getAverageCancelledJobs());
            metricsBean.setAverageCpuLoad(metrics.getAverageCpuLoad());
            metricsBean.setAverageJobExecuteTime(metrics.getAverageJobExecuteTime());
            metricsBean.setAverageJobWaitTime(metrics.getAverageJobWaitTime());
            metricsBean.setAverageRejectedJobs(metrics.getAverageRejectedJobs());
            metricsBean.setAverageWaitingJobs(metrics.getAverageWaitingJobs());
            metricsBean.setCurrentActiveJobs(metrics.getCurrentActiveJobs());
            metricsBean.setCurrentCancelledJobs(metrics.getCurrentCancelledJobs());
            metricsBean.setCurrentCpuLoad(metrics.getCurrentCpuLoad());
            metricsBean.setCurrentGcCpuLoad(metrics.getCurrentGcCpuLoad());
            metricsBean.setCurrentDaemonThreadCount(metrics.getCurrentDaemonThreadCount());
            metricsBean.setCurrentIdleTime(metrics.getCurrentIdleTime());
            metricsBean.setCurrentJobExecuteTime(metrics.getCurrentJobExecuteTime());
            metricsBean.setCurrentJobWaitTime(metrics.getCurrentJobWaitTime());
            metricsBean.setCurrentRejectedJobs(metrics.getCurrentRejectedJobs());
            metricsBean.setCurrentThreadCount(metrics.getCurrentThreadCount());
            metricsBean.setCurrentWaitingJobs(metrics.getCurrentWaitingJobs());
            metricsBean.setHeapMemoryCommitted(metrics.getHeapMemoryCommitted());
            metricsBean.setHeapMemoryInitialized(metrics.getHeapMemoryInitialized());
            metricsBean.setHeapMemoryMaximum(metrics.getHeapMemoryMaximum());
            metricsBean.setHeapMemoryUsed(metrics.getHeapMemoryUsed());
            metricsBean.setLastDataVersion(metrics.getLastDataVersion());
            metricsBean.setLastUpdateTime(metrics.getLastUpdateTime());
            metricsBean.setMaximumActiveJobs(metrics.getMaximumActiveJobs());
            metricsBean.setMaximumCancelledJobs(metrics.getMaximumCancelledJobs());
            metricsBean.setMaximumJobExecuteTime(metrics.getMaximumJobExecuteTime());
            metricsBean.setMaximumJobWaitTime(metrics.getMaximumJobWaitTime());
            metricsBean.setMaximumRejectedJobs(metrics.getMaximumRejectedJobs());
            metricsBean.setMaximumThreadCount(metrics.getMaximumThreadCount());
            metricsBean.setMaximumWaitingJobs(metrics.getMaximumWaitingJobs());
            metricsBean.setNodeStartTime(metrics.getNodeStartTime());
            metricsBean.setNonHeapMemoryCommitted(metrics.getNonHeapMemoryCommitted());
            metricsBean.setNonHeapMemoryInitialized(metrics.getNonHeapMemoryInitialized());
            metricsBean.setNonHeapMemoryMaximum(metrics.getNonHeapMemoryMaximum());
            metricsBean.setNonHeapMemoryUsed(metrics.getNonHeapMemoryUsed());
            metricsBean.setStartTime(metrics.getStartTime());
            metricsBean.setTotalCancelledJobs(metrics.getTotalCancelledJobs());
            metricsBean.setTotalCpus(metrics.getTotalCpus());
            metricsBean.setTotalExecutedJobs(metrics.getTotalExecutedJobs());
            metricsBean.setTotalIdleTime(metrics.getTotalIdleTime());
            metricsBean.setTotalRejectedJobs(metrics.getTotalRejectedJobs());
            metricsBean.setTotalStartedThreadCount(metrics.getTotalStartedThreadCount());
            metricsBean.setTotalExecutedTasks(metrics.getTotalExecutedTasks());
            metricsBean.setSentMessagesCount(metrics.getSentMessagesCount());
            metricsBean.setSentBytesCount(metrics.getSentBytesCount());
            metricsBean.setReceivedMessagesCount(metrics.getReceivedMessagesCount());
            metricsBean.setReceivedBytesCount(metrics.getReceivedBytesCount());
            metricsBean.setUpTime(metrics.getUpTime());
            nodeBean.setMetrics(metricsBean);
        }
        if (attr) {
            HashMap<String, Object> attrs = new HashMap<String, Object>(node.attributes());
            attrs.remove("org.apache.ignite.cache");
            attrs.remove("org.apache.ignite.tx");
            attrs.remove("org.apache.ignite.security.subject");
            attrs.remove("org.apache.ignite.security.cred");
            Iterator i = attrs.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry e = i.next();
                if (!((String)e.getKey()).startsWith("org.apache.ignite.") && !((String)e.getKey()).startsWith("plugins.") && System.getProperty((String)e.getKey()) == null) {
                    i.remove();
                    continue;
                }
                if (e.getValue() == null) continue;
                if (e.getValue().getClass().isEnum() || e.getValue() instanceof InetAddress) {
                    e.setValue(e.getValue().toString());
                    continue;
                }
                if (!e.getValue().getClass().isArray()) continue;
                i.remove();
            }
            nodeBean.setAttributes(attrs);
        }
        return nodeBean;
    }

    private static Collection<String> nonEmptyList(Collection<String> col) {
        return col == null ? Collections.emptyList() : col;
    }

    private <T> T attribute(ClusterNode node, String attrName, T dfltVal) {
        Object attr = node.attribute(attrName);
        return attr == null ? dfltVal : attr;
    }

    private int getRegisteredPort(Class<? extends GridRestProtocol> protoCls, int def) {
        for (GridPortRecord r : this.ctx.ports().records()) {
            if (r.protocol() != IgnitePortProtocol.TCP || !protoCls.isAssignableFrom(r.clazz())) continue;
            return r.port();
        }
        return def;
    }

    public String toString() {
        return S.toString(GridTopologyCommandHandler.class, this);
    }
}

