/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.service;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterGroup;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.GridClosureCallMode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.processors.service.GridServiceMethodNotFoundException;
import org.apache.ignite.internal.processors.service.GridServiceMethodReflectKey;
import org.apache.ignite.internal.processors.service.GridServiceNotFoundException;
import org.apache.ignite.internal.processors.service.ServiceContextImpl;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.jsr166.ThreadLocalRandom8;

public class GridServiceProxy<T>
implements Serializable {
    private static final long serialVersionUID = 0L;
    @GridToStringExclude
    private final IgniteLogger log;
    private final T proxy;
    private final ClusterGroup prj;
    @GridToStringExclude
    private final GridKernalContext ctx;
    private final AtomicReference<ClusterNode> rmtNode = new AtomicReference();
    private boolean hasLocNode;
    private final String name;
    private final boolean sticky;
    private final long waitTimeout;

    public GridServiceProxy(ClusterGroup prj, String name, Class<? super T> svc, boolean sticky, long timeout, GridKernalContext ctx) {
        assert (timeout >= 0L) : timeout;
        this.prj = prj;
        this.ctx = ctx;
        this.name = name;
        this.sticky = sticky;
        this.waitTimeout = timeout;
        this.hasLocNode = this.hasLocalNode(prj);
        this.log = ctx.log(this.getClass());
        this.proxy = Proxy.newProxyInstance(svc.getClassLoader(), new Class[]{svc}, (InvocationHandler)new ProxyInvocationHandler());
    }

    private boolean hasLocalNode(ClusterGroup prj) {
        for (ClusterNode n : prj.nodes()) {
            if (!n.isLocal()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object invokeMethod(Method mtd, Object[] args) {
        block19: {
            if (U.isHashCodeMethod(mtd)) {
                return System.identityHashCode(this.proxy);
            }
            if (U.isEqualsMethod(mtd)) {
                if (this.proxy == args[0]) {
                    v0 = true;
                    return v0;
                }
                v0 = false;
                return v0;
            }
            if (U.isToStringMethod(mtd)) {
                return GridServiceProxy.class.getSimpleName() + " [name=" + this.name + ", sticky=" + this.sticky + ']';
            }
            this.ctx.gateway().readLock();
            try {
                startTime = U.currentTimeMillis();
lbl14:
                // 2 sources

                while (true) {
                    node = null;
                    try {
                        node = this.nodeForService(this.name, this.sticky);
                        if (node == null) {
                            throw new IgniteException("Failed to find deployed service: " + this.name);
                        }
                        if (node.isLocal()) {
                            svcCtx = this.ctx.service().serviceContext(this.name);
                            if (svcCtx == null || (svc = svcCtx.service()) == null) break block19;
                            var8_12 = mtd.invoke((Object)svc, args);
                        }
                        break;
                    }
                    catch (ClusterTopologyCheckedException | GridServiceNotFoundException e) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Service was not found or topology changed (will retry): " + e.getMessage());
                        }
                        break block19;
                    }
                    catch (Error | RuntimeException e) {
                        throw e;
                    }
                    catch (IgniteCheckedException e) {
                        throw U.convertException(e);
                    }
                    catch (Exception e) {
                        throw new IgniteException(e);
                    }
                    this.ctx.gateway().readUnlock();
                    return var8_12;
                }
            }
            catch (Throwable var9_13) {
                this.ctx.gateway().readUnlock();
                throw var9_13;
            }
            {
                svcCtx = this.ctx.closure().callAsyncNoFailover(GridClosureCallMode.BROADCAST, new ServiceProxyCallable(mtd.getName(), this.name, mtd.getParameterTypes(), args), Collections.singleton(node), false, this.waitTimeout).get();
            }
            this.ctx.gateway().readUnlock();
            return svcCtx;
        }
        this.rmtNode.compareAndSet(node, null);
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IgniteException(e);
        }
        ** while (this.waitTimeout <= 0L || U.currentTimeMillis() - startTime < this.waitTimeout)
lbl54:
        // 1 sources

        throw new IgniteException("Service acquire timeout was reached, stopping. [timeout=" + this.waitTimeout + "]");
    }

    private ClusterNode nodeForService(String name, boolean sticky) throws IgniteCheckedException {
        while (sticky) {
            ClusterNode curNode = this.rmtNode.get();
            if (curNode != null) {
                return curNode;
            }
            curNode = this.randomNodeForService(name);
            if (curNode == null) {
                return null;
            }
            if (!this.rmtNode.compareAndSet(null, curNode)) continue;
            return curNode;
        }
        return this.randomNodeForService(name);
    }

    private ClusterNode randomNodeForService(String name) throws IgniteCheckedException {
        if (this.hasLocNode && this.ctx.service().service(name) != null) {
            return this.ctx.discovery().localNode();
        }
        Map<UUID, Integer> snapshot = this.ctx.service().serviceTopology(name, this.waitTimeout);
        if (snapshot == null || snapshot.isEmpty()) {
            return null;
        }
        if (snapshot.size() == 1) {
            UUID nodeId = snapshot.keySet().iterator().next();
            return this.prj.node(nodeId);
        }
        Collection<ClusterNode> nodes = this.prj.nodes();
        if (nodes.size() == 1) {
            ClusterNode n = nodes.iterator().next();
            return snapshot.containsKey(n.id()) ? n : null;
        }
        if (this.prj.predicate() == F.alwaysTrue()) {
            int idx = ThreadLocalRandom8.current().nextInt(snapshot.size());
            int i = 0;
            for (Map.Entry<UUID, Integer> e : snapshot.entrySet()) {
                if (i++ < idx || e.getValue() <= 0) continue;
                return this.ctx.discovery().node(e.getKey());
            }
            i = 0;
            for (Map.Entry<UUID, Integer> e : snapshot.entrySet()) {
                if (e.getValue() > 0) {
                    return this.ctx.discovery().node(e.getKey());
                }
                if (i++ != idx) continue;
                return null;
            }
        } else {
            ArrayList<ClusterNode> nodeList = new ArrayList<ClusterNode>(nodes.size());
            for (ClusterNode n : nodes) {
                Integer cnt = snapshot.get(n.id());
                if (cnt == null || cnt <= 0) continue;
                nodeList.add(n);
            }
            if (nodeList.isEmpty()) {
                return null;
            }
            int idx = ThreadLocalRandom8.current().nextInt(nodeList.size());
            return (ClusterNode)nodeList.get(idx);
        }
        return null;
    }

    T proxy() {
        return this.proxy;
    }

    private static class ServiceProxyCallable
    implements IgniteCallable<Object>,
    Externalizable {
        private static final long serialVersionUID = 0L;
        private String mtdName;
        private String svcName;
        private Class[] argTypes;
        private Object[] args;
        @IgniteInstanceResource
        private transient Ignite ignite;

        public ServiceProxyCallable() {
        }

        private ServiceProxyCallable(String mtdName, String svcName, Class[] argTypes, Object[] args) {
            this.mtdName = mtdName;
            this.svcName = svcName;
            this.argTypes = argTypes;
            this.args = args;
        }

        @Override
        public Object call() throws Exception {
            ServiceContextImpl svcCtx = ((IgniteEx)this.ignite).context().service().serviceContext(this.svcName);
            if (svcCtx == null || svcCtx.service() == null) {
                throw new GridServiceNotFoundException(this.svcName);
            }
            GridServiceMethodReflectKey key = new GridServiceMethodReflectKey(this.mtdName, this.argTypes);
            Method mtd = svcCtx.method(key);
            if (mtd == null) {
                throw new GridServiceMethodNotFoundException(this.svcName, this.mtdName, this.argTypes);
            }
            return mtd.invoke((Object)svcCtx.service(), this.args);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            U.writeString(out, this.svcName);
            U.writeString(out, this.mtdName);
            U.writeArray(out, this.argTypes);
            U.writeArray(out, this.args);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.svcName = U.readString(in);
            this.mtdName = U.readString(in);
            this.argTypes = U.readClassArray(in);
            this.args = U.readArray(in);
        }

        public String toString() {
            return S.toString(ServiceProxyCallable.class, this);
        }
    }

    private class ProxyInvocationHandler
    implements InvocationHandler {
        private ProxyInvocationHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method mtd, Object[] args) {
            return GridServiceProxy.this.invokeMethod(mtd, args);
        }
    }
}

