/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.service;

import java.lang.reflect.Method;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import org.apache.ignite.internal.processors.service.GridServiceMethodReflectKey;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.services.Service;
import org.apache.ignite.services.ServiceContext;
import org.jetbrains.annotations.Nullable;

public class ServiceContextImpl
implements ServiceContext {
    private static final long serialVersionUID = 0L;
    private static final Method NULL_METHOD = ServiceContextImpl.class.getMethods()[0];
    private final String name;
    private final UUID execId;
    private final String cacheName;
    private final Object affKey;
    @GridToStringExclude
    private final ExecutorService exe;
    private final ConcurrentMap<GridServiceMethodReflectKey, Method> mtds = new ConcurrentHashMap<GridServiceMethodReflectKey, Method>();
    @GridToStringExclude
    private volatile Service svc;
    private volatile boolean isCancelled;

    ServiceContextImpl(String name, UUID execId, String cacheName, Object affKey, ExecutorService exe) {
        this.name = name;
        this.execId = execId;
        this.cacheName = cacheName;
        this.affKey = affKey;
        this.exe = exe;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public UUID executionId() {
        return this.execId;
    }

    @Override
    public boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    @Nullable
    public String cacheName() {
        return this.cacheName;
    }

    @Override
    @Nullable
    public <K> K affinityKey() {
        return (K)this.affKey;
    }

    void service(Service svc) {
        this.svc = svc;
    }

    @Nullable
    Service service() {
        return this.svc;
    }

    ExecutorService executor() {
        return this.exe;
    }

    @Nullable
    Method method(GridServiceMethodReflectKey key) {
        Method mtd = (Method)this.mtds.get(key);
        if (mtd == null) {
            try {
                mtd = this.svc.getClass().getMethod(key.methodName(), key.argTypes());
                mtd.setAccessible(true);
            }
            catch (NoSuchMethodException ignored) {
                mtd = NULL_METHOD;
            }
            this.mtds.put(key, mtd);
        }
        return mtd == NULL_METHOD ? null : mtd;
    }

    public void setCancelled(boolean isCancelled) {
        this.isCancelled = isCancelled;
    }

    public String toString() {
        return S.toString(ServiceContextImpl.class, this);
    }
}

