/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.timeout;

import java.io.Closeable;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.GridProcessorAdapter;
import org.apache.ignite.internal.processors.timeout.GridTimeoutObject;
import org.apache.ignite.internal.util.GridConcurrentSkipListSet;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.thread.IgniteThread;

public class GridTimeoutProcessor
extends GridProcessorAdapter {
    private final IgniteThread timeoutWorker;
    private final GridConcurrentSkipListSet<GridTimeoutObject> timeoutObjs = new GridConcurrentSkipListSet<GridTimeoutObject>(new Comparator<GridTimeoutObject>(){

        @Override
        public int compare(GridTimeoutObject o1, GridTimeoutObject o2) {
            int res = Long.compare(o1.endTime(), o2.endTime());
            if (res != 0) {
                return res;
            }
            return o1.timeoutId().compareTo(o2.timeoutId());
        }
    });
    private final Object mux = new Object();

    public GridTimeoutProcessor(GridKernalContext ctx) {
        super(ctx);
        this.timeoutWorker = new IgniteThread(ctx.config().getGridName(), "grid-timeout-worker", new TimeoutWorker());
    }

    @Override
    public void start() {
        this.timeoutWorker.start();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Timeout processor started.");
        }
    }

    @Override
    public void stop(boolean cancel) throws IgniteCheckedException {
        U.interrupt(this.timeoutWorker);
        U.join(this.timeoutWorker);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Timeout processor stopped.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTimeoutObject(GridTimeoutObject timeoutObj) {
        if (timeoutObj.endTime() <= 0L || timeoutObj.endTime() == Long.MAX_VALUE) {
            return;
        }
        boolean added = this.timeoutObjs.add(timeoutObj);
        assert (added) : "Duplicate timeout object found: " + timeoutObj;
        if (this.timeoutObjs.firstx() == timeoutObj) {
            Object object = this.mux;
            synchronized (object) {
                this.mux.notify();
            }
        }
    }

    public CancelableTask schedule(Runnable task, long delay, long period) {
        assert (delay >= 0L) : delay;
        assert (period > 0L || period == -1L) : period;
        CancelableTask obj = new CancelableTask(task, U.currentTimeMillis() + delay, period);
        this.addTimeoutObject(obj);
        return obj;
    }

    public void removeTimeoutObject(GridTimeoutObject timeoutObj) {
        this.timeoutObjs.remove(timeoutObj);
    }

    @Override
    public void printMemoryStats() {
        X.println(">>>", new Object[0]);
        X.println(">>> Timeout processor memory stats [grid=" + this.ctx.gridName() + ']', new Object[0]);
        X.println(">>>   timeoutObjsSize: " + this.timeoutObjs.size(), new Object[0]);
    }

    public class CancelableTask
    implements GridTimeoutObject,
    Closeable {
        private final IgniteUuid id = IgniteUuid.randomUuid();
        private long endTime;
        private final long period;
        private volatile boolean cancel;
        @GridToStringInclude
        private final Runnable task;

        CancelableTask(Runnable task, long firstTime, long period) {
            this.task = task;
            this.endTime = firstTime;
            this.period = period;
        }

        @Override
        public IgniteUuid timeoutId() {
            return this.id;
        }

        @Override
        public long endTime() {
            return this.endTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void onTimeout() {
            if (this.cancel) {
                return;
            }
            try {
                this.task.run();
            }
            finally {
                if (!this.cancel && this.period > 0L) {
                    this.endTime = U.currentTimeMillis() + this.period;
                    GridTimeoutProcessor.this.addTimeoutObject(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            this.cancel = true;
            CancelableTask cancelableTask = this;
            synchronized (cancelableTask) {
                GridTimeoutProcessor.this.removeTimeoutObject(this);
            }
        }

        public String toString() {
            return S.toString(CancelableTask.class, this);
        }
    }

    private class TimeoutWorker
    extends GridWorker {
        TimeoutWorker() {
            super(GridTimeoutProcessor.this.ctx.config().getGridName(), "grid-timeout-worker", GridTimeoutProcessor.this.log);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void body() throws InterruptedException {
            while (!this.isCancelled()) {
                GridTimeoutObject timeoutObj;
                long now = U.currentTimeMillis();
                Iterator iter = GridTimeoutProcessor.this.timeoutObjs.iterator();
                while (iter.hasNext() && (timeoutObj = (GridTimeoutObject)iter.next()).endTime() <= now) {
                    iter.remove();
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Timeout has occurred: " + timeoutObj);
                    }
                    try {
                        timeoutObj.onTimeout();
                    }
                    catch (Throwable e) {
                        U.error(this.log, "Error when executing timeout callback: " + timeoutObj, e);
                        if (!(e instanceof Error)) continue;
                        throw e;
                    }
                }
                Object object = GridTimeoutProcessor.this.mux;
                synchronized (object) {
                    while (true) {
                        GridTimeoutObject first;
                        if ((first = (GridTimeoutObject)GridTimeoutProcessor.this.timeoutObjs.firstx()) != null) {
                            long waitTime = first.endTime() - U.currentTimeMillis();
                            if (waitTime <= 0L) break;
                            GridTimeoutProcessor.this.mux.wait(waitTime);
                            continue;
                        }
                        GridTimeoutProcessor.this.mux.wait(5000L);
                    }
                }
            }
        }
    }
}

