/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.lang.annotation.Annotation;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.internal.util.lang.GridTuple;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;
import org.jsr166.ConcurrentHashMap8;

public final class GridAnnotationsCache {
    private static final ConcurrentMap<Class<?>, ConcurrentMap<Class<? extends Annotation>, GridTuple<Annotation>>> anns = new ConcurrentHashMap8();

    @Nullable
    public static <T extends Annotation> T getAnnotation(Class<?> cls, Class<T> annCls) {
        GridTuple<T> ann;
        ConcurrentMap old;
        ConcurrentMap<Class<Object>, GridTuple<Object>> clsAnns = (ConcurrentHashMap8<Class<T>, GridTuple<T>>)anns.get(cls);
        if (clsAnns == null && (old = (ConcurrentMap)anns.putIfAbsent(cls, clsAnns = new ConcurrentHashMap8<Class<T>, GridTuple<T>>())) != null) {
            clsAnns = old;
        }
        if ((ann = (GridTuple<T>)clsAnns.get(annCls)) == null) {
            ann = F.t(U.getAnnotation(cls, annCls));
            clsAnns.putIfAbsent(annCls, ann);
        }
        return (T)((Annotation)ann.get());
    }

    public static void onUndeployed(ClassLoader ldr) {
        assert (ldr != null);
        for (Class cls : anns.keySet()) {
            if (!ldr.equals(cls.getClassLoader())) continue;
            anns.remove(cls);
        }
    }

    private GridAnnotationsCache() {
    }
}

