/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;

public final class GridCollections {
    private GridCollections() {
    }

    public static <K, V> Map<K, V> lockedMap(Map<K, V> m) {
        return new LockedMap(m);
    }

    public static <E> Set<E> lockedSet(Set<E> s) {
        return new LockedSet(s);
    }

    public static <E> Collection<E> lockedCollection(Collection<E> c) {
        return new LockedCollection(c);
    }

    private static class LockedCollection<E>
    extends ReentrantLock
    implements Collection<E> {
        private static final long serialVersionUID = 0L;
        protected final Collection<E> c;

        private LockedCollection(Collection<E> c) {
            this.c = c;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean add(E e) {
            this.lock();
            try {
                boolean bl = this.c.add(e);
                return bl;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            this.lock();
            try {
                int n = this.c.size();
                return n;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            this.lock();
            try {
                boolean bl = this.c.isEmpty();
                return bl;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object o) {
            this.lock();
            try {
                boolean bl = this.c.contains(o);
                return bl;
            }
            finally {
                this.unlock();
            }
        }

        @Override
        public Iterator<E> iterator() {
            return this.c.iterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            this.lock();
            try {
                Object[] objectArray = this.c.toArray();
                return objectArray;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] a) {
            this.lock();
            try {
                T[] TArray = this.c.toArray(a);
                return TArray;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object o) {
            this.lock();
            try {
                boolean bl = this.c.remove(o);
                return bl;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsAll(Collection<?> c) {
            this.lock();
            try {
                boolean bl = this.c.containsAll(c);
                return bl;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(Collection<? extends E> c) {
            this.lock();
            try {
                boolean bl = this.c.addAll(c);
                return bl;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeAll(Collection<?> c) {
            this.lock();
            try {
                boolean bl = this.c.removeAll(c);
                return bl;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean retainAll(Collection<?> c) {
            this.lock();
            try {
                boolean bl = this.c.retainAll(c);
                return bl;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            this.lock();
            try {
                this.c.clear();
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            this.lock();
            try {
                int n = this.c.hashCode();
                return n;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object o) {
            this.lock();
            try {
                boolean bl = this.c.equals(o);
                return bl;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String toString() {
            this.lock();
            try {
                String string = this.c.toString();
                return string;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeObject(ObjectOutputStream s) throws IOException {
            this.lock();
            try {
                s.defaultWriteObject();
            }
            finally {
                this.unlock();
            }
        }
    }

    private static final class LockedList<E>
    extends LockedCollection<E>
    implements List<E> {
        private static final long serialVersionUID = 0L;
        private final List<E> l;

        private LockedList(List<E> l) {
            super(l);
            this.l = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(int index, E e) {
            this.lock();
            try {
                this.l.add(index, e);
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(int idx, Collection<? extends E> c) {
            this.lock();
            try {
                boolean bl = this.l.addAll(c);
                return bl;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E get(int idx) {
            this.lock();
            try {
                E e = this.l.get(idx);
                return e;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E set(int idx, E e) {
            this.lock();
            try {
                E e2 = this.l.set(idx, e);
                return e2;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E remove(int idx) {
            this.lock();
            try {
                E e = this.l.remove(idx);
                return e;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object o) {
            this.lock();
            try {
                int n = this.l.indexOf(o);
                return n;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object o) {
            this.lock();
            try {
                int n = this.l.lastIndexOf(o);
                return n;
            }
            finally {
                this.unlock();
            }
        }

        @Override
        public ListIterator<E> listIterator() {
            return this.l.listIterator();
        }

        @Override
        public ListIterator<E> listIterator(int idx) {
            return this.l.listIterator(idx);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<E> subList(int fromIdx, int toIdx) {
            this.lock();
            try {
                LockedList<E> lockedList = new LockedList<E>(this.l.subList(fromIdx, toIdx));
                return lockedList;
            }
            finally {
                this.unlock();
            }
        }
    }

    private static final class LockedSet<E>
    extends LockedCollection<E>
    implements Set<E> {
        private static final long serialVersionUID = 0L;

        private LockedSet(Set<E> s) {
            super(s);
        }
    }

    private static final class LockedMap<K, V>
    extends ReentrantLock
    implements Map<K, V> {
        private static final long serialVersionUID = 0L;
        private final Map<K, V> m;

        private LockedMap(Map<K, V> m) {
            this.m = m;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            this.lock();
            try {
                this.m.clear();
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            this.lock();
            try {
                int n = this.m.size();
                return n;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            this.lock();
            try {
                boolean bl = this.m.isEmpty();
                return bl;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsKey(Object key) {
            this.lock();
            try {
                boolean bl = this.m.containsKey(key);
                return bl;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsValue(Object val) {
            this.lock();
            try {
                boolean bl = this.m.containsValue(val);
                return bl;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V get(Object key) {
            this.lock();
            try {
                V v = this.m.get(key);
                return v;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V put(K key, V val) {
            this.lock();
            try {
                V v = this.m.put(key, val);
                return v;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V remove(Object key) {
            this.lock();
            try {
                V v = this.m.remove(key);
                return v;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void putAll(Map<? extends K, ? extends V> m) {
            this.lock();
            try {
                this.m.putAll(m);
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<K> keySet() {
            this.lock();
            try {
                LockedSet lockedSet = new LockedSet(this.m.keySet());
                return lockedSet;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<V> values() {
            this.lock();
            try {
                LockedCollection lockedCollection = new LockedCollection(this.m.values());
                return lockedCollection;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            this.lock();
            try {
                LockedSet<Map.Entry<K, V>> lockedSet = new LockedSet<Map.Entry<K, V>>(this.m.entrySet());
                return lockedSet;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object o) {
            this.lock();
            try {
                boolean bl = this.m.equals(o);
                return bl;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            this.lock();
            try {
                int n = this.m.hashCode();
                return n;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String toString() {
            this.lock();
            try {
                String string = this.m.toString();
                return string;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeObject(ObjectOutputStream s) throws IOException {
            this.lock();
            try {
                s.defaultWriteObject();
            }
            finally {
                this.unlock();
            }
        }
    }
}

