/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.internal.util.GridSetWrapper;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;
import org.jsr166.ConcurrentHashMap8;

public class GridConcurrentHashSet<E>
extends GridSetWrapper<E> {
    private static final long serialVersionUID = 0L;

    public GridConcurrentHashSet() {
        super(new ConcurrentHashMap8());
    }

    public GridConcurrentHashSet(int initCap) {
        super(new ConcurrentHashMap8(initCap));
    }

    public GridConcurrentHashSet(int initCap, float loadFactor, int conLevel) {
        super(new ConcurrentHashMap8(initCap, loadFactor, conLevel));
    }

    public GridConcurrentHashSet(Collection<E> c) {
        super(new ConcurrentHashMap8(c.size()));
        this.addAll(c);
    }

    @Override
    public boolean add(E e) {
        ConcurrentMap m = (ConcurrentMap)this.map;
        return m.putIfAbsent(e, e) == null;
    }

    @Nullable
    public E addx(E e) {
        ConcurrentMap m = (ConcurrentMap)this.map;
        return m.putIfAbsent(e, e);
    }

    @Override
    public String toString() {
        return S.toString(GridConcurrentHashSet.class, this, "elements", this.map().keySet());
    }
}

