/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.jetbrains.annotations.Nullable;

public class GridDebug {
    private static final AtomicReference<ConcurrentLinkedQueue<Item>> que = new AtomicReference(new ConcurrentLinkedQueue());
    private static final SimpleDateFormat DEBUG_DATE_FMT = new SimpleDateFormat("HH:mm:ss,SSS");
    private static final FileOutputStream out;
    private static final Charset charset;
    private static volatile long start;
    private static final String LOGS_PATH;
    private static boolean allowLog;

    public static ConcurrentLinkedQueue<Item> queue() {
        return que.get();
    }

    public static synchronized void allowWriteLog(boolean allow) {
        allowLog = allow;
    }

    public static synchronized void write(Object ... x) {
        if (!allowLog) {
            return;
        }
        Thread th = Thread.currentThread();
        try {
            out.write((GridDebug.formatEntry(System.currentTimeMillis(), th.getName(), th.getId(), x) + "\n").getBytes(charset));
            out.flush();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void debug(Object ... x) {
        ConcurrentLinkedQueue<Item> q = que.get();
        if (q != null) {
            q.add(new Item(x));
        }
    }

    public static void hangIfStopped() {
        if (que.get() == null) {
            try {
                Thread.sleep(300000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static void start() {
        start = U.currentTimeMillis();
    }

    public static void timing(String label) {
        X.println(label + ' ' + (U.currentTimeMillis() - start) + " ms", new Object[0]);
    }

    public static Object dumpStack() {
        final Throwable t = new Throwable();
        return new Object(){

            public String toString() {
                StringWriter errors = new StringWriter();
                t.printStackTrace(new PrintWriter(errors));
                return errors.toString();
            }
        };
    }

    public static void dumpLastAndStop(int n) {
        ConcurrentLinkedQueue q = que.getAndSet(null);
        if (q == null) {
            return;
        }
        int size = q.size();
        while (size-- > n) {
            q.poll();
        }
        GridDebug.dump(q);
    }

    public static void dump(Collection<Item> que) {
        if (que == null) {
            return;
        }
        int start = -1;
        int x = 0;
        for (Item i : que) {
            if (x++ <= start) continue;
            System.out.println(i);
        }
    }

    public static String dumpWithStop(Object ... x) {
        GridDebug.debug(x);
        return GridDebug.dumpWithReset(null, null);
    }

    public static String dumpWithReset() {
        return GridDebug.dumpWithReset(new ConcurrentLinkedQueue<Item>(), null);
    }

    public static String dumpWithReset(@Nullable ConcurrentLinkedQueue<Item> q2, @Nullable IgnitePredicate<Item> filter) {
        ConcurrentLinkedQueue<Item> q;
        while ((q = que.get()) != null && !que.compareAndSet(q, q2)) {
        }
        AbstractCollection col = null;
        if (filter == null) {
            col = q;
        } else if (q != null) {
            col = new ArrayList();
            for (Item item : q) {
                if (!filter.apply(item)) continue;
                col.add((Item)item);
            }
        }
        GridDebug.dump(col);
        return "";
    }

    public static void reset() {
        ConcurrentLinkedQueue<Item> old = que.get();
        if (old != null) {
            que.compareAndSet(old, new ConcurrentLinkedQueue());
        }
    }

    private static String formatEntry(long ts, String threadName, long threadId, Object ... data) {
        return "<" + DEBUG_DATE_FMT.format(new Date(ts)) + "><~DBG~><" + threadName + " id:" + threadId + "> " + Arrays.deepToString(data);
    }

    static {
        charset = Charset.forName("UTF-8");
        LOGS_PATH = null;
        if (LOGS_PATH != null) {
            File log = new File(LOGS_PATH + new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss-").format(new Date()) + ManagementFactory.getRuntimeMXBean().getName() + ".log");
            assert (!log.exists());
            try {
                out = new FileOutputStream(log, false);
            }
            catch (FileNotFoundException e) {
                throw new IllegalStateException(e);
            }
        } else {
            out = null;
        }
    }

    public static class Item {
        public final long ts = System.currentTimeMillis();
        public final String threadName;
        public final long threadId;
        public final Object[] data;

        public Item(Object[] data) {
            this.data = data;
            Thread th = Thread.currentThread();
            this.threadName = th.getName();
            this.threadId = th.getId();
        }

        public String toString() {
            return GridDebug.formatEntry(this.ts, this.threadName, this.threadId, this.data);
        }
    }
}

