/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.util.AbstractCollection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class GridQueue<E>
extends AbstractCollection<E>
implements Queue<E> {
    private int size;
    private int modCnt;
    private Node<E> hdr = new Node(null, null, null);

    public GridQueue() {
        ((Node)this.hdr).next = (((Node)this.hdr).prev = (Node)this.hdr);
    }

    private void checkModCount(int match) {
        if (this.modCnt != match) {
            throw new ConcurrentModificationException("Mod count mismatch [expected=" + match + ", actual=" + this.modCnt + ']');
        }
        ++this.modCnt;
    }

    private Node<E> addBefore(E e, Node<E> n) {
        A.notNull(e, "e");
        assert (n != null);
        int match = this.modCnt;
        Node newNode = new Node(e, n, ((Node)n).prev);
        newNode.prev.next = newNode;
        newNode.next.prev = newNode;
        ++this.size;
        this.checkModCount(match);
        return newNode;
    }

    private E remove(Node<E> n) {
        assert (n != null);
        if (n == this.hdr) {
            throw new NoSuchElementException();
        }
        assert (!n.unlinked());
        int match = this.modCnt;
        Object res = ((Node)n).item;
        ((Node)n).prev.next = ((Node)n).next;
        ((Node)n).next.prev = ((Node)n).prev;
        ((Node)n).next = (((Node)n).prev = null);
        ((Node)n).item = null;
        --this.size;
        this.checkModCount(match);
        n.unlink();
        return (E)res;
    }

    @Override
    public boolean add(E e) {
        this.offer(e);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        A.notNull(o, "o");
        Node n = ((Node)this.hdr).next;
        while (n != this.hdr) {
            if (o.equals(n.item)) {
                this.remove(n);
                return true;
            }
            n = n.next;
        }
        return false;
    }

    @Override
    public boolean offer(E e) {
        this.addBefore(e, this.hdr);
        return true;
    }

    public Node<E> offerx(E e) {
        return this.addBefore(e, this.hdr);
    }

    @Override
    @Nullable
    public E poll() {
        if (this.size == 0) {
            return null;
        }
        return this.remove(((Node)this.hdr).next);
    }

    @Override
    public E element() {
        Node n = ((Node)this.hdr).next;
        if (n == null) {
            throw new NoSuchElementException();
        }
        return (E)n.item;
    }

    @Override
    public E remove() {
        E item = this.poll();
        if (item == null) {
            throw new NoSuchElementException();
        }
        return item;
    }

    @Override
    @Nullable
    public E peek() {
        return (E)((Node)this.hdr).next.item;
    }

    public Node<E> peekx() {
        return ((Node)this.hdr).next == this.hdr ? null : ((Node)this.hdr).next;
    }

    public void unlink(Node<E> n) {
        A.notNull(n, "n");
        this.remove(n);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Iterator<E> iterator() {
        return new QueueIterator();
    }

    private class QueueIterator
    implements Iterator<E> {
        private Node<E> next;
        private int expModCnt;

        QueueIterator() {
            this.expModCnt = GridQueue.this.modCnt;
            this.next = GridQueue.this.hdr.next;
        }

        @Override
        public boolean hasNext() {
            return this.next != GridQueue.this.hdr;
        }

        @Override
        public E next() {
            this.checkModCount();
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Object ret = this.next.item;
            this.next = this.next.next;
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void checkModCount() {
            if (GridQueue.this.modCnt != this.expModCnt) {
                throw new ConcurrentModificationException("Mod count mismatch [expected=" + this.expModCnt + ", actual=" + GridQueue.this.modCnt + ']');
            }
        }
    }

    public static class Node<E> {
        private E item;
        @GridToStringExclude
        private Node<E> next;
        @GridToStringExclude
        private Node<E> prev;
        private boolean unlinked;

        private Node(E item, Node<E> next, Node<E> prev) {
            this.item = item;
            this.next = next;
            this.prev = prev;
        }

        public E item() {
            return this.item;
        }

        void unlink() {
            assert (!this.unlinked);
            this.unlinked = true;
        }

        public boolean unlinked() {
            return this.unlinked;
        }

        public String toString() {
            return S.toString(Node.class, this);
        }
    }
}

