/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import org.jetbrains.annotations.Nullable;

public abstract class GridSnapshotLock<X> {
    private volatile Sync<X> sync = new Sync();

    public void beginUpdate() {
        Sync<X> sync0;
        while (!(sync0 = this.sync).tryAcquireForUpdate()) {
            sync0.awaitResult();
        }
    }

    public boolean tryBeginUpdate() {
        return this.sync.tryAcquireForUpdate();
    }

    public void endUpdate() {
        Sync<X> sync0 = this.sync;
        if (sync0.releaseAfterUpdate()) {
            this.takeSnapshotAndReplaceSync(sync0);
        }
    }

    public X snapshot() {
        Sync<X> sync0 = this.sync;
        if (sync0.flip()) {
            this.takeSnapshotAndReplaceSync(sync0);
        }
        return sync0.get();
    }

    protected abstract X doSnapshot();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void takeSnapshotAndReplaceSync(Sync<X> sync0) {
        try {
            sync0.set(this.doSnapshot(), null);
        }
        catch (RuntimeException e) {
            sync0.set(null, e);
        }
        finally {
            this.sync = new Sync();
            sync0.signalAll();
        }
    }

    private static class Sync<X>
    extends AbstractQueuedSynchronizer {
        private static final long serialVersionUID = 0L;
        private X x;
        private RuntimeException e;

        private Sync() {
            this.setState(1);
        }

        public X get() {
            this.awaitResult();
            if (this.e != null) {
                throw this.e;
            }
            return this.x;
        }

        public void awaitResult() {
            this.acquireShared(1);
        }

        public void set(@Nullable X x, @Nullable RuntimeException e) {
            this.x = x;
            this.e = e;
            boolean res = this.compareAndSetState(-1, 0);
            assert (res);
        }

        public boolean tryAcquireForUpdate() {
            int curr;
            do {
                if ((curr = this.getState()) > 0) continue;
                return false;
            } while (!this.compareAndSetState(curr, curr + 1));
            return true;
        }

        public boolean releaseAfterUpdate() {
            int next;
            int curr;
            do {
                curr = this.getState();
                assert (curr != 0);
                int n = next = curr < 0 ? curr + 1 : curr - 1;
                assert (next != 0);
            } while (!this.compareAndSetState(curr, next));
            return next == -1;
        }

        public boolean flip() {
            int curr;
            do {
                if ((curr = this.getState()) > 0) continue;
                return false;
            } while (!this.compareAndSetState(curr, -curr));
            return curr == 1;
        }

        public void signalAll() {
            this.releaseShared(1);
        }

        @Override
        protected final int tryAcquireShared(int ignored) {
            return this.getState() == 0 ? 1 : -1;
        }

        @Override
        protected final boolean tryReleaseShared(int ignored) {
            return true;
        }
    }
}

