/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.future;

import java.util.Arrays;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.IgniteFutureCancelledCheckedException;
import org.apache.ignite.internal.IgniteFutureTimeoutCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.util.future.GridFutureChainListener;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgniteInClosure;
import org.jetbrains.annotations.Nullable;

public class GridFutureAdapter<R>
extends AbstractQueuedSynchronizer
implements IgniteInternalFuture<R> {
    private static final long serialVersionUID = 0L;
    private static final int INIT = 0;
    private static final int CANCELLED = 1;
    private static final int DONE = 2;
    private static final byte ERR = 1;
    private static final byte RES = 2;
    private byte resFlag;
    @GridToStringInclude(sensitive=true)
    private Object res;
    private final long startTime = U.currentTimeMillis();
    private volatile long endTime;
    private boolean ignoreInterrupts;
    @GridToStringExclude
    private IgniteInClosure<? super IgniteInternalFuture<R>> lsnr;

    @Override
    public long startTime() {
        return this.startTime;
    }

    @Override
    public long duration() {
        long endTime = this.endTime;
        return endTime == 0L ? U.currentTimeMillis() - this.startTime : endTime - this.startTime;
    }

    public void ignoreInterrupts(boolean ignoreInterrupts) {
        this.ignoreInterrupts = ignoreInterrupts;
    }

    public long endTime() {
        return this.endTime;
    }

    @Override
    public Throwable error() {
        return this.resFlag == 1 ? (Throwable)this.res : null;
    }

    @Override
    public R result() {
        return (R)(this.resFlag == 2 ? this.res : null);
    }

    @Override
    public R get() throws IgniteCheckedException {
        return this.get0(this.ignoreInterrupts);
    }

    @Override
    public R getUninterruptibly() throws IgniteCheckedException {
        return this.get0(true);
    }

    @Override
    public R get(long timeout) throws IgniteCheckedException {
        return this.get(timeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public R get(long timeout, TimeUnit unit) throws IgniteCheckedException {
        A.ensure(timeout >= 0L, "timeout cannot be negative: " + timeout);
        A.notNull((Object)unit, "unit");
        try {
            return this.get0(unit.toNanos(timeout));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IgniteInterruptedCheckedException("Got interrupted while waiting for future to complete.", e);
        }
    }

    private R get0(boolean ignoreInterrupts) throws IgniteCheckedException {
        try {
            if (this.endTime == 0L) {
                if (ignoreInterrupts) {
                    this.acquireShared(0);
                } else {
                    this.acquireSharedInterruptibly(0);
                }
            }
            if (this.getState() == 1) {
                throw new IgniteFutureCancelledCheckedException("Future was cancelled: " + this);
            }
            assert (this.resFlag != 0);
            if (this.resFlag == 1) {
                throw U.cast((Throwable)this.res);
            }
            return (R)this.res;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IgniteInterruptedCheckedException(e);
        }
    }

    @Nullable
    protected R get0(long nanosTimeout) throws InterruptedException, IgniteCheckedException {
        if (this.endTime == 0L && !this.tryAcquireSharedNanos(0, nanosTimeout)) {
            throw new IgniteFutureTimeoutCheckedException("Timeout was reached before computation completed.");
        }
        if (this.getState() == 1) {
            throw new IgniteFutureCancelledCheckedException("Future was cancelled: " + this);
        }
        assert (this.resFlag != 0);
        if (this.resFlag == 1) {
            throw U.cast((Throwable)this.res);
        }
        return (R)this.res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void listen(IgniteInClosure<? super IgniteInternalFuture<R>> lsnr0) {
        assert (lsnr0 != null);
        boolean done = this.isDone();
        if (!done) {
            GridFutureAdapter gridFutureAdapter = this;
            synchronized (gridFutureAdapter) {
                done = this.isDone();
                if (!done) {
                    if (this.lsnr == null) {
                        this.lsnr = lsnr0;
                    } else if (this.lsnr instanceof ArrayListener) {
                        ((ArrayListener)this.lsnr).add(lsnr0);
                    } else {
                        this.lsnr = new ArrayListener(new IgniteInClosure[]{this.lsnr, lsnr0});
                    }
                    return;
                }
            }
        }
        assert (done);
        this.notifyListener(lsnr0);
    }

    @Override
    public <T> IgniteInternalFuture<T> chain(IgniteClosure<? super IgniteInternalFuture<R>, T> doneCb) {
        return new ChainFuture(this, doneCb, null);
    }

    @Override
    public <T> IgniteInternalFuture<T> chain(IgniteClosure<? super IgniteInternalFuture<R>, T> doneCb, Executor exec) {
        return new ChainFuture(this, doneCb, exec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners() {
        IgniteInClosure<? super IgniteInternalFuture<R>> lsnr0;
        GridFutureAdapter gridFutureAdapter = this;
        synchronized (gridFutureAdapter) {
            lsnr0 = this.lsnr;
            if (lsnr0 == null) {
                return;
            }
            this.lsnr = null;
        }
        assert (lsnr0 != null);
        this.notifyListener(lsnr0);
    }

    private void notifyListener(IgniteInClosure<? super IgniteInternalFuture<R>> lsnr) {
        assert (lsnr != null);
        try {
            lsnr.apply(this);
        }
        catch (IllegalStateException e) {
            U.error(this.logger(), "Failed to notify listener (is grid stopped?) [fut=" + this + ", lsnr=" + lsnr + ", err=" + e.getMessage() + ']', e);
        }
        catch (Error | RuntimeException e) {
            U.error(this.logger(), "Failed to notify listener: " + lsnr, e);
            throw e;
        }
    }

    @Override
    public boolean cancel() throws IgniteCheckedException {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.endTime != 0L;
    }

    public boolean isFailed() {
        return this.endTime != 0L && this.resFlag == 1;
    }

    @Override
    public boolean isCancelled() {
        return this.getState() == 1;
    }

    public final boolean onDone() {
        return this.onDone(null, null);
    }

    public final boolean onDone(@Nullable R res) {
        return this.onDone(res, null);
    }

    public final boolean onDone(@Nullable Throwable err) {
        return this.onDone(null, err);
    }

    public boolean onDone(@Nullable R res, @Nullable Throwable err) {
        return this.onDone(res, err, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean onDone(@Nullable R res, @Nullable Throwable err, boolean cancel) {
        boolean notify = false;
        try {
            if (this.compareAndSetState(0, cancel ? 1 : 2)) {
                if (err != null) {
                    this.resFlag = 1;
                    this.res = err;
                } else {
                    this.resFlag = (byte)2;
                    this.res = res;
                }
                notify = true;
                this.releaseShared(0);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (notify) {
                this.notifyListeners();
            }
        }
    }

    public boolean onCancelled() {
        return this.onDone(null, null, true);
    }

    @Override
    protected final int tryAcquireShared(int ignore) {
        return this.endTime != 0L ? 1 : -1;
    }

    @Override
    protected final boolean tryReleaseShared(int ignore) {
        this.endTime = U.currentTimeMillis();
        return true;
    }

    private String state() {
        int s = this.getState();
        return s == 0 ? "INIT" : (s == 1 ? "CANCELLED" : "DONE");
    }

    @Nullable
    public IgniteLogger logger() {
        return null;
    }

    @Override
    public String toString() {
        return S.toString(GridFutureAdapter.class, this, "state", this.state());
    }

    private static class ChainFuture<R, T>
    extends GridFutureAdapter<T> {
        private static final long serialVersionUID = 0L;
        private GridFutureAdapter<R> fut;
        private IgniteClosure<? super IgniteInternalFuture<R>, T> doneCb;

        public ChainFuture() {
        }

        ChainFuture(GridFutureAdapter<R> fut, IgniteClosure<? super IgniteInternalFuture<R>, T> doneCb, @Nullable Executor cbExec) {
            this.fut = fut;
            this.doneCb = doneCb;
            fut.listen(new GridFutureChainListener<T, T>(this, doneCb, cbExec));
        }

        @Override
        public String toString() {
            return "ChainFuture [orig=" + this.fut + ", doneCb=" + this.doneCb + ']';
        }
    }

    private static class ArrayListener<R>
    implements IgniteInClosure<IgniteInternalFuture<R>> {
        private static final long serialVersionUID = 0L;
        private IgniteInClosure<? super IgniteInternalFuture<R>>[] arr;

        private ArrayListener(IgniteInClosure ... lsnrs) {
            this.arr = lsnrs;
        }

        @Override
        public void apply(IgniteInternalFuture<R> fut) {
            for (int i = 0; i < this.arr.length; ++i) {
                this.arr[i].apply(fut);
            }
        }

        void add(IgniteInClosure<? super IgniteInternalFuture<R>> lsnr) {
            this.arr = Arrays.copyOf(this.arr, this.arr.length + 1);
            this.arr[this.arr.length - 1] = lsnr;
        }

        public String toString() {
            return S.toString(ArrayListener.class, this, "arrSize", this.arr.length);
        }
    }
}

