/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.future;

import java.util.concurrent.TimeUnit;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.util.lang.GridClosureException;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteInClosure;

public class IgniteFutureImpl<V>
implements IgniteFuture<V> {
    protected final IgniteInternalFuture<V> fut;

    public IgniteFutureImpl(IgniteInternalFuture<V> fut) {
        assert (fut != null);
        this.fut = fut;
    }

    public IgniteInternalFuture<V> internalFuture() {
        return this.fut;
    }

    @Override
    public long startTime() {
        return this.fut.startTime();
    }

    @Override
    public long duration() {
        return this.fut.duration();
    }

    @Override
    public boolean isCancelled() {
        return this.fut.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.fut.isDone();
    }

    @Override
    public void listen(IgniteInClosure<? super IgniteFuture<V>> lsnr) {
        A.notNull(lsnr, "lsnr");
        this.fut.listen(new InternalFutureListener(lsnr));
    }

    @Override
    public <T> IgniteFuture<T> chain(IgniteClosure<? super IgniteFuture<V>, T> doneCb) {
        return new IgniteFutureImpl<T>(this.chainInternal(doneCb));
    }

    protected <T> IgniteInternalFuture<T> chainInternal(final IgniteClosure<? super IgniteFuture<V>, T> doneCb) {
        return this.fut.chain(new C1<IgniteInternalFuture<V>, T>(){

            @Override
            public T apply(IgniteInternalFuture<V> fut) {
                assert (IgniteFutureImpl.this.fut == fut);
                try {
                    return doneCb.apply(IgniteFutureImpl.this);
                }
                catch (Exception e) {
                    throw new GridClosureException(e);
                }
            }
        });
    }

    @Override
    public boolean cancel() throws IgniteException {
        try {
            return this.fut.cancel();
        }
        catch (IgniteCheckedException e) {
            throw this.convertException(e);
        }
    }

    @Override
    public V get() {
        try {
            return this.fut.get();
        }
        catch (IgniteCheckedException e) {
            throw this.convertException(e);
        }
    }

    @Override
    public V get(long timeout) {
        try {
            return this.fut.get(timeout);
        }
        catch (IgniteCheckedException e) {
            throw this.convertException(e);
        }
    }

    @Override
    public V get(long timeout, TimeUnit unit) {
        try {
            return this.fut.get(timeout, unit);
        }
        catch (IgniteCheckedException e) {
            throw this.convertException(e);
        }
    }

    protected RuntimeException convertException(IgniteCheckedException e) {
        return U.convertException(e);
    }

    public String toString() {
        return "IgniteFuture [orig=" + this.fut + ']';
    }

    private class InternalFutureListener
    implements IgniteInClosure<IgniteInternalFuture<V>> {
        private static final long serialVersionUID = 0L;
        private final IgniteInClosure<? super IgniteFuture<V>> lsnr;

        private InternalFutureListener(IgniteInClosure<? super IgniteFuture<V>> lsnr) {
            assert (lsnr != null);
            this.lsnr = lsnr;
        }

        public int hashCode() {
            return this.lsnr.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null || !obj.getClass().equals(InternalFutureListener.class)) {
                return false;
            }
            InternalFutureListener lsnr0 = (InternalFutureListener)obj;
            return this.lsnr.equals(lsnr0.lsnr);
        }

        @Override
        public void apply(IgniteInternalFuture<V> fut) {
            assert (IgniteFutureImpl.this.fut == fut);
            this.lsnr.apply(IgniteFutureImpl.this);
        }

        public String toString() {
            return this.lsnr.toString();
        }
    }
}

