/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.lang;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.cache.Cache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.IgniteFutureTimeoutCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.util.F0;
import org.apache.ignite.internal.util.GridConcurrentHashSet;
import org.apache.ignite.internal.util.GridEmptyIterator;
import org.apache.ignite.internal.util.GridLeanMap;
import org.apache.ignite.internal.util.GridLeanSet;
import org.apache.ignite.internal.util.GridSerializableCollection;
import org.apache.ignite.internal.util.GridSerializableIterator;
import org.apache.ignite.internal.util.GridSerializableList;
import org.apache.ignite.internal.util.GridSerializableMap;
import org.apache.ignite.internal.util.GridSerializableSet;
import org.apache.ignite.internal.util.lang.GridAbsClosure;
import org.apache.ignite.internal.util.lang.GridClosureException;
import org.apache.ignite.internal.util.lang.GridIterator;
import org.apache.ignite.internal.util.lang.GridIteratorAdapter;
import org.apache.ignite.internal.util.lang.GridNodePredicate;
import org.apache.ignite.internal.util.lang.GridTuple;
import org.apache.ignite.internal.util.lang.GridTuple3;
import org.apache.ignite.internal.util.lang.GridTuple4;
import org.apache.ignite.internal.util.lang.GridTuple5;
import org.apache.ignite.internal.util.lang.GridTuple6;
import org.apache.ignite.internal.util.lang.GridTupleV;
import org.apache.ignite.internal.util.lang.IgnitePair;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.CA;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.P1;
import org.apache.ignite.internal.util.typedef.R1;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiClosure;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgniteOutClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteReducer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsr166.ConcurrentHashMap8;
import org.jsr166.ConcurrentLinkedDeque8;
import org.jsr166.ThreadLocalRandom8;

public class GridFunc {
    private static final GridAbsClosure NOOP = new CA(){

        @Override
        public void apply() {
        }
    };
    private static final IgniteClosure IDENTITY = new C1(){
        private static final long serialVersionUID = -6338573080046225172L;

        @Override
        public Object apply(Object o) {
            return o;
        }

        public String toString() {
            return "Identity closure.";
        }
    };
    private static final IgnitePredicate<Object> ALWAYS_TRUE = new P1<Object>(){
        private static final long serialVersionUID = 6101914246981105862L;

        @Override
        public boolean apply(Object e) {
            return true;
        }

        public String toString() {
            return "Always true predicate.";
        }
    };
    private static final IgnitePredicate<Object> ALWAYS_FALSE = new P1<Object>(){

        @Override
        public boolean apply(Object e) {
            return false;
        }

        public String toString() {
            return "Always false predicate.";
        }
    };
    private static final IgniteCallable<?> DEQUE_FACTORY = new IgniteCallable<ConcurrentLinkedDeque8>(){

        @Override
        public ConcurrentLinkedDeque8 call() {
            return new ConcurrentLinkedDeque8();
        }

        public String toString() {
            return "Deque factory.";
        }
    };
    private static final IgnitePredicate<Object> IS_NULL = new P1<Object>(){

        @Override
        public boolean apply(Object o) {
            return o == null;
        }
    };
    private static final IgnitePredicate<Object> IS_NOT_NULL = new P1<Object>(){

        @Override
        public boolean apply(Object o) {
            return o != null;
        }
    };
    private static final IgniteCallable<?> LIST_FACTORY = new IgniteCallable<List>(){

        @Override
        public List call() {
            return new ArrayList();
        }

        public String toString() {
            return "Array list factory.";
        }
    };
    private static final IgniteCallable<?> LINKED_LIST_FACTORY = new IgniteCallable<LinkedList>(){

        @Override
        public LinkedList call() {
            return new LinkedList();
        }

        public String toString() {
            return "Linked list factory.";
        }
    };
    private static final IgniteCallable<?> SET_FACTORY = new IgniteCallable<Set>(){

        @Override
        public Set call() {
            return new HashSet();
        }

        public String toString() {
            return "Hash set factory.";
        }
    };
    private static final IgniteCallable<AtomicInteger> ATOMIC_INT_FACTORY = new IgniteCallable<AtomicInteger>(){

        @Override
        public AtomicInteger call() {
            return new AtomicInteger(0);
        }

        public String toString() {
            return "Atomic integer factory.";
        }
    };
    private static final IgniteCallable<AtomicLong> ATOMIC_LONG_FACTORY = new IgniteCallable<AtomicLong>(){

        @Override
        public AtomicLong call() {
            return new AtomicLong(0L);
        }

        public String toString() {
            return "Atomic long factory.";
        }
    };
    private static final IgniteCallable<AtomicBoolean> ATOMIC_BOOL_FACTORY = new IgniteCallable<AtomicBoolean>(){

        @Override
        public AtomicBoolean call() {
            return new AtomicBoolean();
        }

        public String toString() {
            return "Atomic boolean factory.";
        }
    };
    private static final IgniteCallable<?> ATOMIC_REF_FACTORY = new IgniteCallable<AtomicReference>(){

        @Override
        public AtomicReference call() {
            return new AtomicReference();
        }

        public String toString() {
            return "Atomic reference factory.";
        }
    };
    private static final IgniteCallable<?> MAP_FACTORY = new IgniteCallable<Map>(){

        @Override
        public Map call() {
            return new HashMap();
        }

        public String toString() {
            return "Hash map factory.";
        }
    };
    private static final IgniteCallable<?> CONCURRENT_MAP_FACTORY = new IgniteCallable<ConcurrentMap>(){

        @Override
        public ConcurrentMap call() {
            return new ConcurrentHashMap8();
        }

        public String toString() {
            return "Concurrent hash map factory.";
        }
    };
    private static final IgniteCallable<?> CONCURRENT_SET_FACTORY = new IgniteCallable<GridConcurrentHashSet>(){

        @Override
        public GridConcurrentHashSet call() {
            return new GridConcurrentHashSet();
        }

        public String toString() {
            return "Concurrent hash set factory.";
        }
    };
    private static final IgniteClosure CACHE_ENTRY_KEY = new IgniteClosure(){

        public Object apply(Object o) {
            return ((Cache.Entry)o).getKey();
        }

        public String toString() {
            return "Map entry to key transformer closure.";
        }
    };
    private static final IgniteClosure CACHE_ENTRY_VAL_GET = new IgniteClosure(){

        @Nullable
        public Object apply(Object o) {
            return ((Cache.Entry)o).getValue();
        }

        public String toString() {
            return "Cache entry to get-value transformer closure.";
        }
    };
    private static final IgnitePredicate CACHE_ENTRY_HAS_PEEK_VAL = new IgnitePredicate(){

        public boolean apply(Object o) {
            return ((Cache.Entry)o).getValue() != null;
        }

        public String toString() {
            return "Cache entry has-peek-value predicate.";
        }
    };
    private static final IgniteClosure<ClusterNode, UUID> NODE2ID = new IgniteClosure<ClusterNode, UUID>(){

        @Override
        public UUID apply(ClusterNode n) {
            return n.id();
        }

        public String toString() {
            return "Grid node to node ID transformer closure.";
        }
    };
    private static final IgniteClosure<ClusterNode, String> NODE2ID8 = new IgniteClosure<ClusterNode, String>(){

        @Override
        public String apply(ClusterNode n) {
            return U.id8(n.id());
        }

        public String toString() {
            return "Grid node to node ID8 transformer closure.";
        }
    };
    private static final IgniteClosure<UUID, String> ID2ID8 = new IgniteClosure<UUID, String>(){

        @Override
        public String apply(UUID id) {
            return U.id8(id);
        }

        public String toString() {
            return "UUID to ID8 transformer closure.";
        }
    };
    private static final IgnitePredicate<IgniteInternalFuture<?>> UNFINISHED_FUTURE = new IgnitePredicate<IgniteInternalFuture<?>>(){

        @Override
        public boolean apply(IgniteInternalFuture<?> f) {
            return !f.isDone();
        }
    };

    public static <T extends ClusterNode> IgnitePredicate<T> localNode(final UUID locNodeId) {
        return new P1<T>(){

            @Override
            public boolean apply(T n) {
                return n.id().equals(locNodeId);
            }
        };
    }

    public static <T extends ClusterNode> IgnitePredicate<T> remoteNodes(final UUID locNodeId) {
        return new P1<T>(){

            @Override
            public boolean apply(T n) {
                return !n.id().equals(locNodeId);
            }
        };
    }

    @Deprecated
    public static <T> Collection<T> dedup(Collection<? extends T> c) {
        A.notNull(c, "c");
        GridLeanSet<? extends T> set = new GridLeanSet<T>();
        set.addAll(c);
        return set;
    }

    public static int sumInt(Iterable<Integer> c) {
        A.notNull(c, "c");
        int sum = 0;
        for (int t : c) {
            sum += t;
        }
        return sum;
    }

    public static <T> IgniteReducer<T, T> identityReducer(final T elem) {
        return new R1<T, T>(){

            @Override
            public boolean collect(T e) {
                return true;
            }

            @Override
            public T reduce() {
                return elem;
            }
        };
    }

    @Deprecated
    public static IgniteReducer<Integer, Integer> sumIntReducer() {
        return new R1<Integer, Integer>(){
            private AtomicInteger sum = new AtomicInteger(0);

            @Override
            public boolean collect(Integer e) {
                if (e != null) {
                    this.sum.addAndGet(e);
                }
                return true;
            }

            @Override
            public Integer reduce() {
                return this.sum.get();
            }
        };
    }

    @Deprecated
    public static IgniteReducer<Long, Long> sumLongReducer() {
        return new R1<Long, Long>(){
            private AtomicLong sum = new AtomicLong(0L);

            @Override
            public boolean collect(Long e) {
                if (e != null) {
                    this.sum.addAndGet(e);
                }
                return true;
            }

            @Override
            public Long reduce() {
                return this.sum.get();
            }
        };
    }

    @Deprecated
    public static List<Integer> range(int fromIncl, int toExcl) {
        A.ensure(fromIncl >= 0, "fromIncl >= 0");
        A.ensure(toExcl >= 0, "toExcl >= 0");
        A.ensure(toExcl >= fromIncl, "toExcl > fromIncl");
        if (toExcl == fromIncl) {
            return Collections.emptyList();
        }
        ArrayList<Integer> list = new ArrayList<Integer>(toExcl - fromIncl);
        for (int i = fromIncl; i < toExcl; ++i) {
            list.add(i);
        }
        return list;
    }

    @Deprecated
    public static IgniteReducer<String, String> concatReducer(final @Nullable String delim) {
        return new R1<String, String>(){
            private SB sb = new SB();
            private boolean first = true;
            private final Object lock = new Object();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean collect(String s) {
                Object object = this.lock;
                synchronized (object) {
                    if (!this.first && !GridFunc.isEmpty(delim)) {
                        this.sb.a(delim);
                    }
                    this.sb.a(s);
                    this.first = false;
                }
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String reduce() {
                Object object = this.lock;
                synchronized (object) {
                    return this.sb.toString();
                }
            }
        };
    }

    public static String concat(Iterable<String> c, @Nullable String delim) {
        A.notNull(c, "c");
        return GridFunc.reduce(c, GridFunc.concatReducer(delim));
    }

    @Deprecated
    public static <T> Collection<T> jobResults(@Nullable Collection<? extends ComputeJobResult> res) {
        if (GridFunc.isEmpty(res)) {
            return Collections.emptyList();
        }
        assert (res != null);
        ArrayList c = new ArrayList(res.size());
        for (ComputeJobResult computeJobResult : res) {
            c.add(computeJobResult.getData());
        }
        return c;
    }

    public static Collection<UUID> nodeIds(@Nullable Collection<? extends ClusterNode> nodes) {
        if (nodes == null || nodes.isEmpty()) {
            return Collections.emptyList();
        }
        return F.viewReadOnly(nodes, GridFunc.node2id(), new IgnitePredicate[0]);
    }

    public static Collection<String> nodeId8s(@Nullable Collection<? extends ClusterNode> nodes) {
        if (nodes == null || nodes.isEmpty()) {
            return Collections.emptyList();
        }
        return F.viewReadOnly(nodes, NODE2ID8, new IgnitePredicate[0]);
    }

    @Deprecated
    public static Collection<String> id8s(@Nullable Collection<UUID> ids) {
        if (ids == null || ids.isEmpty()) {
            return Collections.emptyList();
        }
        return F.viewReadOnly(ids, ID2ID8, new IgnitePredicate[0]);
    }

    @Deprecated
    public static GridAbsClosure println(final String msg) {
        return new CA(){

            @Override
            public void apply() {
                System.out.println(msg);
            }
        };
    }

    public static <T> T rand(Collection<? extends T> c) {
        A.notNull(c, "c");
        int n = ThreadLocalRandom8.current().nextInt(c.size());
        int i = 0;
        for (T t : c) {
            if (i++ != n) continue;
            return t;
        }
        throw new ConcurrentModificationException();
    }

    @Deprecated
    public static <T> T rand(List<T> l) {
        A.notNull(l, "l");
        return l.get(ThreadLocalRandom8.current().nextInt(l.size()));
    }

    @Deprecated
    public static <T> T rand(T ... c) {
        A.notNull(c, "c");
        return c[ThreadLocalRandom8.current().nextInt(c.length)];
    }

    public static <T> Collection<T> concat(boolean cp, final @Nullable T t, final @Nullable Collection<T> c) {
        if (cp) {
            if (GridFunc.isEmpty(c)) {
                ArrayList<T> l = new ArrayList<T>(1);
                l.add(t);
                return l;
            }
            assert (c != null);
            ArrayList<T> ret = new ArrayList<T>(c.size() + 1);
            ret.add(t);
            ret.addAll(c);
            return ret;
        }
        if (GridFunc.isEmpty(c)) {
            return Collections.singletonList(t);
        }
        assert (c != null);
        return new GridSerializableCollection<T>(){

            @Override
            @NotNull
            public Iterator<T> iterator() {
                return new GridSerializableIterator<T>(){
                    private Iterator<T> it;

                    @Override
                    public boolean hasNext() {
                        return this.it == null || this.it.hasNext();
                    }

                    @Override
                    @Nullable
                    public T next() {
                        if (this.it == null) {
                            this.it = c.iterator();
                            return t;
                        }
                        return this.it.next();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return c.size() + 1;
            }

            @Override
            public boolean equals(Object obj) {
                return obj instanceof Collection && GridFunc.eqNotOrdered(this, (Collection)obj);
            }
        };
    }

    public static <T> Collection<T> concat(boolean cp, final @Nullable Collection<T> c1, final @Nullable Collection<T> c2) {
        if (cp) {
            if (GridFunc.isEmpty(c1) && GridFunc.isEmpty(c2)) {
                return new ArrayList(0);
            }
            if (GridFunc.isEmpty(c1)) {
                return new ArrayList<T>(c2);
            }
            if (GridFunc.isEmpty(c2)) {
                return new ArrayList<T>(c1);
            }
            ArrayList<T> c = new ArrayList<T>(c1.size() + c2.size());
            c.addAll(c1);
            c.addAll(c2);
            return c;
        }
        if (GridFunc.isEmpty(c1) && GridFunc.isEmpty(c2)) {
            return Collections.emptyList();
        }
        if (GridFunc.isEmpty(c1) || GridFunc.isEmpty(c2)) {
            Collection<T> c;
            Collection<T> collection = c = GridFunc.isEmpty(c1) ? c2 : c1;
            assert (c != null);
            return c;
        }
        return new GridSerializableCollection<T>(){

            @Override
            @NotNull
            public Iterator<T> iterator() {
                return new GridSerializableIterator<T>(){
                    private Iterator<T> it1;
                    private Iterator<T> it2;
                    {
                        this.it1 = c1.iterator();
                        this.it2 = c2.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.it1 != null) {
                            if (!this.it1.hasNext()) {
                                this.it1 = null;
                            } else {
                                return true;
                            }
                        }
                        return this.it2.hasNext();
                    }

                    @Override
                    public T next() {
                        return this.it1 != null ? this.it1.next() : this.it2.next();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public boolean contains(Object o) {
                return c1.contains(o) || c2.contains(o);
            }

            @Override
            public int size() {
                return c1.size() + c2.size();
            }

            @Override
            public boolean equals(Object obj) {
                return obj instanceof Collection && GridFunc.eqNotOrdered(this, (Collection)obj);
            }
        };
    }

    public static <T> T[] concat(@Nullable T[] arr, T ... obj) {
        T[] newArr;
        if (arr == null || arr.length == 0) {
            newArr = obj;
        } else {
            newArr = Arrays.copyOf(arr, arr.length + obj.length);
            System.arraycopy(obj, 0, newArr, arr.length, obj.length);
        }
        return newArr;
    }

    public static <T> Iterator<T> concat(Iterator<T> ... iters) {
        if (iters.length == 1) {
            return iters[0];
        }
        return GridFunc.concat(GridFunc.asList(iters).iterator());
    }

    public static <T> Iterator<T> concat(final Iterator<Iterator<T>> iters) {
        if (!iters.hasNext()) {
            return Collections.emptySet().iterator();
        }
        return new Iterator<T>(){
            private Iterator<T> it;
            private Iterator<T> last;
            private T next;
            {
                this.it = (Iterator)iters.next();
                this.advance();
            }

            private void advance() {
                while (true) {
                    if (this.it.hasNext()) {
                        this.next = this.it.next();
                        assert (this.next != null);
                        return;
                    }
                    if (!iters.hasNext()) {
                        return;
                    }
                    this.it = (Iterator)iters.next();
                }
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public T next() {
                Object res = this.next;
                if (res == null) {
                    throw new NoSuchElementException();
                }
                this.next = null;
                this.last = this.it;
                this.advance();
                return res;
            }

            @Override
            public void remove() {
                if (this.last == null) {
                    throw new IllegalStateException();
                }
                this.last.remove();
            }
        };
    }

    public static <T0, T extends T0> Collection<T> lose(Collection<T> c, boolean cp, @Nullable Collection<T0> filter) {
        A.notNull(c, "c");
        return GridFunc.lose(c, cp, F0.in(filter));
    }

    @Deprecated
    public static <T> Collection<T> lose(Collection<T> c, boolean cp, IgnitePredicate<? super T> ... p) {
        Collection<T> res;
        block5: {
            block3: {
                block4: {
                    A.notNull(c, "c");
                    if (cp) break block3;
                    res = c;
                    if (!GridFunc.isEmpty(p)) break block4;
                    res.clear();
                    break block5;
                }
                if (GridFunc.isAlwaysFalse(p)) break block5;
                Iterator<T> iter = res.iterator();
                while (iter.hasNext()) {
                    if (!GridFunc.isAll(iter.next(), p)) continue;
                    iter.remove();
                }
                break block5;
            }
            res = new LinkedList<T>();
            if (!GridFunc.isEmpty(p) && !GridFunc.isAlwaysTrue(p)) {
                for (T t : c) {
                    if (GridFunc.isAll(t, p)) continue;
                    res.add(t);
                }
            }
        }
        return res;
    }

    @Deprecated
    public static <K, V> Map<K, V> lose(Map<K, V> m, boolean cp, IgnitePredicate<? super Map.Entry<K, V>> ... p) {
        Map<K, V> res;
        block5: {
            block3: {
                block4: {
                    A.notNull(m, "m");
                    if (cp) break block3;
                    res = m;
                    if (!GridFunc.isEmpty(p)) break block4;
                    res.clear();
                    break block5;
                }
                if (GridFunc.isAlwaysFalse(p)) break block5;
                Iterator<Map.Entry<K, V>> iter = m.entrySet().iterator();
                while (iter.hasNext()) {
                    if (!GridFunc.isAll(iter.next(), p)) continue;
                    iter.remove();
                }
                break block5;
            }
            res = U.newHashMap(m.size());
            if (!GridFunc.isEmpty(p) && !GridFunc.isAlwaysTrue(p)) {
                for (Map.Entry<K, V> e : m.entrySet()) {
                    if (F.isAll(e, p)) continue;
                    res.put(e.getKey(), e.getValue());
                }
            }
        }
        return res;
    }

    @Deprecated
    public static <K, V> Map<K, V> loseKeys(Map<K, V> m, boolean cp, final IgnitePredicate<? super K> ... p) {
        return GridFunc.lose(m, cp, new P1<Map.Entry<K, V>>(){

            @Override
            public boolean apply(Map.Entry<K, V> e) {
                return GridFunc.isAll(e.getKey(), p);
            }
        });
    }

    @Deprecated
    public static <K, V> Map<K, V> loseValues(Map<K, V> m, boolean cp, final IgnitePredicate<? super V> ... p) {
        return GridFunc.lose(m, cp, new P1<Map.Entry<K, V>>(){

            @Override
            public boolean apply(Map.Entry<K, V> e) {
                return GridFunc.isAll(e.getValue(), p);
            }
        });
    }

    public static <T> List<T> loseList(List<T> c, boolean cp, @Nullable Collection<? super T> filter) {
        List<T> res;
        A.notNull(c, "c");
        if (!cp) {
            res = c;
            if (filter != null) {
                res.removeAll(filter);
            }
        } else {
            res = new LinkedList<T>();
            for (T t : c) {
                if (filter != null && filter.contains(t)) continue;
                res.add(t);
            }
        }
        return res;
    }

    @Deprecated
    public static <T> List<T> filterList(List<T> c, boolean cp, IgnitePredicate<T> ... p) {
        List<T> res;
        block3: {
            block2: {
                A.notNull(c, "c");
                if (cp) break block2;
                res = c;
                if (p == null) break block3;
                Iterator<T> it = c.iterator();
                while (it.hasNext()) {
                    if (!GridFunc.isAny(it.next(), p)) continue;
                    it.remove();
                }
                break block3;
            }
            res = new ArrayList<T>(c.size());
            for (T t : c) {
                if (GridFunc.isAny(t, p)) continue;
                res.add(t);
            }
        }
        return res;
    }

    public static IgniteClosure<ClusterNode, UUID> node2id() {
        return NODE2ID;
    }

    public static <T extends ClusterNode> IgnitePredicate<T> nodeForNodeId(final UUID nodeId) {
        A.notNull(nodeId, "nodeId");
        return new P1<T>(){
            private static final long serialVersionUID = -7082730222779476623L;

            @Override
            public boolean apply(ClusterNode e) {
                return e.id().equals(nodeId);
            }
        };
    }

    public static <T extends ClusterNode> IgnitePredicate<T> nodeForNodeIds(final @Nullable Collection<UUID> nodeIds) {
        if (GridFunc.isEmpty(nodeIds)) {
            return GridFunc.alwaysFalse();
        }
        return new P1<T>(){
            private static final long serialVersionUID = -5664060422647374863L;

            @Override
            public boolean apply(ClusterNode e) {
                return nodeIds.contains(e.id());
            }
        };
    }

    public static IgnitePredicate<UUID> idForNodeId(final UUID nodeId) {
        A.notNull(nodeId, "nodeId");
        return new P1<UUID>(){

            @Override
            public boolean apply(UUID id) {
                return id.equals(nodeId);
            }
        };
    }

    public static IgnitePredicate<ClusterNode> nodeForNodes(ClusterNode ... nodes) {
        return new GridNodePredicate(nodes);
    }

    @Deprecated
    public static <T0, T extends T0> Collection<T> retain(Collection<T> c, boolean cp, @Nullable Collection<? extends T0> filter) {
        A.notNull(c, "c");
        return GridFunc.retain(c, cp, F0.in(filter));
    }

    public static <T> Collection<T> retain(Collection<T> c, boolean cp, IgnitePredicate<? super T> ... p) {
        A.notNull(c, "c");
        return GridFunc.lose(c, cp, GridFunc.not(p));
    }

    public static <T> Collection<T> retain(Collection<T> c, boolean cp, int num) {
        Collection<T> res;
        block3: {
            block2: {
                A.notNull(c, "c");
                A.ensure(num >= 0, "num >= 0");
                if (cp) break block2;
                res = c;
                if (num >= res.size()) break block3;
                int i = 0;
                Iterator<T> iter = res.iterator();
                while (iter.hasNext()) {
                    iter.next();
                    if (i++ < num) continue;
                    iter.remove();
                }
                break block3;
            }
            res = new ArrayList<T>(num);
            Iterator<T> iter = c.iterator();
            for (int i = 0; i < num && iter.hasNext(); ++i) {
                res.add(iter.next());
            }
        }
        return res;
    }

    @Deprecated
    public static <T, R> IgniteOutClosure<R> curry(final IgniteClosure<? super T, R> f, final T e) {
        return new IgniteOutClosure<R>(){

            @Override
            public R apply() {
                return f.apply(e);
            }
        };
    }

    @Deprecated
    public static <T> GridAbsClosure curry(final IgniteInClosure<? super T> f, final T e) {
        return new GridAbsClosure(){

            @Override
            public void apply() {
                f.apply(e);
            }
        };
    }

    public static <T> List<T> asList(T ... vals) {
        return GridFunc.isEmpty(vals) ? Collections.emptyList() : Arrays.asList(vals);
    }

    @Deprecated
    public static <T> GridIterator<T> emptyIterator() {
        return new GridEmptyIterator();
    }

    public static <T> Collection<T> flatCollections(final @Nullable Collection<? extends Collection<T>> c) {
        if (F.isEmpty(c)) {
            return Collections.emptyList();
        }
        return new GridSerializableCollection<T>(){

            @Override
            @NotNull
            public Iterator<T> iterator() {
                return GridFunc.flat(c);
            }

            @Override
            public int size() {
                return F.size(this.iterator(), new IgnitePredicate[0]);
            }

            @Override
            public boolean isEmpty() {
                return !this.iterator().hasNext();
            }
        };
    }

    public static <T> GridIterator<T> flat(final @Nullable Iterable<? extends Iterable<T>> c) {
        return GridFunc.isEmpty(c) ? GridFunc.emptyIterator() : new GridIteratorAdapter<T>(){
            private Iterator<? extends Iterable<T>> a;
            private Iterator<T> b;
            private boolean moved;
            private boolean more;
            {
                this.a = c.iterator();
                this.moved = true;
            }

            @Override
            public boolean hasNextX() {
                if (!this.moved) {
                    return this.more;
                }
                this.moved = false;
                if (this.b != null && this.b.hasNext()) {
                    this.more = true;
                    return true;
                }
                while (this.a.hasNext()) {
                    this.b = this.a.next().iterator();
                    if (!this.b.hasNext()) continue;
                    this.more = true;
                    return true;
                }
                this.more = false;
                return false;
            }

            @Override
            public T nextX() {
                if (this.hasNext()) {
                    this.moved = true;
                    return this.b.next();
                }
                throw new NoSuchElementException();
            }

            @Override
            public void removeX() {
                assert (this.b != null);
                this.b.remove();
            }
        };
    }

    public static <T> Iterator<T> flatIterators(final @Nullable Iterable<Iterator<T>> c) {
        return GridFunc.isEmpty(c) ? GridFunc.emptyIterator() : new GridIteratorAdapter<T>(){
            private Iterator<? extends Iterator<T>> a;
            private Iterator<T> b;
            private boolean moved;
            private boolean more;
            {
                this.a = c.iterator();
                this.moved = true;
            }

            @Override
            public boolean hasNextX() {
                if (!this.moved) {
                    return this.more;
                }
                this.moved = false;
                if (this.b != null && this.b.hasNext()) {
                    this.more = true;
                    return true;
                }
                while (this.a.hasNext()) {
                    this.b = this.a.next();
                    if (!this.b.hasNext()) continue;
                    this.more = true;
                    return true;
                }
                this.more = false;
                return false;
            }

            @Override
            public T nextX() {
                if (this.hasNext()) {
                    this.moved = true;
                    return this.b.next();
                }
                throw new NoSuchElementException();
            }

            @Override
            public void removeX() {
                assert (this.b != null);
                this.b.remove();
            }
        };
    }

    @Deprecated
    public static GridAbsClosure as(final @Nullable Runnable r) {
        return new CA(){

            @Override
            public void apply() {
                if (r != null) {
                    r.run();
                }
            }
        };
    }

    public static <T> int size(@Nullable Collection<? extends T> c, IgnitePredicate<? super T> ... p) {
        return c == null || c.isEmpty() ? 0 : (GridFunc.isEmpty(p) || GridFunc.isAlwaysTrue(p) ? c.size() : GridFunc.size(c.iterator(), p));
    }

    public static <T> int size(@Nullable Iterator<? extends T> it, IgnitePredicate<? super T> ... p) {
        if (it == null) {
            return 0;
        }
        int n = 0;
        if (!GridFunc.isAlwaysFalse(p)) {
            while (it.hasNext()) {
                if (!GridFunc.isAll(it.next(), p)) continue;
                ++n;
            }
        }
        return n;
    }

    @SafeVarargs
    public static <T> Collection<T> view(final @Nullable Collection<T> c, final IgnitePredicate<? super T> ... p) {
        if (GridFunc.isEmpty(c) || GridFunc.isAlwaysFalse(p)) {
            return Collections.emptyList();
        }
        assert (c != null);
        return GridFunc.isEmpty(p) || GridFunc.isAlwaysTrue(p) ? c : new GridSerializableCollection<T>(){

            @Override
            public boolean add(T e) {
                return GridFunc.isAll(e, p) && c.add(e);
            }

            @Override
            @NotNull
            public Iterator<T> iterator() {
                return F.iterator0(c, false, p);
            }

            @Override
            public int size() {
                return F.size(c, p);
            }

            @Override
            public boolean isEmpty() {
                return F.isEmpty(p) ? c.isEmpty() : !this.iterator().hasNext();
            }
        };
    }

    @SafeVarargs
    public static <T1, T2> Collection<T2> viewReadOnly(final @Nullable Collection<? extends T1> c, final IgniteClosure<? super T1, T2> trans, final IgnitePredicate<? super T1> ... p) {
        A.notNull(trans, "trans");
        if (GridFunc.isEmpty(c) || GridFunc.isAlwaysFalse(p)) {
            return Collections.emptyList();
        }
        assert (c != null);
        return new GridSerializableCollection<T2>(){

            @Override
            @NotNull
            public Iterator<T2> iterator() {
                return F.iterator(c, trans, true, p);
            }

            @Override
            public int size() {
                return F.isEmpty(p) ? c.size() : F.size(this.iterator(), new IgnitePredicate[0]);
            }

            @Override
            public boolean isEmpty() {
                return F.isEmpty(p) ? c.isEmpty() : !this.iterator().hasNext();
            }
        };
    }

    @Deprecated
    public static <T1, T2> List<T2> viewListReadOnly(final @Nullable List<? extends T1> c, final IgniteClosure<? super T1, T2> trans) {
        A.notNull(trans, "trans");
        if (GridFunc.isEmpty(c)) {
            return Collections.emptyList();
        }
        assert (c != null);
        return new GridSerializableList<T2>(){
            private static final long serialVersionUID = 3126625219739967068L;

            @Override
            public T2 get(int idx) {
                return trans.apply(c.get(idx));
            }

            @Override
            @NotNull
            public Iterator<T2> iterator() {
                return F.iterator(c, trans, true, new IgnitePredicate[0]);
            }

            @Override
            public int size() {
                return c.size();
            }

            @Override
            public boolean isEmpty() {
                return c.isEmpty();
            }
        };
    }

    @Deprecated
    public static <T1, T2> List<T2> transformList(Collection<? extends T1> c, IgniteClosure<? super T1, T2> trans, IgnitePredicate<? super T1> ... p) {
        A.notNull(c, "c", trans, "trans");
        if (GridFunc.isAlwaysFalse(p)) {
            return Collections.emptyList();
        }
        return new ArrayList<T2>(GridFunc.transform(GridFunc.retain(c, true, p), trans));
    }

    public static <K0, K extends K0, V0, V extends V0> Map<K, V> view(final @Nullable Map<K, V> m, final IgnitePredicate<? super K> ... p) {
        if (GridFunc.isEmpty(m) || GridFunc.isAlwaysFalse(p)) {
            return Collections.emptyMap();
        }
        assert (m != null);
        return GridFunc.isEmpty(p) || GridFunc.isAlwaysTrue(p) ? m : new GridSerializableMap<K, V>(){
            private static final long serialVersionUID = 5531745605372387948L;
            private IgnitePredicate<Map.Entry<K, V>> ep = new P1<Map.Entry<K, V>>(){

                @Override
                public boolean apply(Map.Entry<K, V> e) {
                    return GridFunc.isAll(e.getKey(), p);
                }
            };

            @Override
            @NotNull
            public Set<Map.Entry<K, V>> entrySet() {
                return new GridSerializableSet<Map.Entry<K, V>>(){

                    @Override
                    @NotNull
                    public Iterator<Map.Entry<K, V>> iterator() {
                        return GridFunc.iterator0(m.entrySet(), false, ep);
                    }

                    @Override
                    public int size() {
                        return F.size(m.keySet(), p);
                    }

                    @Override
                    public boolean remove(Object o) {
                        return F.isAll((Map.Entry)o, ep) && m.entrySet().remove(o);
                    }

                    @Override
                    public boolean contains(Object o) {
                        return F.isAll((Map.Entry)o, ep) && m.entrySet().contains(o);
                    }

                    @Override
                    public boolean isEmpty() {
                        return !this.iterator().hasNext();
                    }
                };
            }

            @Override
            public boolean isEmpty() {
                return this.entrySet().isEmpty();
            }

            @Override
            @Nullable
            public V get(Object key) {
                return GridFunc.isAll(key, p) ? (Object)m.get(key) : null;
            }

            @Override
            @Nullable
            public V put(K key, V val) {
                Object oldVal = this.get(key);
                if (GridFunc.isAll(key, p)) {
                    m.put(key, val);
                }
                return oldVal;
            }

            @Override
            public boolean containsKey(Object key) {
                return GridFunc.isAll(key, p) && m.containsKey(key);
            }
        };
    }

    public static <K0, K extends K0, V0, V extends V0, V1> Map<K, V1> viewReadOnly(final @Nullable Map<K, V> m, final IgniteClosure<V, V1> trans, final IgnitePredicate<? super K> ... p) {
        A.notNull(trans, "trans");
        if (GridFunc.isEmpty(m) || GridFunc.isAlwaysFalse(p)) {
            return Collections.emptyMap();
        }
        assert (m != null);
        final boolean hasPred = p != null && p.length > 0;
        return new GridSerializableMap<K, V1>(){
            private IgnitePredicate<Map.Entry<K, V>> ep = new P1<Map.Entry<K, V>>(){

                @Override
                public boolean apply(Map.Entry<K, V> e) {
                    return GridFunc.isAll(e.getKey(), p);
                }
            };

            @Override
            @NotNull
            public Set<Map.Entry<K, V1>> entrySet() {
                return new GridSerializableSet<Map.Entry<K, V1>>(){

                    @Override
                    @NotNull
                    public Iterator<Map.Entry<K, V1>> iterator() {
                        return new Iterator<Map.Entry<K, V1>>(){
                            private Iterator<Map.Entry<K, V>> it;
                            {
                                this.it = GridFunc.iterator0(m.entrySet(), true, ep);
                            }

                            @Override
                            public boolean hasNext() {
                                return this.it.hasNext();
                            }

                            @Override
                            public Map.Entry<K, V1> next() {
                                final Map.Entry e = this.it.next();
                                return new Map.Entry<K, V1>(){

                                    @Override
                                    public K getKey() {
                                        return e.getKey();
                                    }

                                    @Override
                                    public V1 getValue() {
                                        return trans.apply(e.getValue());
                                    }

                                    @Override
                                    public V1 setValue(V1 val) {
                                        throw new UnsupportedOperationException("Put is not supported for readonly map view.");
                                    }
                                };
                            }

                            @Override
                            public void remove() {
                                throw new UnsupportedOperationException("Remove is not support for readonly map view.");
                            }
                        };
                    }

                    @Override
                    public int size() {
                        return hasPred ? F.size(m.keySet(), p) : m.size();
                    }

                    @Override
                    public boolean remove(Object o) {
                        throw new UnsupportedOperationException("Remove is not support for readonly map view.");
                    }

                    @Override
                    public boolean contains(Object o) {
                        return F.isAll((Map.Entry)o, ep) && m.entrySet().contains(o);
                    }

                    @Override
                    public boolean isEmpty() {
                        return hasPred ? !this.iterator().hasNext() : m.isEmpty();
                    }
                };
            }

            @Override
            public boolean isEmpty() {
                return hasPred ? this.entrySet().isEmpty() : m.isEmpty();
            }

            @Override
            @Nullable
            public V1 get(Object key) {
                Object v;
                if (GridFunc.isAll(key, p) && (v = m.get(key)) != null) {
                    return trans.apply(v);
                }
                return null;
            }

            @Override
            @Nullable
            public V1 put(K key, V1 val) {
                throw new UnsupportedOperationException("Put is not supported for readonly map view.");
            }

            @Override
            public V1 remove(Object key) {
                throw new UnsupportedOperationException("Remove is not supported for readonly map view.");
            }

            @Override
            public boolean containsKey(Object key) {
                return GridFunc.isAll(key, p) && m.containsKey(key);
            }
        };
    }

    @Deprecated
    public static <K0, K extends K0, V0, V extends V0, V1> Map<K, V1> viewReadOnly(final @Nullable Map<K, V> m, final IgniteBiClosure<K, V, V1> trans, final IgnitePredicate<? super K> ... p) {
        A.notNull(trans, "trans");
        if (GridFunc.isEmpty(m) || GridFunc.isAlwaysFalse(p)) {
            return Collections.emptyMap();
        }
        assert (m != null);
        return new GridSerializableMap<K, V1>(){
            private IgnitePredicate<Map.Entry<K, V>> ep = new P1<Map.Entry<K, V>>(){

                @Override
                public boolean apply(Map.Entry<K, V> e) {
                    return GridFunc.isAll(e.getKey(), p);
                }
            };

            @Override
            @NotNull
            public Set<Map.Entry<K, V1>> entrySet() {
                return new GridSerializableSet<Map.Entry<K, V1>>(){

                    @Override
                    @NotNull
                    public Iterator<Map.Entry<K, V1>> iterator() {
                        return new Iterator<Map.Entry<K, V1>>(){
                            private Iterator<Map.Entry<K, V>> it;
                            {
                                this.it = GridFunc.iterator0(m.entrySet(), true, ep);
                            }

                            @Override
                            public boolean hasNext() {
                                return this.it.hasNext();
                            }

                            @Override
                            public Map.Entry<K, V1> next() {
                                final Map.Entry e = this.it.next();
                                return new Map.Entry<K, V1>(){

                                    @Override
                                    public K getKey() {
                                        return e.getKey();
                                    }

                                    @Override
                                    public V1 getValue() {
                                        return trans.apply(e.getKey(), e.getValue());
                                    }

                                    @Override
                                    public V1 setValue(V1 val) {
                                        throw new UnsupportedOperationException("Put is not supported for readonly map view.");
                                    }
                                };
                            }

                            @Override
                            public void remove() {
                                throw new UnsupportedOperationException("Remove is not support for readonly map view.");
                            }
                        };
                    }

                    @Override
                    public int size() {
                        return F.size(m.keySet(), p);
                    }

                    @Override
                    public boolean remove(Object o) {
                        throw new UnsupportedOperationException("Remove is not support for readonly map view.");
                    }

                    @Override
                    public boolean contains(Object o) {
                        return F.isAll((Map.Entry)o, ep) && m.entrySet().contains(o);
                    }

                    @Override
                    public boolean isEmpty() {
                        return !this.iterator().hasNext();
                    }
                };
            }

            @Override
            public boolean isEmpty() {
                return this.entrySet().isEmpty();
            }

            @Override
            @Nullable
            public V1 get(Object key) {
                Object v;
                if (GridFunc.isAll(key, p) && (v = m.get(key)) != null) {
                    return trans.apply(key, v);
                }
                return null;
            }

            @Override
            @Nullable
            public V1 put(K key, V1 val) {
                throw new UnsupportedOperationException("Put is not supported for readonly map view.");
            }

            @Override
            public V1 remove(Object key) {
                throw new UnsupportedOperationException("Remove is not supported for readonly map view.");
            }

            @Override
            public boolean containsKey(Object key) {
                return GridFunc.isAll(key, p) && m.containsKey(key);
            }
        };
    }

    public static <K0, K extends K0, V0, V extends V0> Map<K, V> viewAsMap(final @Nullable Set<K> c, final IgniteClosure<? super K, V> mapClo, final IgnitePredicate<? super K> ... p) {
        A.notNull(mapClo, "trans");
        if (GridFunc.isEmpty(c) || GridFunc.isAlwaysFalse(p)) {
            return Collections.emptyMap();
        }
        assert (c != null);
        return new GridSerializableMap<K, V>(){
            private IgnitePredicate<K> ep = new P1<K>(){

                @Override
                public boolean apply(K e) {
                    return GridFunc.isAll(e, p);
                }
            };

            @Override
            @NotNull
            public Set<Map.Entry<K, V>> entrySet() {
                return new GridSerializableSet<Map.Entry<K, V>>(){

                    @Override
                    @NotNull
                    public Iterator<Map.Entry<K, V>> iterator() {
                        return new Iterator<Map.Entry<K, V>>(){
                            private Iterator<K> it;
                            {
                                this.it = GridFunc.iterator0(c, true, ep);
                            }

                            @Override
                            public boolean hasNext() {
                                return this.it.hasNext();
                            }

                            @Override
                            public Map.Entry<K, V> next() {
                                final Object e = this.it.next();
                                return new Map.Entry<K, V>(){

                                    @Override
                                    public K getKey() {
                                        return e;
                                    }

                                    @Override
                                    public V getValue() {
                                        return mapClo.apply(e);
                                    }

                                    @Override
                                    public V setValue(V val) {
                                        throw new UnsupportedOperationException("Put is not supported for readonly collection view.");
                                    }
                                };
                            }

                            @Override
                            public void remove() {
                                throw new UnsupportedOperationException("Remove is not support for readonly collection view.");
                            }
                        };
                    }

                    @Override
                    public int size() {
                        return F.size(c, p);
                    }

                    @Override
                    public boolean remove(Object o) {
                        throw new UnsupportedOperationException("Remove is not support for readonly collection view.");
                    }

                    @Override
                    public boolean isEmpty() {
                        return !this.iterator().hasNext();
                    }
                };
            }

            @Override
            public boolean isEmpty() {
                return this.entrySet().isEmpty();
            }

            @Override
            @Nullable
            public V get(Object key) {
                if (this.containsKey(key)) {
                    return mapClo.apply(key);
                }
                return null;
            }

            @Override
            @Nullable
            public V put(K key, V val) {
                throw new UnsupportedOperationException("Put is not supported for readonly collection view.");
            }

            @Override
            public V remove(Object key) {
                throw new UnsupportedOperationException("Remove is not supported for readonly collection view.");
            }

            @Override
            public boolean containsKey(Object key) {
                return GridFunc.isAll(key, p) && c.contains(key);
            }
        };
    }

    public static boolean isEmpty(@Nullable String s) {
        return s == null || s.isEmpty();
    }

    public static <T> boolean isEmpty(@Nullable T[] c) {
        return c == null || c.length == 0;
    }

    public static <T> boolean isEmptyOrNulls(@Nullable T[] c) {
        if (GridFunc.isEmpty(c)) {
            return true;
        }
        for (T element : c) {
            if (element == null) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(@Nullable int[] c) {
        return c == null || c.length == 0;
    }

    public static boolean isEmpty(@Nullable byte[] c) {
        return c == null || c.length == 0;
    }

    public static boolean isEmpty(@Nullable long[] c) {
        return c == null || c.length == 0;
    }

    public static boolean isEmpty(@Nullable Iterable<?> c) {
        return c == null || (c instanceof Collection ? ((Collection)c).isEmpty() : !c.iterator().hasNext());
    }

    public static boolean isEmpty(@Nullable Collection<?> c) {
        return c == null || c.isEmpty();
    }

    public static boolean isEmpty(@Nullable Map<?, ?> m) {
        return m == null || m.isEmpty();
    }

    public static int[] toIntArray(Collection<? extends Number> col) {
        if (col == null) {
            return null;
        }
        int[] res = new int[col.size()];
        Iterator<? extends Number> iter = col.iterator();
        for (int i = 0; i < res.length; ++i) {
            res[i] = iter.next().intValue();
        }
        return res;
    }

    @Deprecated
    @Nullable
    public static <K, V> V returnIfAbsent(Map<? extends K, ? extends V> map, @Nullable K key, @Nullable Callable<V> c) {
        A.notNull(map, "map");
        try {
            return !map.containsKey(key) ? (c == null ? null : (V)c.call()) : (V)map.get(key);
        }
        catch (Exception e) {
            throw GridFunc.wrap(e);
        }
    }

    public static <T> IgniteCallable<ConcurrentLinkedDeque8<T>> newDeque() {
        return DEQUE_FACTORY;
    }

    @Deprecated
    public static <T> IgniteCallable<List<T>> newList() {
        return LIST_FACTORY;
    }

    @Deprecated
    public static IgniteCallable<AtomicInteger> newAtomicInt() {
        return ATOMIC_INT_FACTORY;
    }

    @Deprecated
    public static IgniteCallable<AtomicLong> newAtomicLong() {
        return ATOMIC_LONG_FACTORY;
    }

    @Deprecated
    public static <T> IgniteCallable<AtomicReference<T>> newAtomicRef() {
        return ATOMIC_REF_FACTORY;
    }

    @Deprecated
    public static IgniteCallable<AtomicBoolean> newAtomicBoolean() {
        return ATOMIC_BOOL_FACTORY;
    }

    @Deprecated
    public static <T> IgniteCallable<LinkedList<T>> newLinkedList() {
        return LINKED_LIST_FACTORY;
    }

    public static <T> IgniteCallable<Set<T>> newSet() {
        return SET_FACTORY;
    }

    @Deprecated
    public static <K, V> IgniteCallable<Map<K, V>> newMap() {
        return MAP_FACTORY;
    }

    public static <K, V> IgniteCallable<ConcurrentMap<K, V>> newCMap() {
        return CONCURRENT_MAP_FACTORY;
    }

    public static <E> IgniteCallable<Set<E>> newCSet() {
        return CONCURRENT_SET_FACTORY;
    }

    public static <T> GridIterator<T> iterator0(Iterable<? extends T> c, boolean readOnly, IgnitePredicate<? super T> ... p) {
        return F.iterator(c, IDENTITY, readOnly, p);
    }

    public static <T1, T2> GridIterator<T2> iterator(final Iterable<? extends T1> c, final IgniteClosure<? super T1, T2> trans, final boolean readOnly, final IgnitePredicate<? super T1> ... p) {
        A.notNull(c, "c", trans, "trans");
        if (GridFunc.isAlwaysFalse(p)) {
            return F.emptyIterator();
        }
        return new GridIteratorAdapter<T2>(){
            private T1 elem;
            private boolean moved = true;
            private boolean more;
            private Iterator<? extends T1> iter = c.iterator();

            @Override
            public boolean hasNextX() {
                if (GridFunc.isEmpty(p)) {
                    return this.iter.hasNext();
                }
                if (!this.moved) {
                    return this.more;
                }
                this.more = false;
                while (this.iter.hasNext()) {
                    this.elem = this.iter.next();
                    boolean isAll = true;
                    for (IgnitePredicate r : p) {
                        if (r == null || r.apply(this.elem)) continue;
                        isAll = false;
                        break;
                    }
                    if (!isAll) continue;
                    this.more = true;
                    this.moved = false;
                    return true;
                }
                this.elem = null;
                return false;
            }

            @Override
            @Nullable
            public T2 nextX() {
                if (GridFunc.isEmpty(p)) {
                    return trans.apply(this.iter.next());
                }
                if (this.hasNext()) {
                    this.moved = true;
                    return trans.apply(this.elem);
                }
                throw new NoSuchElementException();
            }

            @Override
            public void removeX() {
                if (readOnly) {
                    throw new UnsupportedOperationException("Cannot modify read-only iterator.");
                }
                this.iter.remove();
            }
        };
    }

    public static <T1, T2> Iterator<T2> iterator(final Iterator<? extends T1> c, final IgniteClosure<? super T1, T2> trans, final boolean readOnly, final IgnitePredicate<? super T1> ... p) {
        A.notNull(c, "c", trans, "trans");
        if (GridFunc.isAlwaysFalse(p)) {
            return F.emptyIterator();
        }
        return new GridIteratorAdapter<T2>(){
            private T1 elem;
            private boolean moved = true;
            private boolean more;
            private Iterator<? extends T1> iter = c;

            @Override
            public boolean hasNextX() {
                if (GridFunc.isEmpty(p)) {
                    return this.iter.hasNext();
                }
                if (!this.moved) {
                    return this.more;
                }
                this.more = false;
                while (this.iter.hasNext()) {
                    this.elem = this.iter.next();
                    boolean isAll = true;
                    for (IgnitePredicate r : p) {
                        if (r == null || r.apply(this.elem)) continue;
                        isAll = false;
                        break;
                    }
                    if (!isAll) continue;
                    this.more = true;
                    this.moved = false;
                    return true;
                }
                this.elem = null;
                return false;
            }

            @Override
            @Nullable
            public T2 nextX() {
                if (GridFunc.isEmpty(p)) {
                    return trans.apply(this.iter.next());
                }
                if (this.hasNext()) {
                    this.moved = true;
                    return trans.apply(this.elem);
                }
                throw new NoSuchElementException();
            }

            @Override
            public void removeX() {
                if (readOnly) {
                    throw new UnsupportedOperationException("Cannot modify read-only iterator.");
                }
                this.iter.remove();
            }
        };
    }

    public static <T> IgnitePredicate<T> alwaysTrue() {
        return ALWAYS_TRUE;
    }

    public static <T> IgnitePredicate<T> alwaysFalse() {
        return ALWAYS_FALSE;
    }

    @Deprecated
    public static boolean isAlwaysTrue(IgnitePredicate p) {
        return p == ALWAYS_TRUE;
    }

    public static boolean isAlwaysTrue(@Nullable IgnitePredicate[] p) {
        return p != null && p.length == 1 && GridFunc.isAlwaysTrue(p[0]);
    }

    @Deprecated
    public static boolean isAlwaysFalse(IgnitePredicate p) {
        return p == ALWAYS_FALSE;
    }

    @Deprecated
    public static boolean isAlwaysFalse(@Nullable IgnitePredicate[] p) {
        return p != null && p.length == 1 && GridFunc.isAlwaysFalse(p[0]);
    }

    @Deprecated
    public static <T> IgnitePredicate<T> isNull() {
        return IS_NULL;
    }

    public static <T> IgnitePredicate<T> notNull() {
        return IS_NOT_NULL;
    }

    @SafeVarargs
    public static <T> IgnitePredicate<T> not(final IgnitePredicate<? super T> ... p) {
        return GridFunc.isAlwaysFalse(p) ? F.alwaysTrue() : (GridFunc.isAlwaysTrue(p) ? F.alwaysFalse() : new P1<T>(){

            @Override
            public boolean apply(T t) {
                return !GridFunc.isAll(t, p);
            }
        });
    }

    @Deprecated
    public static <T> IgnitePredicate<T> equalTo(final @Nullable T target) {
        return new P1<T>(){

            @Override
            public boolean apply(T t) {
                return GridFunc.eq(t, target);
            }
        };
    }

    public static <T> IgnitePredicate<T> notEqualTo(final @Nullable T target) {
        return new P1<T>(){

            @Override
            public boolean apply(T t) {
                return !GridFunc.eq(t, target);
            }
        };
    }

    @Deprecated
    public static <T> IgnitePredicate<T> instanceOf(final Class<?> cls) {
        A.notNull(cls, "cls");
        return new P1<T>(){

            @Override
            public boolean apply(T t) {
                return t != null && cls.isAssignableFrom(t.getClass());
            }
        };
    }

    public static <T> T first(@Nullable Iterable<? extends T> c) {
        if (c == null) {
            return null;
        }
        if (c instanceof List) {
            return GridFunc.first((List)c);
        }
        Iterator<T> it = c.iterator();
        return it.hasNext() ? (T)it.next() : null;
    }

    public static <T> T first(List<? extends T> list) {
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    @Deprecated
    @Nullable
    public static <T> T last(@Nullable Iterable<? extends T> c) {
        if (c == null) {
            return null;
        }
        assert (c != null);
        if (c instanceof RandomAccess && c instanceof List) {
            List l = (List)c;
            return (T)l.get(l.size() - 1);
        }
        if (c instanceof NavigableSet) {
            NavigableSet s = (NavigableSet)c;
            return (T)s.last();
        }
        T last = null;
        for (T t : c) {
            last = t;
        }
        return last;
    }

    @Nullable
    public static <V> V firstValue(Map<?, V> m) {
        Iterator<V> it = m.values().iterator();
        return it.hasNext() ? (V)it.next() : null;
    }

    @Deprecated
    @Nullable
    public static <K> K firstKey(Map<K, ?> m) {
        Iterator<K> it = m.keySet().iterator();
        return it.hasNext() ? (K)it.next() : null;
    }

    @Nullable
    public static <K, V> Map.Entry<K, V> firstEntry(Map<K, V> m) {
        Iterator<Map.Entry<K, V>> it = m.entrySet().iterator();
        return it.hasNext() ? it.next() : null;
    }

    public static <T> IgnitePredicate<T> and(final IgnitePredicate<? super T> ... ps) {
        if (GridFunc.isEmpty(ps)) {
            return F.alwaysTrue();
        }
        if (GridFunc.isAlwaysFalse(ps)) {
            return F.alwaysFalse();
        }
        if (GridFunc.isAlwaysTrue(ps)) {
            return F.alwaysTrue();
        }
        if (F0.isAllNodePredicates(ps)) {
            assert (ps != null);
            HashSet<UUID> ids = new HashSet<UUID>();
            for (IgnitePredicate<T> ignitePredicate : ps) {
                if (ignitePredicate == null) continue;
                Set<UUID> list = ((GridNodePredicate)ignitePredicate).nodeIds();
                if (ids.isEmpty()) {
                    ids.addAll(list);
                    continue;
                }
                ids.retainAll(list);
            }
            return new GridNodePredicate((Set<UUID>)ids);
        }
        return new P1<T>(){

            @Override
            public boolean apply(T t) {
                assert (ps != null);
                for (IgnitePredicate p : ps) {
                    if (p == null || p.apply(t)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static <T> IgniteClosure<T, T> identity() {
        return IDENTITY;
    }

    @Deprecated
    public static <T> IgniteClosure<T, String> string() {
        return new C1<T, String>(){

            @Override
            public String apply(@Nullable T t) {
                return String.valueOf(t);
            }
        };
    }

    public static <T> IgnitePredicate<T> notIn(final @Nullable Collection<? extends T> c) {
        return GridFunc.isEmpty(c) ? GridFunc.alwaysTrue() : new P1<T>(){

            @Override
            public boolean apply(T t) {
                assert (c != null);
                return !c.contains(t);
            }
        };
    }

    @Deprecated
    public static <T, C extends Collection<T>> C addAll(C c, Iterable<? extends T> it) {
        if (it == null) {
            return c;
        }
        if (it instanceof Collection) {
            c.addAll((Collection)it);
            return c;
        }
        return GridFunc.addAll(c, it.iterator());
    }

    @Deprecated
    public static <T, C extends Collection<T>> C addAll(C c, Iterator<? extends T> it) {
        if (it != null) {
            while (it.hasNext()) {
                c.add(it.next());
            }
        }
        return c;
    }

    public static <K, V> V addIfAbsent(ConcurrentMap<K, V> map, K key, @Nullable Callable<V> c) {
        A.notNull(map, "map", key, "key");
        Object v = map.get(key);
        if (v == null && c != null) {
            try {
                v = c.call();
            }
            catch (Exception e) {
                throw F.wrap(e);
            }
            V v0 = map.putIfAbsent(key, v);
            if (v0 != null) {
                v = v0;
            }
        }
        return v;
    }

    public static <K, V> V addIfAbsent(ConcurrentMap<K, V> map, K key, V val) {
        A.notNull(map, "map", key, "key", val, "val");
        V v = map.putIfAbsent(key, val);
        if (v != null) {
            val = v;
        }
        return val;
    }

    @Nullable
    public static <K, V> V addIfAbsent(Map<? super K, V> map, @Nullable K key, @Nullable Callable<? extends V> c) {
        A.notNull(map, "map");
        try {
            if (!map.containsKey(key)) {
                V v = c == null ? null : (V)c.call();
                map.put(key, v);
                return v;
            }
            return map.get(key);
        }
        catch (Exception e) {
            throw GridFunc.wrap(e);
        }
    }

    @Nullable
    public static <K, V> V addIfAbsent(Map<K, V> map, @Nullable K key, @Nullable V v) {
        A.notNull(map, "map");
        try {
            if (!map.containsKey(key)) {
                map.put(key, v);
                return v;
            }
            return map.get(key);
        }
        catch (Exception e) {
            throw GridFunc.wrap(e);
        }
    }

    @Deprecated
    public static <X, Y> Y reduce(Iterable<? extends X> c, IgniteReducer<? super X, Y> f) {
        A.notNull(c, "c", f, "f");
        for (X x : c) {
            if (!f.collect(x)) break;
        }
        return f.reduce();
    }

    @Deprecated
    public static <X> void forEach(Iterable<? extends X> c, IgniteInClosure<? super X> f, IgnitePredicate<? super X> ... p) {
        A.notNull(c, "c", f, "f");
        for (X x : c) {
            if (!GridFunc.isAll(x, p)) continue;
            f.apply(x);
        }
    }

    @Deprecated
    public static <X> void forEach(X[] c, IgniteInClosure<? super X> f, IgnitePredicate<? super X> ... p) {
        A.notNull(c, "c", f, "f");
        F.forEach(GridFunc.asList(c), f, p);
    }

    @Deprecated
    public static <T> Collection<T> copy(Collection<T> to, T ... from) {
        A.notNull(to, "to", from, "from");
        GridFunc.copy(to, GridFunc.asList(from), new IgnitePredicate[0]);
        return to;
    }

    @Deprecated
    public static <T> Collection<T> copy(Collection<T> to, Iterable<? extends T> from, IgnitePredicate<? super T> ... p) {
        A.notNull(to, "to", from, "from");
        if (!GridFunc.isAlwaysFalse(p)) {
            for (T t : from) {
                if (!GridFunc.isAll(t, p)) continue;
                to.add(t);
            }
        }
        return to;
    }

    public static <X, Y> Collection<Y> transform(Collection<? extends X> c, IgniteClosure<? super X, Y> f) {
        A.notNull(c, "c", f, "f");
        ArrayList<Y> d = new ArrayList<Y>(c.size());
        for (X x : c) {
            d.add(f.apply(x));
        }
        return d;
    }

    @Deprecated
    public static <T extends R, R> Collection<R> upcast(Collection<T> c) {
        A.notNull(c, "c");
        return c;
    }

    @Deprecated
    public static <X, Y> Collection<Y> transform(X[] c, IgniteClosure<? super X, Y> f) {
        A.notNull(c, "c", f, "f");
        return GridFunc.viewReadOnly(GridFunc.asList(c), f, new IgnitePredicate[0]);
    }

    public static <T> boolean isAll(@Nullable T t, IgnitePredicate<? super T> ... p) {
        if (p != null) {
            for (IgnitePredicate<T> ignitePredicate : p) {
                if (ignitePredicate == null || ignitePredicate.apply(t)) continue;
                return false;
            }
        }
        return true;
    }

    @Deprecated
    public static <T> boolean isAny(@Nullable T t, IgnitePredicate<? super T> ... p) {
        if (p != null) {
            for (IgnitePredicate<T> ignitePredicate : p) {
                if (ignitePredicate == null || !ignitePredicate.apply(t)) continue;
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public static GridAbsClosure noop() {
        return NOOP;
    }

    @SafeVarargs
    @Nullable
    public static <V> V find(Iterable<? extends V> c, @Nullable V dfltVal, IgnitePredicate<? super V> ... p) {
        A.notNull(c, "c");
        if (!GridFunc.isEmpty(p) && !GridFunc.isAlwaysFalse(p)) {
            for (V v : c) {
                if (!GridFunc.isAny(v, p)) continue;
                return v;
            }
        }
        return dfltVal;
    }

    @Deprecated
    public static <V, Y> Y find(Iterable<? extends V> c, @Nullable Y dfltVal, IgniteClosure<? super V, Y> f, IgnitePredicate<? super V> ... p) {
        A.notNull(c, "c", f, "f");
        if (GridFunc.isAlwaysTrue(p) && c.iterator().hasNext()) {
            return f.apply(c.iterator().next());
        }
        if (!GridFunc.isEmpty(p) && !GridFunc.isAlwaysFalse(p)) {
            for (V v : c) {
                if (!GridFunc.isAny(v, p)) continue;
                return f.apply(v);
            }
        }
        return dfltVal;
    }

    @Deprecated
    public static <T> boolean containsAny(@Nullable Collection<? extends T> c1, @Nullable Iterable<? extends T> c2) {
        if (c1 != null && !c1.isEmpty() && c2 != null && c2.iterator().hasNext()) {
            for (T t : c2) {
                if (!c1.contains(t)) continue;
                return true;
            }
        }
        return false;
    }

    public static <T> boolean containsAny(@Nullable Collection<? extends T> c1, T ... c2) {
        if (c1 != null && !c1.isEmpty() && c2 != null && c2.length > 0) {
            for (T t : c2) {
                if (!c1.contains(t)) continue;
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public static <T> boolean containsAll(@Nullable Collection<? extends T> c1, @Nullable Iterable<? extends T> c2) {
        if (c1 == null) {
            return false;
        }
        if (c2 != null) {
            for (T t : c2) {
                if (c1.contains(t)) continue;
                return false;
            }
        }
        return true;
    }

    @Deprecated
    public static <T> IgnitePair<T> pair(@Nullable T t1, @Nullable T t2) {
        return new IgnitePair<T>(t1, t2);
    }

    @Deprecated
    public static <V> IgniteBiTuple<Collection<V>, Collection<V>> partition(Iterable<? extends V> c, IgnitePredicate<? super V> p) {
        A.notNull(c, "c", p, "p");
        LinkedList<V> c1 = new LinkedList<V>();
        LinkedList<V> c2 = new LinkedList<V>();
        for (V v : c) {
            if (p.apply(v)) {
                c1.add(v);
                continue;
            }
            c2.add(v);
        }
        return GridFunc.t(c1, c2);
    }

    public static <V> boolean exist(Iterable<? extends V> c, IgnitePredicate<? super V> ... p) {
        A.notNull(c, "c");
        if (GridFunc.isAlwaysFalse(p)) {
            return false;
        }
        if (GridFunc.isAlwaysTrue(p)) {
            return true;
        }
        if (GridFunc.isEmpty(p)) {
            return true;
        }
        for (V v : c) {
            if (!GridFunc.isAll(v, p)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static <V> boolean forAll(Iterable<? extends V> c, IgnitePredicate<? super V> ... p) {
        A.notNull(c, "c");
        if (GridFunc.isAlwaysFalse(p)) {
            return false;
        }
        if (GridFunc.isAlwaysTrue(p)) {
            return true;
        }
        if (!GridFunc.isEmpty(p)) {
            for (V v : c) {
                if (GridFunc.isAll(v, p)) continue;
                return false;
            }
        }
        return true;
    }

    @Deprecated
    public static <K1, K extends K1, V1, V extends V1> boolean forAll(Map<K, V> m, IgnitePredicate<? super Map.Entry<K, V>> ... p) {
        A.notNull(m, "m");
        if (GridFunc.isAlwaysFalse(p)) {
            return false;
        }
        if (GridFunc.isAlwaysTrue(p)) {
            return true;
        }
        if (!GridFunc.isEmpty(p)) {
            for (Map.Entry<K, V> e : m.entrySet()) {
                if (GridFunc.isAll(e, p)) continue;
                return false;
            }
        }
        return true;
    }

    @Deprecated
    public static <V> boolean forAny(Iterable<? extends V> c, IgnitePredicate<? super V> ... p) {
        A.notNull(c, "c");
        if (!c.iterator().hasNext()) {
            return false;
        }
        if (GridFunc.isEmpty(p)) {
            return true;
        }
        if (GridFunc.isAlwaysFalse(p)) {
            return false;
        }
        if (GridFunc.isAlwaysTrue(p)) {
            return true;
        }
        for (V v : c) {
            if (!GridFunc.isAll(v, p)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    @Nullable
    public static <D, B> B fold(Iterable<? extends D> c, @Nullable B b, IgniteBiClosure<? super D, ? super B, B> ... fs) {
        A.notNull(c, "c");
        if (!GridFunc.isEmpty(fs)) {
            for (D e : c) {
                assert (fs != null);
                for (IgniteBiClosure<D, B, B> igniteBiClosure : fs) {
                    b = igniteBiClosure.apply(e, b);
                }
            }
        }
        return b;
    }

    public static <V> GridTuple<V> t(@Nullable V v) {
        return new GridTuple<V>(v);
    }

    @Deprecated
    public static <V> GridTuple<V> t1() {
        return new GridTuple();
    }

    public static <V1, V2> IgniteBiTuple<V1, V2> t(@Nullable V1 v1, @Nullable V2 v2) {
        return new IgniteBiTuple<V1, V2>(v1, v2);
    }

    @Deprecated
    public static <V1, V2> IgniteBiTuple<V1, V2> t2() {
        return new IgniteBiTuple();
    }

    public static <V1, V2, V3> GridTuple3<V1, V2, V3> t(@Nullable V1 v1, @Nullable V2 v2, @Nullable V3 v3) {
        return new GridTuple3<V1, V2, V3>(v1, v2, v3);
    }

    @Deprecated
    public static <V1, V2, V3, V4> GridTuple4<V1, V2, V3, V4> t(@Nullable V1 v1, @Nullable V2 v2, @Nullable V3 v3, @Nullable V4 v4) {
        return new GridTuple4<V1, V2, V3, V4>(v1, v2, v3, v4);
    }

    @Deprecated
    public static <V1, V2, V3, V4, V5> GridTuple5<V1, V2, V3, V4, V5> t(@Nullable V1 v1, @Nullable V2 v2, @Nullable V3 v3, @Nullable V4 v4, @Nullable V5 v5) {
        return new GridTuple5<V1, V2, V3, V4, V5>(v1, v2, v3, v4, v5);
    }

    @Deprecated
    public static <V1, V2, V3, V4, V5, V6> GridTuple6<V1, V2, V3, V4, V5, V6> t(@Nullable V1 v1, @Nullable V2 v2, @Nullable V3 v3, @Nullable V4 v4, @Nullable V5 v5, @Nullable V6 v6) {
        return new GridTuple6<V1, V2, V3, V4, V5, V6>(v1, v2, v3, v4, v5, v6);
    }

    @Deprecated
    public static GridTupleV tv(Object ... objs) {
        assert (objs != null);
        return new GridTupleV(objs);
    }

    @Deprecated
    public static <V1, V2, V3> GridTuple3<V1, V2, V3> t3() {
        return new GridTuple3();
    }

    @Deprecated
    public static <V1, V2, V3, V4> GridTuple4<V1, V2, V3, V4> t4() {
        return new GridTuple4();
    }

    @Deprecated
    public static <V1, V2, V3, V4, V5> GridTuple5<V1, V2, V3, V4, V5> t5() {
        return new GridTuple5();
    }

    @Deprecated
    public static <V1, V2, V3, V4, V5, V6> GridTuple6<V1, V2, V3, V4, V5, V6> t6() {
        return new GridTuple6();
    }

    @Deprecated
    public static <K, V> Map<K, V> zip(Collection<? extends K> keys, V dfltVal) {
        A.notNull(keys, "keys");
        HashMap<K, V> m = new HashMap<K, V>(keys.size(), 1.0f);
        for (K k : keys) {
            m.put(k, dfltVal);
        }
        return m;
    }

    public static <K, V> Map<K, V> asMap(K k, V v) {
        GridLeanMap<K, V> map = new GridLeanMap<K, V>(1);
        map.put(k, v);
        return map;
    }

    public static <K, V> Map<K, V> asMap(K k1, V v1, K k2, V v2) {
        GridLeanMap<K, V> map = new GridLeanMap<K, V>(2);
        map.put(k1, v1);
        map.put(k2, v2);
        return map;
    }

    @Deprecated
    public static <K, V> Map<K, V> asMap(K k1, V v1, K k2, V v2, K k3, V v3) {
        GridLeanMap<K, V> map = new GridLeanMap<K, V>(3);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        return map;
    }

    @Deprecated
    public static <K, V> Map<K, V> asMap(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        GridLeanMap<K, V> map = new GridLeanMap<K, V>(4);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        return map;
    }

    @Deprecated
    public static <K, V> Map<K, V> asMap(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        GridLeanMap<K, V> map = new GridLeanMap<K, V>(5);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        return map;
    }

    public static <T> T[] asArray(T ... t) {
        return t;
    }

    public static <T> List<T> asList(@Nullable T t) {
        return t == null ? Collections.emptyList() : Collections.singletonList(t);
    }

    @Deprecated
    public static <T> Set<T> asSet(@Nullable T t) {
        return t == null ? Collections.emptySet() : Collections.singleton(t);
    }

    @Deprecated
    public static <T> Set<T> asSet(T ... t) {
        if (t == null || t.length == 0) {
            return Collections.emptySet();
        }
        if (t.length == 1) {
            return Collections.singleton(t[0]);
        }
        return new GridLeanSet<T[]>(GridFunc.asList(t));
    }

    public static <T> boolean contains(@Nullable Collection<T> c, @Nullable T t) {
        return c != null && c.contains(t);
    }

    public static <T> IgnitePredicate<T> contains(final @Nullable Collection<T> c) {
        return c == null || c.isEmpty() ? GridFunc.alwaysFalse() : new P1<T>(){

            @Override
            public boolean apply(T t) {
                return c.contains(t);
            }
        };
    }

    public static <T> IgnitePredicate<T> notContains(final @Nullable Collection<T> c) {
        return c == null || c.isEmpty() ? GridFunc.alwaysTrue() : new P1<T>(){

            @Override
            public boolean apply(T t) {
                return !c.contains(t);
            }
        };
    }

    public static boolean contains(int[] arr, int val) {
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] != val) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static boolean contains(Integer[] arr, int val) {
        for (Integer el : arr) {
            if (el != val) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static boolean contains(long[] arr, long val) {
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] != val) continue;
            return true;
        }
        return false;
    }

    public static boolean eq(@Nullable Object o1, @Nullable Object o2) {
        return o1 == null ? o2 == null : o2 != null && (o1 == o2 || o1.equals(o2));
    }

    @Deprecated
    public static boolean eqOrdered(@Nullable Collection<?> c1, @Nullable Collection<?> c2) {
        if (c1 == c2) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        if (c1.size() != c2.size()) {
            return false;
        }
        Iterator<?> it1 = c1.iterator();
        Iterator<?> it2 = c2.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            if (GridFunc.eq(it1.next(), it2.next())) continue;
            return false;
        }
        return it1.hasNext() == it2.hasNext();
    }

    public static boolean eqNotOrdered(@Nullable Collection<?> c1, @Nullable Collection<?> c2) {
        if (c1 == c2) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        if (c1.size() != c2.size()) {
            return false;
        }
        if (c1 instanceof RandomAccess || c2 instanceof RandomAccess) {
            List lst;
            Collection<?> col;
            if (c1 instanceof RandomAccess) {
                col = c2;
                lst = (List)c1;
            } else {
                col = c1;
                lst = (List)c2;
            }
            int p = 0;
            int size = c1.size();
            for (Object o1 : col) {
                boolean found = false;
                for (int i = p; i < size; ++i) {
                    if (!F.eq(lst.get(i), o1)) continue;
                    found = true;
                    if (i != p) break;
                    ++p;
                    break;
                }
                if (found) continue;
                return false;
            }
        } else if (c1 instanceof Set && c2 instanceof Set) {
            for (Object o : c1) {
                if (c2.contains(o)) continue;
                return false;
            }
        } else {
            for (Object o : c1) {
                if (c2.contains(o)) continue;
                return false;
            }
            for (Object o : c2) {
                if (c1.contains(o)) continue;
                return false;
            }
        }
        return true;
    }

    public static <K, V> boolean eqNotOrdered(@Nullable Map<K, V> m1, @Nullable Map<K, V> m2) {
        if (m1 == m2) {
            return true;
        }
        if (m1 == null || m2 == null) {
            return false;
        }
        if (m1.size() != m2.size()) {
            return false;
        }
        for (Map.Entry<K, V> e : m1.entrySet()) {
            V v2;
            V v1 = e.getValue();
            if (v1 == (v2 = m2.get(e.getKey()))) {
                return true;
            }
            if (v1 == null || v2 == null) {
                return false;
            }
            if (!(v1 instanceof Collection && v2 instanceof Collection ? !GridFunc.eqNotOrdered((Collection)v1, (Collection)v2) : (v1 instanceof Map && v2 instanceof Map ? !GridFunc.eqNotOrdered((Map)v1, (Map)v2) : !GridFunc.eq(v1, v2)))) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public static boolean eqArray(Object[] a1, Object[] a2, boolean sorted, boolean dups) {
        boolean found;
        if (a1 == a2) {
            return true;
        }
        if (a1 == null || a2 == null || a1.length != a2.length) {
            return false;
        }
        if (a1.length == 1) {
            return GridFunc.eq(a1[0], a2[0]);
        }
        for (Object o1 : a1) {
            found = false;
            if (sorted) {
                found = Arrays.binarySearch(a2, o1) >= 0;
            } else {
                for (Object o2 : a2) {
                    if (!GridFunc.eq(o1, o2)) continue;
                    found = true;
                    break;
                }
            }
            if (found) continue;
            return false;
        }
        if (dups) {
            for (Object o2 : a2) {
                found = false;
                if (sorted) {
                    found = Arrays.binarySearch(a1, o2) >= 0;
                } else {
                    for (Object o1 : a1) {
                        if (!GridFunc.eq(o2, o1)) continue;
                        found = true;
                        break;
                    }
                }
                if (found) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean eqNodes(Object n1, Object n2) {
        return n1 == n2 || n1 != null && n2 != null && n1 instanceof ClusterNode && n2 instanceof ClusterNode && ((ClusterNode)n1).id().equals(((ClusterNode)n2).id());
    }

    public static <K, V> IgniteClosure<Cache.Entry<K, V>, K> cacheEntry2Key() {
        return CACHE_ENTRY_KEY;
    }

    public static <K, V> IgniteClosure<Cache.Entry<K, V>, V> cacheEntry2Get() {
        return CACHE_ENTRY_VAL_GET;
    }

    public static <K, V> IgnitePredicate<Cache.Entry<K, V>> cacheHasPeekValue() {
        return CACHE_ENTRY_HAS_PEEK_VAL;
    }

    public static GridClosureException wrap(Throwable e) {
        return new GridClosureException(e);
    }

    @Deprecated
    public static <E> boolean intersects(Iterable<E> s1, Collection<E> ... s2) {
        for (E e1 : s1) {
            for (Collection<E> s : s2) {
                if (!s.contains(e1)) continue;
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public static <T> void awaitAll(@Nullable Collection<IgniteInternalFuture<T>> futs) throws IgniteCheckedException {
        GridFunc.awaitAll(0L, null, futs);
    }

    @Deprecated
    public static <T> void awaitAll(long timeout, @Nullable Collection<IgniteInternalFuture<T>> futs) throws IgniteCheckedException {
        GridFunc.awaitAll(timeout, null, futs);
    }

    @Deprecated
    @Nullable
    public static <T, R> R awaitAll(long timeout, @Nullable IgniteReducer<T, R> rdc, @Nullable Collection<IgniteInternalFuture<T>> futs) throws IgniteCheckedException {
        long end;
        if (futs == null || futs.isEmpty()) {
            return null;
        }
        long l = end = timeout == 0L ? Long.MAX_VALUE : U.currentTimeMillis() + timeout;
        if (end < 0L) {
            end = Long.MAX_VALUE;
        }
        for (IgniteInternalFuture<T> fut : futs) {
            T t;
            if (timeout > 0L) {
                long left = end - U.currentTimeMillis();
                if (left <= 0L && !fut.isDone()) {
                    throw new IgniteFutureTimeoutCheckedException("Timed out waiting for all futures: " + futs);
                }
                if (fut.isDone() && left < 0L) {
                    left = 0L;
                }
                t = fut.get(left);
            } else {
                t = fut.get();
            }
            if (rdc == null) continue;
            rdc.collect(t);
        }
        return rdc == null ? null : (R)rdc.reduce();
    }

    @Deprecated
    public static IgnitePredicate<IgniteInternalFuture<?>> unfinishedFutures() {
        return UNFINISHED_FUTURE;
    }
}

