/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.nio;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.internal.util.nio.GridCommunicationClient;
import org.apache.ignite.internal.util.nio.GridNioMetricsListener;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public abstract class GridAbstractCommunicationClient
implements GridCommunicationClient {
    private volatile long lastUsed = U.currentTimeMillis();
    private final AtomicInteger reserves = new AtomicInteger();
    protected final GridNioMetricsListener metricsLsnr;
    private final int connIdx;

    protected GridAbstractCommunicationClient(int connIdx, @Nullable GridNioMetricsListener metricsLsnr) {
        this.connIdx = connIdx;
        this.metricsLsnr = metricsLsnr;
    }

    @Override
    public int connectionIndex() {
        return this.connIdx;
    }

    @Override
    public boolean close() {
        return this.reserves.compareAndSet(0, -1);
    }

    @Override
    public void forceClose() {
        this.reserves.set(-1);
    }

    @Override
    public boolean closed() {
        return this.reserves.get() == -1;
    }

    @Override
    public boolean reserve() {
        int r;
        do {
            if ((r = this.reserves.get()) != -1) continue;
            return false;
        } while (!this.reserves.compareAndSet(r, r + 1));
        return true;
    }

    @Override
    public void release() {
        int r;
        do {
            if ((r = this.reserves.get()) != -1) continue;
            return;
        } while (!this.reserves.compareAndSet(r, r - 1));
    }

    @Override
    public boolean reserved() {
        return this.reserves.get() > 0;
    }

    @Override
    public long getIdleTime() {
        return U.currentTimeMillis() - this.lastUsed;
    }

    protected void markUsed() {
        this.lastUsed = U.currentTimeMillis();
    }

    @Override
    public boolean async() {
        return false;
    }

    public String toString() {
        return S.toString(GridAbstractCommunicationClient.class, this);
    }
}

