/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.nio;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.util.nio.GridNioException;
import org.apache.ignite.internal.util.nio.GridNioFilter;
import org.apache.ignite.internal.util.nio.GridNioFuture;
import org.apache.ignite.internal.util.nio.GridNioSession;

public abstract class GridNioFilterAdapter
implements GridNioFilter {
    private String name;
    protected GridNioFilter nextFilter;
    protected GridNioFilter prevFilter;

    protected GridNioFilterAdapter(String name) {
        assert (name != null);
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public GridNioFilter nextFilter() {
        return this.nextFilter;
    }

    @Override
    public GridNioFilter previousFilter() {
        return this.prevFilter;
    }

    @Override
    public void nextFilter(GridNioFilter filter) {
        this.nextFilter = filter;
    }

    @Override
    public void previousFilter(GridNioFilter filter) {
        this.prevFilter = filter;
    }

    @Override
    public void proceedSessionOpened(GridNioSession ses) throws IgniteCheckedException {
        this.checkPrevious();
        this.prevFilter.onSessionOpened(ses);
    }

    @Override
    public void proceedSessionClosed(GridNioSession ses) throws IgniteCheckedException {
        this.checkPrevious();
        this.prevFilter.onSessionClosed(ses);
    }

    @Override
    public void proceedExceptionCaught(GridNioSession ses, IgniteCheckedException e) throws IgniteCheckedException {
        this.checkPrevious();
        this.prevFilter.onExceptionCaught(ses, e);
    }

    @Override
    public void proceedMessageReceived(GridNioSession ses, Object msg) throws IgniteCheckedException {
        this.checkPrevious();
        this.prevFilter.onMessageReceived(ses, msg);
    }

    @Override
    public GridNioFuture<?> proceedSessionWrite(GridNioSession ses, Object msg, boolean fut) throws IgniteCheckedException {
        this.checkNext();
        return this.nextFilter.onSessionWrite(ses, msg, fut);
    }

    @Override
    public GridNioFuture<Boolean> proceedSessionClose(GridNioSession ses) throws IgniteCheckedException {
        this.checkNext();
        return this.nextFilter.onSessionClose(ses);
    }

    @Override
    public void proceedSessionIdleTimeout(GridNioSession ses) throws IgniteCheckedException {
        this.checkPrevious();
        this.prevFilter.onSessionIdleTimeout(ses);
    }

    @Override
    public void proceedSessionWriteTimeout(GridNioSession ses) throws IgniteCheckedException {
        this.checkPrevious();
        this.prevFilter.onSessionWriteTimeout(ses);
    }

    @Override
    public GridNioFuture<?> proceedPauseReads(GridNioSession ses) throws IgniteCheckedException {
        this.checkNext();
        return this.nextFilter.onPauseReads(ses);
    }

    @Override
    public GridNioFuture<?> proceedResumeReads(GridNioSession ses) throws IgniteCheckedException {
        this.checkNext();
        return this.nextFilter.onResumeReads(ses);
    }

    @Override
    public GridNioFuture<?> onPauseReads(GridNioSession ses) throws IgniteCheckedException {
        return this.proceedPauseReads(ses);
    }

    @Override
    public GridNioFuture<?> onResumeReads(GridNioSession ses) throws IgniteCheckedException {
        return this.proceedResumeReads(ses);
    }

    private void checkPrevious() throws GridNioException {
        if (this.prevFilter == null) {
            throw new GridNioException("Failed to proceed with filter call since previous filter is not set (do you use filter outside the filter chain?): " + this.getClass().getName());
        }
    }

    private void checkNext() throws GridNioException {
        if (this.nextFilter == null) {
            throw new GridNioException("Failed to proceed with filter call since previous filter is not set (do you use filter outside the filter chain?): " + this.getClass().getName());
        }
    }
}

