/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.nio;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.util.nio.GridNioFilter;
import org.apache.ignite.internal.util.nio.GridNioFilterAdapter;
import org.apache.ignite.internal.util.nio.GridNioFuture;
import org.apache.ignite.internal.util.nio.GridNioServerListener;
import org.apache.ignite.internal.util.nio.GridNioSession;
import org.apache.ignite.internal.util.typedef.internal.LT;

public class GridNioFilterChain<T>
extends GridNioFilterAdapter {
    private IgniteLogger log;
    private GridNioServerListener<T> lsnr;
    private GridNioFilter head;
    private GridNioFilter tail;
    private volatile String str;

    public GridNioFilterChain(IgniteLogger log, GridNioServerListener<T> lsnr, GridNioFilter head, GridNioFilter ... filters) {
        super("FilterChain");
        this.log = log;
        this.lsnr = lsnr;
        this.head = head;
        GridNioFilter prev = new TailFilter();
        this.tail = prev;
        for (GridNioFilter filter : filters) {
            prev.nextFilter(filter);
            filter.previousFilter(prev);
            prev = filter;
        }
        prev.nextFilter(head);
        head.previousFilter(prev);
    }

    @Override
    public String toString() {
        if (this.str == null) {
            StringBuilder res = new StringBuilder("FilterChain[filters=[");
            GridNioFilter ref = this.tail.nextFilter();
            while (ref != this.head) {
                res.append(ref);
                if ((ref = ref.nextFilter()) == this.head) continue;
                res.append(", ");
            }
            res.append(']');
            this.str = res.toString();
        }
        return this.str;
    }

    @Override
    public void start() {
        for (GridNioFilter ref = this.tail.nextFilter(); ref != this.head; ref = ref.nextFilter()) {
            ref.start();
        }
    }

    @Override
    public void stop() {
        for (GridNioFilter ref = this.head.previousFilter(); ref != this.tail; ref = ref.previousFilter()) {
            ref.stop();
        }
    }

    @Override
    public void onSessionOpened(GridNioSession ses) throws IgniteCheckedException {
        this.head.onSessionOpened(ses);
    }

    @Override
    public void onSessionClosed(GridNioSession ses) throws IgniteCheckedException {
        this.head.onSessionClosed(ses);
    }

    @Override
    public void onExceptionCaught(GridNioSession ses, IgniteCheckedException e) {
        try {
            this.head.onExceptionCaught(ses, e);
        }
        catch (Exception ex) {
            LT.error(this.log, ex, "Failed to forward GridNioException to filter chain [ses=" + ses + ", e=" + e + ']');
        }
    }

    @Override
    public void onMessageReceived(GridNioSession ses, Object msg) throws IgniteCheckedException {
        this.head.onMessageReceived(ses, msg);
    }

    @Override
    public GridNioFuture<?> onSessionWrite(GridNioSession ses, Object msg, boolean fut) throws IgniteCheckedException {
        return this.tail.onSessionWrite(ses, msg, fut);
    }

    @Override
    public GridNioFuture<Boolean> onSessionClose(GridNioSession ses) throws IgniteCheckedException {
        return this.tail.onSessionClose(ses);
    }

    @Override
    public void onSessionIdleTimeout(GridNioSession ses) throws IgniteCheckedException {
        this.head.onSessionIdleTimeout(ses);
    }

    @Override
    public void onSessionWriteTimeout(GridNioSession ses) throws IgniteCheckedException {
        this.head.onSessionWriteTimeout(ses);
    }

    @Override
    public GridNioFuture<?> onPauseReads(GridNioSession ses) throws IgniteCheckedException {
        return this.tail.onPauseReads(ses);
    }

    @Override
    public GridNioFuture<?> onResumeReads(GridNioSession ses) throws IgniteCheckedException {
        return this.tail.onResumeReads(ses);
    }

    private class TailFilter
    extends GridNioFilterAdapter {
        private TailFilter() {
            super("TailFilter");
        }

        @Override
        public void onSessionOpened(GridNioSession ses) {
            GridNioFilterChain.this.lsnr.onConnected(ses);
        }

        @Override
        public void onSessionClosed(GridNioSession ses) {
            GridNioFilterChain.this.lsnr.onDisconnected(ses, null);
        }

        @Override
        public void onExceptionCaught(GridNioSession ses, IgniteCheckedException ex) {
            GridNioFilterChain.this.lsnr.onDisconnected(ses, ex);
        }

        @Override
        public GridNioFuture<?> onSessionWrite(GridNioSession ses, Object msg, boolean fut) throws IgniteCheckedException {
            return this.proceedSessionWrite(ses, msg, fut);
        }

        @Override
        public GridNioFuture<Boolean> onSessionClose(GridNioSession ses) throws IgniteCheckedException {
            return this.proceedSessionClose(ses);
        }

        @Override
        public void onMessageReceived(GridNioSession ses, Object msg) {
            GridNioFilterChain.this.lsnr.onMessage(ses, msg);
        }

        @Override
        public void onSessionIdleTimeout(GridNioSession ses) throws IgniteCheckedException {
            GridNioFilterChain.this.lsnr.onSessionIdleTimeout(ses);
        }

        @Override
        public void onSessionWriteTimeout(GridNioSession ses) throws IgniteCheckedException {
            GridNioFilterChain.this.lsnr.onSessionWriteTimeout(ses);
        }

        @Override
        public GridNioFuture<?> onPauseReads(GridNioSession ses) throws IgniteCheckedException {
            return this.proceedPauseReads(ses);
        }

        @Override
        public GridNioFuture<?> onResumeReads(GridNioSession ses) throws IgniteCheckedException {
            return this.proceedResumeReads(ses);
        }
    }
}

