/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.offheap.unsafe;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridReservable;
import org.apache.ignite.internal.util.offheap.unsafe.GridOffHeapSmartPointer;
import org.apache.ignite.internal.util.offheap.unsafe.GridOffHeapSmartPointerFactory;
import org.apache.ignite.internal.util.offheap.unsafe.GridUnsafeCompoundMemory;
import org.apache.ignite.internal.util.offheap.unsafe.GridUnsafeGuard;
import org.apache.ignite.internal.util.offheap.unsafe.GridUnsafeMemory;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.jetbrains.annotations.Nullable;
import org.jsr166.ConcurrentHashMap8;

public class GridOffHeapSnapTreeMap<K extends GridOffHeapSmartPointer, V extends GridOffHeapSmartPointer>
extends AbstractMap<K, V>
implements ConcurrentNavigableMap<K, V>,
Cloneable,
AutoCloseable,
GridReservable {
    private static final GridOffHeapSmartPointer SpecialRetry = new GridOffHeapSmartPointer(){

        @Override
        public long pointer() {
            throw new IllegalStateException();
        }

        @Override
        public void incrementRefCount() {
            throw new IllegalStateException();
        }

        @Override
        public void decrementRefCount() {
            throw new IllegalStateException();
        }
    };
    private static final int SpinCount = Integer.parseInt(System.getProperty("snaptree.spin", "100"));
    private static final int YieldCount = Integer.parseInt(System.getProperty("snaptree.yield", "0"));
    private static final char Left = 'L';
    private static final char Right = 'R';
    private static final long UnlinkedOVL = 2L;
    static final int scale = 8;
    static final int KEY = 0;
    static final int V_OPT = 8;
    static final int LEFT = 16;
    static final int RIGHT = 24;
    static final int SHRINK_OVL = 32;
    static final int PARENT = 40;
    static final int HEIGHT = 48;
    static final int LONGS_IN_NODE = 7;
    static final int NODE_SIZE = 56;
    private final Comparator<? super K> comparator;
    private volatile transient long holderRef;
    private final GridOffHeapSmartPointerFactory<K> keyFactory;
    private final GridOffHeapSmartPointerFactory<V> valFactory;
    protected final GridUnsafeMemory mem;
    protected final GridUnsafeGuard guard;
    private final KeyLock lock = new KeyLock();
    private final AtomicLong snapshotsCnt = new AtomicLong();
    private final ConcurrentSkipListMap<Long, GridOffHeapSnapTreeMap> snapshots = new ConcurrentSkipListMap();
    private Long snapshotId = 0L;
    private volatile StoppableRecycleQueue recycleBin;
    private AtomicInteger reservations;
    private volatile boolean closing;
    private AtomicInteger size = new AtomicInteger();
    private static final int UpdateAlways = 0;
    private static final int UpdateIfAbsent = 1;
    private static final int UpdateIfPresent = 2;
    private static final int UpdateIfEq = 3;
    private static final int UnlinkRequired = -1;
    private static final int RebalanceRequired = -2;
    private static final int NothingRequired = -3;

    private static long beginChange(long ovl) {
        return ovl | 1L;
    }

    private static long endChange(long ovl) {
        return (ovl | 3L) + 1L;
    }

    private static boolean isShrinking(long ovl) {
        return (ovl & 1L) != 0L;
    }

    private static boolean isUnlinked(long ovl) {
        return (ovl & 2L) != 0L;
    }

    private static boolean isShrinkingOrUnlinked(long ovl) {
        return (ovl & 3L) != 0L;
    }

    private long newNode(K key, int height, V vOpt, long parent, long left, long right) {
        long ptr = this.mem.allocate(56L);
        this.vOpt0(ptr);
        assert (vOpt != null && key != null || key == vOpt);
        this.key(ptr, key);
        this.height(ptr, height);
        this.vOpt(ptr, (GridOffHeapSmartPointer)vOpt);
        this.parent(ptr, parent);
        this.shrinkOVL(ptr, 0L);
        this.left(ptr, left);
        this.right(ptr, right);
        return ptr;
    }

    protected long keyPtr(long node) {
        return this.mem.readLongVolatile(node + 0L);
    }

    private K key(long ptr) {
        long resPtr = this.mem.readLongVolatile(ptr + 0L);
        if (resPtr == 0L) {
            return null;
        }
        return this.keyFactory.createPointer(resPtr);
    }

    private V vOpt(long ptr) {
        long resPtr = this.mem.readLongVolatile(ptr + 8L);
        if (resPtr == 0L) {
            return null;
        }
        return this.valFactory.createPointer(resPtr);
    }

    private boolean vOptIsNull(long ptr) {
        return this.mem.readLongVolatile(ptr + 8L) == 0L;
    }

    long right(long ptr) {
        return this.mem.readLongVolatile(ptr + 24L);
    }

    long left(long ptr) {
        return this.mem.readLongVolatile(ptr + 16L);
    }

    protected void right(long ptr, long nodePtr) {
        assert (nodePtr >= 0L);
        this.mem.writeLongVolatile(ptr + 24L, nodePtr);
    }

    private void left(long ptr, long nodePtr) {
        assert (nodePtr >= 0L);
        this.mem.writeLongVolatile(ptr + 16L, nodePtr);
    }

    private long parent(long ptr) {
        return this.mem.readLongVolatile(ptr + 40L);
    }

    private void parent(long ptr, long nodePtr) {
        assert (nodePtr >= 0L);
        this.mem.writeLongVolatile(ptr + 40L, nodePtr);
    }

    private long readLink(long addr) {
        long ptr = -this.mem.readLongVolatile(addr + 40L);
        assert (ptr >= 0L);
        return ptr;
    }

    private void writeLink(long addr, long val) {
        assert (val > 0L);
        this.mem.writeLongVolatile(addr + 40L, -val);
    }

    private long lazyCopy(long ptr, long newParent, LongArray unlinked) {
        assert (ptr > 0L);
        assert (this.isShared(ptr));
        assert (!GridOffHeapSnapTreeMap.isShrinkingOrUnlinked(this.shrinkOVL(ptr)));
        if (this.snapshots.isEmpty()) {
            this.parent(ptr, newParent);
            return ptr;
        }
        long n = this.mem.allocate(56L);
        this.mem.copyMemory(ptr, n, 56L);
        this.markShared(this.left(n));
        this.markShared(this.right(n));
        this.key(n).incrementRefCount();
        V val = this.vOpt(n);
        if (val != null) {
            val.incrementRefCount();
        }
        this.parent(n, newParent);
        unlinked.add(-ptr);
        return n;
    }

    private long shrinkOVL(long ptr) {
        return this.mem.readLongVolatile(ptr + 32L);
    }

    private int height(long ptr) {
        return ptr == 0L ? 0 : (int)this.mem.readLongVolatile(ptr + 48L);
    }

    private void shrinkOVL(long ptr, long shrinkOVL) {
        this.mem.writeLongVolatile(ptr + 32L, shrinkOVL);
    }

    private void vOpt0(long ptr) {
        this.mem.writeLongVolatile(ptr + 8L, 0L);
    }

    private void vOpt(long ptr, GridOffHeapSmartPointer newValue) {
        V old = this.vOpt(ptr);
        long newValPtr = 0L;
        if (newValue != null) {
            newValue.incrementRefCount();
            newValPtr = newValue.pointer();
        }
        assert (newValPtr >= 0L);
        this.mem.writeLongVolatile(ptr + 8L, newValPtr);
        if (old != null) {
            old.decrementRefCount();
        }
    }

    protected void key(long ptr, K key) {
        long keyPtr = 0L;
        if (key != null) {
            key.incrementRefCount();
            keyPtr = key.pointer();
        }
        this.mem.writeLongVolatile(ptr + 0L, keyPtr);
    }

    private void height(long ptr, int h) {
        this.mem.writeLongVolatile(ptr + 48L, h);
    }

    private long child(long ptr, char dir) {
        return dir == 'L' ? this.left(ptr) : this.right(ptr);
    }

    private void setChild(long ptr, char dir, long node) {
        if (dir == 'L') {
            this.left(ptr, node);
        } else {
            this.right(ptr, node);
        }
    }

    private boolean isShared(long node) {
        assert (node >= 0L);
        return node != 0L && this.parent(node) <= 0L && !GridOffHeapSnapTreeMap.isUnlinked(this.shrinkOVL(node));
    }

    private long markShared(long node) {
        assert (node >= 0L);
        if (node != 0L && this.parent(node) > 0L) {
            this.parent(node, 0L);
        }
        return node;
    }

    private long unsharedLeft(long ptr, LongArray unlinked) {
        long cl = this.left(ptr);
        if (!this.isShared(cl)) {
            return cl;
        }
        this.lazyCopyChildren(ptr, unlinked);
        return this.left(ptr);
    }

    private long unsharedRight(long ptr, LongArray unlinked) {
        long cr = this.right(ptr);
        if (!this.isShared(cr)) {
            return cr;
        }
        this.lazyCopyChildren(ptr, unlinked);
        return this.right(ptr);
    }

    private long unsharedChild(long ptr, char dir, LongArray unlinked) {
        return dir == 'L' ? this.unsharedLeft(ptr, unlinked) : this.unsharedRight(ptr, unlinked);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyCopyChildren(long ptr, LongArray unlinked) {
        KeyLock.Lock l = this.lock.lock(ptr);
        try {
            long cr;
            long cl = this.left(ptr);
            if (this.isShared(cl)) {
                this.left(ptr, this.lazyCopy(cl, ptr, unlinked));
            }
            if (this.isShared(cr = this.right(ptr))) {
                this.right(ptr, this.lazyCopy(cr, ptr, unlinked));
            }
        }
        finally {
            if (l != null) {
                l.unlock();
            }
        }
    }

    private void waitUntilShrinkCompleted(long ptr, long ovl) {
        int tries;
        if (GridOffHeapSnapTreeMap.isUnlinked(ovl) || !GridOffHeapSnapTreeMap.isShrinking(ovl)) {
            return;
        }
        for (tries = 0; tries < SpinCount; ++tries) {
            if (this.shrinkOVL(ptr) == ovl) continue;
            return;
        }
        for (tries = 0; tries < YieldCount; ++tries) {
            Thread.yield();
            if (this.shrinkOVL(ptr) == ovl) continue;
            return;
        }
        KeyLock.Lock l = this.lock.lock(ptr);
        if (l != null) {
            l.unlock();
        }
        assert (this.shrinkOVL(ptr) != ovl) : ptr + " " + ovl;
    }

    private int validatedHeight(long ptr) {
        int hR;
        int hL = this.left(ptr) == 0L ? 0 : this.validatedHeight(this.left(ptr));
        int n = hR = this.right(ptr) == 0L ? 0 : this.validatedHeight(this.right(ptr));
        assert (Math.abs(hL - hR) <= 1);
        int h = 1 + Math.max(hL, hR);
        int resH = this.height(ptr);
        assert (h == resH);
        return resH;
    }

    private int computeFrozenSize(long root, Comparable<? super K> fromCmp, boolean fromIncl, Comparable<? super K> toCmp, boolean toIncl) {
        int result = 0;
        while (root != 0L) {
            int c;
            if (fromCmp != null && ((c = fromCmp.compareTo(this.key(root))) > 0 || c == 0 && !fromIncl)) {
                root = this.right(root);
                continue;
            }
            if (toCmp != null && ((c = toCmp.compareTo(this.key(root))) < 0 || c == 0 && !toIncl)) {
                root = this.left(root);
                continue;
            }
            if (!this.vOptIsNull(root)) {
                ++result;
            }
            result += this.computeFrozenSize(this.left(root), fromCmp, fromIncl, null, false);
            fromCmp = null;
            root = this.right(root);
        }
        return result;
    }

    private long rootHolder() {
        return this.newNode(null, 1, null, 0L, 0L, 0L);
    }

    private long rootHolder(long rootHolderSnapshot) {
        return this.newNode(null, 1 + this.height(rootHolderSnapshot), null, 0L, 0L, this.right(rootHolderSnapshot));
    }

    public GridOffHeapSnapTreeMap(GridOffHeapSmartPointerFactory keyFactory, GridOffHeapSmartPointerFactory valFactory, GridUnsafeMemory mem, GridUnsafeGuard guard) {
        this(keyFactory, valFactory, mem, guard, null);
    }

    public GridOffHeapSnapTreeMap(GridOffHeapSmartPointerFactory keyFactory, GridOffHeapSmartPointerFactory valFactory, GridUnsafeMemory mem, GridUnsafeGuard guard, Comparator<? super K> comparator) {
        assert (keyFactory != null);
        assert (valFactory != null);
        assert (mem != null);
        assert (guard != null);
        this.comparator = comparator;
        this.keyFactory = keyFactory;
        this.valFactory = valFactory;
        this.mem = mem;
        this.guard = guard;
        this.holderRef = this.rootHolder();
    }

    @Override
    public boolean reserve() {
        int r;
        do {
            if ((r = this.reservations.get()) == -1) {
                return false;
            }
            assert (r >= 0) : r;
        } while (!this.reservations.compareAndSet(r, r + 1));
        return true;
    }

    @Override
    public void release() {
        int z;
        int r;
        do {
            r = this.reservations.get();
            assert (r > 0) : r;
        } while (!this.reservations.compareAndSet(r, z = r == 1 && this.closing ? -1 : r - 1));
        if (z == -1) {
            this.doClose();
        }
    }

    @Override
    public void close() {
        this.closing = true;
        if (this.reservations == null || this.reservations.compareAndSet(0, -1)) {
            this.doClose();
        }
    }

    private void doClose() {
        RecycleQueue q;
        if (this.snapshotId == 0L) {
            assert (this.recycleBin == null);
            q = new RecycleQueue();
            this.deallocateSubTree(this.root(), q);
        } else {
            GridOffHeapSnapTreeMap s = this.snapshots.remove(this.snapshotId);
            assert (s == this);
            q = this.recycleBin;
            boolean res = this.recycleBin.stop();
            assert (res);
        }
        this.mem.release(this.holderRef, 56L);
        if (!q.isEmpty()) {
            this.doDeallocateSnapshot(q);
        }
    }

    private void deallocateSubTree(long node, RecycleQueue que) {
        if (node == 0L) {
            return;
        }
        this.deallocateSubTree(this.left(node), que);
        this.deallocateSubTree(this.right(node), que);
        que.add(node);
    }

    @Override
    public GridOffHeapSnapTreeMap<K, V> clone() {
        GridOffHeapSnapTreeMap copy;
        try {
            copy = (GridOffHeapSnapTreeMap)super.clone();
        }
        catch (CloneNotSupportedException xx) {
            throw new InternalError();
        }
        assert (copy.comparator == this.comparator);
        copy.holderRef = this.rootHolder(this.holderRef);
        this.markShared(this.root());
        copy.reservations = new AtomicInteger();
        copy.size = new AtomicInteger(this.size());
        copy.recycleBin = new StoppableRecycleQueue();
        copy.snapshotId = this.snapshotsCnt.decrementAndGet();
        this.snapshots.put(copy.snapshotId, copy);
        return copy;
    }

    long root() {
        return this.right(this.holderRef);
    }

    long nodes(boolean nonNull) {
        return this.nodes(this.root(), nonNull);
    }

    private long nodes(long node, boolean nonNull) {
        if (node == 0L) {
            return 0L;
        }
        return (long)(nonNull && this.vOptIsNull(node) ? 0 : 1) + this.nodes(this.left(node), nonNull) + this.nodes(this.right(node), nonNull);
    }

    String print() {
        long root = this.root();
        if (root == 0L) {
            return "Empty tree";
        }
        ArrayList<SB> s = new ArrayList<SB>(this.height(root) + 1);
        this.print(root, s, 0, 0);
        SB res = new SB();
        for (SB sb : s) {
            res.a(sb).a('\n');
        }
        return '\n' + res.toString();
    }

    private int print(long node, ArrayList<SB> s, int level, int offset) {
        SB sb;
        if (node == 0L) {
            return s.get(level - 1).length();
        }
        SB sB = sb = s.size() <= level ? null : s.get(level);
        if (sb == null) {
            sb = new SB();
            s.add(level, sb);
        }
        int o = Math.max(this.print(this.left(node), s, level + 1, offset), offset);
        String v = this.print0(node);
        while (sb.length() < o) {
            sb.a(' ');
        }
        sb.a(v);
        return this.print(this.right(node), s, level + 1, o + v.length());
    }

    private String print0(long node) {
        if (this.key(node) == null) {
            return "[" + node + "]";
        }
        return "[(" + node + ":" + this.shrinkOVL(node) + " " + this.parent(node) + ") " + this.key(node) + " = " + this.vOpt(node) + " ]";
    }

    void validate() {
        long res = this.validate(this.root());
        assert (res == 0L);
    }

    private long validate(long node) {
        long right;
        if (node == 0L) {
            return 0L;
        }
        long left = this.left(node);
        if (left != 0L) {
            if (this.comparable(this.key(left)).compareTo(this.key(node)) >= 0) {
                return node;
            }
            long res = this.validate(left);
            if (res != 0L) {
                return res;
            }
        }
        if ((right = this.right(node)) != 0L) {
            if (this.comparable(this.key(right)).compareTo(this.key(node)) <= 0) {
                return node;
            }
            long res = this.validate(right);
            if (res != 0L) {
                return res;
            }
        }
        return 0L;
    }

    @Override
    public int size() {
        return this.size.get();
    }

    @Override
    public boolean isEmpty() {
        return this.root() == 0L;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.comparator;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getImpl((GridOffHeapSmartPointer)key) != null;
    }

    @Override
    public V get(Object key) {
        return (V)this.getImpl((GridOffHeapSmartPointer)key);
    }

    protected Comparable<? super K> comparable(final Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (this.comparator == null) {
            return (Comparable)key;
        }
        return new Comparable<K>(){
            final Comparator<? super K> _cmp;
            {
                this._cmp = GridOffHeapSnapTreeMap.this.comparator;
            }

            @Override
            public int compareTo(K rhs) {
                return this._cmp.compare((GridOffHeapSmartPointer)key, rhs);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GridOffHeapSmartPointer getImpl(K key) {
        LongArray unlinked = new LongArray();
        try {
            GridOffHeapSmartPointer gridOffHeapSmartPointer = this.doGet(key, unlinked);
            return gridOffHeapSmartPointer;
        }
        finally {
            this.deallocate(unlinked);
        }
    }

    private GridOffHeapSmartPointer doGet(K key, LongArray unlinked) {
        GridOffHeapSmartPointer vo;
        Comparable<K> k = this.comparable(key);
        while (true) {
            long right;
            if ((right = this.unsharedRight(this.holderRef, unlinked)) == 0L) {
                return null;
            }
            int rightCmp = k.compareTo(this.key(right));
            if (rightCmp == 0) {
                return this.vOpt(right);
            }
            long ovl = this.shrinkOVL(right);
            if (GridOffHeapSnapTreeMap.isShrinkingOrUnlinked(ovl)) {
                this.waitUntilShrinkCompleted(right, ovl);
                continue;
            }
            if (right == this.right(this.holderRef) && (vo = this.attemptGet(k, right, rightCmp < 0 ? (char)'L' : 'R', ovl, unlinked)) != SpecialRetry) break;
        }
        return vo;
    }

    private GridOffHeapSmartPointer attemptGet(Comparable<? super K> k, long node, char dirToC, long nodeOVL, LongArray unlinked) {
        GridOffHeapSmartPointer vo;
        while (true) {
            long child;
            if ((child = this.unsharedChild(node, dirToC, unlinked)) == 0L) {
                if (this.isOutdatedOVL(node, nodeOVL)) {
                    return SpecialRetry;
                }
                return null;
            }
            int childCmp = k.compareTo(this.key(child));
            if (childCmp == 0) {
                return this.vOpt(child);
            }
            long childOVL = this.shrinkOVL(child);
            if (GridOffHeapSnapTreeMap.isShrinkingOrUnlinked(childOVL)) {
                this.waitUntilShrinkCompleted(child, childOVL);
                if (!this.isOutdatedOVL(node, nodeOVL)) continue;
                return SpecialRetry;
            }
            if (child != this.child(node, dirToC)) {
                if (!this.isOutdatedOVL(node, nodeOVL)) continue;
                return SpecialRetry;
            }
            if (this.isOutdatedOVL(node, nodeOVL)) {
                return SpecialRetry;
            }
            vo = this.attemptGet(k, child, childCmp < 0 ? (char)'L' : 'R', childOVL, unlinked);
            if (vo != SpecialRetry) break;
        }
        return vo;
    }

    @Override
    public K firstKey() {
        return this.extremeKeyOrThrow('L');
    }

    @Override
    public Map.Entry<K, V> firstEntry() {
        return (AbstractMap.SimpleImmutableEntry)this.extreme(false, 'L');
    }

    @Override
    public K lastKey() {
        return this.extremeKeyOrThrow('R');
    }

    @Override
    public Map.Entry<K, V> lastEntry() {
        return (AbstractMap.SimpleImmutableEntry)this.extreme(false, 'R');
    }

    private K extremeKeyOrThrow(char dir) {
        GridOffHeapSmartPointer k = (GridOffHeapSmartPointer)this.extreme(true, dir);
        if (k == null) {
            throw new NoSuchElementException();
        }
        return (K)k;
    }

    private Object extreme(boolean returnKey, char dir) {
        Object vo;
        while (true) {
            long right;
            if ((right = this.right(this.holderRef)) == 0L) {
                return null;
            }
            long ovl = this.shrinkOVL(right);
            if (GridOffHeapSnapTreeMap.isShrinkingOrUnlinked(ovl)) {
                this.waitUntilShrinkCompleted(right, ovl);
                continue;
            }
            if (right == this.right(this.holderRef) && (vo = this.attemptExtreme(returnKey, dir, right, ovl)) != SpecialRetry) break;
        }
        return vo;
    }

    private Object attemptExtreme(boolean returnKey, char dir, long node, long nodeOVL) {
        Object vo;
        while (true) {
            long child;
            if ((child = this.child(node, dir)) == 0L) {
                V vo2 = this.vOpt(node);
                if (this.isOutdatedOVL(node, nodeOVL)) {
                    return SpecialRetry;
                }
                assert (vo2 != null);
                return returnKey ? this.key(node) : new AbstractMap.SimpleImmutableEntry<K, V>(this.key(node), vo2);
            }
            long childOVL = this.shrinkOVL(child);
            if (GridOffHeapSnapTreeMap.isShrinkingOrUnlinked(childOVL)) {
                this.waitUntilShrinkCompleted(child, childOVL);
                if (!this.isOutdatedOVL(node, nodeOVL)) continue;
                return SpecialRetry;
            }
            if (child != this.child(node, dir)) {
                if (!this.isOutdatedOVL(node, nodeOVL)) continue;
                return SpecialRetry;
            }
            if (this.isOutdatedOVL(node, nodeOVL)) {
                return SpecialRetry;
            }
            vo = this.attemptExtreme(returnKey, dir, child, childOVL);
            if (vo != SpecialRetry) break;
        }
        return vo;
    }

    @Override
    public K lowerKey(K key) {
        return (K)((GridOffHeapSmartPointer)this.boundedExtreme(null, false, this.comparable(key), false, true, 'R'));
    }

    @Override
    public K floorKey(K key) {
        return (K)((GridOffHeapSmartPointer)this.boundedExtreme(null, false, this.comparable(key), true, true, 'R'));
    }

    @Override
    public K ceilingKey(K key) {
        return (K)((GridOffHeapSmartPointer)this.boundedExtreme(this.comparable(key), true, null, false, true, 'L'));
    }

    @Override
    public K higherKey(K key) {
        return (K)((GridOffHeapSmartPointer)this.boundedExtreme(this.comparable(key), false, null, false, true, 'L'));
    }

    @Override
    public Map.Entry<K, V> lowerEntry(K key) {
        return (Map.Entry)this.boundedExtreme(null, false, this.comparable(key), false, false, 'R');
    }

    @Override
    public Map.Entry<K, V> floorEntry(K key) {
        return (Map.Entry)this.boundedExtreme(null, false, this.comparable(key), true, false, 'R');
    }

    @Override
    public Map.Entry<K, V> ceilingEntry(K key) {
        return (Map.Entry)this.boundedExtreme(this.comparable(key), true, null, false, false, 'L');
    }

    @Override
    public Map.Entry<K, V> higherEntry(K key) {
        return (Map.Entry)this.boundedExtreme(this.comparable(key), false, null, false, false, 'L');
    }

    private K boundedExtremeKeyOrThrow(Comparable<? super K> minCmp, boolean minIncl, Comparable<? super K> maxCmp, boolean maxIncl, char dir) {
        GridOffHeapSmartPointer k = (GridOffHeapSmartPointer)this.boundedExtreme(minCmp, minIncl, maxCmp, maxIncl, true, dir);
        if (k == null) {
            throw new NoSuchElementException();
        }
        return (K)k;
    }

    private Object boundedExtreme(Comparable<? super K> minCmp, boolean minIncl, Comparable<? super K> maxCmp, boolean maxIncl, boolean returnKey, char dir) {
        int c;
        GridOffHeapSmartPointer resultKey;
        AbstractMap.SimpleImmutableEntry<K, V> result;
        if (dir == 'L' && minCmp == null || dir == 'R' && maxCmp == null) {
            result = this.extreme(returnKey, dir);
            if (result == null) {
                return null;
            }
            resultKey = returnKey ? (GridOffHeapSmartPointer)((Object)result) : (GridOffHeapSmartPointer)((AbstractMap.SimpleImmutableEntry)result).getKey();
        } else {
            long node;
            long holder = this.holderRef;
            long l = node = dir == 'L' ? this.boundedMin(this.right(holder), minCmp, minIncl) : this.boundedMax(this.right(holder), maxCmp, maxIncl);
            if (node == 0L) {
                return null;
            }
            resultKey = this.key(node);
            result = returnKey ? resultKey : new AbstractMap.SimpleImmutableEntry<K, V>(this.key(node), this.vOpt(node));
        }
        if (dir == 'L' && maxCmp != null && ((c = maxCmp.compareTo(resultKey)) < 0 || c == 0 && !maxIncl)) {
            return null;
        }
        if (dir == 'R' && minCmp != null && ((c = minCmp.compareTo(resultKey)) > 0 || c == 0 && !minIncl)) {
            return null;
        }
        return result;
    }

    private long boundedMin(long node, Comparable<? super K> minCmp, boolean minIncl) {
        while (node != 0L) {
            long z;
            int c = minCmp.compareTo(this.key(node));
            if (c < 0 && (z = this.boundedMin(this.left(node), minCmp, minIncl)) != 0L) {
                return z;
            }
            if ((c < 0 || c == 0 && minIncl) && !this.vOptIsNull(node)) {
                return node;
            }
            node = this.right(node);
        }
        return 0L;
    }

    private long boundedMax(long node, Comparable<? super K> maxCmp, boolean maxIncl) {
        while (node != 0L) {
            long z;
            int c = maxCmp.compareTo(this.key(node));
            if (c > 0 && (z = this.boundedMax(this.right(node), maxCmp, maxIncl)) != 0L) {
                return z;
            }
            if ((c > 0 || c == 0 && maxIncl) && !this.vOptIsNull(node)) {
                return node;
            }
            node = this.left(node);
        }
        return 0L;
    }

    private static boolean shouldUpdate(int func, Object prev, Object expected) {
        switch (func) {
            case 0: {
                return true;
            }
            case 1: {
                return prev == null;
            }
            case 2: {
                return prev != null;
            }
        }
        assert (expected != null);
        if (prev == null) {
            return false;
        }
        return prev.equals(expected);
    }

    private static Object noUpdateResult(int func, Object prev) {
        return func == 3 ? Boolean.FALSE : prev;
    }

    private static Object updateResult(int func, Object prev) {
        return func == 3 ? Boolean.TRUE : prev;
    }

    private static int sizeDelta(int func, Object result, Object newValue) {
        switch (func) {
            case 0: {
                return (result != null ? -1 : 0) + (newValue != null ? 1 : 0);
            }
            case 1: {
                assert (newValue != null);
                return result != null ? 0 : 1;
            }
            case 2: {
                return result == null ? 0 : (newValue != null ? 0 : -1);
            }
        }
        return (Boolean)result == false ? 0 : (newValue != null ? 0 : -1);
    }

    @Override
    public V put(K key, V value) {
        return (V)((GridOffHeapSmartPointer)this.update(key, 0, null, value));
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return (V)((GridOffHeapSmartPointer)this.update(key, 1, null, value));
    }

    @Override
    public V replace(K key, V value) {
        return (V)((GridOffHeapSmartPointer)this.update(key, 2, null, value));
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return (Boolean)this.update(key, 3, oldValue, newValue);
    }

    @Override
    public V remove(Object key) {
        return (V)((GridOffHeapSmartPointer)this.update((GridOffHeapSmartPointer)key, 0, null, null));
    }

    @Override
    public boolean remove(Object key, Object value) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            return false;
        }
        return (Boolean)this.update((GridOffHeapSmartPointer)key, 3, (GridOffHeapSmartPointer)value, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object update(K key, int func, V expected, V newValue) {
        Comparable<K> k = this.comparable(key);
        LongArray unlinked = new LongArray();
        int sd = 0;
        try {
            Object result = this.updateUnderRoot(key, k, func, expected, newValue, this.holderRef, unlinked);
            sd = GridOffHeapSnapTreeMap.sizeDelta(func, result, newValue);
            if (sd != 0) {
                this.size.addAndGet(sd);
            }
            Object object = result;
            return object;
        }
        finally {
            this.deallocate(unlinked);
        }
    }

    private void deallocate(LongArray unlinked) {
        RecycleQueue toMem = null;
        RecycleQueue toSnap = null;
        for (int i = 0; i < unlinked.idx; ++i) {
            long ptr = unlinked.arr[i];
            if (ptr > 0L) {
                if (toMem == null) {
                    toMem = new RecycleQueue();
                }
                toMem.add(ptr);
                continue;
            }
            assert (ptr != 0L);
            if (toSnap == null) {
                toSnap = new RecycleQueue();
            }
            toSnap.add(-ptr);
        }
        if (toSnap != null) {
            for (GridOffHeapSnapTreeMap snap : this.snapshots.values()) {
                if (!snap.recycleBin.add(toSnap)) continue;
                toSnap = null;
                break;
            }
            if (toSnap != null) {
                if (toMem == null) {
                    toMem = toSnap;
                } else {
                    toMem.add(toSnap);
                }
            }
        }
        if (toMem != null) {
            this.guard.releaseLater(toMem);
        }
    }

    private void doDeallocateSnapshot(RecycleQueue q) {
        for (GridOffHeapSnapTreeMap s : this.snapshots.tailMap((Object)this.snapshotId, false).values()) {
            if (!s.recycleBin.add(q)) continue;
            return;
        }
        q.deallocate();
    }

    private Object updateUnderRoot(K key, Comparable<? super K> k, int func, V expected, V newValue, long holder, LongArray unlinked) {
        Object vo;
        boolean i = false;
        while (true) {
            long right;
            if ((right = this.unsharedRight(holder, unlinked)) == 0L) {
                if (!GridOffHeapSnapTreeMap.shouldUpdate(func, null, expected)) {
                    return GridOffHeapSnapTreeMap.noUpdateResult(func, null);
                }
                if (newValue != null && !this.attemptInsertIntoEmpty(key, newValue, holder)) continue;
                return GridOffHeapSnapTreeMap.updateResult(func, null);
            }
            long ovl = this.shrinkOVL(right);
            if (GridOffHeapSnapTreeMap.isShrinkingOrUnlinked(ovl)) {
                this.waitUntilShrinkCompleted(right, ovl);
                continue;
            }
            if (right == this.right(holder) && (vo = this.attemptUpdate(key, k, func, expected, newValue, holder, right, ovl, unlinked)) != SpecialRetry) break;
        }
        return vo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean attemptInsertIntoEmpty(K key, V vOpt, long holder) {
        KeyLock.Lock l = this.lock.lock(holder);
        try {
            if (this.right(holder) == 0L) {
                this.right(holder, this.newNode(key, 1, vOpt, holder, 0L, 0L));
                this.height(holder, 2);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (l != null) {
                l.unlock();
            }
        }
    }

    private boolean isOutdatedOVL(long node, long nodeOVL) {
        return this.shrinkOVL(node) != nodeOVL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object attemptUpdate(Object key, Comparable<? super K> k, int func, V expected, V newValue, long parent, long node, long nodeOVL, LongArray unlinked) {
        Object vo;
        assert (!GridOffHeapSnapTreeMap.isUnlinked(nodeOVL));
        int cmp = k.compareTo(this.key(node));
        if (cmp == 0) {
            return this.attemptNodeUpdate(func, expected, newValue, parent, node, unlinked);
        }
        char dirToC = cmp < 0 ? (char)'L' : 'R';
        boolean i = false;
        while (true) {
            if (this.isOutdatedOVL(node, nodeOVL)) {
                return SpecialRetry;
            }
            long child = this.unsharedChild(node, dirToC, unlinked);
            if (child == 0L) {
                long damaged;
                boolean success;
                if (newValue == null) {
                    KeyLock.Lock l = this.lock.lock(node);
                    try {
                        if (this.isOutdatedOVL(node, nodeOVL)) {
                            GridOffHeapSmartPointer gridOffHeapSmartPointer = SpecialRetry;
                            return gridOffHeapSmartPointer;
                        }
                        Object var19_19 = null;
                        return var19_19;
                    }
                    finally {
                        if (l != null) {
                            l.unlock();
                        }
                    }
                }
                KeyLock.Lock l = this.lock.lock(node);
                try {
                    if (this.isOutdatedOVL(node, nodeOVL)) {
                        GridOffHeapSmartPointer gridOffHeapSmartPointer = SpecialRetry;
                        return gridOffHeapSmartPointer;
                    }
                    if (this.child(node, dirToC) != 0L) {
                        success = false;
                        damaged = 0L;
                    } else {
                        if (!GridOffHeapSnapTreeMap.shouldUpdate(func, null, expected)) {
                            Object object = GridOffHeapSnapTreeMap.noUpdateResult(func, null);
                            return object;
                        }
                        this.setChild(node, dirToC, this.newNode((GridOffHeapSmartPointer)key, 1, newValue, node, 0L, 0L));
                        success = true;
                        damaged = this.fixHeight_nl(node);
                    }
                }
                finally {
                    if (l != null) {
                        l.unlock();
                    }
                }
                if (!success) continue;
                this.fixHeightAndRebalance(damaged, unlinked);
                return GridOffHeapSnapTreeMap.updateResult(func, null);
            }
            long childOVL = this.shrinkOVL(child);
            if (GridOffHeapSnapTreeMap.isShrinkingOrUnlinked(childOVL)) {
                this.waitUntilShrinkCompleted(child, childOVL);
                continue;
            }
            if (child != this.child(node, dirToC)) continue;
            if (this.isOutdatedOVL(node, nodeOVL)) {
                return SpecialRetry;
            }
            vo = this.attemptUpdate(key, k, func, expected, newValue, node, child, childOVL, unlinked);
            if (vo != SpecialRetry) break;
        }
        return vo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object attemptNodeUpdate(int func, V expected, V newValue, long parent, long node, LongArray unlinked) {
        if (newValue == null && this.vOptIsNull(node)) {
            return null;
        }
        if (newValue == null && (this.left(node) == 0L || this.right(node) == 0L)) {
            long damaged;
            V prev;
            KeyLock.Lock pl = this.lock.lock(parent);
            try {
                if (GridOffHeapSnapTreeMap.isUnlinked(this.shrinkOVL(parent)) || this.parent(node) != parent) {
                    GridOffHeapSmartPointer gridOffHeapSmartPointer = SpecialRetry;
                    return gridOffHeapSmartPointer;
                }
                KeyLock.Lock nl = this.lock.lock(node);
                try {
                    if (GridOffHeapSnapTreeMap.isUnlinked(this.shrinkOVL(node))) {
                        GridOffHeapSmartPointer gridOffHeapSmartPointer = SpecialRetry;
                        return gridOffHeapSmartPointer;
                    }
                    if (!$assertionsDisabled) {
                        if (this.parent(node) != parent) throw new AssertionError();
                        if (parent <= 0L) {
                            throw new AssertionError();
                        }
                    }
                    if (!GridOffHeapSnapTreeMap.shouldUpdate(func, prev = this.vOpt(node), expected)) {
                        Object object = GridOffHeapSnapTreeMap.noUpdateResult(func, prev);
                        return object;
                    }
                    if (prev == null) {
                        Object object = GridOffHeapSnapTreeMap.updateResult(func, prev);
                        return object;
                    }
                    if (!this.attemptUnlink_nl(parent, node, unlinked)) {
                        GridOffHeapSmartPointer gridOffHeapSmartPointer = SpecialRetry;
                        return gridOffHeapSmartPointer;
                    }
                }
                finally {
                    if (nl != null) {
                        nl.unlock();
                    }
                }
                damaged = this.fixHeight_nl(parent);
            }
            finally {
                if (pl != null) {
                    pl.unlock();
                }
            }
            this.fixHeightAndRebalance(damaged, unlinked);
            return GridOffHeapSnapTreeMap.updateResult(func, prev);
        }
        KeyLock.Lock l = this.lock.lock(node);
        try {
            if (GridOffHeapSnapTreeMap.isUnlinked(this.shrinkOVL(node))) {
                GridOffHeapSmartPointer damaged = SpecialRetry;
                return damaged;
            }
            V prev = this.vOpt(node);
            if (!GridOffHeapSnapTreeMap.shouldUpdate(func, prev, expected)) {
                Object object = GridOffHeapSnapTreeMap.noUpdateResult(func, prev);
                return object;
            }
            if (newValue == null && (this.left(node) == 0L || this.right(node) == 0L)) {
                GridOffHeapSmartPointer gridOffHeapSmartPointer = SpecialRetry;
                return gridOffHeapSmartPointer;
            }
            this.vOpt(node, (GridOffHeapSmartPointer)newValue);
            this.afterNodeUpdate_nl(node, newValue);
            Object object = GridOffHeapSnapTreeMap.updateResult(func, prev);
            return object;
        }
        finally {
            if (l != null) {
                l.unlock();
            }
        }
    }

    protected void afterNodeUpdate_nl(long node, V val) {
    }

    private boolean attemptUnlink_nl(long parent, long node, LongArray unlinked) {
        long splice;
        assert (!GridOffHeapSnapTreeMap.isUnlinked(this.shrinkOVL(parent)));
        long parentL = this.left(parent);
        long parentR = this.right(parent);
        if (parentL != node && parentR != node) {
            return false;
        }
        long nodeOVL = this.shrinkOVL(node);
        assert (!GridOffHeapSnapTreeMap.isUnlinked(nodeOVL));
        assert (parent == this.parent(node));
        long left = this.unsharedLeft(node, unlinked);
        long right = this.unsharedRight(node, unlinked);
        if (left != 0L && right != 0L) {
            return false;
        }
        long l = splice = left != 0L ? left : right;
        if (parentL == node) {
            this.left(parent, splice);
        } else {
            this.right(parent, splice);
        }
        if (splice != 0L) {
            this.parent(splice, parent);
        }
        this.shrinkOVL(node, 2L);
        this.vOpt(node, null);
        unlinked.add(node);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map.Entry<K, V> pollFirstEntry() {
        LongArray unlinked = new LongArray();
        try {
            Map.Entry<K, V> entry = this.pollExtremeEntry('L', unlinked);
            return entry;
        }
        finally {
            this.deallocate(unlinked);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map.Entry<K, V> pollLastEntry() {
        LongArray unlinked = new LongArray();
        try {
            Map.Entry<K, V> entry = this.pollExtremeEntry('R', unlinked);
            return entry;
        }
        finally {
            this.deallocate(unlinked);
        }
    }

    private Map.Entry<K, V> pollExtremeEntry(char dir, LongArray unlinked) {
        int sizeDelta = 0;
        Map.Entry<K, V> prev = this.pollExtremeEntryUnderRoot(dir, this.holderRef, unlinked);
        if (prev != null) {
            sizeDelta = -1;
        }
        return prev;
    }

    private Map.Entry<K, V> pollExtremeEntryUnderRoot(char dir, long holder, LongArray unlinked) {
        Map.Entry<K, V> result;
        while (true) {
            long right;
            if ((right = this.unsharedRight(holder, unlinked)) == 0L) {
                return null;
            }
            long ovl = this.shrinkOVL(right);
            if (GridOffHeapSnapTreeMap.isShrinkingOrUnlinked(ovl)) {
                this.waitUntilShrinkCompleted(right, ovl);
                continue;
            }
            if (right == this.right(holder) && (result = this.attemptRemoveExtreme(dir, holder, right, ovl, unlinked)) != SpecialRetry) break;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map.Entry<K, V> attemptRemoveExtreme(char dir, long parent, long node, long nodeOVL, LongArray unlinked) {
        Map.Entry<K, V> result;
        assert (!GridOffHeapSnapTreeMap.isUnlinked(nodeOVL));
        while (true) {
            long child = this.unsharedChild(node, dir, unlinked);
            if (this.isOutdatedOVL(node, nodeOVL)) {
                return null;
            }
            if (child == 0L) {
                long damaged;
                V vo;
                KeyLock.Lock pl = this.lock.lock(parent);
                try {
                    if (GridOffHeapSnapTreeMap.isUnlinked(this.shrinkOVL(parent)) || this.parent(node) != parent) {
                        Map.Entry<K, V> entry = null;
                        return entry;
                    }
                    KeyLock.Lock nl = this.lock.lock(node);
                    try {
                        vo = this.vOpt(node);
                        if (this.child(node, dir) != 0L || !this.attemptUnlink_nl(parent, node, unlinked)) {
                            Map.Entry<K, V> entry = null;
                            return entry;
                        }
                    }
                    finally {
                        if (nl != null) {
                            nl.unlock();
                        }
                    }
                    damaged = this.fixHeight_nl(parent);
                }
                finally {
                    if (pl != null) {
                        pl.unlock();
                    }
                }
                this.fixHeightAndRebalance(damaged, unlinked);
                return new AbstractMap.SimpleImmutableEntry<K, GridOffHeapSmartPointer>(this.key(node), (GridOffHeapSmartPointer)vo);
            }
            long childOVL = this.shrinkOVL(child);
            if (GridOffHeapSnapTreeMap.isShrinkingOrUnlinked(childOVL)) {
                this.waitUntilShrinkCompleted(child, childOVL);
                continue;
            }
            if (child != this.child(node, dir)) continue;
            if (this.isOutdatedOVL(node, nodeOVL)) {
                return null;
            }
            result = this.attemptRemoveExtreme(dir, node, child, childOVL, unlinked);
            if (result != null) break;
        }
        return result;
    }

    private int nodeCondition(long node) {
        long nL = this.left(node);
        long nR = this.right(node);
        if ((nL == 0L || nR == 0L) && this.vOptIsNull(node)) {
            return -1;
        }
        int hN = this.height(node);
        int hL0 = this.height(nL);
        int hR0 = this.height(nR);
        int hNRepl = 1 + Math.max(hL0, hR0);
        int bal = hL0 - hR0;
        if (bal < -1 || bal > 1) {
            return -2;
        }
        return hN != hNRepl ? hNRepl : -3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fixHeightAndRebalance(long node, LongArray unlinked) {
        while (node != 0L && this.parent(node) > 0L) {
            int condition = this.nodeCondition(node);
            if (condition == -3 || GridOffHeapSnapTreeMap.isUnlinked(this.shrinkOVL(node))) {
                return;
            }
            if (condition != -1 && condition != -2) {
                long n = node;
                KeyLock.Lock l = this.lock.lock(n);
                try {
                    if (GridOffHeapSnapTreeMap.isUnlinked(this.shrinkOVL(node))) {
                        return;
                    }
                    node = this.fixHeight_nl(node);
                    continue;
                }
                finally {
                    if (l != null) {
                        l.unlock();
                    }
                    continue;
                }
            }
            long nParent = this.parent(node);
            if (nParent <= 0L) continue;
            KeyLock.Lock pl = this.lock.lock(nParent);
            try {
                if (GridOffHeapSnapTreeMap.isUnlinked(this.shrinkOVL(nParent)) || this.parent(node) != nParent) continue;
                long n = node;
                KeyLock.Lock nl = this.lock.lock(n);
                try {
                    if (GridOffHeapSnapTreeMap.isUnlinked(this.shrinkOVL(node))) {
                        return;
                    }
                    node = this.rebalance_nl(nParent, node, unlinked);
                }
                finally {
                    if (nl == null) continue;
                    nl.unlock();
                }
            }
            finally {
                if (pl == null) continue;
                pl.unlock();
            }
        }
    }

    private long fixHeight_nl(long node) {
        int c = this.nodeCondition(node);
        switch (c) {
            case -2: 
            case -1: {
                return node;
            }
            case -3: {
                return 0L;
            }
        }
        this.height(node, c);
        return this.parent(node);
    }

    private long rebalance_nl(long nParent, long n, LongArray unlinked) {
        long nL = this.unsharedLeft(n, unlinked);
        long nR = this.unsharedRight(n, unlinked);
        if ((nL == 0L || nR == 0L) && this.vOptIsNull(n)) {
            if (this.attemptUnlink_nl(nParent, n, unlinked)) {
                return this.fixHeight_nl(nParent);
            }
            return n;
        }
        int hN = this.height(n);
        int hL0 = this.height(nL);
        int hR0 = this.height(nR);
        int hNRepl = 1 + Math.max(hL0, hR0);
        int bal = hL0 - hR0;
        if (bal > 1) {
            return this.rebalanceToRight_nl(nParent, n, nL, hR0, unlinked);
        }
        if (bal < -1) {
            return this.rebalanceToLeft_nl(nParent, n, nR, hL0, unlinked);
        }
        if (hNRepl != hN) {
            this.height(n, hNRepl);
            return this.fixHeight_nl(nParent);
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long rebalanceToRight_nl(long nParent, long n, long nL, int hR0, LongArray unlinked) {
        KeyLock.Lock nLl = this.lock.lock(nL);
        try {
            int hLR0;
            int hL = this.height(nL);
            if (hL - hR0 <= 1) {
                long l = n;
                return l;
            }
            long nLR = this.unsharedRight(nL, unlinked);
            int hLL0 = this.height(this.left(nL));
            if (hLL0 >= (hLR0 = this.height(nLR))) {
                long l = this.rotateRight_nl(nParent, n, nL, hR0, hLL0, nLR, hLR0);
                return l;
            }
            KeyLock.Lock nLRl = this.lock.lock(nLR);
            try {
                int hLR = this.height(nLR);
                if (hLL0 >= hLR) {
                    long l = this.rotateRight_nl(nParent, n, nL, hR0, hLL0, nLR, hLR);
                    return l;
                }
                int hLRL = this.height(this.left(nLR));
                int b = hLL0 - hLRL;
                if (b >= -1 && b <= 1 && (hLL0 != 0 && hLRL != 0 || !this.vOptIsNull(nL))) {
                    long l = this.rotateRightOverLeft_nl(nParent, n, nL, hR0, hLL0, nLR, hLRL, unlinked);
                    return l;
                }
            }
            finally {
                if (nLRl != null) {
                    nLRl.unlock();
                }
            }
            long l = this.rebalanceToLeft_nl(n, nL, nLR, hLL0, unlinked);
            return l;
        }
        finally {
            if (nLl != null) {
                nLl.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long rebalanceToLeft_nl(long nParent, long n, long nR, int hL0, LongArray unlinked) {
        KeyLock.Lock nRl = this.lock.lock(nR);
        try {
            int hR = this.height(nR);
            if (hL0 - hR >= -1) {
                long l = n;
                return l;
            }
            long nRL = this.unsharedLeft(nR, unlinked);
            int hRL0 = this.height(nRL);
            int hRR0 = this.height(this.right(nR));
            if (hRR0 >= hRL0) {
                long l = this.rotateLeft_nl(nParent, n, hL0, nR, nRL, hRL0, hRR0);
                return l;
            }
            KeyLock.Lock nRLl = this.lock.lock(nRL);
            try {
                int hRL = this.height(nRL);
                if (hRR0 >= hRL) {
                    long l = this.rotateLeft_nl(nParent, n, hL0, nR, nRL, hRL, hRR0);
                    return l;
                }
                int hRLR = this.height(this.right(nRL));
                int b = hRR0 - hRLR;
                if (b >= -1 && b <= 1 && (hRR0 != 0 && hRLR != 0 || !this.vOptIsNull(nR))) {
                    long l = this.rotateLeftOverRight_nl(nParent, n, hL0, nR, nRL, hRR0, hRLR, unlinked);
                    return l;
                }
            }
            finally {
                if (nRLl != null) {
                    nRLl.unlock();
                }
            }
            long l = this.rebalanceToRight_nl(n, nR, nRL, hRR0, unlinked);
            return l;
        }
        finally {
            if (nRl != null) {
                nRl.unlock();
            }
        }
    }

    private long rotateRight_nl(long nParent, long n, long nL, int hR, int hLL, long nLR, int hLR) {
        long nodeOVL = this.shrinkOVL(n);
        assert (!GridOffHeapSnapTreeMap.isShrinkingOrUnlinked(nodeOVL));
        long nPL = this.left(nParent);
        this.shrinkOVL(n, GridOffHeapSnapTreeMap.beginChange(nodeOVL));
        this.left(n, nLR);
        if (nLR != 0L) {
            this.parent(nLR, n);
        }
        this.right(nL, n);
        this.parent(n, nL);
        if (nPL == n) {
            this.left(nParent, nL);
        } else {
            this.right(nParent, nL);
        }
        this.parent(nL, nParent);
        int hNRepl = 1 + Math.max(hLR, hR);
        this.height(n, hNRepl);
        this.height(nL, 1 + Math.max(hLL, hNRepl));
        this.shrinkOVL(n, GridOffHeapSnapTreeMap.endChange(nodeOVL));
        int balN = hLR - hR;
        if (balN < -1 || balN > 1) {
            return n;
        }
        if ((nLR == 0L || hR == 0) && this.vOptIsNull(n)) {
            return n;
        }
        int balL = hLL - hNRepl;
        if (balL < -1 || balL > 1) {
            return nL;
        }
        if (hLL == 0 && this.vOptIsNull(nL)) {
            return nL;
        }
        return this.fixHeight_nl(nParent);
    }

    private long rotateLeft_nl(long nParent, long n, int hL, long nR, long nRL, int hRL, int hRR) {
        long nodeOVL = this.shrinkOVL(n);
        assert (!GridOffHeapSnapTreeMap.isShrinkingOrUnlinked(nodeOVL));
        long nPL = this.left(nParent);
        this.shrinkOVL(n, GridOffHeapSnapTreeMap.beginChange(nodeOVL));
        this.right(n, nRL);
        if (nRL != 0L) {
            this.parent(nRL, n);
        }
        this.left(nR, n);
        this.parent(n, nR);
        if (nPL == n) {
            this.left(nParent, nR);
        } else {
            this.right(nParent, nR);
        }
        this.parent(nR, nParent);
        int hNRepl = 1 + Math.max(hL, hRL);
        this.height(n, hNRepl);
        this.height(nR, 1 + Math.max(hNRepl, hRR));
        this.shrinkOVL(n, GridOffHeapSnapTreeMap.endChange(nodeOVL));
        int balN = hRL - hL;
        if (balN < -1 || balN > 1) {
            return n;
        }
        if ((nRL == 0L || hL == 0) && this.vOptIsNull(n)) {
            return n;
        }
        int balR = hRR - hNRepl;
        if (balR < -1 || balR > 1) {
            return nR;
        }
        if (hRR == 0 && this.vOptIsNull(nR)) {
            return nR;
        }
        return this.fixHeight_nl(nParent);
    }

    private long rotateRightOverLeft_nl(long nParent, long n, long nL, int hR, int hLL, long nLR, int hLRL, LongArray unlinked) {
        long nodeOVL = this.shrinkOVL(n);
        long leftOVL = this.shrinkOVL(nL);
        long nPL = this.left(nParent);
        long nLRL = this.unsharedLeft(nLR, unlinked);
        long nLRR = this.unsharedRight(nLR, unlinked);
        int hLRR = this.height(nLRR);
        assert (!GridOffHeapSnapTreeMap.isShrinkingOrUnlinked(nodeOVL));
        assert (!GridOffHeapSnapTreeMap.isShrinkingOrUnlinked(leftOVL));
        this.shrinkOVL(n, GridOffHeapSnapTreeMap.beginChange(nodeOVL));
        this.shrinkOVL(nL, GridOffHeapSnapTreeMap.beginChange(leftOVL));
        this.left(n, nLRR);
        if (nLRR != 0L) {
            this.parent(nLRR, n);
        }
        this.right(nL, nLRL);
        if (nLRL != 0L) {
            this.parent(nLRL, nL);
        }
        this.left(nLR, nL);
        this.parent(nL, nLR);
        this.right(nLR, n);
        this.parent(n, nLR);
        if (nPL == n) {
            this.left(nParent, nLR);
        } else {
            this.right(nParent, nLR);
        }
        this.parent(nLR, nParent);
        int hNRepl = 1 + Math.max(hLRR, hR);
        this.height(n, hNRepl);
        int hLRepl = 1 + Math.max(hLL, hLRL);
        this.height(nL, hLRepl);
        this.height(nLR, 1 + Math.max(hLRepl, hNRepl));
        this.shrinkOVL(n, GridOffHeapSnapTreeMap.endChange(nodeOVL));
        this.shrinkOVL(nL, GridOffHeapSnapTreeMap.endChange(leftOVL));
        assert (Math.abs(hLL - hLRL) <= 1);
        assert (hLL != 0 && nLRL != 0L || !this.vOptIsNull(nL));
        int balN = hLRR - hR;
        if (balN < -1 || balN > 1) {
            return n;
        }
        if ((nLRR == 0L || hR == 0) && this.vOptIsNull(n)) {
            return n;
        }
        int balLR = hLRepl - hNRepl;
        if (balLR < -1 || balLR > 1) {
            return nLR;
        }
        return this.fixHeight_nl(nParent);
    }

    private long rotateLeftOverRight_nl(long nParent, long n, int hL, long nR, long nRL, int hRR, int hRLR, LongArray unlinked) {
        long nodeOVL = this.shrinkOVL(n);
        long rightOVL = this.shrinkOVL(nR);
        long nPL = this.left(nParent);
        long nRLL = this.unsharedLeft(nRL, unlinked);
        long nRLR = this.unsharedRight(nRL, unlinked);
        int hRLL = this.height(nRLL);
        assert (!GridOffHeapSnapTreeMap.isShrinkingOrUnlinked(nodeOVL));
        assert (!GridOffHeapSnapTreeMap.isShrinkingOrUnlinked(rightOVL));
        this.shrinkOVL(n, GridOffHeapSnapTreeMap.beginChange(nodeOVL));
        this.shrinkOVL(nR, GridOffHeapSnapTreeMap.beginChange(rightOVL));
        this.right(n, nRLL);
        if (nRLL != 0L) {
            this.parent(nRLL, n);
        }
        this.left(nR, nRLR);
        if (nRLR != 0L) {
            this.parent(nRLR, nR);
        }
        this.right(nRL, nR);
        this.parent(nR, nRL);
        this.left(nRL, n);
        this.parent(n, nRL);
        if (nPL == n) {
            this.left(nParent, nRL);
        } else {
            this.right(nParent, nRL);
        }
        this.parent(nRL, nParent);
        int hNRepl = 1 + Math.max(hL, hRLL);
        this.height(n, hNRepl);
        int hRRepl = 1 + Math.max(hRLR, hRR);
        this.height(nR, hRRepl);
        this.height(nRL, 1 + Math.max(hNRepl, hRRepl));
        this.shrinkOVL(n, GridOffHeapSnapTreeMap.endChange(nodeOVL));
        this.shrinkOVL(nR, GridOffHeapSnapTreeMap.endChange(rightOVL));
        assert (Math.abs(hRR - hRLR) <= 1);
        int balN = hRLL - hL;
        if (balN < -1 || balN > 1) {
            return n;
        }
        if ((nRLL == 0L || hL == 0) && this.vOptIsNull(n)) {
            return n;
        }
        int balRL = hRRepl - hNRepl;
        if (balRL < -1 || balRL > 1) {
            return nRL;
        }
        return this.fixHeight_nl(nParent);
    }

    @Override
    public NavigableSet<K> keySet() {
        return this.navigableKeySet();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    @Override
    public NavigableSet<K> navigableKeySet() {
        return new KeySet(this){

            @Override
            public Iterator<GridOffHeapSmartPointer> iterator() {
                return new KeyIter(GridOffHeapSnapTreeMap.this);
            }
        };
    }

    @Override
    public NavigableSet<K> descendingKeySet() {
        return this.descendingMap().navigableKeySet();
    }

    @Override
    public ConcurrentNavigableMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        Comparable<K> fromCmp = this.comparable(fromKey);
        if (fromCmp.compareTo(toKey) > 0) {
            throw new IllegalArgumentException();
        }
        return new SubMap(this, (GridOffHeapSmartPointer)fromKey, fromCmp, fromInclusive, (GridOffHeapSmartPointer)toKey, this.comparable(toKey), toInclusive, false);
    }

    @Override
    public ConcurrentNavigableMap<K, V> headMap(K toKey, boolean inclusive) {
        return new SubMap(this, null, null, false, (GridOffHeapSmartPointer)toKey, this.comparable(toKey), inclusive, false);
    }

    @Override
    public ConcurrentNavigableMap<K, V> tailMap(K fromKey, boolean inclusive) {
        return new SubMap(this, (GridOffHeapSmartPointer)fromKey, this.comparable(fromKey), inclusive, null, null, false, false);
    }

    @Override
    public ConcurrentNavigableMap<K, V> subMap(K fromKey, K toKey) {
        return this.subMap(fromKey, true, toKey, false);
    }

    @Override
    public ConcurrentNavigableMap<K, V> headMap(K toKey) {
        return this.headMap(toKey, false);
    }

    @Override
    public ConcurrentNavigableMap<K, V> tailMap(K fromKey) {
        return this.tailMap(fromKey, true);
    }

    @Override
    public ConcurrentNavigableMap<K, V> descendingMap() {
        return new SubMap(this, null, null, false, null, null, false, true);
    }

    static class KeyLock {
        private final ConcurrentHashMap8<Object, Lock> m = new ConcurrentHashMap8();

        KeyLock() {
        }

        @Nullable
        public Lock lock(Object key) {
            Thread th = Thread.currentThread();
            Lock l = new Lock(key, th);
            Lock l2;
            while ((l2 = this.m.putIfAbsent(key, l)) != null) {
                if (l2.owner == th) {
                    return null;
                }
                try {
                    l2.await();
                }
                catch (InterruptedException e) {
                    throw new IllegalStateException(e);
                }
            }
            return l;
        }

        public class Lock {
            private final Object key;
            private final Thread owner;
            private final CountDownLatch latch = new CountDownLatch(1);

            private Lock(Object key, Thread owner) {
                this.key = key;
                this.owner = owner;
            }

            private void await() throws InterruptedException {
                this.latch.await();
            }

            public void unlock() {
                Lock l = (Lock)KeyLock.this.m.remove(this.key);
                assert (this.owner == Thread.currentThread());
                assert (l == this);
                this.latch.countDown();
            }
        }
    }

    private class SubMap
    extends AbstractMap<K, V>
    implements ConcurrentNavigableMap<K, V> {
        private final GridOffHeapSnapTreeMap<K, V> m;
        private final GridOffHeapSmartPointer minKey;
        private transient Comparable<? super K> minCmp;
        private final boolean minIncl;
        private final GridOffHeapSmartPointer maxKey;
        private transient Comparable<? super K> maxCmp;
        private final boolean maxIncl;
        private final boolean descending;

        private SubMap(GridOffHeapSnapTreeMap<K, V> m, GridOffHeapSmartPointer minKey, Comparable<? super K> minCmp, boolean minIncl, GridOffHeapSmartPointer maxKey, Comparable<? super K> maxCmp, boolean maxIncl, boolean descending) {
            this.m = m;
            this.minKey = minKey;
            this.minCmp = minCmp;
            this.minIncl = minIncl;
            this.maxKey = maxKey;
            this.maxCmp = maxCmp;
            this.maxIncl = maxIncl;
            this.descending = descending;
        }

        private boolean tooLow(K key) {
            if (this.minCmp == null) {
                return false;
            }
            int c = this.minCmp.compareTo(key);
            return c > 0 || c == 0 && !this.minIncl;
        }

        private boolean tooHigh(K key) {
            if (this.maxCmp == null) {
                return false;
            }
            int c = this.maxCmp.compareTo(key);
            return c < 0 || c == 0 && !this.maxIncl;
        }

        private boolean inRange(K key) {
            return !this.tooLow(key) && !this.tooHigh(key);
        }

        private void requireInRange(K key) {
            if (key == null) {
                throw new NullPointerException();
            }
            if (!this.inRange(key)) {
                throw new IllegalArgumentException();
            }
        }

        private char minDir() {
            return this.descending ? (char)'R' : 'L';
        }

        private char maxDir() {
            return this.descending ? (char)'L' : 'R';
        }

        @Override
        public boolean isEmpty() {
            return this.m.boundedExtreme(this.minCmp, this.minIncl, this.maxCmp, this.maxIncl, true, 'L') == null;
        }

        @Override
        public int size() {
            long root = GridOffHeapSnapTreeMap.this.right(this.m.holderRef);
            return GridOffHeapSnapTreeMap.this.computeFrozenSize(root, this.minCmp, this.minIncl, this.maxCmp, this.maxIncl);
        }

        @Override
        public boolean containsKey(Object key) {
            if (key == null) {
                throw new NullPointerException();
            }
            GridOffHeapSmartPointer k = (GridOffHeapSmartPointer)key;
            return this.inRange(k) && this.m.containsKey(k);
        }

        @Override
        public boolean containsValue(Object value) {
            return super.containsValue(value);
        }

        @Override
        public V get(Object key) {
            if (key == null) {
                throw new NullPointerException();
            }
            GridOffHeapSmartPointer k = (GridOffHeapSmartPointer)key;
            return !this.inRange(k) ? null : this.m.get(k);
        }

        @Override
        public V put(K key, V value) {
            this.requireInRange(key);
            return this.m.put(key, value);
        }

        @Override
        public V remove(Object key) {
            if (key == null) {
                throw new NullPointerException();
            }
            return !this.inRange((GridOffHeapSmartPointer)key) ? null : this.m.remove(key);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new EntrySubSet();
        }

        @Override
        public Comparator<? super K> comparator() {
            Comparator fromM = this.m.comparator();
            if (this.descending) {
                return Collections.reverseOrder(fromM);
            }
            return fromM;
        }

        @Override
        public K firstKey() {
            return this.m.boundedExtremeKeyOrThrow(this.minCmp, this.minIncl, this.maxCmp, this.maxIncl, this.minDir());
        }

        @Override
        public K lastKey() {
            return this.m.boundedExtremeKeyOrThrow(this.minCmp, this.minIncl, this.maxCmp, this.maxIncl, this.maxDir());
        }

        private K firstKeyOrNull() {
            return (GridOffHeapSmartPointer)this.m.boundedExtreme(this.minCmp, this.minIncl, this.maxCmp, this.maxIncl, true, this.minDir());
        }

        private K lastKeyOrNull() {
            return (GridOffHeapSmartPointer)this.m.boundedExtreme(this.minCmp, this.minIncl, this.maxCmp, this.maxIncl, true, this.maxDir());
        }

        private Map.Entry firstEntryOrNull() {
            return (Map.Entry)this.m.boundedExtreme(this.minCmp, this.minIncl, this.maxCmp, this.maxIncl, false, this.minDir());
        }

        private Map.Entry lastEntryOrNull() {
            return (Map.Entry)this.m.boundedExtreme(this.minCmp, this.minIncl, this.maxCmp, this.maxIncl, false, this.maxDir());
        }

        @Override
        public Map.Entry lowerEntry(K key) {
            if (key == null) {
                throw new NullPointerException();
            }
            if (!this.descending ? this.tooLow(key) : this.tooHigh(key)) {
                return null;
            }
            return ((!this.descending ? this.tooHigh(key) : this.tooLow(key)) ? this : this.subMapInRange(null, false, key, false)).lastEntryOrNull();
        }

        @Override
        public K lowerKey(K key) {
            if (key == null) {
                throw new NullPointerException();
            }
            if (!this.descending ? this.tooLow(key) : this.tooHigh(key)) {
                return null;
            }
            return ((!this.descending ? this.tooHigh(key) : this.tooLow(key)) ? this : this.subMapInRange(null, false, key, false)).lastKeyOrNull();
        }

        @Override
        public Map.Entry floorEntry(K key) {
            if (key == null) {
                throw new NullPointerException();
            }
            if (!this.descending ? this.tooLow(key) : this.tooHigh(key)) {
                return null;
            }
            return ((!this.descending ? this.tooHigh(key) : this.tooLow(key)) ? this : this.subMapInRange(null, false, key, true)).lastEntryOrNull();
        }

        @Override
        public K floorKey(K key) {
            if (key == null) {
                throw new NullPointerException();
            }
            if (!this.descending ? this.tooLow(key) : this.tooHigh(key)) {
                return null;
            }
            return ((!this.descending ? this.tooHigh(key) : this.tooLow(key)) ? this : this.subMapInRange(null, false, key, true)).lastKeyOrNull();
        }

        @Override
        public Map.Entry ceilingEntry(K key) {
            if (key == null) {
                throw new NullPointerException();
            }
            if (!this.descending ? this.tooHigh(key) : this.tooLow(key)) {
                return null;
            }
            return ((!this.descending ? this.tooLow(key) : this.tooHigh(key)) ? this : this.subMapInRange(key, true, null, false)).firstEntryOrNull();
        }

        @Override
        public K ceilingKey(K key) {
            if (key == null) {
                throw new NullPointerException();
            }
            if (!this.descending ? this.tooHigh(key) : this.tooLow(key)) {
                return null;
            }
            return ((!this.descending ? this.tooLow(key) : this.tooHigh(key)) ? this : this.subMapInRange(key, true, null, false)).firstKeyOrNull();
        }

        @Override
        public Map.Entry higherEntry(K key) {
            if (key == null) {
                throw new NullPointerException();
            }
            if (!this.descending ? this.tooHigh(key) : this.tooLow(key)) {
                return null;
            }
            return ((!this.descending ? this.tooLow(key) : this.tooHigh(key)) ? this : this.subMapInRange(key, false, null, false)).firstEntryOrNull();
        }

        @Override
        public K higherKey(K key) {
            if (key == null) {
                throw new NullPointerException();
            }
            if (!this.descending ? this.tooHigh(key) : this.tooLow(key)) {
                return null;
            }
            return ((!this.descending ? this.tooLow(key) : this.tooHigh(key)) ? this : this.subMapInRange(key, false, null, false)).firstKeyOrNull();
        }

        @Override
        public Map.Entry firstEntry() {
            return (Map.Entry)this.m.boundedExtreme(this.minCmp, this.minIncl, this.maxCmp, this.maxIncl, false, this.minDir());
        }

        @Override
        public Map.Entry lastEntry() {
            return (Map.Entry)this.m.boundedExtreme(this.minCmp, this.minIncl, this.maxCmp, this.maxIncl, false, this.maxDir());
        }

        @Override
        public Map.Entry pollFirstEntry() {
            Map.Entry snapshot;
            while ((snapshot = (Map.Entry)this.m.boundedExtreme(this.minCmp, this.minIncl, this.maxCmp, this.maxIncl, false, this.minDir())) != null && !this.m.remove(snapshot.getKey(), snapshot.getValue())) {
            }
            return snapshot;
        }

        @Override
        public Map.Entry pollLastEntry() {
            Map.Entry snapshot;
            while ((snapshot = (Map.Entry)this.m.boundedExtreme(this.minCmp, this.minIncl, this.maxCmp, this.maxIncl, false, this.maxDir())) != null && !this.m.remove(snapshot.getKey(), snapshot.getValue())) {
            }
            return snapshot;
        }

        @Override
        public V putIfAbsent(K key, V value) {
            this.requireInRange(key);
            return this.m.putIfAbsent(key, value);
        }

        @Override
        public boolean remove(Object key, Object value) {
            return this.inRange((GridOffHeapSmartPointer)key) && this.m.remove(key, value);
        }

        @Override
        public boolean replace(K key, V oldValue, V newValue) {
            this.requireInRange(key);
            return this.m.replace(key, oldValue, newValue);
        }

        @Override
        public V replace(K key, V value) {
            this.requireInRange(key);
            return this.m.replace(key, value);
        }

        public SubMap subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
            if (fromKey == null || toKey == null) {
                throw new NullPointerException();
            }
            return this.subMapImpl(fromKey, fromInclusive, toKey, toInclusive);
        }

        public SubMap headMap(K toKey, boolean inclusive) {
            if (toKey == null) {
                throw new NullPointerException();
            }
            return this.subMapImpl(null, false, toKey, inclusive);
        }

        public SubMap tailMap(K fromKey, boolean inclusive) {
            if (fromKey == null) {
                throw new NullPointerException();
            }
            return this.subMapImpl(fromKey, inclusive, null, false);
        }

        public SubMap subMap(K fromKey, K toKey) {
            return this.subMap((K)fromKey, true, (K)toKey, false);
        }

        public SubMap headMap(K toKey) {
            return this.headMap((K)toKey, false);
        }

        public SubMap tailMap(K fromKey) {
            return this.tailMap((K)fromKey, true);
        }

        private SubMap subMapImpl(K fromKey, boolean fromIncl, K toKey, boolean toIncl) {
            if (fromKey != null) {
                this.requireInRange(fromKey);
            }
            if (toKey != null) {
                this.requireInRange(toKey);
            }
            return this.subMapInRange(fromKey, fromIncl, toKey, toIncl);
        }

        private SubMap subMapInRange(K fromKey, boolean fromIncl, K toKey, boolean toIncl) {
            Comparable toCmp;
            Comparable fromCmp = fromKey == null ? null : this.m.comparable(fromKey);
            Comparable comparable = toCmp = toKey == null ? null : this.m.comparable(toKey);
            if (fromKey != null && toKey != null) {
                int c = fromCmp.compareTo(toKey);
                if (!this.descending ? c > 0 : c < 0) {
                    throw new IllegalArgumentException();
                }
            }
            GridOffHeapSmartPointer minK = this.minKey;
            Comparable<Object> minC = this.minCmp;
            boolean minI = this.minIncl;
            GridOffHeapSmartPointer maxK = this.maxKey;
            Comparable<Object> maxC = this.maxCmp;
            boolean maxI = this.maxIncl;
            if (fromKey != null) {
                if (!this.descending) {
                    minK = fromKey;
                    minC = fromCmp;
                    minI = fromIncl;
                } else {
                    maxK = fromKey;
                    maxC = fromCmp;
                    maxI = fromIncl;
                }
            }
            if (toKey != null) {
                if (!this.descending) {
                    maxK = toKey;
                    maxC = toCmp;
                    maxI = toIncl;
                } else {
                    minK = toKey;
                    minC = toCmp;
                    minI = toIncl;
                }
            }
            return new SubMap(this.m, minK, minC, minI, maxK, maxC, maxI, this.descending);
        }

        @Override
        public SubMap descendingMap() {
            return new SubMap(this.m, this.minKey, this.minCmp, this.minIncl, this.maxKey, this.maxCmp, this.maxIncl, !this.descending);
        }

        @Override
        public NavigableSet<K> keySet() {
            return this.navigableKeySet();
        }

        @Override
        public NavigableSet<K> navigableKeySet() {
            return new KeySet(this){

                @Override
                public Iterator<GridOffHeapSmartPointer> iterator() {
                    return new KeyIter(SubMap.this.m, SubMap.this.minCmp, SubMap.this.minIncl, SubMap.this.maxCmp, SubMap.this.maxIncl, SubMap.this.descending);
                }
            };
        }

        @Override
        public NavigableSet<K> descendingKeySet() {
            return this.descendingMap().navigableKeySet();
        }

        private class EntrySubSet
        extends AbstractSet<Map.Entry<K, V>> {
            private EntrySubSet() {
            }

            @Override
            public int size() {
                return SubMap.this.size();
            }

            @Override
            public boolean isEmpty() {
                return SubMap.this.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Object k = ((Map.Entry)o).getKey();
                if (!SubMap.this.inRange((GridOffHeapSmartPointer)k)) {
                    return false;
                }
                Object v = ((Map.Entry)o).getValue();
                GridOffHeapSmartPointer actual = SubMap.this.m.getImpl((GridOffHeapSmartPointer)k);
                if (actual == null) {
                    return false;
                }
                return v.equals(actual);
            }

            @Override
            public boolean add(Map.Entry<K, V> e) {
                SubMap.this.requireInRange((GridOffHeapSmartPointer)e.getKey());
                GridOffHeapSmartPointer v = (GridOffHeapSmartPointer)e.getValue();
                if (v == null) {
                    throw new NullPointerException();
                }
                return !v.equals(SubMap.this.m.update((GridOffHeapSmartPointer)e.getKey(), 0, null, v));
            }

            @Override
            public boolean remove(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Object k = ((Map.Entry)o).getKey();
                Object v = ((Map.Entry)o).getValue();
                return SubMap.this.remove(k, v);
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new EntryIter(SubMap.this.m, SubMap.this.minCmp, SubMap.this.minIncl, SubMap.this.maxCmp, SubMap.this.maxIncl, SubMap.this.descending);
            }
        }
    }

    private static abstract class KeySet<K>
    extends AbstractSet<K>
    implements NavigableSet<K> {
        private final ConcurrentNavigableMap<K, ?> map;

        protected KeySet(ConcurrentNavigableMap<K, ?> map) {
            this.map = map;
        }

        @Override
        public boolean contains(Object o) {
            return this.map.containsKey(o);
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public boolean remove(Object o) {
            return this.map.remove(o) != null;
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.map.comparator();
        }

        @Override
        public K first() {
            return this.map.firstKey();
        }

        @Override
        public K last() {
            return this.map.lastKey();
        }

        @Override
        public K lower(K k) {
            return this.map.lowerKey(k);
        }

        @Override
        public K floor(K k) {
            return this.map.floorKey(k);
        }

        @Override
        public K ceiling(K k) {
            return this.map.ceilingKey(k);
        }

        @Override
        public K higher(K k) {
            return this.map.higherKey(k);
        }

        @Override
        public K pollFirst() {
            return this.map.pollFirstEntry().getKey();
        }

        @Override
        public K pollLast() {
            return this.map.pollLastEntry().getKey();
        }

        @Override
        public NavigableSet<K> descendingSet() {
            return this.map.descendingKeySet();
        }

        @Override
        public Iterator<K> descendingIterator() {
            return this.map.descendingKeySet().iterator();
        }

        @Override
        public NavigableSet<K> subSet(K fromElement, boolean minInclusive, K toElement, boolean maxInclusive) {
            return this.map.subMap((Object)fromElement, minInclusive, (Object)toElement, maxInclusive).keySet();
        }

        @Override
        public NavigableSet<K> headSet(K toElement, boolean inclusive) {
            return this.map.headMap((Object)toElement, inclusive).keySet();
        }

        @Override
        public NavigableSet<K> tailSet(K fromElement, boolean inclusive) {
            return this.map.tailMap((Object)fromElement, inclusive).keySet();
        }

        @Override
        public SortedSet<K> subSet(K fromElement, K toElement) {
            return this.map.subMap((Object)fromElement, (Object)toElement).keySet();
        }

        @Override
        public SortedSet<K> headSet(K toElement) {
            return this.map.headMap((Object)toElement).keySet();
        }

        @Override
        public SortedSet<K> tailSet(K fromElement) {
            return this.map.tailMap((Object)fromElement).keySet();
        }
    }

    private class AbstractIter {
        private final GridOffHeapSnapTreeMap m;
        private final boolean descending;
        private final char forward;
        private final char reverse;
        private long[] path;
        private int depth = 0;
        private long mostRecentNode;
        private final GridOffHeapSmartPointer endKey;
        private final long rootHolderSnapshot;

        AbstractIter(GridOffHeapSnapTreeMap m) {
            this.m = m;
            this.descending = false;
            this.forward = (char)82;
            this.reverse = (char)76;
            this.rootHolderSnapshot = m.holderRef;
            long root = GridOffHeapSnapTreeMap.this.right(this.rootHolderSnapshot);
            this.path = new long[1 + GridOffHeapSnapTreeMap.this.height(root)];
            this.endKey = null;
            this.pushFirst(root);
        }

        AbstractIter(GridOffHeapSnapTreeMap m, Comparable<? super K> minCmp, boolean minIncl, Comparable<? super K> maxCmp, boolean maxIncl, boolean descending) {
            Comparable<Object> toCmp;
            Comparable fromCmp;
            boolean toIncl;
            this.m = m;
            this.descending = descending;
            this.forward = (char)(!descending ? 82 : 76);
            this.reverse = (char)(!descending ? 76 : 82);
            boolean fromIncl = !descending ? minIncl : maxIncl;
            boolean bl = toIncl = !descending ? maxIncl : minIncl;
            if (!descending) {
                fromCmp = minCmp;
                toCmp = maxCmp;
            } else {
                fromCmp = maxCmp;
                toCmp = minCmp;
            }
            this.rootHolderSnapshot = m.holderRef;
            long root = GridOffHeapSnapTreeMap.this.right(this.rootHolderSnapshot);
            if (toCmp != null) {
                this.endKey = (GridOffHeapSmartPointer)m.boundedExtreme(minCmp, minIncl, maxCmp, maxIncl, true, this.forward);
                if (this.endKey == null) {
                    return;
                }
            } else {
                this.endKey = null;
            }
            this.path = new long[1 + GridOffHeapSnapTreeMap.this.height(root)];
            if (fromCmp == null) {
                this.pushFirst(root);
            } else {
                this.pushFirst(root, fromCmp, fromIncl);
                if (this.depth > 0 && GridOffHeapSnapTreeMap.this.vOptIsNull(this.top())) {
                    this.advance();
                }
            }
        }

        private int cmp(Comparable<? super K> comparable, K key) {
            int c = comparable.compareTo(key);
            if (!this.descending) {
                return c;
            }
            return c == Integer.MIN_VALUE ? 1 : -c;
        }

        private void pushFirst(long node) {
            while (node != 0L) {
                this.path(node);
                node = GridOffHeapSnapTreeMap.this.child(node, this.reverse);
            }
        }

        private void path(long node) {
            if (this.depth == this.path.length) {
                this.path = Arrays.copyOf(this.path, this.depth + 2);
            }
            this.path[this.depth++] = node;
        }

        private void pushFirst(long node, Comparable<? super K> fromCmp, boolean fromIncl) {
            while (node != 0L) {
                int c = this.cmp(fromCmp, GridOffHeapSnapTreeMap.this.key(node));
                if (c > 0 || c == 0 && !fromIncl) {
                    node = GridOffHeapSnapTreeMap.this.child(node, this.forward);
                    continue;
                }
                this.path(node);
                if (c == 0) {
                    return;
                }
                node = GridOffHeapSnapTreeMap.this.child(node, this.reverse);
            }
        }

        private long top() {
            return this.path[this.depth - 1];
        }

        private void advance() {
            do {
                long t = this.top();
                if (this.endKey != null && this.endKey.equals(GridOffHeapSnapTreeMap.this.key(t))) {
                    this.depth = 0;
                    this.path = null;
                    return;
                }
                long fwd = GridOffHeapSnapTreeMap.this.child(t, this.forward);
                if (fwd != 0L) {
                    this.pushFirst(fwd);
                } else {
                    long popped;
                    do {
                        popped = this.path[--this.depth];
                    } while (this.depth > 0 && popped == GridOffHeapSnapTreeMap.this.child(this.top(), this.forward));
                }
                if (this.depth != 0) continue;
                this.path = null;
                return;
            } while (GridOffHeapSnapTreeMap.this.vOptIsNull(this.top()));
        }

        public boolean hasNext() {
            return this.depth > 0;
        }

        long nextNode() {
            if (this.depth == 0) {
                throw new NoSuchElementException();
            }
            this.mostRecentNode = this.top();
            this.advance();
            return this.mostRecentNode;
        }

        public void remove() {
            if (this.mostRecentNode == 0L) {
                throw new IllegalStateException();
            }
            this.m.remove(GridOffHeapSnapTreeMap.this.key(this.mostRecentNode));
            this.mostRecentNode = 0L;
        }
    }

    private class KeyIter
    extends AbstractIter
    implements Iterator<GridOffHeapSmartPointer> {
        private KeyIter(GridOffHeapSnapTreeMap m) {
            super(m);
        }

        private KeyIter(GridOffHeapSnapTreeMap m, Comparable<? super K> minCmp, boolean minIncl, Comparable<? super K> maxCmp, boolean maxIncl, boolean descending) {
            super(m, minCmp, minIncl, maxCmp, maxIncl, descending);
        }

        @Override
        public GridOffHeapSmartPointer next() {
            return GridOffHeapSnapTreeMap.this.key(this.nextNode());
        }
    }

    private class EntryIter
    extends AbstractIter
    implements Iterator<Map.Entry<K, V>> {
        private EntryIter(GridOffHeapSnapTreeMap m) {
            super(m);
        }

        private EntryIter(GridOffHeapSnapTreeMap m, Comparable<? super K> minCmp, boolean minIncl, Comparable<? super K> maxCmp, boolean maxIncl, boolean descending) {
            super(m, minCmp, minIncl, maxCmp, maxIncl, descending);
        }

        @Override
        public Map.Entry next() {
            return new Entree(this.nextNode());
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public int size() {
            return GridOffHeapSnapTreeMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return GridOffHeapSnapTreeMap.this.isEmpty();
        }

        @Override
        public void clear() {
            GridOffHeapSnapTreeMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Object k = ((Map.Entry)o).getKey();
            Object v = ((Map.Entry)o).getValue();
            GridOffHeapSmartPointer actual = GridOffHeapSnapTreeMap.this.getImpl((GridOffHeapSmartPointer)k);
            if (actual == null) {
                return false;
            }
            return v.equals(actual);
        }

        @Override
        public boolean add(Map.Entry<K, V> e) {
            GridOffHeapSmartPointer v = (GridOffHeapSmartPointer)e.getValue();
            if (v == null) {
                throw new NullPointerException();
            }
            return !v.equals(GridOffHeapSnapTreeMap.this.update((GridOffHeapSmartPointer)e.getKey(), 0, null, v));
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Object k = ((Map.Entry)o).getKey();
            Object v = ((Map.Entry)o).getValue();
            return GridOffHeapSnapTreeMap.this.remove(k, v);
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIter(GridOffHeapSnapTreeMap.this);
        }
    }

    private class StoppableRecycleQueue
    extends RecycleQueue {
        protected final ReentrantReadWriteLock lock;
        private boolean stopped;

        private StoppableRecycleQueue() {
            this.lock = new ReentrantReadWriteLock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean add(long node) {
            ReentrantReadWriteLock.ReadLock l = this.lock.readLock();
            if (!l.tryLock()) {
                return false;
            }
            try {
                boolean bl = !this.stopped && super.add(node);
                return bl;
            }
            finally {
                l.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean add(RecycleQueue que) {
            ReentrantReadWriteLock.ReadLock l = this.lock.readLock();
            if (!l.tryLock()) {
                return false;
            }
            try {
                boolean bl = !this.stopped && super.add(que);
                return bl;
            }
            finally {
                l.unlock();
            }
        }

        @Override
        public void merge(GridUnsafeCompoundMemory compound) {
            boolean res = super.add((RecycleQueue)compound);
            assert (res);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean stop() {
            ReentrantReadWriteLock.WriteLock l = this.lock.writeLock();
            l.lock();
            try {
                if (this.stopped) {
                    boolean bl = false;
                    return bl;
                }
                this.stopped = true;
                boolean bl = true;
                return bl;
            }
            finally {
                l.unlock();
            }
        }
    }

    private class RecycleQueue
    implements GridUnsafeCompoundMemory {
        private volatile long tail;
        protected final AtomicLong head = new AtomicLong(Long.MAX_VALUE);
        protected final AtomicLong size = new AtomicLong();

        private RecycleQueue() {
        }

        long size() {
            return this.size.get();
        }

        boolean add(long node) {
            assert (node > 0L);
            return this.add(node, node, 1L);
        }

        @Override
        public void merge(GridUnsafeCompoundMemory compound) {
            boolean res = this.add((RecycleQueue)compound);
            assert (res);
        }

        public boolean add(RecycleQueue q) {
            assert (!q.isEmpty());
            long node = q.head.get();
            long tail = q.tail;
            long size = q.size();
            assert (node > 0L);
            assert (tail > 0L);
            assert (size > 0L);
            return this.add(node, tail, size);
        }

        protected boolean add(long node, long tail, long size) {
            long h;
            do {
                h = this.head.get();
                assert (h > 0L) : h;
                GridOffHeapSnapTreeMap.this.writeLink(tail, h);
            } while (!this.head.compareAndSet(h, node));
            if (h == Long.MAX_VALUE) {
                this.tail = tail;
            }
            this.size.addAndGet(size);
            return true;
        }

        boolean isEmpty() {
            return this.head.get() == Long.MAX_VALUE;
        }

        @Override
        public void deallocate() {
            long h = this.head.get();
            while (h != Long.MAX_VALUE) {
                assert (h > 0L) : h;
                GridOffHeapSmartPointer k = GridOffHeapSnapTreeMap.this.key(h);
                if (k != null) {
                    k.decrementRefCount();
                    GridOffHeapSmartPointer v = GridOffHeapSnapTreeMap.this.vOpt(h);
                    if (v != null) {
                        v.decrementRefCount();
                    }
                }
                long prev = h;
                h = GridOffHeapSnapTreeMap.this.readLink(h);
                GridOffHeapSnapTreeMap.this.mem.release(prev, 56L);
            }
        }
    }

    private class Entree
    implements Map.Entry<K, V> {
        private final long ptr;

        private Entree(long ptr) {
            this.ptr = ptr;
        }

        @Override
        public K getKey() {
            return GridOffHeapSnapTreeMap.this.key(this.ptr);
        }

        @Override
        public V getValue() {
            return GridOffHeapSnapTreeMap.this.vOpt(this.ptr);
        }

        @Override
        public GridOffHeapSmartPointer setValue(GridOffHeapSmartPointer v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry rhs = (Map.Entry)o;
            return GridOffHeapSnapTreeMap.this.key(this.ptr).equals(rhs.getKey()) && this.getValue().equals(rhs.getValue());
        }

        @Override
        public int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }

        public String toString() {
            return GridOffHeapSnapTreeMap.this.key(this.ptr) + "=" + this.getValue();
        }
    }

    private static class LongArray {
        private long[] arr;
        private int idx = 0;

        private LongArray() {
        }

        public void add(long x) {
            if (this.arr == null) {
                this.arr = new long[4];
            } else if (this.arr.length == this.idx) {
                this.arr = Arrays.copyOf(this.arr, this.arr.length * 2);
            }
            this.arr[this.idx++] = x;
        }
    }
}

