/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.offheap.unsafe;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.ignite.internal.util.offheap.unsafe.GridUnsafeCompoundMemory;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;

public class GridUnsafeGuard {
    @GridToStringInclude
    private final AtomicReference<Operation> head = new AtomicReference();
    @GridToStringInclude
    private final AtomicReference<Operation> tail = new AtomicReference();
    @GridToStringExclude
    private final ThreadLocal<Operation> currOp = new ThreadLocal();

    public GridUnsafeGuard() {
        Operation fake = new Operation();
        fake.allowDeallocate();
        this.head.set(fake);
        this.tail.set(fake);
    }

    public void begin() {
        Operation prev;
        Operation op = this.currOp.get();
        if (op != null) {
            op.reentries++;
            return;
        }
        op = new Operation();
        this.currOp.set(op);
        do {
            prev = this.head.get();
            op.previous(prev);
        } while (!this.head.compareAndSet(prev, op));
        prev.next(op);
    }

    public void end() {
        Operation t;
        int state;
        Operation op = this.currOp.get();
        assert (op != null) : "must be called after begin in the same thread";
        if (op.reentries != 0) {
            assert (op.reentries > 0) : Operation.access$200(op);
            op.reentries--;
            return;
        }
        this.currOp.remove();
        op.allowDeallocate();
        op = this.tail.get();
        while ((state = op.state) != 0) {
            Operation next;
            if (state == 1) {
                op.finish();
            }
            if ((next = op.next) == null) break;
            op = next;
        }
        do {
            t = this.tail.get();
        } while (op.id > t.id && !this.tail.compareAndSet(t, op));
    }

    public void releaseLater(GridUnsafeCompoundMemory compound) {
        assert (this.currOp.get() != null) : "must be called in begin-end block";
        this.head.get().add(compound);
    }

    public void finalizeLater(Runnable finalizer) {
        assert (this.currOp.get() != null) : "must be called in begin-end block";
        this.head.get().add(new Finalizer(finalizer));
    }

    public String toString() {
        return S.toString(GridUnsafeGuard.class, this, "currOp", this.currOp.get());
    }

    private static class Finalizer {
        private Finalizer prev;
        private final Runnable delegate;

        private Finalizer(Runnable delegate) {
            assert (delegate != null);
            this.delegate = delegate;
        }

        private Finalizer previous() {
            return this.prev;
        }

        private void previous(Finalizer prev) {
            this.prev = prev;
        }

        private void run() {
            this.delegate.run();
        }

        public String toString() {
            return S.toString(Finalizer.class, this);
        }
    }

    private static class Operation {
        private static final int STATE_ACTIVE = 0;
        private static final int STATE_MAY_DEALLOCATE = 1;
        private static final int STATE_DEALLOCATED = 2;
        private static final AtomicReferenceFieldUpdater<Operation, Finalizer> finUpdater = AtomicReferenceFieldUpdater.newUpdater(Operation.class, Finalizer.class, "finHead");
        private static final AtomicReferenceFieldUpdater<Operation, GridUnsafeCompoundMemory> compoundUpdater = AtomicReferenceFieldUpdater.newUpdater(Operation.class, GridUnsafeCompoundMemory.class, "compound");
        private static final AtomicIntegerFieldUpdater<Operation> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(Operation.class, "state");
        private long id;
        private int reentries;
        private volatile int state;
        private volatile Finalizer finHead;
        private volatile GridUnsafeCompoundMemory compound;
        @GridToStringExclude
        private volatile Operation next;

        private Operation() {
        }

        private void add(Finalizer fin) {
            Finalizer prev;
            do {
                prev = this.finHead;
                fin.previous(prev);
            } while (!finUpdater.compareAndSet(this, prev, fin));
        }

        private void finish() {
            Finalizer fin;
            if (!stateUpdater.compareAndSet(this, 1, 2)) {
                return;
            }
            GridUnsafeCompoundMemory c = this.compound;
            if (c != null) {
                c.deallocate();
                compoundUpdater.lazySet(this, null);
            }
            if ((fin = this.finHead) != null) {
                finUpdater.lazySet(this, null);
                do {
                    fin.run();
                } while ((fin = fin.previous()) != null);
            }
        }

        private boolean deallocated() {
            return this.state == 2;
        }

        private void add(GridUnsafeCompoundMemory c) {
            GridUnsafeCompoundMemory existing = this.compound;
            if (existing == null) {
                if (compoundUpdater.compareAndSet(this, null, c)) {
                    return;
                }
                existing = this.compound;
            }
            existing.merge(c);
        }

        private void previous(Operation prev) {
            this.id = prev.id + 1L;
        }

        private void allowDeallocate() {
            stateUpdater.lazySet(this, 1);
        }

        private void next(Operation next) {
            this.next = next;
        }

        public String toString() {
            Operation next0 = this.next;
            return S.toString(Operation.class, this, "identity", System.identityHashCode(this), "next", next0 == null ? null : (Math.random() < 0.03 ? "other..." : next0));
        }
    }
}

