/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.offheap.unsafe;

import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.util.GridCloseableIteratorAdapter;
import org.apache.ignite.internal.util.lang.GridCloseableIterator;
import org.apache.ignite.internal.util.offheap.GridOffHeapEventListener;
import org.apache.ignite.internal.util.offheap.GridOffHeapEvictListener;
import org.apache.ignite.internal.util.offheap.GridOffHeapMap;
import org.apache.ignite.internal.util.offheap.GridOffHeapPartitionedMap;
import org.apache.ignite.internal.util.offheap.unsafe.GridUnsafeLru;
import org.apache.ignite.internal.util.offheap.unsafe.GridUnsafeLruPoller;
import org.apache.ignite.internal.util.offheap.unsafe.GridUnsafeMap;
import org.apache.ignite.internal.util.offheap.unsafe.GridUnsafeMemory;
import org.apache.ignite.internal.util.typedef.CX2;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteBiTuple;
import org.jetbrains.annotations.Nullable;
import org.jsr166.LongAdder8;

public class GridUnsafePartitionedMap
implements GridOffHeapPartitionedMap {
    private static final int MIN_SEGMENT_CONCURRENCY = 4;
    private final GridUnsafeMap[] partMap;
    private final GridUnsafeMemory mem;
    private GridOffHeapEvictListener evictLsnr;
    private GridOffHeapEventListener evtLsnr;
    private final GridUnsafeLru lru;
    private final int concurrency;
    private final float load;
    private final int parts;
    private final LongAdder8 totalCnt = new LongAdder8();

    public GridUnsafePartitionedMap(int parts, int concurrency, float load, long initCap, long totalMem, short lruStripes, @Nullable GridOffHeapEvictListener evictLsnr) {
        this.parts = parts;
        this.concurrency = concurrency;
        this.load = load;
        this.partMap = new GridUnsafeMap[parts];
        this.mem = new GridUnsafeMemory(totalMem);
        if (totalMem > 0L) {
            this.evictLsnr = evictLsnr;
        }
        this.lru = totalMem > 0L ? new GridUnsafeLru(lruStripes, this.mem) : null;
        long cnt = initCap / (long)parts;
        int mod = (int)(initCap % (long)parts);
        if ((concurrency /= parts) < 4) {
            concurrency = 4;
        }
        for (int p = 0; p < parts; ++p) {
            long init = --mod >= 0 ? cnt + 1L : cnt;
            this.partMap[p] = new GridUnsafeMap(p, concurrency, load, init, this.totalCnt, this.mem, this.lru, evictLsnr, new GridUnsafeLruPoller(){

                @Override
                public void lruPoll(int size) {
                    int released;
                    if (GridUnsafePartitionedMap.this.lru == null) {
                        return;
                    }
                    for (int left = size; left > 0; left -= released) {
                        long qAddr = GridUnsafePartitionedMap.this.lru.prePoll();
                        if (qAddr == 0L) {
                            return;
                        }
                        short order = GridUnsafePartitionedMap.this.lru.order(qAddr);
                        int part = GridUnsafePartitionedMap.this.lru.partition(order, qAddr);
                        released = GridUnsafePartitionedMap.this.partMap[part].freeSpace(order, qAddr);
                        if (released != 0) continue;
                        return;
                    }
                }
            });
        }
    }

    @Override
    public float loadFactor() {
        return this.load;
    }

    @Override
    public int concurrency() {
        return this.concurrency;
    }

    @Override
    public int partitions() {
        return this.parts;
    }

    private GridOffHeapMap mapFor(int p) {
        assert (p < this.parts);
        return this.partMap[p];
    }

    @Override
    public boolean contains(int part, int hash, byte[] keyBytes) {
        return this.mapFor(part).contains(hash, keyBytes);
    }

    @Override
    public byte[] get(int p, int hash, byte[] keyBytes) {
        return this.mapFor(p).get(hash, keyBytes);
    }

    @Override
    public IgniteBiTuple<Long, Integer> valuePointer(int p, int hash, byte[] keyBytes) {
        return this.mapFor(p).valuePointer(hash, keyBytes);
    }

    @Override
    public void enableEviction(int p, int hash, byte[] keyBytes) {
        if (this.lru == null) {
            return;
        }
        this.mapFor(p).enableEviction(hash, keyBytes);
    }

    @Override
    public byte[] remove(int p, int hash, byte[] keyBytes) {
        return this.mapFor(p).remove(hash, keyBytes);
    }

    @Override
    public boolean removex(int p, int hash, byte[] keyBytes) {
        return this.mapFor(p).removex(hash, keyBytes);
    }

    @Override
    public boolean removex(int part, int hash, byte[] keyBytes, IgniteBiPredicate<Long, Integer> p) {
        return this.mapFor(part).removex(hash, keyBytes, p);
    }

    @Override
    public boolean put(int p, int hash, byte[] keyBytes, byte[] valBytes) {
        return this.mapFor(p).put(hash, keyBytes, valBytes);
    }

    @Override
    public void insert(int p, int hash, byte[] keyBytes, byte[] valBytes) {
        this.mapFor(p).insert(hash, keyBytes, valBytes);
    }

    @Override
    public long size() {
        return this.totalCnt.sum();
    }

    @Override
    public long size(Set<Integer> parts) {
        int cnt = 0;
        for (Integer part : parts) {
            cnt = (int)((long)cnt + this.mapFor(part).size());
        }
        return cnt;
    }

    @Override
    public long memorySize() {
        return this.mem.totalSize();
    }

    @Override
    public long allocatedSize() {
        return this.mem.allocatedSize();
    }

    @Override
    public long systemAllocatedSize() {
        return this.mem.systemAllocatedSize();
    }

    @Override
    public long freeSize() {
        return this.mem.freeSize();
    }

    @Override
    public boolean eventListener(GridOffHeapEventListener evtLsnr) {
        if (this.evtLsnr != null) {
            return false;
        }
        this.evtLsnr = evtLsnr;
        for (GridUnsafeMap m : this.partMap) {
            m.eventListener(evtLsnr);
        }
        this.mem.listen(evtLsnr);
        return true;
    }

    @Override
    public boolean evictListener(GridOffHeapEvictListener evictLsnr) {
        if (this.evictLsnr != null) {
            return false;
        }
        this.evictLsnr = evictLsnr;
        for (GridUnsafeMap m : this.partMap) {
            m.evictListener(evictLsnr);
        }
        return true;
    }

    @Override
    public void destruct() {
        for (GridUnsafeMap m : this.partMap) {
            m.destruct();
        }
        if (this.lru != null) {
            this.lru.destruct();
        }
    }

    @Override
    public GridCloseableIterator<IgniteBiTuple<byte[], byte[]>> iterator() {
        return new PartitionedMapCloseableIterator<IgniteBiTuple<byte[], byte[]>>(){

            @Override
            protected void advance() throws IgniteCheckedException {
                this.curIt = null;
                while (this.p < GridUnsafePartitionedMap.this.parts) {
                    this.curIt = GridUnsafePartitionedMap.this.mapFor(this.p++).iterator();
                    if (this.curIt.hasNext()) {
                        return;
                    }
                    this.curIt.close();
                }
                this.curIt = null;
            }
        };
    }

    @Override
    public <T> GridCloseableIterator<T> iterator(final CX2<T2<Long, Integer>, T2<Long, Integer>, T> c) {
        assert (c != null);
        return new PartitionedMapCloseableIterator<T>(){

            @Override
            protected void advance() throws IgniteCheckedException {
                this.curIt = null;
                while (this.p < GridUnsafePartitionedMap.this.parts) {
                    this.curIt = GridUnsafePartitionedMap.this.mapFor(this.p++).iterator(c);
                    if (this.curIt.hasNext()) {
                        return;
                    }
                    this.curIt.close();
                }
                this.curIt = null;
            }
        };
    }

    @Override
    public <T> GridCloseableIterator<T> iterator(CX2<T2<Long, Integer>, T2<Long, Integer>, T> c, int part) {
        return this.mapFor(part).iterator(c);
    }

    @Override
    public GridCloseableIterator<IgniteBiTuple<byte[], byte[]>> iterator(int p) {
        return this.mapFor(p).iterator();
    }

    public short lruStripes() {
        return this.lru.concurrency();
    }

    public long lruMemorySize() {
        return this.lru.memorySize();
    }

    public long lruSize() {
        return this.lru.size();
    }

    private abstract class PartitionedMapCloseableIterator<T>
    extends GridCloseableIteratorAdapter<T> {
        protected int p;
        protected GridCloseableIterator<T> curIt;

        private PartitionedMapCloseableIterator() {
            try {
                this.advance();
            }
            catch (IgniteCheckedException e) {
                e.printStackTrace();
            }
        }

        abstract void advance() throws IgniteCheckedException;

        @Override
        protected T onNext() throws IgniteCheckedException {
            if (this.curIt == null) {
                throw new NoSuchElementException();
            }
            Object t = this.curIt.next();
            if (!this.curIt.hasNext()) {
                this.curIt.close();
                this.advance();
            }
            return (T)t;
        }

        @Override
        protected boolean onHasNext() {
            return this.curIt != null;
        }

        @Override
        protected void onRemove() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void onClose() throws IgniteCheckedException {
            if (this.curIt != null) {
                this.curIt.close();
            }
        }
    }
}

