/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.tostring;

import java.io.Externalizable;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.util.tostring.GridToStringClassDescriptor;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringFieldDescriptor;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.tostring.GridToStringOrder;
import org.apache.ignite.internal.util.tostring.GridToStringThreadLocal;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class GridToStringBuilder {
    private static final Map<String, GridToStringClassDescriptor> classCache = new HashMap<String, GridToStringClassDescriptor>();
    private static final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    public static final int MAX_COL_SIZE = 100;
    public static final boolean INCLUDE_SENSITIVE = IgniteSystemProperties.getBoolean("IGNITE_TO_STRING_INCLUDE_SENSITIVE", true);
    private static ThreadLocal<Queue<GridToStringThreadLocal>> threadCache = new ThreadLocal<Queue<GridToStringThreadLocal>>(){

        @Override
        protected Queue<GridToStringThreadLocal> initialValue() {
            LinkedList<GridToStringThreadLocal> queue = new LinkedList<GridToStringThreadLocal>();
            queue.offer(new GridToStringThreadLocal());
            return queue;
        }
    };

    public static <T> String toString(Class<T> cls, T obj, String name0, Object val0, String name1, Object val1, String name2, Object val2, String name3, Object val3, String name4, Object val4) {
        return GridToStringBuilder.toString(cls, obj, name0, val0, false, name1, val1, false, name2, val2, false, name3, val3, false, name4, val4, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> String toString(Class<T> cls, T obj, String name0, Object val0, boolean sens0, String name1, Object val1, boolean sens1, String name2, Object val2, boolean sens2, String name3, Object val3, boolean sens3, String name4, Object val4, boolean sens4) {
        assert (cls != null);
        assert (obj != null);
        assert (name0 != null);
        assert (name1 != null);
        assert (name2 != null);
        assert (name3 != null);
        assert (name4 != null);
        Queue<GridToStringThreadLocal> queue = threadCache.get();
        assert (queue != null);
        GridToStringThreadLocal tmp = queue.isEmpty() ? new GridToStringThreadLocal() : queue.remove();
        Object[] addNames = tmp.getAdditionalNames();
        Object[] addVals = tmp.getAdditionalValues();
        boolean[] addSens = tmp.getAdditionalSensitives();
        addNames[0] = name0;
        addVals[0] = val0;
        addSens[0] = sens0;
        addNames[1] = name1;
        addVals[1] = val1;
        addSens[1] = sens1;
        addNames[2] = name2;
        addVals[2] = val2;
        addSens[2] = sens2;
        addNames[3] = name3;
        addVals[3] = val3;
        addSens[3] = sens3;
        addNames[4] = name4;
        addVals[4] = val4;
        addSens[4] = sens4;
        try {
            String string = GridToStringBuilder.toStringImpl(cls, tmp.getStringBuilder(), obj, addNames, addVals, addSens, 5);
            return string;
        }
        finally {
            queue.offer(tmp);
        }
    }

    public static <T> String toString(Class<T> cls, T obj, String name0, Object val0, String name1, Object val1, String name2, Object val2, String name3, Object val3) {
        return GridToStringBuilder.toString(cls, obj, name0, val0, false, name1, val1, false, name2, val2, false, name3, val3, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> String toString(Class<T> cls, T obj, String name0, Object val0, boolean sens0, String name1, Object val1, boolean sens1, String name2, Object val2, boolean sens2, String name3, Object val3, boolean sens3) {
        assert (cls != null);
        assert (obj != null);
        assert (name0 != null);
        assert (name1 != null);
        assert (name2 != null);
        assert (name3 != null);
        Queue<GridToStringThreadLocal> queue = threadCache.get();
        assert (queue != null);
        GridToStringThreadLocal tmp = queue.isEmpty() ? new GridToStringThreadLocal() : queue.remove();
        Object[] addNames = tmp.getAdditionalNames();
        Object[] addVals = tmp.getAdditionalValues();
        boolean[] addSens = tmp.getAdditionalSensitives();
        addNames[0] = name0;
        addVals[0] = val0;
        addSens[0] = sens0;
        addNames[1] = name1;
        addVals[1] = val1;
        addSens[1] = sens1;
        addNames[2] = name2;
        addVals[2] = val2;
        addSens[2] = sens2;
        addNames[3] = name3;
        addVals[3] = val3;
        addSens[3] = sens3;
        try {
            String string = GridToStringBuilder.toStringImpl(cls, tmp.getStringBuilder(), obj, addNames, addVals, addSens, 4);
            return string;
        }
        finally {
            queue.offer(tmp);
        }
    }

    public static <T> String toString(Class<T> cls, T obj, String name0, Object val0, String name1, Object val1, String name2, Object val2) {
        return GridToStringBuilder.toString(cls, obj, name0, val0, false, name1, val1, false, name2, val2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> String toString(Class<T> cls, T obj, String name0, Object val0, boolean sens0, String name1, Object val1, boolean sens1, String name2, Object val2, boolean sens2) {
        assert (cls != null);
        assert (obj != null);
        assert (name0 != null);
        assert (name1 != null);
        assert (name2 != null);
        Queue<GridToStringThreadLocal> queue = threadCache.get();
        assert (queue != null);
        GridToStringThreadLocal tmp = queue.isEmpty() ? new GridToStringThreadLocal() : queue.remove();
        Object[] addNames = tmp.getAdditionalNames();
        Object[] addVals = tmp.getAdditionalValues();
        boolean[] addSens = tmp.getAdditionalSensitives();
        addNames[0] = name0;
        addVals[0] = val0;
        addSens[0] = sens0;
        addNames[1] = name1;
        addVals[1] = val1;
        addSens[1] = sens1;
        addNames[2] = name2;
        addVals[2] = val2;
        addSens[2] = sens2;
        try {
            String string = GridToStringBuilder.toStringImpl(cls, tmp.getStringBuilder(), obj, addNames, addVals, addSens, 3);
            return string;
        }
        finally {
            queue.offer(tmp);
        }
    }

    public static <T> String toString(Class<T> cls, T obj, String name0, Object val0, String name1, Object val1) {
        return GridToStringBuilder.toString(cls, obj, name0, val0, false, name1, val1, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> String toString(Class<T> cls, T obj, String name0, Object val0, boolean sens0, String name1, Object val1, boolean sens1) {
        assert (cls != null);
        assert (obj != null);
        assert (name0 != null);
        assert (name1 != null);
        Queue<GridToStringThreadLocal> queue = threadCache.get();
        assert (queue != null);
        GridToStringThreadLocal tmp = queue.isEmpty() ? new GridToStringThreadLocal() : queue.remove();
        Object[] addNames = tmp.getAdditionalNames();
        Object[] addVals = tmp.getAdditionalValues();
        boolean[] addSens = tmp.getAdditionalSensitives();
        addNames[0] = name0;
        addVals[0] = val0;
        addSens[0] = sens0;
        addNames[1] = name1;
        addVals[1] = val1;
        addSens[1] = sens1;
        try {
            String string = GridToStringBuilder.toStringImpl(cls, tmp.getStringBuilder(), obj, addNames, addVals, addSens, 2);
            return string;
        }
        finally {
            queue.offer(tmp);
        }
    }

    public static <T> String toString(Class<T> cls, T obj, String name, @Nullable Object val) {
        return GridToStringBuilder.toString(cls, obj, name, val, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> String toString(Class<T> cls, T obj, String name, @Nullable Object val, boolean sens) {
        assert (cls != null);
        assert (obj != null);
        assert (name != null);
        Queue<GridToStringThreadLocal> queue = threadCache.get();
        assert (queue != null);
        GridToStringThreadLocal tmp = queue.isEmpty() ? new GridToStringThreadLocal() : queue.remove();
        Object[] addNames = tmp.getAdditionalNames();
        Object[] addVals = tmp.getAdditionalValues();
        boolean[] addSens = tmp.getAdditionalSensitives();
        addNames[0] = name;
        addVals[0] = val;
        addSens[0] = sens;
        try {
            String string = GridToStringBuilder.toStringImpl(cls, tmp.getStringBuilder(), obj, addNames, addVals, addSens, 1);
            return string;
        }
        finally {
            queue.offer(tmp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> String toString(Class<T> cls, T obj) {
        assert (cls != null);
        assert (obj != null);
        Queue<GridToStringThreadLocal> queue = threadCache.get();
        assert (queue != null);
        GridToStringThreadLocal tmp = queue.isEmpty() ? new GridToStringThreadLocal() : queue.remove();
        try {
            String string = GridToStringBuilder.toStringImpl(cls, tmp.getStringBuilder(), obj, tmp.getAdditionalNames(), tmp.getAdditionalValues(), null, 0);
            return string;
        }
        finally {
            queue.offer(tmp);
        }
    }

    public static <T> String toString(Class<T> cls, T obj, String parent) {
        return parent != null ? GridToStringBuilder.toString(cls, obj, "super", parent) : GridToStringBuilder.toString(cls, obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> String toStringImpl(Class<T> cls, SB buf, T obj, Object[] addNames, Object[] addVals, @Nullable boolean[] addSens, int addLen) {
        assert (cls != null);
        assert (buf != null);
        assert (obj != null);
        assert (addNames != null);
        assert (addVals != null);
        assert (addNames.length == addVals.length);
        assert (addLen <= addNames.length);
        try {
            GridToStringClassDescriptor cd = GridToStringBuilder.getClassDescriptor(cls);
            assert (cd != null);
            buf.setLength(0);
            buf.a(cd.getSimpleClassName()).a(" [");
            boolean first = true;
            for (GridToStringFieldDescriptor fd : cd.getFields()) {
                if (!first) {
                    buf.a(", ");
                } else {
                    first = false;
                }
                String name = fd.getName();
                Field field = cls.getDeclaredField(name);
                field.setAccessible(true);
                buf.a(name).a('=');
                Class<?> fieldType = field.getType();
                if (fieldType.isArray()) {
                    buf.a(GridToStringBuilder.arrayToString(fieldType, field.get(obj)));
                    continue;
                }
                Collection val = field.get(obj);
                if (val instanceof Collection && ((Collection)val).size() > 100) {
                    val = F.retain(val, true, 100);
                } else if (val instanceof Map && ((Map)((Object)val)).size() > 100) {
                    HashMap tmp = U.newHashMap(100);
                    int cntr = 0;
                    Iterator i$ = ((Map)((Object)val)).entrySet().iterator();
                    while (i$.hasNext()) {
                        Map.Entry o;
                        Map.Entry e = o = i$.next();
                        tmp.put(e.getKey(), e.getValue());
                        if (++cntr < 100) continue;
                        break;
                    }
                    val = tmp;
                }
                buf.a(val);
            }
            GridToStringBuilder.appendVals(buf, first, addNames, addVals, addSens, addLen);
            buf.a(']');
            return buf.toString();
        }
        catch (Exception e) {
            rwLock.writeLock().lock();
            try {
                classCache.remove(cls.getName() + System.identityHashCode(cls.getClassLoader()));
            }
            finally {
                rwLock.writeLock().unlock();
            }
            throw new IgniteException(e);
        }
    }

    private static String arrayToString(Class arrType, Object arr) {
        if (arrType.equals(byte[].class)) {
            return Arrays.toString((byte[])arr);
        }
        if (arrType.equals(boolean[].class)) {
            return Arrays.toString((boolean[])arr);
        }
        if (arrType.equals(short[].class)) {
            return Arrays.toString((short[])arr);
        }
        if (arrType.equals(int[].class)) {
            return Arrays.toString((int[])arr);
        }
        if (arrType.equals(long[].class)) {
            return Arrays.toString((long[])arr);
        }
        if (arrType.equals(float[].class)) {
            return Arrays.toString((float[])arr);
        }
        if (arrType.equals(double[].class)) {
            return Arrays.toString((double[])arr);
        }
        if (arrType.equals(char[].class)) {
            return Arrays.toString((char[])arr);
        }
        return Arrays.toString((Object[])arr);
    }

    public static String toString(String str, String name, @Nullable Object val) {
        return GridToStringBuilder.toString(str, name, val, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(String str, String name, @Nullable Object val, boolean sens) {
        assert (name != null);
        Queue<GridToStringThreadLocal> queue = threadCache.get();
        assert (queue != null);
        GridToStringThreadLocal tmp = queue.isEmpty() ? new GridToStringThreadLocal() : queue.remove();
        Object[] propNames = tmp.getAdditionalNames();
        Object[] propVals = tmp.getAdditionalValues();
        boolean[] propSens = tmp.getAdditionalSensitives();
        propNames[0] = name;
        propVals[0] = val;
        propSens[0] = sens;
        try {
            String string = GridToStringBuilder.toStringImpl(str, tmp.getStringBuilder(), propNames, propVals, propSens, 1);
            return string;
        }
        finally {
            queue.offer(tmp);
        }
    }

    public static String toString(String str, String name0, @Nullable Object val0, String name1, @Nullable Object val1) {
        return GridToStringBuilder.toString(str, name0, val0, false, name1, val1, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(String str, String name0, @Nullable Object val0, boolean sens0, String name1, @Nullable Object val1, boolean sens1) {
        assert (name0 != null);
        assert (name1 != null);
        Queue<GridToStringThreadLocal> queue = threadCache.get();
        assert (queue != null);
        GridToStringThreadLocal tmp = queue.isEmpty() ? new GridToStringThreadLocal() : queue.remove();
        Object[] propNames = tmp.getAdditionalNames();
        Object[] propVals = tmp.getAdditionalValues();
        boolean[] propSens = tmp.getAdditionalSensitives();
        propNames[0] = name0;
        propVals[0] = val0;
        propSens[0] = sens0;
        propNames[1] = name1;
        propVals[1] = val1;
        propSens[1] = sens1;
        try {
            String string = GridToStringBuilder.toStringImpl(str, tmp.getStringBuilder(), propNames, propVals, propSens, 2);
            return string;
        }
        finally {
            queue.offer(tmp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(String str, String name0, @Nullable Object val0, boolean sens0, String name1, @Nullable Object val1, boolean sens1, String name2, @Nullable Object val2, boolean sens2) {
        assert (name0 != null);
        assert (name1 != null);
        assert (name2 != null);
        Queue<GridToStringThreadLocal> queue = threadCache.get();
        assert (queue != null);
        GridToStringThreadLocal tmp = queue.isEmpty() ? new GridToStringThreadLocal() : queue.remove();
        Object[] propNames = tmp.getAdditionalNames();
        Object[] propVals = tmp.getAdditionalValues();
        boolean[] propSens = tmp.getAdditionalSensitives();
        propNames[0] = name0;
        propVals[0] = val0;
        propSens[0] = sens0;
        propNames[1] = name1;
        propVals[1] = val1;
        propSens[1] = sens1;
        propNames[2] = name2;
        propVals[2] = val2;
        propSens[2] = sens2;
        try {
            String string = GridToStringBuilder.toStringImpl(str, tmp.getStringBuilder(), propNames, propVals, propSens, 3);
            return string;
        }
        finally {
            queue.offer(tmp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(String str, String name0, @Nullable Object val0, boolean sens0, String name1, @Nullable Object val1, boolean sens1, String name2, @Nullable Object val2, boolean sens2, String name3, @Nullable Object val3, boolean sens3) {
        assert (name0 != null);
        assert (name1 != null);
        assert (name2 != null);
        assert (name3 != null);
        Queue<GridToStringThreadLocal> queue = threadCache.get();
        assert (queue != null);
        GridToStringThreadLocal tmp = queue.isEmpty() ? new GridToStringThreadLocal() : queue.remove();
        Object[] propNames = tmp.getAdditionalNames();
        Object[] propVals = tmp.getAdditionalValues();
        boolean[] propSens = tmp.getAdditionalSensitives();
        propNames[0] = name0;
        propVals[0] = val0;
        propSens[0] = sens0;
        propNames[1] = name1;
        propVals[1] = val1;
        propSens[1] = sens1;
        propNames[2] = name2;
        propVals[2] = val2;
        propSens[2] = sens2;
        propNames[3] = name3;
        propVals[3] = val3;
        propSens[3] = sens3;
        try {
            String string = GridToStringBuilder.toStringImpl(str, tmp.getStringBuilder(), propNames, propVals, propSens, 4);
            return string;
        }
        finally {
            queue.offer(tmp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(String str, String name0, @Nullable Object val0, boolean sens0, String name1, @Nullable Object val1, boolean sens1, String name2, @Nullable Object val2, boolean sens2, String name3, @Nullable Object val3, boolean sens3, String name4, @Nullable Object val4, boolean sens4) {
        assert (name0 != null);
        assert (name1 != null);
        assert (name2 != null);
        assert (name3 != null);
        assert (name4 != null);
        Queue<GridToStringThreadLocal> queue = threadCache.get();
        assert (queue != null);
        GridToStringThreadLocal tmp = queue.isEmpty() ? new GridToStringThreadLocal() : queue.remove();
        Object[] propNames = tmp.getAdditionalNames();
        Object[] propVals = tmp.getAdditionalValues();
        boolean[] propSens = tmp.getAdditionalSensitives();
        propNames[0] = name0;
        propVals[0] = val0;
        propSens[0] = sens0;
        propNames[1] = name1;
        propVals[1] = val1;
        propSens[1] = sens1;
        propNames[2] = name2;
        propVals[2] = val2;
        propSens[2] = sens2;
        propNames[3] = name3;
        propVals[3] = val3;
        propSens[3] = sens3;
        propNames[4] = name4;
        propVals[4] = val4;
        propSens[4] = sens4;
        try {
            String string = GridToStringBuilder.toStringImpl(str, tmp.getStringBuilder(), propNames, propVals, propSens, 5);
            return string;
        }
        finally {
            queue.offer(tmp);
        }
    }

    private static String toStringImpl(String str, SB buf, Object[] propNames, Object[] propVals, boolean[] propSens, int propCnt) {
        buf.setLength(0);
        if (str != null) {
            buf.a(str).a(" ");
        }
        buf.a("[");
        GridToStringBuilder.appendVals(buf, true, propNames, propVals, propSens, propCnt);
        buf.a(']');
        return buf.toString();
    }

    private static void appendVals(SB buf, boolean first, Object[] addNames, Object[] addVals, boolean[] addSens, int addLen) {
        if (addLen > 0) {
            for (int i = 0; i < addLen; ++i) {
                Object addVal = addVals[i];
                if (addVal != null) {
                    GridToStringInclude incAnn;
                    if (addSens != null && addSens[i] && !INCLUDE_SENSITIVE || (incAnn = addVal.getClass().getAnnotation(GridToStringInclude.class)) != null && incAnn.sensitive() && !INCLUDE_SENSITIVE) continue;
                    Class<?> cls = addVal.getClass();
                    if (cls.isArray()) {
                        addVal = GridToStringBuilder.arrayToString(cls, addVal);
                    }
                }
                if (!first) {
                    buf.a(", ");
                } else {
                    first = false;
                }
                buf.a(addNames[i]).a('=').a(addVal);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> GridToStringClassDescriptor getClassDescriptor(Class<T> cls) {
        GridToStringClassDescriptor cd;
        assert (cls != null);
        String key = cls.getName() + System.identityHashCode(cls.getClassLoader());
        rwLock.readLock().lock();
        try {
            cd = classCache.get(key);
        }
        finally {
            rwLock.readLock().unlock();
        }
        if (cd == null) {
            cd = new GridToStringClassDescriptor(cls);
            for (Field f : cls.getDeclaredFields()) {
                boolean add = false;
                Class<?> type = f.getType();
                GridToStringInclude incFld = f.getAnnotation(GridToStringInclude.class);
                GridToStringInclude incType = type.getAnnotation(GridToStringInclude.class);
                if (incFld != null || incType != null) {
                    boolean notSens = !(incFld != null && incFld.sensitive() || incType != null && incType.sensitive());
                    add = notSens || INCLUDE_SENSITIVE;
                } else if (!(f.isAnnotationPresent(GridToStringExclude.class) || f.getType().isAnnotationPresent(GridToStringExclude.class) || !Modifier.isPrivate(f.getModifiers()) || Modifier.isStatic(f.getModifiers()) || Object.class == type || Serializable.class == type || Externalizable.class == type || type.isArray() || EventListener.class.isAssignableFrom(type) || Map.class.isAssignableFrom(type) || Collection.class.isAssignableFrom(type) || InputStream.class.isAssignableFrom(type) || OutputStream.class.isAssignableFrom(type) || Thread.class.isAssignableFrom(type) || Runnable.class.isAssignableFrom(type) || Lock.class.isAssignableFrom(type) || ReadWriteLock.class.isAssignableFrom(type) || Condition.class.isAssignableFrom(type))) {
                    add = true;
                }
                if (!add) continue;
                GridToStringFieldDescriptor fd = new GridToStringFieldDescriptor(f.getName());
                GridToStringOrder annOrder = f.getAnnotation(GridToStringOrder.class);
                if (annOrder != null) {
                    fd.setOrder(annOrder.value());
                }
                cd.addField(fd);
            }
            cd.sortFields();
            rwLock.writeLock().lock();
            try {
                classCache.put(key, cd);
            }
            finally {
                rwLock.writeLock().unlock();
            }
        }
        return cd;
    }
}

