/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.cache;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.LessNamingBean;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtPartitionTopology;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionMap2;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearCacheAdapter;
import org.apache.ignite.internal.util.lang.IgnitePair;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.cache.VisorCacheMetrics;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public class VisorCache
implements Serializable,
LessNamingBean {
    private static final long serialVersionUID = 0L;
    private static final int DFLT_CACHE_SIZE_SAMPLING = 10;
    private String name;
    private IgniteUuid dynamicDeploymentId;
    private CacheMode mode;
    private long memorySize;
    private long indexesSize;
    private int size;
    private int nearSize;
    private int dhtSize;
    private int primarySize;
    private long offHeapAllocatedSize;
    private long offHeapEntriesCnt;
    private long swapSize;
    private long swapKeys;
    private int partitions;
    private Collection<IgnitePair<Integer>> primaryPartitions;
    private Collection<IgnitePair<Integer>> backupPartitions;
    private VisorCacheMetrics metrics;
    private GridDhtPartitionMap partitionsMap;

    public VisorCache from(IgniteEx ignite, String cacheName, int sample) throws IgniteCheckedException {
        boolean partitioned;
        assert (ignite != null);
        GridCacheAdapter ca = ignite.context().cache().internalCache(cacheName);
        if (ca == null || !ca.context().started()) {
            return null;
        }
        this.name = cacheName;
        try {
            this.swapSize = ca.swapSize();
            this.swapKeys = ca.swapKeys();
        }
        catch (IgniteCheckedException ignored) {
            this.swapSize = -1L;
            this.swapKeys = -1L;
        }
        this.primaryPartitions = Collections.emptyList();
        this.backupPartitions = Collections.emptyList();
        CacheConfiguration cfg = ca.configuration();
        this.mode = cfg.getCacheMode();
        boolean bl = partitioned = (this.mode == CacheMode.PARTITIONED || this.mode == CacheMode.REPLICATED) && ca.context().affinityNode();
        if (partitioned) {
            GridDhtCacheAdapter dca = null;
            if (ca instanceof GridNearCacheAdapter) {
                dca = ((GridNearCacheAdapter)ca).dht();
            } else if (ca instanceof GridDhtCacheAdapter) {
                dca = (GridDhtCacheAdapter)ca;
            }
            if (dca != null) {
                GridDhtPartitionTopology top = dca.topology();
                if (cfg.getCacheMode() != CacheMode.LOCAL && cfg.getBackups() > 0) {
                    GridDhtPartitionMap2 map2 = top.localPartitionMap();
                    this.partitionsMap = new GridDhtPartitionMap(map2.nodeId(), map2.updateSequence(), map2.map());
                }
            }
        }
        this.size = ca.size();
        this.nearSize = ca.nearSize();
        this.dynamicDeploymentId = ca.context().dynamicDeploymentId();
        this.dhtSize = this.size - this.nearSize;
        this.primarySize = ca.primarySize();
        this.offHeapAllocatedSize = ca.offHeapAllocatedSize();
        this.offHeapEntriesCnt = ca.offHeapEntriesCount();
        this.partitions = ca.affinity().partitions();
        this.metrics = new VisorCacheMetrics().from(ignite, cacheName);
        this.estimateMemorySize(ignite, ca, sample);
        return this;
    }

    protected void estimateMemorySize(IgniteEx ignite, GridCacheAdapter ca, int sample) throws IgniteCheckedException {
        int cnt;
        int size = ca.size();
        Iterable<GridCacheEntryEx> set = ca.context().isNear() ? ((GridNearCacheAdapter)ca).dht().entries() : ca.entries();
        long memSz = 0L;
        Iterator<GridCacheEntryEx> it = set.iterator();
        int sz = sample > 0 ? sample : 10;
        for (cnt = 0; it.hasNext() && cnt < sz; ++cnt) {
            memSz += (long)it.next().memorySize();
        }
        if (cnt > 0) {
            memSz = (long)((double)memSz / (double)cnt * (double)size);
        }
        this.memorySize = memSz;
    }

    protected VisorCache initHistory(VisorCache c) {
        if (c != null) {
            c.name = this.name;
            c.mode = this.mode;
            c.memorySize = this.memorySize;
            c.indexesSize = this.indexesSize;
            c.size = this.size;
            c.nearSize = this.nearSize;
            c.dhtSize = this.dhtSize;
            c.primarySize = this.primarySize;
            c.offHeapAllocatedSize = this.offHeapAllocatedSize;
            c.offHeapEntriesCnt = this.offHeapEntriesCnt;
            c.swapSize = this.swapSize;
            c.swapKeys = this.swapKeys;
            c.partitions = this.partitions;
            c.primaryPartitions = Collections.emptyList();
            c.backupPartitions = Collections.emptyList();
            c.metrics = this.metrics;
        }
        return c;
    }

    public VisorCache history() {
        return this.initHistory(new VisorCache());
    }

    public String name() {
        return this.name;
    }

    public void name(String name) {
        this.name = name;
    }

    public IgniteUuid dynamicDeploymentId() {
        return this.dynamicDeploymentId;
    }

    public CacheMode mode() {
        return this.mode;
    }

    public long memorySize() {
        return this.memorySize;
    }

    public long indexesSize() {
        return this.indexesSize;
    }

    public int size() {
        return this.size;
    }

    public int nearSize() {
        return this.nearSize;
    }

    public int dhtSize() {
        return this.dhtSize;
    }

    public int primarySize() {
        return this.primarySize;
    }

    public long offHeapAllocatedSize() {
        return this.offHeapAllocatedSize;
    }

    public long offHeapEntriesCount() {
        return this.offHeapEntriesCnt;
    }

    public long swapSize() {
        return this.swapSize;
    }

    public long swapKeys() {
        return this.swapKeys;
    }

    public int partitions() {
        return this.partitions;
    }

    public Collection<IgnitePair<Integer>> primaryPartitions() {
        return this.primaryPartitions;
    }

    public Collection<IgnitePair<Integer>> backupPartitions() {
        return this.backupPartitions;
    }

    public VisorCacheMetrics metrics() {
        return this.metrics;
    }

    @Nullable
    public GridDhtPartitionMap partitionMap() {
        return this.partitionsMap;
    }

    public String toString() {
        return S.toString(VisorCache.class, this);
    }
}

