/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.cache;

import java.io.Serializable;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.LessNamingBean;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;
import org.jetbrains.annotations.Nullable;

public class VisorCacheAffinityConfiguration
implements Serializable,
LessNamingBean {
    private static final long serialVersionUID = 0L;
    private String function;
    private String mapper;
    private int partitionedBackups;
    private Integer partitions;
    private Boolean excludeNeighbors;

    public static VisorCacheAffinityConfiguration from(CacheConfiguration ccfg) {
        AffinityFunction aff = ccfg.getAffinity();
        Boolean excludeNeighbors = null;
        if (aff instanceof RendezvousAffinityFunction) {
            RendezvousAffinityFunction hashAffFunc = (RendezvousAffinityFunction)aff;
            excludeNeighbors = hashAffFunc.isExcludeNeighbors();
        }
        VisorCacheAffinityConfiguration cfg = new VisorCacheAffinityConfiguration();
        cfg.function = VisorTaskUtils.compactClass(aff);
        cfg.mapper = VisorTaskUtils.compactClass(ccfg.getAffinityMapper());
        cfg.partitions = aff.partitions();
        cfg.partitionedBackups = ccfg.getBackups();
        cfg.excludeNeighbors = excludeNeighbors;
        return cfg;
    }

    public String function() {
        return this.function;
    }

    public String mapper() {
        return this.mapper;
    }

    public int partitionedBackups() {
        return this.partitionedBackups;
    }

    public Integer partitions() {
        return this.partitions;
    }

    @Nullable
    public Boolean excludeNeighbors() {
        return this.excludeNeighbors;
    }

    public String toString() {
        return S.toString(VisorCacheAffinityConfiguration.class, this);
    }
}

