/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.cache;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.internal.LessNamingBean;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.cache.VisorCacheMetrics;
import org.apache.ignite.internal.visor.cache.VisorCacheMetricsV2;

public class VisorCacheAggregatedMetrics
implements Serializable,
LessNamingBean {
    private static final long serialVersionUID = 0L;
    private String name;
    private CacheMode mode;
    private boolean sys;
    private final Map<UUID, VisorCacheMetrics> metrics = new HashMap<UUID, VisorCacheMetrics>();
    private transient Long minHeapSize;
    private transient Double avgHeapSize;
    private transient Long maxHeapSize;
    private transient Long minOffHeapSize;
    private transient Double avgOffHeapSize;
    private transient Long maxOffHeapSize;
    private transient Long minHits;
    private transient Double avgHits;
    private transient Long maxHits;
    private transient Long minMisses;
    private transient Double avgMisses;
    private transient Long maxMisses;
    private transient Long minReads;
    private transient Double avgReads;
    private transient Long maxReads;
    private transient Long minWrites;
    private transient Double avgWrites;
    private transient Long maxWrites;
    private transient Long minQryTime;
    private transient Double avgQryTime;
    private transient Long maxQryTime;
    private transient Long totalQryTime;
    private transient Integer execsQry;
    private transient Integer failsQry;

    public static VisorCacheAggregatedMetrics from(VisorCacheMetrics cm) {
        VisorCacheAggregatedMetrics acm = new VisorCacheAggregatedMetrics();
        acm.name = cm.name();
        acm.mode = cm.mode();
        acm.sys = cm.system();
        return acm;
    }

    public String name() {
        return this.name;
    }

    public CacheMode mode() {
        return this.mode;
    }

    public boolean system() {
        return this.sys;
    }

    public Collection<UUID> nodes() {
        return this.metrics.keySet();
    }

    public long minimumHeapSize() {
        if (this.minHeapSize == null) {
            this.minHeapSize = Long.MAX_VALUE;
            for (VisorCacheMetrics metric : this.metrics.values()) {
                this.minHeapSize = Math.min(this.minHeapSize, (long)metric.keySize());
            }
        }
        return this.minHeapSize;
    }

    public double averageHeapSize() {
        if (this.avgHeapSize == null) {
            this.avgHeapSize = 0.0;
            for (VisorCacheMetrics metric : this.metrics.values()) {
                this.avgHeapSize = this.avgHeapSize + (double)metric.keySize();
            }
            this.avgHeapSize = this.avgHeapSize / (double)this.metrics.size();
        }
        return this.avgHeapSize;
    }

    public long maximumHeapSize() {
        if (this.maxHeapSize == null) {
            this.maxHeapSize = Long.MIN_VALUE;
            for (VisorCacheMetrics metric : this.metrics.values()) {
                this.maxHeapSize = Math.max(this.maxHeapSize, (long)metric.keySize());
            }
        }
        return this.maxHeapSize;
    }

    private long offHeapEntriesCount(VisorCacheMetrics metric) {
        return metric instanceof VisorCacheMetricsV2 ? ((VisorCacheMetricsV2)metric).offHeapEntriesCount() : 0L;
    }

    public long minimumOffHeapSize() {
        if (this.minOffHeapSize == null) {
            this.minOffHeapSize = Long.MAX_VALUE;
            for (VisorCacheMetrics metric : this.metrics.values()) {
                this.minOffHeapSize = Math.min(this.minOffHeapSize, this.offHeapEntriesCount(metric));
            }
        }
        return this.minOffHeapSize;
    }

    public double averageOffHeapSize() {
        if (this.avgOffHeapSize == null) {
            this.avgOffHeapSize = 0.0;
            for (VisorCacheMetrics metric : this.metrics.values()) {
                this.avgOffHeapSize = this.avgOffHeapSize + (double)this.offHeapEntriesCount(metric);
            }
            this.avgOffHeapSize = this.avgOffHeapSize / (double)this.metrics.size();
        }
        return this.avgOffHeapSize;
    }

    public long maximumOffHeapSize() {
        if (this.maxOffHeapSize == null) {
            this.maxOffHeapSize = Long.MIN_VALUE;
            for (VisorCacheMetrics metric : this.metrics.values()) {
                this.maxOffHeapSize = Math.max(this.maxOffHeapSize, this.offHeapEntriesCount(metric));
            }
        }
        return this.maxOffHeapSize;
    }

    public long minimumHits() {
        if (this.minHits == null) {
            this.minHits = Long.MAX_VALUE;
            for (VisorCacheMetrics metric : this.metrics.values()) {
                this.minHits = Math.min(this.minHits, metric.hits());
            }
        }
        return this.minHits;
    }

    public double averageHits() {
        if (this.avgHits == null) {
            this.avgHits = 0.0;
            for (VisorCacheMetrics metric : this.metrics.values()) {
                this.avgHits = this.avgHits + (double)metric.hits();
            }
            this.avgHits = this.avgHits / (double)this.metrics.size();
        }
        return this.avgHits;
    }

    public long maximumHits() {
        if (this.maxHits == null) {
            this.maxHits = Long.MIN_VALUE;
            for (VisorCacheMetrics metric : this.metrics.values()) {
                this.maxHits = Math.max(this.maxHits, metric.hits());
            }
        }
        return this.maxHits;
    }

    public long minimumMisses() {
        if (this.minMisses == null) {
            this.minMisses = Long.MAX_VALUE;
            for (VisorCacheMetrics metric : this.metrics.values()) {
                this.minMisses = Math.min(this.minMisses, metric.misses());
            }
        }
        return this.minMisses;
    }

    public double averageMisses() {
        if (this.avgMisses == null) {
            this.avgMisses = 0.0;
            for (VisorCacheMetrics metric : this.metrics.values()) {
                this.avgMisses = this.avgMisses + (double)metric.misses();
            }
            this.avgMisses = this.avgMisses / (double)this.metrics.size();
        }
        return this.avgMisses;
    }

    public long maximumMisses() {
        if (this.maxMisses == null) {
            this.maxMisses = Long.MIN_VALUE;
            for (VisorCacheMetrics metric : this.metrics.values()) {
                this.maxMisses = Math.max(this.maxMisses, metric.misses());
            }
        }
        return this.maxMisses;
    }

    public long minimumReads() {
        if (this.minReads == null) {
            this.minReads = Long.MAX_VALUE;
            for (VisorCacheMetrics metric : this.metrics.values()) {
                this.minReads = Math.min(this.minReads, metric.reads());
            }
        }
        return this.minReads;
    }

    public double averageReads() {
        if (this.avgReads == null) {
            this.avgReads = 0.0;
            for (VisorCacheMetrics metric : this.metrics.values()) {
                this.avgReads = this.avgReads + (double)metric.reads();
            }
            this.avgReads = this.avgReads / (double)this.metrics.size();
        }
        return this.avgReads;
    }

    public long maximumReads() {
        if (this.maxReads == null) {
            this.maxReads = Long.MIN_VALUE;
            for (VisorCacheMetrics metric : this.metrics.values()) {
                this.maxReads = Math.max(this.maxReads, metric.reads());
            }
        }
        return this.maxReads;
    }

    public long minimumWrites() {
        if (this.minWrites == null) {
            this.minWrites = Long.MAX_VALUE;
            for (VisorCacheMetrics metric : this.metrics.values()) {
                this.minWrites = Math.min(this.minWrites, metric.writes());
            }
        }
        return this.minWrites;
    }

    public double averageWrites() {
        if (this.avgWrites == null) {
            this.avgWrites = 0.0;
            for (VisorCacheMetrics metric : this.metrics.values()) {
                this.avgWrites = this.avgWrites + (double)metric.writes();
            }
            this.avgWrites = this.avgWrites / (double)this.metrics.size();
        }
        return this.avgWrites;
    }

    public long maximumWrites() {
        if (this.maxWrites == null) {
            this.maxWrites = Long.MIN_VALUE;
            for (VisorCacheMetrics metric : this.metrics.values()) {
                this.maxWrites = Math.max(this.maxWrites, metric.writes());
            }
        }
        return this.maxWrites;
    }

    public long minimumQueryTime() {
        if (this.minQryTime == null) {
            this.minQryTime = Long.MAX_VALUE;
            for (VisorCacheMetrics metric : this.metrics.values()) {
                this.minQryTime = Math.min(this.minQryTime, metric.queryMetrics().minimumTime());
            }
        }
        return this.minQryTime;
    }

    public double averageQueryTime() {
        if (this.avgQryTime == null) {
            this.avgQryTime = 0.0;
            for (VisorCacheMetrics metric : this.metrics.values()) {
                this.avgQryTime = this.avgQryTime + metric.queryMetrics().averageTime();
            }
            this.avgQryTime = this.avgQryTime / (double)this.metrics.size();
        }
        return this.avgQryTime;
    }

    public long maximumQueryTime() {
        if (this.maxQryTime == null) {
            this.maxQryTime = Long.MIN_VALUE;
            for (VisorCacheMetrics metric : this.metrics.values()) {
                this.maxQryTime = Math.max(this.maxQryTime, metric.queryMetrics().maximumTime());
            }
        }
        return this.maxQryTime;
    }

    public long totalQueryTime() {
        if (this.totalQryTime == null) {
            this.totalQryTime = (long)(this.averageQueryTime() * (double)this.execsQuery());
        }
        return this.totalQryTime;
    }

    public int execsQuery() {
        if (this.execsQry == null) {
            this.execsQry = 0;
            for (VisorCacheMetrics metric : this.metrics.values()) {
                this.execsQry = this.execsQry + metric.queryMetrics().executions();
            }
        }
        return this.execsQry;
    }

    public int failsQuery() {
        if (this.failsQry == null) {
            this.failsQry = 0;
            for (VisorCacheMetrics metric : this.metrics.values()) {
                this.failsQry = this.failsQry + metric.queryMetrics().fails();
            }
        }
        return this.failsQry;
    }

    public Map<UUID, VisorCacheMetrics> metrics() {
        return this.metrics;
    }

    public String toString() {
        return S.toString(VisorCacheAggregatedMetrics.class, this);
    }
}

