/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.cache;

import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.compute.ComputeJobContext;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorOneNodeTask;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.resources.JobContextResource;

@GridInternal
public class VisorCacheClearTask
extends VisorOneNodeTask<String, IgniteBiTuple<Integer, Integer>> {
    private static final long serialVersionUID = 0L;

    protected VisorCacheClearJob job(String arg) {
        return new VisorCacheClearJob(arg, this.debug);
    }

    private static class VisorCacheClearJob
    extends VisorJob<String, IgniteBiTuple<Integer, Integer>> {
        private static final long serialVersionUID = 0L;
        private final String cacheName;
        private final IgniteInClosure<IgniteFuture<Integer>> lsnr;
        private IgniteFuture<Integer>[] futs;
        @JobContextResource
        private ComputeJobContext jobCtx;

        private VisorCacheClearJob(String cacheName, boolean debug) {
            super(cacheName, debug);
            this.cacheName = cacheName;
            this.lsnr = new IgniteInClosure<IgniteFuture<Integer>>(){
                private static final long serialVersionUID = 0L;

                @Override
                public void apply(IgniteFuture<Integer> f) {
                    assert (VisorCacheClearJob.this.futs[0].isDone());
                    assert (VisorCacheClearJob.this.futs[1] == null || VisorCacheClearJob.this.futs[1].isDone());
                    assert (VisorCacheClearJob.this.futs[2] == null || VisorCacheClearJob.this.futs[2].isDone());
                    VisorCacheClearJob.this.jobCtx.callcc();
                }
            };
        }

        private boolean callAsync(IgniteFuture<Integer> fut, int idx) {
            this.futs[idx] = fut;
            if (fut.isDone()) {
                return false;
            }
            this.jobCtx.holdcc();
            fut.listen(this.lsnr);
            return true;
        }

        @Override
        protected IgniteBiTuple<Integer, Integer> run(String cacheName) {
            if (this.futs == null) {
                this.futs = new IgniteFuture[3];
            }
            if (this.futs[0] == null || this.futs[1] == null || this.futs[2] == null) {
                IgniteCache cache = this.ignite.cache(cacheName).withAsync();
                if (this.futs[0] == null) {
                    cache.size(CachePeekMode.PRIMARY);
                    if (this.callAsync(cache.future(), 0)) {
                        return null;
                    }
                }
                if (this.futs[1] == null) {
                    cache.clear();
                    if (this.callAsync(cache.future(), 1)) {
                        return null;
                    }
                }
                if (this.futs[2] == null) {
                    cache.size(CachePeekMode.PRIMARY);
                    if (this.callAsync(cache.future(), 2)) {
                        return null;
                    }
                }
            }
            assert (this.futs[0].isDone() && this.futs[1].isDone() && this.futs[2].isDone());
            return new IgniteBiTuple<Integer, Integer>(this.futs[0].get(), this.futs[2].get());
        }

        public String toString() {
            return S.toString(VisorCacheClearJob.class, this);
        }
    }
}

