/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.cache;

import java.io.Serializable;
import java.util.Collection;
import org.apache.ignite.cache.CacheAtomicWriteOrderMode;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMemoryMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.LessNamingBean;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.cache.VisorCacheAffinityConfiguration;
import org.apache.ignite.internal.visor.cache.VisorCacheDefaultConfiguration;
import org.apache.ignite.internal.visor.cache.VisorCacheEvictionConfiguration;
import org.apache.ignite.internal.visor.cache.VisorCacheNearConfiguration;
import org.apache.ignite.internal.visor.cache.VisorCacheQueryConfiguration;
import org.apache.ignite.internal.visor.cache.VisorCacheQueryConfigurationV2;
import org.apache.ignite.internal.visor.cache.VisorCacheRebalanceConfiguration;
import org.apache.ignite.internal.visor.cache.VisorCacheStoreConfiguration;
import org.apache.ignite.internal.visor.cache.VisorCacheStoreConfigurationV2;
import org.apache.ignite.internal.visor.cache.VisorCacheTypeMetadata;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;
import org.apache.ignite.lang.IgniteProductVersion;
import org.jetbrains.annotations.Nullable;

public class VisorCacheConfiguration
implements Serializable,
LessNamingBean {
    private static final long serialVersionUID = 0L;
    private static final IgniteProductVersion VER_1_4_1 = IgniteProductVersion.fromString("1.4.1");
    private String name;
    private CacheMode mode;
    private CacheAtomicityMode atomicityMode;
    private CacheAtomicWriteOrderMode atomicWriteOrderMode;
    private boolean eagerTtl;
    private CacheWriteSynchronizationMode writeSynchronizationMode;
    private boolean swapEnabled;
    private boolean invalidate;
    private int startSize;
    private long offHeapMaxMemory;
    private int maxConcurrentAsyncOps;
    private CacheMemoryMode memoryMode;
    private String interceptor;
    private VisorCacheAffinityConfiguration affinityCfg;
    private VisorCacheRebalanceConfiguration rebalanceCfg;
    private VisorCacheEvictionConfiguration evictCfg;
    private VisorCacheNearConfiguration nearCfg;
    private VisorCacheDefaultConfiguration dfltCfg;
    private VisorCacheStoreConfiguration storeCfg;
    private Collection<VisorCacheTypeMetadata> typeMeta;
    private boolean statisticsEnabled;
    private boolean mgmtEnabled;
    private String ldrFactory;
    private String writerFactory;
    private String expiryPlcFactory;
    private VisorCacheQueryConfiguration qryCfg;
    private boolean sys;

    public VisorCacheConfiguration from(IgniteEx ignite, CacheConfiguration ccfg) {
        this.name = ccfg.getName();
        this.mode = ccfg.getCacheMode();
        this.atomicityMode = ccfg.getAtomicityMode();
        this.atomicWriteOrderMode = ccfg.getAtomicWriteOrderMode();
        this.eagerTtl = ccfg.isEagerTtl();
        this.writeSynchronizationMode = ccfg.getWriteSynchronizationMode();
        this.swapEnabled = ccfg.isSwapEnabled();
        this.invalidate = ccfg.isInvalidate();
        this.startSize = ccfg.getStartSize();
        this.offHeapMaxMemory = ccfg.getOffHeapMaxMemory();
        this.maxConcurrentAsyncOps = ccfg.getMaxConcurrentAsyncOperations();
        this.memoryMode = ccfg.getMemoryMode();
        this.interceptor = VisorTaskUtils.compactClass(ccfg.getInterceptor());
        this.typeMeta = VisorCacheTypeMetadata.list(ccfg.getQueryEntities(), ccfg.getCacheStoreFactory(), ccfg.getTypeMetadata());
        this.statisticsEnabled = ccfg.isStatisticsEnabled();
        this.mgmtEnabled = ccfg.isManagementEnabled();
        this.ldrFactory = VisorTaskUtils.compactClass(ccfg.getCacheLoaderFactory());
        this.writerFactory = VisorTaskUtils.compactClass(ccfg.getCacheWriterFactory());
        this.expiryPlcFactory = VisorTaskUtils.compactClass(ccfg.getExpiryPolicyFactory());
        this.sys = ignite.context().cache().systemCache(ccfg.getName());
        this.affinityCfg = VisorCacheAffinityConfiguration.from(ccfg);
        this.rebalanceCfg = VisorCacheRebalanceConfiguration.from(ccfg);
        this.evictCfg = VisorCacheEvictionConfiguration.from(ccfg);
        this.nearCfg = VisorCacheNearConfiguration.from(ccfg);
        this.dfltCfg = VisorCacheDefaultConfiguration.from(ccfg);
        boolean compatibility = false;
        for (ClusterNode node : ignite.cluster().nodes()) {
            if (node.version().compareToIgnoreTimestamp(VER_1_4_1) > 0) continue;
            compatibility = true;
            break;
        }
        this.storeCfg = (compatibility ? new VisorCacheStoreConfiguration() : new VisorCacheStoreConfigurationV2()).from(ignite, ccfg);
        this.qryCfg = (compatibility ? new VisorCacheQueryConfiguration() : new VisorCacheQueryConfigurationV2()).from(ccfg);
        return this;
    }

    @Nullable
    public String name() {
        return this.name;
    }

    public CacheMode mode() {
        return this.mode;
    }

    public CacheAtomicityMode atomicityMode() {
        return this.atomicityMode;
    }

    public CacheAtomicWriteOrderMode atomicWriteOrderMode() {
        return this.atomicWriteOrderMode;
    }

    public boolean eagerTtl() {
        return this.eagerTtl;
    }

    public CacheWriteSynchronizationMode writeSynchronizationMode() {
        return this.writeSynchronizationMode;
    }

    public boolean swapEnabled() {
        return this.swapEnabled;
    }

    public boolean invalidate() {
        return this.invalidate;
    }

    public int startSize() {
        return this.startSize;
    }

    public long offsetHeapMaxMemory() {
        return this.offHeapMaxMemory;
    }

    public int maxConcurrentAsyncOperations() {
        return this.maxConcurrentAsyncOps;
    }

    public CacheMemoryMode memoryMode() {
        return this.memoryMode;
    }

    @Nullable
    public String interceptor() {
        return this.interceptor;
    }

    public Collection<VisorCacheTypeMetadata> typeMeta() {
        return this.typeMeta;
    }

    public boolean statisticsEnabled() {
        return this.statisticsEnabled;
    }

    public boolean managementEnabled() {
        return this.mgmtEnabled;
    }

    public String loaderFactory() {
        return this.ldrFactory;
    }

    public String writerFactory() {
        return this.writerFactory;
    }

    public String expiryPolicyFactory() {
        return this.expiryPlcFactory;
    }

    public VisorCacheAffinityConfiguration affinityConfiguration() {
        return this.affinityCfg;
    }

    public VisorCacheRebalanceConfiguration rebalanceConfiguration() {
        return this.rebalanceCfg;
    }

    public VisorCacheEvictionConfiguration evictConfiguration() {
        return this.evictCfg;
    }

    public VisorCacheNearConfiguration nearConfiguration() {
        return this.nearCfg;
    }

    public VisorCacheDefaultConfiguration defaultConfiguration() {
        return this.dfltCfg;
    }

    public VisorCacheStoreConfiguration storeConfiguration() {
        return this.storeCfg;
    }

    public VisorCacheQueryConfiguration queryConfiguration() {
        return this.qryCfg;
    }

    public boolean system() {
        return this.sys;
    }

    public String toString() {
        return S.toString(VisorCacheConfiguration.class, this);
    }
}

