/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.cache;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxy;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.cache.VisorCacheConfiguration;
import org.apache.ignite.lang.IgniteUuid;

public class VisorCacheConfigurationCollectorJob
extends VisorJob<Collection<IgniteUuid>, Map<IgniteUuid, VisorCacheConfiguration>> {
    private static final long serialVersionUID = 0L;

    public VisorCacheConfigurationCollectorJob(Collection<IgniteUuid> arg, boolean debug) {
        super(arg, debug);
    }

    @Override
    protected Map<IgniteUuid, VisorCacheConfiguration> run(Collection<IgniteUuid> arg) {
        Collection<IgniteCacheProxy<?, ?>> caches = this.ignite.context().cache().jcaches();
        boolean all = arg == null || arg.isEmpty();
        HashMap<IgniteUuid, VisorCacheConfiguration> res = U.newHashMap(caches.size());
        for (IgniteCacheProxy<?, ?> cache : caches) {
            IgniteUuid deploymentId = cache.context().dynamicDeploymentId();
            if (!all && !arg.contains(deploymentId)) continue;
            res.put(deploymentId, this.config(cache.getConfiguration(CacheConfiguration.class)));
        }
        return res;
    }

    protected VisorCacheConfiguration config(CacheConfiguration ccfg) {
        return new VisorCacheConfiguration().from(this.ignite, ccfg);
    }

    public String toString() {
        return S.toString(VisorCacheConfigurationCollectorJob.class, this);
    }
}

