/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.cache;

import java.io.Serializable;
import org.apache.ignite.cache.eviction.EvictionPolicy;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.LessNamingBean;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;
import org.jetbrains.annotations.Nullable;

public class VisorCacheEvictionConfiguration
implements Serializable,
LessNamingBean {
    private static final long serialVersionUID = 0L;
    private String plc;
    private Integer plcMaxSize;
    private String filter;
    private int syncConcurrencyLvl;
    private long syncTimeout;
    private int syncKeyBufSize;
    private boolean evictSynchronized;
    private float maxOverflowRatio;

    public static VisorCacheEvictionConfiguration from(CacheConfiguration ccfg) {
        VisorCacheEvictionConfiguration cfg = new VisorCacheEvictionConfiguration();
        EvictionPolicy plc = ccfg.getEvictionPolicy();
        cfg.plc = VisorTaskUtils.compactClass(plc);
        cfg.plcMaxSize = VisorTaskUtils.evictionPolicyMaxSize(plc);
        cfg.filter = VisorTaskUtils.compactClass(ccfg.getEvictionFilter());
        cfg.syncConcurrencyLvl = ccfg.getEvictSynchronizedConcurrencyLevel();
        cfg.syncTimeout = ccfg.getEvictSynchronizedTimeout();
        cfg.syncKeyBufSize = ccfg.getEvictSynchronizedKeyBufferSize();
        cfg.evictSynchronized = ccfg.isEvictSynchronized();
        cfg.maxOverflowRatio = ccfg.getEvictMaxOverflowRatio();
        return cfg;
    }

    @Nullable
    public String policy() {
        return this.plc;
    }

    @Nullable
    public Integer policyMaxSize() {
        return this.plcMaxSize;
    }

    @Nullable
    public String filter() {
        return this.filter;
    }

    public int synchronizedConcurrencyLevel() {
        return this.syncConcurrencyLvl;
    }

    public long synchronizedTimeout() {
        return this.syncTimeout;
    }

    public int synchronizedKeyBufferSize() {
        return this.syncKeyBufSize;
    }

    public boolean evictSynchronized() {
        return this.evictSynchronized;
    }

    public float maxOverflowRatio() {
        return this.maxOverflowRatio;
    }

    public String toString() {
        return S.toString(VisorCacheEvictionConfiguration.class, this);
    }
}

