/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.cache;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.cache.expiry.CreatedExpiryPolicy;
import javax.cache.expiry.Duration;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.lang.GridTuple3;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorOneNodeTask;

@GridInternal
public class VisorCacheLoadTask
extends VisorOneNodeTask<GridTuple3<Set<String>, Long, Object[]>, Map<String, Integer>> {
    private static final long serialVersionUID = 0L;

    protected VisorCachesLoadJob job(GridTuple3<Set<String>, Long, Object[]> arg) {
        return new VisorCachesLoadJob(arg, this.debug);
    }

    private static class VisorCachesLoadJob
    extends VisorJob<GridTuple3<Set<String>, Long, Object[]>, Map<String, Integer>> {
        private static final long serialVersionUID = 0L;

        private VisorCachesLoadJob(GridTuple3<Set<String>, Long, Object[]> arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected Map<String, Integer> run(GridTuple3<Set<String>, Long, Object[]> arg) {
            Set<String> cacheNames = arg.get1();
            Long ttl = arg.get2();
            Object[] ldrArgs = arg.get3();
            assert (cacheNames != null && !cacheNames.isEmpty());
            assert (ttl != null);
            HashMap<String, Integer> res = U.newHashMap(cacheNames.size());
            CreatedExpiryPolicy plc = null;
            for (String cacheName : cacheNames) {
                IgniteCache cache = this.ignite.cache(cacheName);
                if (ttl > 0L) {
                    if (plc == null) {
                        plc = new CreatedExpiryPolicy(new Duration(TimeUnit.MILLISECONDS, (long)ttl));
                    }
                    cache = cache.withExpiryPolicy(plc);
                }
                cache.loadCache(null, ldrArgs);
                res.put(cacheName, cache.size(CachePeekMode.PRIMARY));
            }
            return res;
        }

        public String toString() {
            return S.toString(VisorCachesLoadJob.class, this);
        }
    }
}

