/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.cache;

import java.io.Serializable;
import org.apache.ignite.cache.CacheMetrics;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.LessNamingBean;
import org.apache.ignite.internal.processors.cache.GridCacheProcessor;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxy;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.cache.VisorCacheQueryMetrics;

public class VisorCacheMetrics
implements Serializable,
LessNamingBean {
    private static final float MICROSECONDS_IN_SECOND = 1000000.0f;
    private static final long serialVersionUID = 0L;
    private String name;
    private CacheMode mode;
    private boolean sys;
    private int size;
    private int keySize;
    private long reads;
    private float avgReadTime;
    private long writes;
    private long hits;
    private long misses;
    private long txCommits;
    private float avgTxCommitTime;
    private long txRollbacks;
    private float avgTxRollbackTime;
    private long puts;
    private float avgPutTime;
    private long removals;
    private float avgRemovalTime;
    private long evictions;
    private int readsPerSec;
    private int putsPerSec;
    private int removalsPerSec;
    private int commitsPerSec;
    private int rollbacksPerSec;
    private VisorCacheQueryMetrics qryMetrics;
    private int dhtEvictQueueCurrSize;
    private int txThreadMapSize;
    private int txXidMapSize;
    private int txCommitQueueSize;
    private int txPrepareQueueSize;
    private int txStartVerCountsSize;
    private int txCommittedVersionsSize;
    private int txRolledbackVersionsSize;
    private int txDhtThreadMapSize;
    private int txDhtXidMapSize;
    private int txDhtCommitQueueSize;
    private int txDhtPrepareQueueSize;
    private int txDhtStartVerCountsSize;
    private int txDhtCommittedVersionsSize;
    private int txDhtRolledbackVersionsSize;

    private static int perSecond(float meanTime) {
        return meanTime > 0.0f ? (int)(1000000.0f / meanTime) : 0;
    }

    public VisorCacheMetrics from(IgniteEx ignite, String cacheName) {
        GridCacheProcessor cacheProcessor = ignite.context().cache();
        IgniteCacheProxy c = cacheProcessor.jcache(cacheName);
        this.name = cacheName;
        this.mode = cacheProcessor.cacheMode(cacheName);
        this.sys = cacheProcessor.systemCache(cacheName);
        CacheMetrics m = c.localMetrics();
        this.size = m.getSize();
        this.keySize = m.getKeySize();
        this.reads = m.getCacheGets();
        this.writes = m.getCachePuts() + m.getCacheRemovals();
        this.hits = m.getCacheHits();
        this.misses = m.getCacheMisses();
        this.txCommits = m.getCacheTxCommits();
        this.txRollbacks = m.getCacheTxRollbacks();
        this.avgTxCommitTime = m.getAverageTxCommitTime();
        this.avgTxRollbackTime = m.getAverageTxRollbackTime();
        this.puts = m.getCachePuts();
        this.removals = m.getCacheRemovals();
        this.evictions = m.getCacheEvictions();
        this.avgReadTime = m.getAverageGetTime();
        this.avgPutTime = m.getAveragePutTime();
        this.avgRemovalTime = m.getAverageRemoveTime();
        this.readsPerSec = VisorCacheMetrics.perSecond(m.getAverageGetTime());
        this.putsPerSec = VisorCacheMetrics.perSecond(m.getAveragePutTime());
        this.removalsPerSec = VisorCacheMetrics.perSecond(m.getAverageRemoveTime());
        this.commitsPerSec = VisorCacheMetrics.perSecond(m.getAverageTxCommitTime());
        this.rollbacksPerSec = VisorCacheMetrics.perSecond(m.getAverageTxRollbackTime());
        this.qryMetrics = VisorCacheQueryMetrics.from(c.queryMetrics());
        this.dhtEvictQueueCurrSize = m.getDhtEvictQueueCurrentSize();
        this.txThreadMapSize = m.getTxThreadMapSize();
        this.txXidMapSize = m.getTxXidMapSize();
        this.txCommitQueueSize = m.getTxCommitQueueSize();
        this.txPrepareQueueSize = m.getTxPrepareQueueSize();
        this.txStartVerCountsSize = m.getTxStartVersionCountsSize();
        this.txCommittedVersionsSize = m.getTxCommittedVersionsSize();
        this.txRolledbackVersionsSize = m.getTxRolledbackVersionsSize();
        this.txDhtThreadMapSize = m.getTxDhtThreadMapSize();
        this.txDhtXidMapSize = m.getTxDhtXidMapSize();
        this.txDhtCommitQueueSize = m.getTxDhtCommitQueueSize();
        this.txDhtPrepareQueueSize = m.getTxDhtPrepareQueueSize();
        this.txDhtStartVerCountsSize = m.getTxDhtStartVersionCountsSize();
        this.txDhtCommittedVersionsSize = m.getTxDhtCommittedVersionsSize();
        this.txDhtRolledbackVersionsSize = m.getTxDhtRolledbackVersionsSize();
        return this;
    }

    public String name() {
        return this.name;
    }

    public void name(String name) {
        this.name = name;
    }

    public CacheMode mode() {
        return this.mode;
    }

    public boolean system() {
        return this.sys;
    }

    public long reads() {
        return this.reads;
    }

    public float avgReadTime() {
        return this.avgReadTime;
    }

    public long writes() {
        return this.writes;
    }

    public long hits() {
        return this.hits;
    }

    public long misses() {
        return this.misses;
    }

    public long txCommits() {
        return this.txCommits;
    }

    public float avgTxCommitTime() {
        return this.avgTxCommitTime;
    }

    public float avgTxRollbackTime() {
        return this.avgTxRollbackTime;
    }

    public long puts() {
        return this.puts;
    }

    public float avgPutTime() {
        return this.avgPutTime;
    }

    public long removals() {
        return this.removals;
    }

    public float avgRemovalTime() {
        return this.avgRemovalTime;
    }

    public long evictions() {
        return this.evictions;
    }

    public long txRollbacks() {
        return this.txRollbacks;
    }

    public int readsPerSecond() {
        return this.readsPerSec;
    }

    public int putsPerSecond() {
        return this.putsPerSec;
    }

    public int removalsPerSecond() {
        return this.removalsPerSec;
    }

    public int commitsPerSecond() {
        return this.commitsPerSec;
    }

    public int rollbacksPerSecond() {
        return this.rollbacksPerSec;
    }

    public int size() {
        return this.size;
    }

    public int keySize() {
        return this.keySize;
    }

    public VisorCacheQueryMetrics queryMetrics() {
        return this.qryMetrics;
    }

    public int dhtEvictQueueCurrentSize() {
        return this.dhtEvictQueueCurrSize;
    }

    public int txThreadMapSize() {
        return this.txThreadMapSize;
    }

    public int txXidMapSize() {
        return this.txXidMapSize;
    }

    public int txCommitQueueSize() {
        return this.txCommitQueueSize;
    }

    public int txPrepareQueueSize() {
        return this.txPrepareQueueSize;
    }

    public int txStartVersionCountsSize() {
        return this.txStartVerCountsSize;
    }

    public int txCommittedVersionsSize() {
        return this.txCommittedVersionsSize;
    }

    public int txRolledbackVersionsSize() {
        return this.txRolledbackVersionsSize;
    }

    public int txDhtThreadMapSize() {
        return this.txDhtThreadMapSize;
    }

    public int txDhtXidMapSize() {
        return this.txDhtXidMapSize;
    }

    public int txDhtCommitQueueSize() {
        return this.txDhtCommitQueueSize;
    }

    public int txDhtPrepareQueueSize() {
        return this.txDhtPrepareQueueSize;
    }

    public int txDhtStartVersionCountsSize() {
        return this.txDhtStartVerCountsSize;
    }

    public int txDhtCommittedVersionsSize() {
        return this.txDhtCommittedVersionsSize;
    }

    public int txDhtRolledbackVersionsSize() {
        return this.txDhtRolledbackVersionsSize;
    }

    public String toString() {
        return S.toString(VisorCacheMetrics.class, this);
    }
}

