/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.processors.cache.GridCacheProcessor;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxy;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.apache.ignite.internal.visor.cache.VisorCacheAggregatedMetrics;
import org.apache.ignite.internal.visor.cache.VisorCacheMetrics;
import org.apache.ignite.internal.visor.cache.VisorCacheMetricsV2;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteProductVersion;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class VisorCacheMetricsCollectorTask
extends VisorMultiNodeTask<IgniteBiTuple<Boolean, Collection<String>>, Iterable<VisorCacheAggregatedMetrics>, Collection<VisorCacheMetrics>> {
    private static final long serialVersionUID = 0L;

    protected VisorCacheMetricsCollectorJob job(IgniteBiTuple<Boolean, Collection<String>> arg) {
        return new VisorCacheMetricsCollectorJob(arg, this.debug);
    }

    @Override
    @Nullable
    protected Iterable<VisorCacheAggregatedMetrics> reduce0(List<ComputeJobResult> results) {
        HashMap<String, VisorCacheAggregatedMetrics> grpAggrMetrics = U.newHashMap(results.size());
        for (ComputeJobResult res : results) {
            if (res.getException() != null) continue;
            Collection cms = (Collection)res.getData();
            for (VisorCacheMetrics cm : cms) {
                VisorCacheAggregatedMetrics am = (VisorCacheAggregatedMetrics)grpAggrMetrics.get(cm.name());
                if (am == null) {
                    am = VisorCacheAggregatedMetrics.from(cm);
                    grpAggrMetrics.put(cm.name(), am);
                }
                am.metrics().put(res.getNode().id(), cm);
            }
        }
        return new ArrayList<VisorCacheAggregatedMetrics>(grpAggrMetrics.values());
    }

    private static class VisorCacheMetricsCollectorJob
    extends VisorJob<IgniteBiTuple<Boolean, Collection<String>>, Collection<VisorCacheMetrics>> {
        private static final long serialVersionUID = 0L;
        private static final IgniteProductVersion V2_SINCE = IgniteProductVersion.fromString("1.5.8");

        private VisorCacheMetricsCollectorJob(IgniteBiTuple<Boolean, Collection<String>> arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected Collection<VisorCacheMetrics> run(IgniteBiTuple<Boolean, Collection<String>> arg) {
            assert (arg != null);
            Boolean showSysCaches = arg.get1();
            assert (showSysCaches != null);
            Collection<String> cacheNames = arg.get2();
            assert (cacheNames != null);
            GridCacheProcessor cacheProcessor = this.ignite.context().cache();
            Collection<IgniteCacheProxy<?, ?>> caches = cacheProcessor.jcaches();
            ArrayList<VisorCacheMetrics> res = new ArrayList<VisorCacheMetrics>(caches.size());
            boolean allCaches = cacheNames.isEmpty();
            for (IgniteCacheProxy<?, ?> ca : caches) {
                if (!ca.context().started()) continue;
                String cacheName = ca.getName();
                boolean compatibilityMode = false;
                for (ClusterNode node : this.ignite.cluster().nodes()) {
                    if (node.version().compareToIgnoreTimestamp(V2_SINCE) >= 0) continue;
                    compatibilityMode = true;
                    break;
                }
                VisorCacheMetrics cm = (compatibilityMode ? new VisorCacheMetrics() : new VisorCacheMetricsV2()).from(this.ignite, cacheName);
                if (!allCaches && !cacheNames.contains(cacheName) || !showSysCaches.booleanValue() && cm.system()) continue;
                res.add(cm);
            }
            return res;
        }

        public String toString() {
            return S.toString(VisorCacheMetricsCollectorJob.class, this);
        }
    }
}

